/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.master;

import com.google.common.base.Preconditions;
import io.ray.api.RayActor;
import io.ray.streaming.jobgraph.JobGraph;
import io.ray.streaming.runtime.config.StreamingConfig;
import io.ray.streaming.runtime.config.StreamingMasterConfig;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionGraph;
import io.ray.streaming.runtime.master.JobRuntimeContext;
import io.ray.streaming.runtime.master.graphmanager.GraphManager;
import io.ray.streaming.runtime.master.graphmanager.GraphManagerImpl;
import io.ray.streaming.runtime.master.resourcemanager.ResourceManager;
import io.ray.streaming.runtime.master.resourcemanager.ResourceManagerImpl;
import io.ray.streaming.runtime.master.scheduler.JobSchedulerImpl;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMaster {
    private static final Logger LOG = LoggerFactory.getLogger(JobMaster.class);
    private JobRuntimeContext runtimeContext;
    private ResourceManager resourceManager;
    private JobSchedulerImpl scheduler;
    private GraphManager graphManager;
    private StreamingMasterConfig conf;
    private RayActor jobMasterActor;

    public JobMaster(Map<String, String> confMap) {
        LOG.info("Creating job master with conf: {}.", (Object)confMap);
        StreamingConfig streamingConfig = new StreamingConfig(confMap);
        this.conf = streamingConfig.masterConfig;
        this.runtimeContext = new JobRuntimeContext(streamingConfig);
        LOG.info("Finished creating job master.");
    }

    public Boolean init() {
        LOG.info("Initializing job master.");
        if (this.runtimeContext.getExecutionGraph() == null) {
            LOG.error("Init job master failed. Job graphs is null.");
            return false;
        }
        ExecutionGraph executionGraph = this.graphManager.getExecutionGraph();
        Preconditions.checkArgument(executionGraph != null, "no execution graph");
        LOG.info("Finished initializing job master.");
        return true;
    }

    public boolean submitJob(RayActor<JobMaster> jobMasterActor, JobGraph jobGraph) {
        LOG.info("Begin submitting job using logical plan: {}.", (Object)jobGraph);
        this.jobMasterActor = jobMasterActor;
        this.graphManager = new GraphManagerImpl(this.runtimeContext);
        this.resourceManager = new ResourceManagerImpl(this.runtimeContext);
        ExecutionGraph executionGraph = this.graphManager.buildExecutionGraph(jobGraph);
        this.runtimeContext.setJobGraph(jobGraph);
        this.runtimeContext.setExecutionGraph(executionGraph);
        try {
            this.scheduler = new JobSchedulerImpl(this);
            this.scheduler.scheduleJob(this.graphManager.getExecutionGraph());
        }
        catch (Exception e) {
            LOG.error("Failed to submit job.", e);
            return false;
        }
        return true;
    }

    public RayActor getJobMasterActor() {
        return this.jobMasterActor;
    }

    public JobRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public GraphManager getGraphManager() {
        return this.graphManager;
    }

    public StreamingMasterConfig getConf() {
        return this.conf;
    }
}

