/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.serialization;

import io.ray.streaming.message.KeyRecord;
import io.ray.streaming.message.Record;
import io.ray.streaming.runtime.serialization.MsgPackSerializer;
import io.ray.streaming.runtime.serialization.Serializer;
import java.util.Arrays;
import java.util.List;

public class CrossLangSerializer
implements Serializer {
    private static final byte RECORD_TYPE_ID = 0;
    private static final byte KEY_RECORD_TYPE_ID = 1;
    private MsgPackSerializer msgPackSerializer = new MsgPackSerializer();

    @Override
    public byte[] serialize(Object object) {
        Record record = (Record)object;
        Object value = record.getValue();
        Class<?> clz = record.getClass();
        if (clz == Record.class) {
            return this.msgPackSerializer.serialize(Arrays.asList((byte)0, record.getStream(), value));
        }
        if (clz == KeyRecord.class) {
            KeyRecord keyRecord = (KeyRecord)record;
            Object key = keyRecord.getKey();
            return this.msgPackSerializer.serialize(Arrays.asList((byte)1, keyRecord.getStream(), key, value));
        }
        throw new UnsupportedOperationException(String.format("Serialize %s is unsupported.", record));
    }

    public Record deserialize(byte[] bytes) {
        List list = (List)this.msgPackSerializer.deserialize(bytes);
        Byte typeId = (Byte)list.get(0);
        switch (typeId) {
            case 0: {
                String stream = (String)list.get(1);
                Object value = list.get(2);
                Record record = new Record(value);
                record.setStream(stream);
                return record;
            }
            case 1: {
                String stream = (String)list.get(1);
                Object key = list.get(2);
                Object value = list.get(3);
                KeyRecord keyRecord = new KeyRecord(key, value);
                keyRecord.setStream(stream);
                return keyRecord;
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + typeId);
    }
}

