/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class ReflectionUtils {
    public static Method findMethod(Class<?> cls, String methodName) {
        List<Method> methods = ReflectionUtils.findMethods(cls, methodName);
        Preconditions.checkArgument(methods.size() == 1);
        return methods.get(0);
    }

    public static List<Method> findMethods(Class<?> cls, String methodName) {
        ArrayList classes = new ArrayList();
        for (Class<?> clazz = cls; clazz != null; clazz = clazz.getSuperclass()) {
            classes.add(clazz);
        }
        classes.addAll(ReflectionUtils.getAllInterfaces(cls));
        if (classes.indexOf(Object.class) == -1) {
            classes.add(Object.class);
        }
        LinkedHashMap methods = new LinkedHashMap();
        for (Class clazz : classes) {
            for (Method m3 : clazz.getDeclaredMethods()) {
                if (!m3.getName().equals(methodName)) continue;
                List<Class<?>> params = Arrays.asList(m3.getParameterTypes());
                Method method = (Method)methods.get(params);
                if (method == null) {
                    methods.put(params, m3);
                    continue;
                }
                if (!method.getReturnType().isAssignableFrom(m3.getReturnType())) continue;
                methods.put(params, m3);
            }
        }
        return new ArrayList<Method>(methods.values());
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        ReflectionUtils.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    private static void getAllInterfaces(Class<?> cls, LinkedHashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = cls.getInterfaces()) {
                if (interfacesFound.contains(anInterface)) continue;
                interfacesFound.add(anInterface);
                ReflectionUtils.getAllInterfaces(anInterface, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }
}

