/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.backend;

import io.ray.streaming.state.backend.AbstractStateBackend;
import io.ray.streaming.state.backend.BackendType;
import io.ray.streaming.state.backend.impl.MemoryStateBackend;
import java.util.Map;

public class StateBackendBuilder {
    private static AbstractStateBackend getStateBackend(Map<String, String> config, BackendType type) {
        switch (type) {
            case MEMORY: {
                return new MemoryStateBackend(config);
            }
        }
        throw new RuntimeException(type.name() + " not supported");
    }

    public static AbstractStateBackend buildStateBackend(Map<String, String> config) {
        BackendType type = config == null ? BackendType.MEMORY : BackendType.getEnum(config.get("state.backend.type"));
        return StateBackendBuilder.getStateBackend(config, type);
    }
}

