/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.keystate.desc;

import com.google.common.base.Preconditions;
import io.ray.streaming.state.keystate.state.State;

public abstract class AbstractStateDescriptor<S extends State, T> {
    private final String name;
    private String tableName;
    private Class<T> type;

    protected AbstractStateDescriptor(String name, Class<T> type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    protected Class<T> setType(Class<T> type) {
        return type;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public abstract StateType getStateType();

    public String getIdentify() {
        Preconditions.checkArgument(this.tableName != null, "table name must not be null.");
        Preconditions.checkArgument(this.name != null, "table name must not be null.");
        return this.name;
    }

    public String toString() {
        return "AbstractStateDescriptor{tableName='" + this.tableName + '\'' + ", name='" + this.name + '\'' + ", type=" + this.type + '}';
    }

    public static enum StateType {
        VALUE,
        LIST,
        MAP;

    }
}

