/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.keystate.state.impl;

import com.google.common.base.Preconditions;
import io.ray.streaming.state.PartitionRecord;
import io.ray.streaming.state.backend.AbstractKeyStateBackend;
import io.ray.streaming.state.keystate.desc.ListStateDescriptor;
import io.ray.streaming.state.keystate.state.ListState;
import io.ray.streaming.state.keystate.state.impl.StateHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class OperatorStateImpl<V>
implements ListState<V> {
    private final ListStateDescriptor<V> descriptor;
    private StateHelper<List<PartitionRecord<V>>> helper;
    private List<PartitionRecord<V>> allList;
    private AtomicBoolean hasInit;
    private boolean isSplit;

    public OperatorStateImpl(ListStateDescriptor<V> descriptor, AbstractKeyStateBackend backend) {
        this.descriptor = descriptor;
        this.helper = new StateHelper(backend, descriptor);
        this.isSplit = false;
        this.hasInit = new AtomicBoolean(false);
        this.allList = new ArrayList<PartitionRecord<V>>();
    }

    private void splitList() {
        ArrayList<PartitionRecord<V>> list = new ArrayList<PartitionRecord<V>>();
        int step = this.descriptor.getPartitionNumber();
        Preconditions.checkArgument(step > 0);
        int round = 0;
        while (round * step <= this.allList.size()) {
            int m3 = round * step + this.descriptor.getIndex();
            if (m3 < this.allList.size()) {
                PartitionRecord<V> tmp = this.allList.get(m3);
                tmp.setPartitionID(this.descriptor.getPartitionNumber());
                list.add(tmp);
            }
            ++round;
        }
        this.helper.put(list, this.getStateKey());
        this.allList.clear();
    }

    private void scan() {
        int partitionNum = -1;
        int index = 0;
        do {
            List list;
            if ((list = (List)this.helper.getBackend().get(this.descriptor, this.getKey(this.descriptor.getIdentify(), index))) == null || list.isEmpty()) continue;
            partitionNum = ((PartitionRecord)list.get(0)).getPartitionID();
            this.allList.addAll(list);
        } while (++index < partitionNum);
    }

    public void init() {
        this.scan();
        if (this.isSplit) {
            this.splitList();
        }
    }

    private String getKey(String descName, int index) {
        String[] stringList = descName.split("\u0001\b");
        return String.format("%s%s%s%s%d", stringList[0], "\u0001\b", stringList[1], "\u0001\b", index);
    }

    protected String getStateKey() {
        return this.getKey(this.descriptor.getIdentify(), this.descriptor.getIndex());
    }

    @Override
    public void setCurrentKey(Object currentKey) {
        throw new UnsupportedOperationException("OperatorState cannot set current key");
    }

    @Override
    public List<V> get() {
        if (!this.hasInit.getAndSet(true)) {
            this.init();
        }
        List<PartitionRecord<V>> prList = this.helper.get(this.getStateKey());
        ArrayList<V> list = new ArrayList<V>();
        for (PartitionRecord<V> pr : prList) {
            list.add(pr.getValue());
        }
        return list;
    }

    @Override
    public void add(V value) {
        List<PartitionRecord<V>> list;
        if (!this.hasInit.getAndSet(true)) {
            this.init();
        }
        if ((list = this.helper.get(this.getStateKey())) == null) {
            list = new ArrayList<PartitionRecord<V>>();
        }
        list.add(new PartitionRecord<V>(this.descriptor.getPartitionNumber(), value));
        this.helper.put(list, this.getStateKey());
    }

    @Override
    public void update(List<V> list) {
        ArrayList<PartitionRecord<V>> prList = new ArrayList<PartitionRecord<V>>();
        if (list != null) {
            for (V value : list) {
                prList.add(new PartitionRecord<V>(this.descriptor.getPartitionNumber(), value));
            }
        }
        this.helper.put(prList);
    }

    public void setSplit(boolean split) {
        this.isSplit = split;
    }
}

