/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.keystate.state.impl;

import com.google.common.base.Preconditions;
import io.ray.streaming.state.backend.AbstractKeyStateBackend;
import io.ray.streaming.state.keystate.desc.AbstractStateDescriptor;

public class StateHelper<T> {
    private final AbstractKeyStateBackend backend;
    private final AbstractStateDescriptor descriptor;

    public StateHelper(AbstractKeyStateBackend backend, AbstractStateDescriptor descriptor) {
        this.backend = backend;
        this.descriptor = descriptor;
    }

    protected String getStateKey(String descName) {
        Preconditions.checkNotNull(this.backend, "KeyedBackend must not be null");
        Preconditions.checkNotNull(this.backend.getCurrentKey(), "currentKey must not be null");
        return this.backend.getBackend().getStateKey(descName, this.backend.getCurrentKey().toString());
    }

    public void put(T value, String key) {
        this.backend.put(this.descriptor, key, value);
    }

    public void put(T value) {
        this.put(value, this.getStateKey(this.descriptor.getIdentify()));
    }

    public T get(String key) {
        return this.backend.get(this.descriptor, key);
    }

    public T get() {
        return this.get(this.getStateKey(this.descriptor.getIdentify()));
    }

    public void setCurrentKey(Object currentKey) {
        Preconditions.checkNotNull(this.backend, "KeyedBackend must not be null");
        this.backend.setCurrentKey(currentKey);
    }

    public void setKeyGroupIndex(int keyGroupIndex) {
        this.backend.setKeyGroupIndex(keyGroupIndex);
    }

    public void resetKeyGroupIndex() {
        this.backend.setKeyGroupIndex(-1);
    }

    public AbstractStateDescriptor getDescriptor() {
        return this.descriptor;
    }

    public AbstractKeyStateBackend getBackend() {
        return this.backend;
    }
}

