#! /usr/bin/env python

##############################################################################
##  pyvolve: Python platform for simulating evolutionary sequences.
##
##  Written by Stephanie J. Spielman (stephanie.spielman@gmail.com) 
##############################################################################

############################################## CODON MODELS ######################################################
scg_matrix = [0.40849, 0.01506, 0.26198, 0.01904, 0.01527, 0.0065, 0.01149, 0.00774, 0.09164, 0.00886, 0.06529, 0.01076, 0.0066, 0.00143, 0.00546, 0.00199, 0.03077, 0.0071, 0.01811, 0.00826, 0.00398, 0.00212, 0.00365, 0.00235, 0.04568, 0.02826, 0.03891, 0.02978, 0.00271, 0.00126, 0.00142, 0.00159, 0.01551, 0.00399, 0.00889, 0.00437, 0.00663, 0.00287, 0.00496, 0.00357, 0.00548, 0.00272, 0.00424, 0.00339, 0.00423, 0.00159, 0.00221, 0.00206, 0.00093, 0.00119, 0.00521, 0.00275, 0.00405, 0.00343, 0.00141, 0.00127, 0.00163, 0.0024, 0.00044, 0.00188, 0.00054],[0.011, 0.41485, 0.00959, 0.25289, 0.00916, 0.01865, 0.0096, 0.01375, 0.00594, 0.06004, 0.00586, 0.04124, 0.00198, 0.00335, 0.00212, 0.00227, 0.00651, 0.02338, 0.00584, 0.0164, 0.00191, 0.0032, 0.00236, 0.00226, 0.00323, 0.00648, 0.00382, 0.00479, 0.00094, 0.00154, 0.00076, 0.00105, 0.00487, 0.02458, 0.00468, 0.01611, 0.00379, 0.00645, 0.00491, 0.00461, 0.00562, 0.01425, 0.00697, 0.01034, 0.00173, 0.00277, 0.00133, 0.00205, 0.0049, 0.00365, 0.00484, 0.00759, 0.00499, 0.00589, 0.00411, 0.00048, 0.00314, 0.00098, 0.00121, 0.00101, 0.00096],[0.29591, 0.01484, 0.46315, 0.01686, 0.01135, 0.00675, 0.01565, 0.00657, 0.06807, 0.00889, 0.09736, 0.00994, 0.00415, 0.00151, 0.00852, 0.00177, 0.0226, 0.00788, 0.02791, 0.00789, 0.00319, 0.00209, 0.00438, 0.00206, 0.04198, 0.03598, 0.05322, 0.03283, 0.0021, 0.00128, 0.00207, 0.00145, 0.01041, 0.00391, 0.01442, 0.00412, 0.005, 0.00321, 0.00602, 0.0032, 0.00395, 0.00301, 0.00626, 0.00326, 0.00309, 0.00161, 0.00278, 0.00172, 0.00102, 0.00117, 0.00413, 0.00263, 0.00413, 0.00291, 0.00157, 0.00212, 0.00158, 0.00185, 0.00037, 0.00225, 0.00053],[0.0123, 0.22372, 0.00965, 0.3545, 0.00971, 0.01103, 0.00955, 0.01893, 0.00611, 0.03574, 0.00553, 0.06048, 0.00225, 0.00204, 0.00231, 0.00365, 0.00734, 0.01464, 0.00582, 0.02313, 0.00232, 0.00241, 0.00236, 0.00313, 0.0036, 0.00378, 0.00354, 0.00675, 0.00105, 0.00094, 0.00075, 0.00183, 0.00592, 0.01542, 0.00501, 0.02542, 0.00453, 0.00409, 0.00434, 0.00605, 0.00568, 0.00863, 0.00573, 0.01384, 0.00191, 0.00185, 0.00136, 0.00276, 0.00315, 0.00568, 0.00509, 0.00479, 0.00474, 0.0069, 0.00269, 0.00051, 0.00472, 0.00127, 0.0007, 0.00115, 0.00126],[0.00913, 0.0075, 0.006, 0.00899, 0.25029, 0.13459, 0.19326, 0.15274, 0.00817, 0.0142, 0.00526, 0.01523, 0.01986, 0.00584, 0.01536, 0.00737, 0.0056, 0.00217, 0.00379, 0.00283, 0.01224, 0.00653, 0.0087, 0.00787, 0.00267, 0.00206, 0.0027, 0.00253, 0.00425, 0.00196, 0.00286, 0.0024, 0.00384, 0.00164, 0.00303, 0.00234, 0.03211, 0.01449, 0.02058, 0.01735, 0.00429, 0.00314, 0.00381, 0.00377, 0.01548, 0.00686, 0.00917, 0.00835, 0.00058, 0.00094, 0.03303, 0.01719, 0.02545, 0.02118, 0.00201, 0.00073, 0.00287, 0.00561, 0.00101, 0.00409, 0.00135],[0.00368, 0.01445, 0.00338, 0.00966, 0.12735, 0.27128, 0.15326, 0.14524, 0.00311, 0.02754, 0.00306, 0.01691, 0.00817, 0.01213, 0.00809, 0.00755, 0.00277, 0.00339, 0.00247, 0.00257, 0.00521, 0.01038, 0.00571, 0.00659, 0.00181, 0.00266, 0.00188, 0.00208, 0.00183, 0.0031, 0.00199, 0.00203, 0.00185, 0.00284, 0.00185, 0.00191, 0.01364, 0.02925, 0.01658, 0.01571, 0.00251, 0.0055, 0.00274, 0.00392, 0.00703, 0.01272, 0.00621, 0.00776, 0.00112, 0.00109, 0.01656, 0.02719, 0.01767, 0.01793, 0.00354, 0.00047, 0.00265, 0.00231, 0.00178, 0.00237, 0.00124],[0.0024, 0.00274, 0.00289, 0.00309, 0.06746, 0.05654, 0.0985, 0.05631, 0.0019, 0.00596, 0.00256, 0.00568, 0.00401, 0.00227, 0.00719, 0.00266, 0.00151, 0.00077, 0.00162, 0.00083, 0.00238, 0.00239, 0.00353, 0.00211, 0.0011, 0.00104, 0.00134, 0.00083, 0.00115, 0.00088, 0.00126, 0.00097, 0.00095, 0.00072, 0.00115, 0.00068, 0.00725, 0.00561, 0.0104, 0.00546, 0.00121, 0.00131, 0.00165, 0.00123, 0.00399, 0.00271, 0.00395, 0.00312, 0.00029, 0.00041, 0.00836, 0.00688, 0.01102, 0.0067, 0.00077, 0.00036, 0.00107, 0.00146, 0.00042, 0.00168, 0.00053],[0.00395, 0.0096, 0.00296, 0.01494, 0.13029, 0.13094, 0.1376, 0.2089, 0.00312, 0.01788, 0.00272, 0.02573, 0.00854, 0.00653, 0.00841, 0.01267, 0.00326, 0.0022, 0.00226, 0.00341, 0.00616, 0.0064, 0.00592, 0.00999, 0.00147, 0.00186, 0.00159, 0.00288, 0.00199, 0.00184, 0.00188, 0.00302, 0.00199, 0.00217, 0.00191, 0.003, 0.0156, 0.01487, 0.01514, 0.02512, 0.00264, 0.00349, 0.00294, 0.00526, 0.0074, 0.0073, 0.00644, 0.0116, 0.00087, 0.00141, 0.01903, 0.01644, 0.01878, 0.02496, 0.00251, 0.00036, 0.0038, 0.00274, 0.0012, 0.00261, 0.00179],[0.04383, 0.00389, 0.02882, 0.00452, 0.00654, 0.00263, 0.00435, 0.00293, 0.28665, 0.00702, 0.17898, 0.00863, 0.00367, 0.00076, 0.00259, 0.00093, 0.0114, 0.00452, 0.00656, 0.00499, 0.00136, 0.00094, 0.00176, 0.00091, 0.15015, 0.079, 0.10946, 0.09469, 0.00143, 0.00072, 0.00092, 0.00089, 0.00318, 0.00097, 0.00176, 0.00108, 0.00238, 0.00127, 0.00199, 0.00139, 0.00867, 0.00287, 0.0052, 0.0031, 0.0022, 0.00077, 0.00097, 0.00091, 0.00054, 0.00064, 0.00193, 0.00124, 0.00168, 0.00148, 0.00142, 0.00227, 0.00178, 0.00126, 0.00022, 0.0009, 0.00034],[0.00598, 0.05551, 0.00531, 0.03735, 0.01604, 0.03288, 0.01929, 0.02368, 0.00991, 0.3642, 0.01051, 0.23871, 0.00275, 0.00449, 0.0028, 0.00327, 0.00473, 0.00982, 0.00423, 0.00721, 0.00268, 0.00491, 0.00337, 0.00323, 0.00534, 0.01107, 0.00541, 0.00744, 0.00097, 0.00177, 0.00101, 0.00141, 0.0035, 0.00931, 0.0035, 0.00623, 0.00695, 0.01246, 0.00848, 0.00855, 0.01324, 0.03782, 0.0157, 0.0232, 0.00277, 0.00442, 0.00208, 0.00354, 0.00239, 0.00204, 0.01118, 0.01804, 0.01438, 0.0136, 0.01623, 0.0009, 0.01193, 0.00126, 0.00122, 0.00112, 0.00103],[0.0274, 0.00337, 0.03617, 0.00359, 0.00369, 0.00227, 0.00515, 0.00224, 0.15703, 0.00653, 0.25775, 0.00725, 0.00203, 0.00066, 0.00346, 0.00076, 0.00714, 0.00432, 0.00762, 0.00393, 0.00113, 0.00084, 0.00184, 0.00076, 0.1013, 0.07793, 0.1184, 0.07455, 0.00099, 0.00076, 0.00101, 0.00067, 0.0018, 0.00078, 0.00242, 0.00084, 0.00173, 0.00121, 0.00229, 0.00103, 0.00398, 0.0025, 0.00907, 0.00238, 0.00124, 0.00083, 0.0013, 0.00072, 0.00046, 0.00063, 0.00119, 0.00098, 0.00157, 0.00105, 0.00142, 0.00446, 0.0014, 0.00094, 0.00018, 0.00092, 0.00029],[0.00519, 0.02725, 0.00425, 0.04518, 0.0123, 0.01443, 0.01315, 0.02436, 0.00871, 0.17062, 0.00833, 0.28774, 0.00236, 0.0019, 0.00217, 0.00399, 0.00376, 0.00484, 0.00287, 0.00781, 0.00227, 0.00221, 0.00221, 0.00324, 0.0037, 0.0042, 0.00392, 0.00833, 0.00078, 0.00079, 0.00067, 0.00132, 0.00297, 0.00496, 0.00277, 0.00752, 0.00596, 0.00565, 0.00577, 0.00853, 0.00981, 0.01644, 0.01097, 0.0271, 0.00206, 0.00213, 0.00162, 0.00356, 0.00132, 0.00247, 0.00919, 0.00856, 0.0096, 0.01208, 0.00834, 0.00074, 0.01247, 0.00094, 0.00056, 0.001, 0.00106],[0.00219, 0.0009, 0.00122, 0.00115, 0.01102, 0.00479, 0.00637, 0.00556, 0.00254, 0.00135, 0.0016, 0.00162, 0.19608, 0.0846, 0.02113, 0.08774, 0.00126, 0.00054, 0.0008, 0.0008, 0.00156, 0.0009, 0.00123, 0.00102, 0.00105, 0.0006, 0.00077, 0.00083, 0.01595, 0.00859, 0.00903, 0.00872, 0.00101, 0.00027, 0.00069, 0.0004, 0.00474, 0.00216, 0.00362, 0.0027, 0.00102, 0.00061, 0.00083, 0.00062, 0.03922, 0.02017, 0.02211, 0.02166, 0.00041, 0.00061, 0.00257, 0.00124, 0.0018, 0.00121, 0.00053, 0.00037, 0.00065, 0.01789, 0.00215, 0.01059, 0.0028],[0.00101, 0.00324, 0.00095, 0.00224, 0.00691, 0.01517, 0.0077, 0.00905, 0.00112, 0.0047, 0.00111, 0.00279, 0.18032, 0.36846, 0.02111, 0.22364, 0.00116, 0.00139, 0.00095, 0.00125, 0.00114, 0.00196, 0.00137, 0.00127, 0.00062, 0.00097, 0.00074, 0.00092, 0.01435, 0.02784, 0.01379, 0.01781, 0.00065, 0.00074, 0.00061, 0.00041, 0.00338, 0.00675, 0.00469, 0.00436, 0.00069, 0.00166, 0.00104, 0.00101, 0.03416, 0.07875, 0.03548, 0.04577, 0.00151, 0.00128, 0.00176, 0.00241, 0.00179, 0.00178, 0.00186, 0.00048, 0.00147, 0.01339, 0.0085, 0.01114, 0.00576],[0.00423, 0.00224, 0.00584, 0.00277, 0.01992, 0.01108, 0.02671, 0.01278, 0.00419, 0.00321, 0.00639, 0.00348, 0.04935, 0.02313, 0.58867, 0.0273, 0.00406, 0.00167, 0.00445, 0.00235, 0.00306, 0.00211, 0.00373, 0.00228, 0.0022, 0.00199, 0.00313, 0.00209, 0.02734, 0.01925, 0.03256, 0.01949, 0.00169, 0.00073, 0.00232, 0.00077, 0.00923, 0.00577, 0.01064, 0.00608, 0.00201, 0.00153, 0.00332, 0.0017, 0.02529, 0.01522, 0.03171, 0.01708, 0.00124, 0.00153, 0.0062, 0.00345, 0.007, 0.00418, 0.00126, 0.00206, 0.00152, 0.02594, 0.00453, 0.03811, 0.00543],[0.00123, 0.00193, 0.00097, 0.0035, 0.00763, 0.00826, 0.00788, 0.01538, 0.0012, 0.003, 0.00113, 0.00512, 0.16368, 0.19576, 0.02181, 0.31668, 0.00111, 0.00106, 0.00098, 0.00186, 0.00137, 0.00132, 0.00113, 0.00201, 0.0009, 0.00065, 0.0007, 0.00113, 0.014, 0.01601, 0.01217, 0.02313, 0.00071, 0.00051, 0.00074, 0.00096, 0.00419, 0.00373, 0.00414, 0.0063, 0.00087, 0.00105, 0.00089, 0.00159, 0.03429, 0.0417, 0.03137, 0.06628, 0.00098, 0.00168, 0.00194, 0.00186, 0.0019, 0.00256, 0.00122, 0.0005, 0.00199, 0.0135, 0.00508, 0.0121, 0.00825],[0.0149, 0.00431, 0.00969, 0.0055, 0.00454, 0.00237, 0.00351, 0.00309, 0.01154, 0.00339, 0.00824, 0.00377, 0.00184, 0.00079, 0.00254, 0.00087, 0.26231, 0.02332, 0.14369, 0.02704, 0.01374, 0.00618, 0.01156, 0.00656, 0.02448, 0.01132, 0.01691, 0.01436, 0.00687, 0.00262, 0.00367, 0.00333, 0.01305, 0.00297, 0.00911, 0.00341, 0.00407, 0.00209, 0.00371, 0.0024, 0.0029, 0.0015, 0.00246, 0.00161, 0.00267, 0.00122, 0.00149, 0.00156, 0.00213, 0.00263, 0.00511, 0.00283, 0.00366, 0.00321, 0.00153, 0.0015, 0.00175, 0.00326, 0.00073, 0.00284, 0.0009],[0.00361, 0.0163, 0.00355, 0.01154, 0.00185, 0.00305, 0.00187, 0.00219, 0.00481, 0.0074, 0.00524, 0.00511, 0.00083, 0.001, 0.0011, 0.00087, 0.02452, 0.41696, 0.0224, 0.28133, 0.00407, 0.00786, 0.00564, 0.00486, 0.011, 0.02839, 0.01124, 0.02084, 0.00228, 0.00488, 0.00196, 0.0036, 0.00216, 0.0049, 0.0024, 0.00309, 0.00143, 0.00212, 0.00186, 0.00146, 0.0012, 0.00281, 0.00144, 0.00173, 0.00099, 0.00142, 0.00084, 0.00093, 0.02363, 0.01766, 0.00233, 0.00371, 0.00263, 0.00296, 0.005, 0.001, 0.00393, 0.00153, 0.00365, 0.00148, 0.00267],[0.02161, 0.00954, 0.02948, 0.01075, 0.00756, 0.00521, 0.00928, 0.00529, 0.01636, 0.00748, 0.02167, 0.00709, 0.00289, 0.00161, 0.00685, 0.00188, 0.35405, 0.0525, 0.52647, 0.05483, 0.01993, 0.01301, 0.03017, 0.01156, 0.03288, 0.02725, 0.05789, 0.0278, 0.01045, 0.00687, 0.01124, 0.0072, 0.01992, 0.00656, 0.02826, 0.00642, 0.00643, 0.00528, 0.00923, 0.00477, 0.00391, 0.00358, 0.00643, 0.0035, 0.00407, 0.00261, 0.00379, 0.00287, 0.00459, 0.0047, 0.00821, 0.00593, 0.00939, 0.00574, 0.0031, 0.00572, 0.00338, 0.00622, 0.00148, 0.00764, 0.00156],[0.00339, 0.00922, 0.00287, 0.0147, 0.00194, 0.00187, 0.00163, 0.00275, 0.00429, 0.00439, 0.00384, 0.00665, 0.00099, 0.00073, 0.00124, 0.00123, 0.02293, 0.22692, 0.01887, 0.33894, 0.00376, 0.0048, 0.00463, 0.00671, 0.00924, 0.01386, 0.00858, 0.02509, 0.00201, 0.00314, 0.00181, 0.00514, 0.00242, 0.00305, 0.0022, 0.00439, 0.0015, 0.00111, 0.00167, 0.00174, 0.00119, 0.00168, 0.00126, 0.00264, 0.00091, 0.00089, 0.00076, 0.00115, 0.01282, 0.02091, 0.00221, 0.0023, 0.00209, 0.00359, 0.00311, 0.00121, 0.00552, 0.00166, 0.00209, 0.00149, 0.003],[0.0025, 0.00165, 0.00178, 0.00225, 0.01289, 0.00579, 0.00716, 0.0076, 0.00178, 0.00249, 0.0017, 0.00296, 0.00296, 0.00102, 0.00249, 0.00139, 0.01784, 0.00503, 0.01051, 0.00575, 0.32539, 0.17662, 0.22917, 0.19929, 0.00451, 0.00264, 0.00359, 0.00313, 0.0106, 0.00323, 0.00523, 0.00455, 0.0023, 0.00101, 0.00202, 0.00122, 0.01506, 0.00722, 0.01036, 0.0089, 0.00218, 0.00185, 0.00212, 0.00198, 0.00489, 0.00226, 0.00283, 0.0025, 0.00052, 0.00069, 0.02995, 0.01275, 0.01891, 0.01569, 0.00078, 0.00066, 0.00126, 0.00521, 0.00075, 0.00437, 0.00094],[0.00113, 0.00233, 0.00098, 0.00198, 0.0058, 0.00975, 0.00608, 0.00667, 0.00105, 0.00386, 0.00106, 0.00243, 0.00143, 0.00147, 0.00145, 0.00114, 0.00678, 0.0082, 0.00579, 0.0062, 0.14911, 0.30688, 0.17731, 0.17279, 0.00231, 0.00448, 0.0024, 0.00324, 0.00369, 0.00639, 0.00264, 0.00411, 0.00115, 0.00139, 0.0013, 0.00097, 0.00721, 0.01193, 0.00906, 0.00791, 0.00134, 0.00233, 0.00173, 0.00169, 0.0022, 0.00303, 0.00172, 0.00199, 0.00112, 0.00079, 0.01305, 0.02477, 0.01391, 0.01529, 0.00146, 0.00026, 0.00117, 0.00205, 0.00154, 0.00207, 0.00097],[0.00076, 0.00067, 0.00081, 0.00076, 0.00303, 0.0021, 0.00352, 0.00242, 0.00077, 0.00104, 0.00092, 0.00095, 0.00077, 0.0004, 0.001, 0.00038, 0.00497, 0.00231, 0.00527, 0.00235, 0.07588, 0.06954, 0.12303, 0.06422, 0.00157, 0.00154, 0.00262, 0.00144, 0.00259, 0.00131, 0.00272, 0.00166, 0.00068, 0.00047, 0.00079, 0.00045, 0.00387, 0.00313, 0.00691, 0.00291, 0.00072, 0.00089, 0.00109, 0.00068, 0.00113, 0.00088, 0.00113, 0.00089, 0.00028, 0.00028, 0.00667, 0.00483, 0.0089, 0.00515, 0.00043, 0.00045, 0.00053, 0.00143, 0.0003, 0.00188, 0.00038],[0.00146, 0.00193, 0.00114, 0.00302, 0.00821, 0.00726, 0.00631, 0.01221, 0.00119, 0.00299, 0.00112, 0.00419, 0.00193, 0.00112, 0.00184, 0.00203, 0.00844, 0.00595, 0.00604, 0.01019, 0.19753, 0.20286, 0.19224, 0.31933, 0.00265, 0.00284, 0.0022, 0.00598, 0.0043, 0.00442, 0.00312, 0.009, 0.00143, 0.00105, 0.00135, 0.00142, 0.01009, 0.00899, 0.00938, 0.01445, 0.0016, 0.00188, 0.00169, 0.00281, 0.00256, 0.00214, 0.00207, 0.00391, 0.00082, 0.00139, 0.01758, 0.01622, 0.01606, 0.02968, 0.00143, 0.00034, 0.00259, 0.00261, 0.00096, 0.00293, 0.00206],[0.01001, 0.00097, 0.00814, 0.00122, 0.00098, 0.0007, 0.00116, 0.00063, 0.06878, 0.00173, 0.05289, 0.00168, 0.00069, 0.00019, 0.00062, 0.00032, 0.01108, 0.00473, 0.00604, 0.00493, 0.00157, 0.00095, 0.00165, 0.00093, 0.14856, 0.08404, 0.0946, 0.10057, 0.00154, 0.00076, 0.00078, 0.0007, 0.0008, 0.00028, 0.00062, 0.0003, 0.00063, 0.00042, 0.00065, 0.00033, 0.00159, 0.00071, 0.00139, 0.00095, 0.00052, 0.00025, 0.00029, 0.00025, 0.0004, 0.00066, 0.0008, 0.00051, 0.00078, 0.00048, 0.00138, 0.00182, 0.00146, 0.00055, 0.00015, 0.00056, 0.00019],[0.00872, 0.00274, 0.00983, 0.00181, 0.00107, 0.00145, 0.00154, 0.00112, 0.05098, 0.00506, 0.05731, 0.00269, 0.00056, 0.00042, 0.00079, 0.00033, 0.00722, 0.01721, 0.00705, 0.01042, 0.0013, 0.0026, 0.00228, 0.00141, 0.11837, 0.27708, 0.11422, 0.16725, 0.00093, 0.00259, 0.00106, 0.00145, 0.00058, 0.00077, 0.00085, 0.00052, 0.00058, 0.00115, 0.00113, 0.00057, 0.00103, 0.00274, 0.00137, 0.00131, 0.00038, 0.00064, 0.00046, 0.00044, 0.00165, 0.00127, 0.00069, 0.00149, 0.00118, 0.00084, 0.0062, 0.0017, 0.00285, 0.00067, 0.00061, 0.00061, 0.00027],[0.0117, 0.00157, 0.01417, 0.00165, 0.00136, 0.001, 0.00193, 0.00094, 0.06881, 0.00241, 0.08484, 0.00244, 0.0007, 0.00032, 0.00122, 0.00034, 0.0105, 0.00664, 0.01459, 0.00628, 0.00172, 0.00136, 0.00378, 0.00106, 0.12984, 0.11128, 0.1872, 0.11799, 0.00157, 0.00111, 0.00188, 0.00119, 0.00085, 0.00048, 0.0014, 0.00048, 0.00092, 0.00067, 0.00166, 0.00071, 0.00137, 0.00135, 0.00315, 0.00099, 0.00061, 0.00051, 0.00069, 0.00044, 0.00056, 0.00064, 0.00097, 0.00089, 0.00158, 0.00075, 0.00206, 0.00512, 0.00183, 0.00089, 0.00026, 0.00121, 0.00028],[0.00572, 0.00126, 0.00558, 0.002, 0.00081, 0.00071, 0.00076, 0.00108, 0.038, 0.00212, 0.0341, 0.00331, 0.00048, 0.00025, 0.00052, 0.00035, 0.00569, 0.00786, 0.00447, 0.01173, 0.00096, 0.00117, 0.00133, 0.00184, 0.0881, 0.10402, 0.07532, 0.15866, 0.00073, 0.00098, 0.00063, 0.00158, 0.00056, 0.00036, 0.00048, 0.0005, 0.00055, 0.00054, 0.00063, 0.00064, 0.00085, 0.00102, 0.00086, 0.00166, 0.00034, 0.00033, 0.0003, 0.00044, 0.00088, 0.00158, 0.00064, 0.00072, 0.00069, 0.00109, 0.00239, 0.00105, 0.00408, 0.00051, 0.00029, 0.00056, 0.00043],[0.00077, 0.00037, 0.00053, 0.00046, 0.00202, 0.00092, 0.00157, 0.00111, 0.00085, 0.00041, 0.00067, 0.00046, 0.01368, 0.00577, 0.01004, 0.00644, 0.00403, 0.00127, 0.00249, 0.0014, 0.0048, 0.00197, 0.00354, 0.00196, 0.00201, 0.00085, 0.00148, 0.00108, 0.1062, 0.04915, 0.06203, 0.05216, 0.0005, 0.00015, 0.00039, 0.00017, 0.00189, 0.0009, 0.00143, 0.00106, 0.00044, 0.00025, 0.00039, 0.00031, 0.00805, 0.00397, 0.00533, 0.00398, 0.00069, 0.00094, 0.00279, 0.00104, 0.00206, 0.00118, 0.00042, 0.00088, 0.0007, 0.072, 0.00381, 0.05304, 0.00424],[0.00078, 0.0013, 0.0007, 0.00089, 0.00202, 0.00337, 0.0026, 0.00222, 0.00092, 0.00161, 0.00111, 0.00101, 0.01591, 0.02419, 0.01526, 0.01589, 0.00332, 0.00589, 0.00354, 0.0047, 0.00315, 0.00739, 0.00385, 0.00436, 0.00212, 0.00516, 0.00227, 0.00313, 0.10612, 0.267, 0.10385, 0.14785, 0.00052, 0.00054, 0.00061, 0.00033, 0.00188, 0.0032, 0.00265, 0.00206, 0.00054, 0.00091, 0.00067, 0.00056, 0.00902, 0.01816, 0.00898, 0.01018, 0.00315, 0.00233, 0.00198, 0.00322, 0.002, 0.00197, 0.00272, 0.00113, 0.00185, 0.07661, 0.01939, 0.07639, 0.01149],[0.00188, 0.00137, 0.00243, 0.00153, 0.00633, 0.00465, 0.00801, 0.00487, 0.00254, 0.00199, 0.00318, 0.00183, 0.03601, 0.0258, 0.05557, 0.026, 0.01002, 0.00508, 0.01246, 0.00582, 0.01099, 0.00658, 0.01728, 0.00662, 0.0047, 0.00453, 0.00827, 0.00434, 0.28833, 0.22357, 0.37963, 0.22568, 0.00137, 0.00064, 0.00186, 0.00062, 0.00595, 0.0043, 0.00903, 0.00451, 0.00115, 0.0012, 0.00225, 0.0012, 0.02453, 0.01807, 0.03125, 0.01804, 0.00307, 0.00381, 0.00703, 0.00406, 0.00858, 0.00432, 0.00221, 0.00507, 0.00275, 0.21527, 0.01736, 0.27841, 0.01931],[0.00084, 0.00076, 0.00068, 0.00151, 0.00213, 0.00191, 0.00248, 0.00316, 0.00099, 0.00111, 0.00085, 0.00146, 0.01399, 0.0134, 0.01338, 0.01988, 0.00366, 0.00376, 0.00321, 0.00665, 0.00385, 0.00412, 0.00424, 0.00768, 0.0017, 0.0025, 0.00211, 0.00439, 0.09753, 0.12805, 0.09079, 0.2261, 0.00055, 0.00041, 0.00053, 0.00053, 0.00216, 0.00201, 0.00243, 0.00294, 0.00056, 0.00063, 0.00062, 0.00088, 0.00865, 0.00905, 0.0077, 0.01443, 0.00195, 0.00295, 0.00232, 0.00186, 0.00201, 0.00325, 0.00159, 0.00108, 0.00239, 0.07121, 0.00989, 0.07363, 0.01629],[0.01709, 0.00734, 0.01015, 0.0101, 0.00708, 0.0036, 0.00504, 0.0043, 0.00731, 0.00571, 0.00472, 0.00677, 0.00335, 0.00101, 0.0024, 0.00127, 0.02968, 0.00467, 0.01839, 0.00649, 0.00403, 0.00239, 0.00358, 0.00253, 0.00401, 0.00208, 0.00311, 0.00319, 0.00193, 0.00093, 0.00114, 0.00114, 0.39774, 0.06078, 0.26124, 0.06884, 0.01546, 0.00619, 0.01168, 0.00739, 0.0188, 0.0068, 0.01319, 0.0083, 0.00774, 0.00281, 0.00428, 0.00352, 0.00088, 0.00127, 0.00515, 0.0028, 0.00418, 0.00343, 0.00069, 0.00061, 0.00102, 0.00193, 0.0004, 0.00179, 0.00057],[0.00347, 0.02932, 0.00302, 0.02079, 0.00239, 0.00438, 0.00301, 0.0037, 0.00177, 0.01201, 0.00163, 0.00896, 0.0007, 0.00091, 0.00082, 0.00072, 0.00534, 0.00838, 0.00479, 0.00647, 0.0014, 0.00229, 0.00195, 0.00147, 0.00111, 0.00216, 0.00139, 0.00163, 0.00045, 0.00076, 0.00042, 0.00067, 0.04806, 0.43708, 0.05027, 0.26165, 0.00421, 0.00744, 0.00592, 0.00459, 0.00701, 0.01655, 0.00702, 0.0104, 0.0017, 0.00305, 0.00124, 0.00205, 0.00228, 0.00184, 0.00256, 0.00364, 0.00299, 0.00264, 0.00132, 0.00022, 0.00121, 0.00061, 0.00054, 0.00049, 0.00036],[0.01224, 0.00882, 0.01758, 0.01069, 0.00698, 0.00452, 0.00761, 0.00515, 0.00508, 0.00715, 0.00795, 0.00789, 0.00285, 0.00119, 0.00412, 0.00165, 0.02591, 0.00649, 0.03262, 0.00738, 0.00442, 0.00337, 0.00523, 0.00297, 0.0039, 0.00381, 0.00639, 0.00346, 0.00188, 0.00136, 0.00193, 0.00138, 0.32656, 0.07947, 0.4719, 0.07833, 0.01369, 0.00828, 0.02097, 0.0084, 0.01223, 0.00812, 0.02184, 0.00829, 0.00699, 0.00358, 0.00705, 0.00374, 0.00109, 0.00149, 0.00499, 0.00373, 0.00551, 0.00391, 0.00108, 0.00115, 0.0011, 0.00196, 0.00051, 0.00215, 0.00057],[0.0039, 0.01967, 0.00326, 0.03509, 0.00349, 0.00301, 0.0029, 0.00525, 0.00202, 0.00822, 0.00179, 0.0139, 0.00108, 0.00052, 0.00089, 0.00139, 0.00627, 0.0054, 0.0048, 0.00953, 0.00173, 0.00164, 0.00193, 0.00203, 0.00123, 0.00151, 0.00141, 0.00234, 0.00053, 0.00048, 0.00042, 0.00088, 0.05572, 0.26784, 0.05072, 0.43347, 0.00512, 0.0045, 0.00523, 0.0081, 0.00733, 0.00956, 0.00728, 0.01881, 0.00211, 0.00179, 0.00146, 0.00383, 0.00142, 0.00322, 0.00305, 0.00251, 0.0029, 0.00412, 0.00094, 0.00026, 0.00182, 0.0006, 0.0003, 0.00066, 0.00065],[0.0042, 0.00329, 0.0028, 0.00445, 0.03406, 0.01529, 0.02203, 0.0194, 0.00316, 0.00652, 0.00261, 0.00783, 0.00906, 0.00303, 0.00755, 0.00429, 0.00533, 0.00178, 0.00342, 0.00232, 0.01518, 0.00861, 0.01179, 0.01026, 0.00183, 0.0012, 0.00194, 0.00181, 0.0042, 0.00194, 0.00285, 0.00258, 0.0089, 0.00307, 0.0063, 0.00364, 0.23923, 0.11918, 0.15637, 0.14627, 0.0143, 0.00833, 0.01186, 0.01034, 0.02504, 0.01103, 0.01617, 0.01387, 0.00064, 0.00092, 0.03383, 0.01772, 0.02497, 0.02121, 0.00242, 0.0007, 0.00319, 0.00544, 0.001, 0.00402, 0.00152],[0.00216, 0.00666, 0.00214, 0.00477, 0.01826, 0.03896, 0.02024, 0.02197, 0.002, 0.01389, 0.00218, 0.00881, 0.0049, 0.00719, 0.00561, 0.00454, 0.00325, 0.00314, 0.00333, 0.00203, 0.00864, 0.01692, 0.0113, 0.01087, 0.00143, 0.00281, 0.00168, 0.0021, 0.00238, 0.00393, 0.00245, 0.00284, 0.00423, 0.00644, 0.00453, 0.0038, 0.14159, 0.30926, 0.16163, 0.17132, 0.009, 0.01747, 0.01036, 0.01073, 0.01353, 0.02825, 0.01244, 0.01575, 0.00132, 0.00116, 0.02187, 0.03748, 0.02494, 0.02424, 0.00536, 0.00071, 0.0038, 0.00296, 0.00242, 0.00297, 0.0016],[0.00105, 0.00142, 0.00113, 0.00142, 0.00727, 0.00619, 0.01053, 0.00628, 0.00088, 0.00265, 0.00115, 0.00253, 0.0023, 0.0014, 0.0029, 0.00141, 0.00162, 0.00077, 0.00164, 0.00086, 0.00348, 0.00361, 0.00701, 0.00318, 0.00063, 0.00077, 0.00116, 0.0007, 0.00106, 0.00091, 0.00144, 0.00097, 0.00224, 0.00144, 0.00322, 0.00124, 0.05211, 0.04534, 0.09721, 0.04571, 0.00369, 0.00373, 0.00604, 0.0034, 0.00602, 0.00467, 0.00805, 0.00492, 0.00039, 0.00033, 0.00788, 0.00695, 0.01329, 0.00722, 0.00115, 0.00035, 0.00117, 0.00115, 0.00052, 0.0019, 0.00052],[0.00252, 0.00447, 0.002, 0.00662, 0.02052, 0.01964, 0.0185, 0.03483, 0.00205, 0.00895, 0.00174, 0.01249, 0.00575, 0.00436, 0.00555, 0.00719, 0.0035, 0.00203, 0.00283, 0.003, 0.01, 0.01053, 0.00989, 0.01638, 0.00106, 0.00131, 0.00168, 0.00236, 0.00263, 0.00237, 0.00241, 0.00391, 0.00474, 0.00373, 0.00431, 0.00642, 0.16307, 0.16078, 0.15293, 0.26402, 0.00971, 0.01006, 0.00926, 0.01592, 0.01546, 0.01441, 0.01257, 0.02627, 0.00104, 0.00163, 0.02398, 0.02228, 0.0232, 0.03371, 0.00351, 0.00044, 0.00515, 0.00335, 0.00154, 0.00328, 0.0025],[0.00358, 0.00502, 0.00228, 0.00574, 0.00469, 0.0029, 0.00379, 0.00338, 0.01183, 0.01281, 0.0062, 0.01328, 0.00201, 0.00064, 0.00169, 0.00092, 0.00391, 0.00153, 0.00214, 0.0019, 0.00227, 0.00165, 0.00227, 0.00168, 0.00473, 0.00217, 0.00299, 0.00288, 0.001, 0.00058, 0.00057, 0.00069, 0.01115, 0.00526, 0.0058, 0.00537, 0.01473, 0.00781, 0.0114, 0.00897, 0.3478, 0.16769, 0.23567, 0.18952, 0.00616, 0.0021, 0.00285, 0.00254, 0.00027, 0.00053, 0.00478, 0.00329, 0.00402, 0.00361, 0.00209, 0.00124, 0.0027, 0.00105, 0.00035, 0.00089, 0.00053],[0.0017, 0.01217, 0.00166, 0.00834, 0.00328, 0.00607, 0.00391, 0.00427, 0.00375, 0.03494, 0.00371, 0.02125, 0.00114, 0.00147, 0.00124, 0.00106, 0.00193, 0.00345, 0.00187, 0.00255, 0.00184, 0.00273, 0.00267, 0.00188, 0.00203, 0.00553, 0.00281, 0.00332, 0.00054, 0.00093, 0.00057, 0.00074, 0.00385, 0.01186, 0.00368, 0.00669, 0.0082, 0.01447, 0.01101, 0.00888, 0.16015, 0.33181, 0.16396, 0.19735, 0.00251, 0.00482, 0.00206, 0.0029, 0.00094, 0.00074, 0.00366, 0.00538, 0.00514, 0.00397, 0.00686, 0.00092, 0.00466, 0.00063, 0.00069, 0.00076, 0.00058],[0.00199, 0.00449, 0.0026, 0.00417, 0.003, 0.00227, 0.00372, 0.00271, 0.00511, 0.01093, 0.01016, 0.01069, 0.00118, 0.00069, 0.00202, 0.00067, 0.00238, 0.00133, 0.00253, 0.00144, 0.00159, 0.00154, 0.00247, 0.00127, 0.00297, 0.00208, 0.00492, 0.0021, 0.00065, 0.00051, 0.0008, 0.00055, 0.00563, 0.00379, 0.00746, 0.00384, 0.0088, 0.00646, 0.01343, 0.00616, 0.1696, 0.12355, 0.25839, 0.1255, 0.00376, 0.00205, 0.00386, 0.00221, 0.0003, 0.00044, 0.00341, 0.00258, 0.00448, 0.00252, 0.00192, 0.00306, 0.00207, 0.00082, 0.00032, 0.00123, 0.00035],[0.00139, 0.00579, 0.00118, 0.00876, 0.00258, 0.00284, 0.00242, 0.00422, 0.00265, 0.01406, 0.00232, 0.02298, 0.00076, 0.00058, 0.0009, 0.00105, 0.00136, 0.00139, 0.0012, 0.00263, 0.00129, 0.0013, 0.00134, 0.00184, 0.00178, 0.00173, 0.00134, 0.00353, 0.00044, 0.00037, 0.00037, 0.00067, 0.00308, 0.00488, 0.00246, 0.00863, 0.00667, 0.00583, 0.00658, 0.00921, 0.11872, 0.12944, 0.10924, 0.23409, 0.00222, 0.00182, 0.00168, 0.00362, 0.00039, 0.00083, 0.00274, 0.00248, 0.00303, 0.00362, 0.00285, 0.00053, 0.005, 0.00058, 0.00029, 0.0005, 0.00054],[0.00125, 0.0007, 0.00081, 0.00088, 0.00768, 0.00369, 0.00568, 0.00431, 0.00136, 0.00122, 0.00088, 0.00127, 0.03506, 0.01433, 0.00968, 0.01644, 0.00164, 0.00058, 0.00101, 0.00066, 0.00231, 0.00123, 0.00161, 0.00122, 0.00071, 0.00036, 0.0006, 0.00053, 0.00839, 0.00435, 0.0055, 0.00482, 0.00209, 0.00058, 0.0015, 0.0007, 0.01171, 0.00533, 0.00845, 0.00649, 0.0028, 0.00119, 0.00237, 0.00161, 0.1305, 0.06004, 0.08321, 0.067, 0.00032, 0.00044, 0.00327, 0.00151, 0.00226, 0.00187, 0.00066, 0.00031, 0.00086, 0.01148, 0.00135, 0.0071, 0.00175],[0.00077, 0.00185, 0.0007, 0.00139, 0.0056, 0.01096, 0.00634, 0.00698, 0.00078, 0.00319, 0.00096, 0.00216, 0.02964, 0.05429, 0.00957, 0.03284, 0.00123, 0.00136, 0.00107, 0.00106, 0.00175, 0.00278, 0.00206, 0.00168, 0.00055, 0.001, 0.00082, 0.00084, 0.0068, 0.01441, 0.00666, 0.0083, 0.00124, 0.00171, 0.00127, 0.00098, 0.00848, 0.01828, 0.01077, 0.00994, 0.00157, 0.00376, 0.00213, 0.00217, 0.09869, 0.2371, 0.1005, 0.12299, 0.00124, 0.00094, 0.00265, 0.00371, 0.00242, 0.0025, 0.0019, 0.00037, 0.00148, 0.00684, 0.0059, 0.00665, 0.0035],[0.00207, 0.00172, 0.00231, 0.00198, 0.01441, 0.0103, 0.01777, 0.01185, 0.0019, 0.00289, 0.00292, 0.00315, 0.06259, 0.04713, 0.03843, 0.04759, 0.00289, 0.00156, 0.00298, 0.00175, 0.00423, 0.00304, 0.00508, 0.00311, 0.00125, 0.00139, 0.00216, 0.00147, 0.01759, 0.01373, 0.02219, 0.0136, 0.00365, 0.00133, 0.00481, 0.00154, 0.02394, 0.01551, 0.03579, 0.01669, 0.0041, 0.0031, 0.00771, 0.00384, 0.26346, 0.1936, 0.3678, 0.2048, 0.00114, 0.00126, 0.00649, 0.00409, 0.00747, 0.00474, 0.00197, 0.00141, 0.00261, 0.01844, 0.00438, 0.02497, 0.00505],[0.00099, 0.00135, 0.00073, 0.00205, 0.00673, 0.00661, 0.00719, 0.01096, 0.00092, 0.00252, 0.00083, 0.00355, 0.03145, 0.03118, 0.01061, 0.05157, 0.00155, 0.00088, 0.00116, 0.00135, 0.00191, 0.0018, 0.00205, 0.00302, 0.00055, 0.00069, 0.0007, 0.00111, 0.00673, 0.00798, 0.00657, 0.01306, 0.00154, 0.00113, 0.00131, 0.00207, 0.01053, 0.01007, 0.01122, 0.01789, 0.00188, 0.00224, 0.00227, 0.00427, 0.10879, 0.1215, 0.10502, 0.2139, 0.00068, 0.00127, 0.00326, 0.00273, 0.00266, 0.00395, 0.0016, 0.00054, 0.00206, 0.00775, 0.00321, 0.00774, 0.00556],[0.00052, 0.0038, 0.00051, 0.00276, 0.00055, 0.00112, 0.00079, 0.00097, 0.00064, 0.002, 0.00062, 0.00155, 0.0007, 0.00121, 0.00091, 0.0009, 0.00249, 0.02629, 0.00218, 0.01767, 0.00047, 0.00119, 0.00076, 0.00075, 0.00104, 0.00302, 0.00105, 0.00259, 0.00137, 0.0029, 0.00131, 0.00208, 0.00045, 0.00148, 0.00045, 0.0009, 0.00057, 0.00099, 0.00103, 0.00083, 0.00024, 0.00085, 0.00037, 0.00054, 0.00061, 0.00145, 0.00069, 0.0008, 0.52036, 0.34215, 0.00165, 0.00423, 0.00206, 0.00278, 0.01125, 0.00267, 0.00797, 0.00245, 0.03633, 0.00182, 0.02556],[0.00055, 0.00233, 0.00048, 0.00411, 0.00073, 0.0009, 0.00093, 0.00129, 0.00063, 0.00141, 0.0007, 0.00239, 0.00086, 0.00085, 0.00093, 0.00127, 0.00254, 0.01622, 0.00184, 0.02381, 0.00051, 0.0007, 0.00062, 0.00104, 0.0014, 0.00193, 0.001, 0.00386, 0.00154, 0.00177, 0.00135, 0.00259, 0.00054, 0.00099, 0.00051, 0.00169, 0.00068, 0.00072, 0.00073, 0.00108, 0.00038, 0.00055, 0.00044, 0.00095, 0.00069, 0.00091, 0.00063, 0.00123, 0.2824, 0.43553, 0.00182, 0.00266, 0.0019, 0.00437, 0.00668, 0.00257, 0.01282, 0.00248, 0.02244, 0.00177, 0.03261],[0.00246, 0.00313, 0.00173, 0.00372, 0.02612, 0.01384, 0.01893, 0.01764, 0.0019, 0.00783, 0.00134, 0.009, 0.00365, 0.00118, 0.00378, 0.00148, 0.00498, 0.00216, 0.00325, 0.00254, 0.0225, 0.01161, 0.01514, 0.01332, 0.00171, 0.00105, 0.00152, 0.00158, 0.00463, 0.00152, 0.00251, 0.00206, 0.00221, 0.00139, 0.00171, 0.00162, 0.02522, 0.01372, 0.01763, 0.01604, 0.00346, 0.00277, 0.00342, 0.00316, 0.00521, 0.00257, 0.00326, 0.0032, 0.00138, 0.00184, 0.23909, 0.11502, 0.1691, 0.12683, 0.00437, 0.0018, 0.00593, 0.0133, 0.00185, 0.00823, 0.00264],[0.00156, 0.00588, 0.00132, 0.00419, 0.01627, 0.02719, 0.01865, 0.01823, 0.00147, 0.01511, 0.00133, 0.01003, 0.00212, 0.00193, 0.00252, 0.0017, 0.00331, 0.00412, 0.00281, 0.00317, 0.01146, 0.02639, 0.01312, 0.01472, 0.00133, 0.00273, 0.00168, 0.00211, 0.00207, 0.00297, 0.00174, 0.00198, 0.00144, 0.00237, 0.00153, 0.0016, 0.01581, 0.02815, 0.0186, 0.01783, 0.00285, 0.00488, 0.00311, 0.00343, 0.00288, 0.0043, 0.00246, 0.00321, 0.00423, 0.00322, 0.13767, 0.298, 0.16395, 0.15853, 0.0114, 0.00119, 0.00754, 0.00461, 0.00611, 0.00437, 0.00336],[0.00062, 0.00105, 0.00056, 0.00112, 0.00653, 0.00479, 0.00809, 0.00564, 0.00054, 0.00326, 0.00057, 0.00305, 0.00083, 0.00039, 0.00138, 0.00047, 0.00116, 0.00079, 0.00121, 0.00078, 0.00461, 0.00401, 0.00654, 0.00395, 0.00054, 0.00058, 0.0008, 0.00055, 0.00111, 0.0005, 0.00099, 0.00058, 0.00058, 0.00053, 0.00061, 0.0005, 0.00603, 0.00507, 0.00964, 0.00503, 0.00094, 0.00126, 0.00146, 0.00114, 0.00117, 0.00076, 0.00122, 0.00085, 0.00056, 0.00062, 0.05482, 0.04441, 0.09137, 0.04539, 0.00164, 0.00106, 0.00187, 0.00193, 0.00062, 0.00328, 0.0009],[0.00208, 0.00489, 0.00156, 0.00647, 0.02149, 0.01922, 0.01948, 0.02968, 0.00187, 0.01221, 0.00152, 0.01518, 0.00221, 0.00152, 0.00327, 0.00251, 0.00402, 0.00352, 0.00292, 0.0053, 0.01512, 0.01746, 0.015, 0.02887, 0.00132, 0.00164, 0.00151, 0.00344, 0.00251, 0.00195, 0.00198, 0.0037, 0.00189, 0.00184, 0.00172, 0.0028, 0.02029, 0.01952, 0.02071, 0.02892, 0.00335, 0.00386, 0.00325, 0.00537, 0.00382, 0.00311, 0.00306, 0.00497, 0.00298, 0.00566, 0.16272, 0.16995, 0.17963, 0.27638, 0.00831, 0.00124, 0.01443, 0.00597, 0.0037, 0.00551, 0.00694],[0.00059, 0.00238, 0.00058, 0.00175, 0.00142, 0.00264, 0.00155, 0.00207, 0.00125, 0.01013, 0.00143, 0.00728, 0.00068, 0.00111, 0.00069, 0.00083, 0.00133, 0.00414, 0.00109, 0.00319, 0.00052, 0.00116, 0.00087, 0.00097, 0.00266, 0.00847, 0.00289, 0.00524, 0.00063, 0.00187, 0.0007, 0.00126, 0.00026, 0.00064, 0.00033, 0.00044, 0.00161, 0.003, 0.0023, 0.00209, 0.00135, 0.00464, 0.00172, 0.00294, 0.00094, 0.00164, 0.00088, 0.0014, 0.00838, 0.00603, 0.0039, 0.00849, 0.0045, 0.00578, 0.52365, 0.00371, 0.31521, 0.00117, 0.00438, 0.00118, 0.00341],[0.00056, 0.00029, 0.00083, 0.00035, 0.00054, 0.00036, 0.00076, 0.00031, 0.00209, 0.00059, 0.00469, 0.00068, 0.00049, 0.0003, 0.00118, 0.00036, 0.00137, 0.00087, 0.00212, 0.0013, 0.00046, 0.00022, 0.00096, 0.00024, 0.00367, 0.00244, 0.00752, 0.00241, 0.00137, 0.00081, 0.00169, 0.0009, 0.00024, 0.00011, 0.00037, 0.00013, 0.00049, 0.00041, 0.00072, 0.00028, 0.00084, 0.00065, 0.00287, 0.00057, 0.00046, 0.00034, 0.00066, 0.00049, 0.00208, 0.00243, 0.00168, 0.00093, 0.00305, 0.0009, 0.00388, 0.90947, 0.00412, 0.00171, 0.00193, 0.00447, 0.00229],[0.00063, 0.00167, 0.00055, 0.00284, 0.00187, 0.00182, 0.00199, 0.0029, 0.00145, 0.00687, 0.0013, 0.01006, 0.00076, 0.00081, 0.00076, 0.00125, 0.0014, 0.003, 0.0011, 0.00523, 0.00078, 0.00086, 0.00099, 0.00162, 0.0026, 0.00359, 0.00237, 0.00827, 0.00096, 0.00117, 0.00081, 0.00175, 0.00036, 0.00054, 0.00031, 0.0008, 0.00196, 0.00196, 0.00216, 0.00283, 0.00161, 0.00291, 0.00172, 0.00476, 0.00112, 0.00118, 0.00108, 0.00166, 0.00548, 0.01067, 0.00488, 0.00518, 0.00475, 0.00926, 0.29089, 0.00363, 0.48068, 0.00143, 0.00289, 0.00142, 0.00503],[0.00072, 0.0004, 0.00049, 0.00059, 0.00283, 0.00124, 0.00211, 0.00162, 0.00079, 0.00056, 0.00068, 0.00059, 0.01628, 0.00572, 0.01011, 0.00659, 0.00203, 0.0009, 0.00157, 0.00122, 0.0025, 0.00117, 0.00207, 0.00126, 0.00076, 0.00065, 0.0009, 0.00081, 0.0764, 0.03765, 0.04914, 0.0404, 0.00053, 0.00021, 0.00043, 0.0002, 0.00259, 0.00119, 0.00165, 0.00143, 0.00048, 0.00031, 0.00052, 0.00043, 0.01168, 0.00423, 0.00593, 0.00486, 0.00131, 0.0016, 0.00849, 0.00246, 0.00381, 0.00297, 0.00084, 0.00117, 0.00111, 0.17793, 0.00694, 0.0798, 0.00794],[0.0003, 0.00115, 0.00023, 0.00075, 0.00117, 0.00218, 0.00138, 0.00163, 0.00032, 0.00125, 0.00029, 0.00081, 0.00449, 0.00834, 0.00406, 0.00569, 0.00104, 0.00497, 0.00086, 0.00354, 0.00083, 0.00201, 0.001, 0.00106, 0.00047, 0.00136, 0.00059, 0.00106, 0.0093, 0.02189, 0.0091, 0.01289, 0.00025, 0.00043, 0.00026, 0.00023, 0.0011, 0.00223, 0.0017, 0.00151, 0.00037, 0.00077, 0.00047, 0.00049, 0.00315, 0.00839, 0.00324, 0.00462, 0.04448, 0.03328, 0.00271, 0.0075, 0.0028, 0.00423, 0.0072, 0.00302, 0.00515, 0.01594, 0.51137, 0.01299, 0.28288],[0.00094, 0.00069, 0.001, 0.00089, 0.00342, 0.0021, 0.00404, 0.00256, 0.00094, 0.00083, 0.0011, 0.00103, 0.01597, 0.00789, 0.02462, 0.00978, 0.00293, 0.00145, 0.0032, 0.00182, 0.00348, 0.00195, 0.00451, 0.00235, 0.00129, 0.00098, 0.00201, 0.00146, 0.09329, 0.06223, 0.10535, 0.06926, 0.00082, 0.00028, 0.00078, 0.00037, 0.00317, 0.00197, 0.00449, 0.00232, 0.00068, 0.00061, 0.00131, 0.00061, 0.01198, 0.00682, 0.0133, 0.00805, 0.00161, 0.00189, 0.00872, 0.00387, 0.0107, 0.00455, 0.0014, 0.00506, 0.00182, 0.13228, 0.00937, 0.19038, 0.0116],[0.00037, 0.00089, 0.00032, 0.00132, 0.00152, 0.00148, 0.00172, 0.00238, 0.00048, 0.00103, 0.00047, 0.00149, 0.0057, 0.0055, 0.00473, 0.009, 0.00125, 0.00354, 0.00088, 0.00493, 0.00101, 0.00123, 0.00124, 0.00223, 0.00058, 0.0006, 0.00062, 0.00153, 0.01007, 0.01263, 0.00986, 0.02068, 0.00035, 0.00028, 0.00028, 0.00049, 0.00162, 0.00143, 0.00167, 0.00239, 0.00055, 0.00063, 0.0005, 0.00089, 0.00399, 0.00486, 0.00363, 0.0078, 0.03048, 0.04712, 0.00377, 0.00402, 0.00395, 0.00773, 0.00547, 0.00351, 0.00873, 0.01777, 0.27555, 0.01565, 0.49052]


# NOTE: added fudge factor here for numerical tolerance, from 1. - sum(ecmunrest_freqs) as seen in issue #18
ecmunrest_freqs = [0.03108988 + 9.999999828202988e-09, 0.02032094, 0.02669892, 0.02227593, 0.01311996, 0.01788195, 0.01068197, 0.01265596, 0.00974597, 0.01370096, 0.00678798, 0.01030997, 0.01281396, 0.02376193, 0.02117994, 0.02475893, 0.01716795, 0.01103997, 0.02072994, 0.01067097, 0.01116497, 0.01040797, 0.01219896, 0.01042497, 0.00480899, 0.01460396, 0.00815798, 0.00849097, 0.00735898, 0.01679795, 0.02849691, 0.01516695, 0.0345269 , 0.02528492, 0.03060591, 0.02858991, 0.01651595, 0.02681692, 0.01828795, 0.01890694, 0.01638595, 0.02365893, 0.01022297, 0.01688295, 0.01092097, 0.01841894, 0.02262593, 0.01901994, 0.01669695, 0.01723695, 0.01036597, 0.01076097, 0.00872097, 0.01179796, 0.00741498, 0.01274396, 0.00644098, 0.01619495, 0.02134894, 0.01571695, 0.02141394]
ecmunrest_matrix = [0., 4.139570000000000194e-01, 2.931524000000000019, 2.075153999999999943, 1.523250999999999911, 8.947599999999999998e-02, 1.995889999999999886e-01, 8.781630000000000269e-01, 5.815293999999999741, 3.342240000000000211e-01, 1.86819399999999991, 1.29386000000000001, 6.67397000000000018e-01, 2.30199999999999988e-02, 2.753550000000000164e-01, 2.215360000000000107e-01, 3.215816999999999926, 1.434789999999999954e-01, 2.853840000000000265e-01, 8.992620000000000058e-01, 1.042456999999999967, 1.23940000000000005e-02, 4.099999999999999912e-04, 2.471949999999999981e-01, 3.065510000000000179, 2.963580000000000103e-01, 1.103200000000000014e-02, 1.76987899999999998, 4.336200000000000054e-01, 2.14299999999999994e-03, 3.499999999999999693e-05, 6.092199999999999699e-02, 2.258321000000000023, 5.316799999999999998e-02, 1.592480000000000007e-01, 6.048590000000000355e-01, 9.236440000000000206e-01, 5.499999999999999681e-03, 4.820000000000000066e-04, 2.162439999999999918e-01, 7.139609999999999568e-01, 2.863000000000000093e-03, 1.157999999999999958e-03, 4.873000000000000248e-02, 7.082039999999999447e-01, 1.930000000000000075e-03, 1.930000000000000021e-04, 2.014799999999999924e-01, 4.2942000000000001e-02, 4.671359999999999957e-01, 1.496628000000000069, 2.09090000000000005e-02, 4.589999999999999896e-04, 3.409909999999999886e-01, 4.316000000000000392e-03, 5.100500000000000173e-02, 9.951899999999999635e-02, 6.126599999999999824e-01, 5.995999999999999594e-03, 4.963000000000000397e-03, 1.482680000000000109e-01],[4.139570000000000194e-01, 0., 1.038682000000000105, 7.634676999999999936, 2.599090000000000011e-01, 1.346384999999999943, 8.221330000000000027e-01, 2.960659999999999958e-01, 2.738550000000000151e-01, 4.127466000000000079, 6.00415000000000032e-01, 5.86685000000000012e-01, 2.083700000000000135e-02, 1.754910000000000081e-01, 2.191700000000000037e-01, 2.54050000000000005e-02, 3.77446999999999977e-01, 2.203539000000000136, 9.851450000000000484e-01, 4.609699999999999909e-01, 7.416100000000000469e-02, 5.320920000000000094e-01, 9.541800000000000281e-02, 9.59e-04, 1.663600000000000148e-02, 8.631910000000000416e-01, 6.521200000000000607e-02, 3.180000000000000101e-03, 1.454000000000000084e-02, 1.878799999999999915e-01, 3.491600000000000259e-02, 3.299999999999999982e-04, 1.935439999999999938e-01, 2.729646999999999935, 3.727190000000000225e-01, 3.716849999999999876e-01, 4.143499999999999961e-02, 5.659680000000000266e-01, 6.850100000000000633e-02, 1.329000000000000103e-03, 2.803999999999999826e-01, 1.110726000000000102, 2.938839999999999786e-01, 5.904999999999999659e-03, 2.36199999999999995e-03, 2.154919999999999891e-01, 1.358200000000000032e-02, 2.950000000000000148e-04, 4.878140000000000254e-01, 4.658600000000000241e-02, 1.87825999999999993e-01, 1.118208000000000091, 7.258360000000000367e-01, 3.389999999999999784e-03, 3.254219999999999891e-01, 5.390799999999999759e-02, 9.319999999999999942e-04, 2.840000000000000076e-03, 1.436139999999999917e-01, 6.069900000000000295e-02, 9.299999999999999727e-05],[2.931524000000000019, 1.038682000000000105, 0., 5.246469999999999745e-01, 2.561740000000000128e-01, 6.233659999999999757e-01, 1.144638999999999962, 2.910090000000000177e-01, 1.197613999999999956, 9.28876000000000035e-01, 7.316622999999999877, 3.890040000000000164e-01, 5.626699999999999757e-02, 1.164049999999999946e-01, 4.975930000000000075e-01, 4.143999999999999767e-02, 4.613829999999999876e-01, 5.714690000000000047e-01, 2.285051999999999861, 3.245250000000000079e-01, 1.200200000000000052e-02, 3.036130000000000217e-01, 5.615229999999999944e-01, 2.208160000000000123e-01, 3.451900000000000107e-02, 2.721042999999999878, 3.832199999999999829, 5.608309999999999684e-01, 6.790000000000000245e-04, 2.238400000000000112e-02, 1.330320000000000114e-01, 3.936200000000000115e-02, 3.088509999999999867e-01, 4.266840000000000077e-01, 1.563846000000000069, 1.880969999999999864e-01, 4.381999999999999611e-03, 3.739480000000000026e-01, 7.59132000000000029e-01, 2.686620000000000119e-01, 1.760000000000000063e-03, 1.762239999999999918e-01, 7.439999999999999947e-01, 2.164900000000000158e-02, 5.240000000000000517e-04, 5.614500000000000046e-02, 3.118850000000000233e-01, 7.213799999999999379e-02, 1.408639999999999892e-01, 7.286700000000000121e-02, 4.438000000000000105e-03, 2.516499999999999848e-01, 7.686070000000000402e-01, 1.56467999999999996e-01, 3.479399999999999854e-02, 1.052260000000000001e-01, 1.148899999999999921e-02, 6.20000000000000027e-05, 4.360900000000000193e-02, 3.337800000000000211e-01, 1.312199999999999998e-02],[2.075153999999999943, 7.634676999999999936, 5.246469999999999745e-01, 0., 1.243753000000000108, 6.755400000000000293e-02, 2.243970000000000131e-01, 2.057449000000000083, 9.368400000000000061e-01, 6.437889999999999446e-01, 4.543470000000000009e-01, 4.971506999999999898, 2.56282999999999983e-01, 1.435099999999999917e-02, 2.089239999999999986e-01, 2.393879999999999897e-01, 1.759732000000000074, 1.885870000000000046e-01, 2.068510000000000071e-01, 2.691225999999999896, 9.610399999999999499e-02, 1.920000000000000049e-04, 2.704999999999999939e-03, 7.873400000000000398e-01, 9.981000000000000288e-03, 6.799999999999999946e-05, 9.810000000000001011e-04, 6.822540000000000271e-01, 1.956799999999999859e-02, 0., 1.399999999999999877e-04, 2.593799999999999994e-01, 9.755819999999999492e-01, 1.67040999999999995e-01, 1.495779999999999887e-01, 3.529593000000000202, 8.462000000000000077e-02, 4.500000000000000283e-05, 3.771000000000000046e-03, 6.43159999999999954e-01, 9.098610000000000309e-01, 1.12199999999999995e-03, 1.949639999999999984e-01, 1.322233999999999909, 8.843999999999999431e-03, 0., 6.279999999999999775e-04, 3.185950000000000171e-01, 4.27620000000000014e-02, 7.478700000000000347e-01, 8.720839999999999703e-01, 9.290000000000000297e-04, 4.070599999999999913e-02, 1.773101999999999956, 1.350000000000000017e-04, 7.485899999999999499e-02, 3.600380000000000247e-01, 2.716279999999999806e-01, 9.399999999999999448e-05, 7.787800000000000278e-02, 2.635669999999999957e-01],[1.523250999999999911, 2.599090000000000011e-01, 2.561740000000000128e-01, 1.243753000000000108, 0., 8.373639000000000721, 9.459274999999999878, 1.915858000000000061, 1.316696000000000089, 4.410839999999999761e-01, 5.119679999999999787e-01, 2.397415000000000074, 2.260423999999999989, 4.890200000000000102e-02, 8.537789999999999546e-01, 2.960139999999999993e-01, 1.660884999999999945, 2.191999999999999851e-02, 1.301999999999999989e-03, 8.237300000000000177e-02, 1.018005000000000049, 2.622999999999999984e-02, 1.500100000000000044e-02, 3.685379999999999767e-01, 3.605749999999999789e-01, 0., 0., 5.890000000000000053e-04, 9.445599999999999552e-01, 1.190000000000000058e-04, 6.999999999999999387e-05, 8.570000000000000144e-04, 1.164865999999999957, 3.35400000000000021e-03, 8.379999999999999862e-04, 9.298800000000000121e-02, 2.735831000000000124, 1.966499999999999845e-02, 4.984800000000000342e-02, 3.241620000000000057e-01, 4.667700000000000182e-01, 0., 6.099999999999999737e-04, 5.339999999999999695e-04, 3.879354999999999887, 2.514999999999999875e-03, 1.143300000000000045e-02, 5.625000000000000139e-02, 5.336300000000000071e-02, 2.080410000000000037e-01, 5.709933000000000369, 4.097210000000000019e-01, 3.498459999999999903e-01, 2.018482999999999805, 6.12269999999999967e-02, 6.042100000000000248e-02, 4.157750000000000057e-01, 8.715680000000000094e-01, 1.053899999999999976e-02, 1.11339999999999998e-02, 7.994800000000000517e-02],[8.947599999999999998e-02, 1.346384999999999943, 6.233659999999999757e-01, 6.755400000000000293e-02, 8.373639000000000721, 0., 8.470046999999999215, 3.991582999999999881, 2.169799999999999854e-02, 4.699374999999999858, 1.407009999999999927e-01, 2.758650000000000269e-01, 1.670100000000000057e-02, 1.066284999999999927, 4.337590000000000057e-01, 3.457299999999999957e-02, 6.65189999999999948e-02, 9.693869999999999987e-01, 6.174640000000000128e-01, 1.124999999999999915e-03, 2.713799999999999893e-02, 8.709670000000000467e-01, 5.270939999999999515e-01, 4.412499999999999756e-02, 2.079000000000000119e-03, 1.481721000000000066, 1.77740000000000016e-02, 1.059999999999999961e-03, 6.790000000000000245e-04, 8.9749000000000001e-01, 7.365700000000000025e-02, 3.959999999999999762e-04, 1.096639999999999976e-01, 1.013424000000000103, 3.601960000000000162e-01, 5.590000000000000351e-04, 7.734099999999999309e-02, 2.159327999999999914, 7.288909999999999556e-01, 1.201210000000000055e-01, 1.119999999999999983e-04, 5.189030000000000031e-01, 4.470000000000000232e-04, 1.119999999999999983e-04, 1.956999999999999972e-03, 2.862216000000000093, 8.964300000000000046e-02, 3.020000000000000115e-03, 3.935449999999999782e-01, 1.160000000000000007e-04, 1.501069999999999904e-01, 3.829579999999999984, 2.395833000000000101, 1.969829999999999914e-01, 8.06070999999999982e-01, 3.782200000000000145e-02, 7.759999999999999971e-04, 6.20000000000000027e-05, 3.715410000000000101e-01, 2.990000000000000036e-03, 9.299999999999999727e-05],[1.995889999999999886e-01, 8.221330000000000027e-01, 1.144638999999999962, 2.243970000000000131e-01, 9.459274999999999878, 8.470046999999999215, 0., 2.116657000000000011, 8.790499999999999703e-02, 2.871847999999999956, 7.654950000000000365e-01, 5.635660000000000114e-01, 1.54440999999999995e-01, 3.117590000000000083e-01, 1.376727000000000034, 9.06740000000000046e-02, 2.8540000000000002e-03, 1.03080000000000005e-01, 1.766961000000000004, 7.693800000000000638e-02, 8.347499999999999365e-02, 4.35242999999999991e-01, 9.622950000000000115e-01, 7.971200000000000507e-02, 2.910999999999999959e-03, 1.424300000000000045e-02, 2.985421000000000102, 4.592999999999999861e-03, 4.079999999999999968e-04, 5.950000000000000427e-04, 7.332020000000000204e-01, 2.640000000000000202e-04, 3.464000000000000065e-03, 9.520699999999999996e-02, 1.447392000000000012, 4.259500000000000092e-02, 3.185740000000000238e-01, 4.985040000000000027e-01, 2.86632499999999979, 1.085010000000000002e-01, 1.869999999999999917e-04, 6.459000000000000331e-03, 7.164409999999999945e-01, 3.739999999999999835e-04, 2.527999999999999865e-03, 1.029799999999999986e-02, 3.092499999999999805, 4.867999999999999931e-03, 1.777569999999999983e-01, 4.211899999999999672e-02, 5.165939999999999976e-01, 1.562591000000000063, 4.919173999999999936, 3.61163999999999985e-01, 1.732980000000000076e-01, 3.626809999999999756e-01, 5.387399999999999828e-02, 6.20000000000000027e-05, 3.64890000000000006e-02, 5.868179999999999508e-01, 8.03199999999999921e-03],[8.781630000000000269e-01, 2.960659999999999958e-01, 2.910090000000000177e-01, 2.057449000000000083, 1.915858000000000061, 3.991582999999999881, 2.116657000000000011, 0., 4.32918000000000025e-01, 6.228679999999999772e-01, 3.096559999999999868e-01, 4.943438999999999695, 3.518819999999999726e-01, 7.5878000000000001e-02, 4.198310000000000097e-01, 1.266653999999999947, 3.744190000000000018e-01, 2.719999999999999979e-04, 2.908799999999999927e-02, 8.987939999999999818e-01, 3.45544999999999991e-01, 5.380499999999999866e-02, 1.147600000000000009e-02, 1.050362999999999936, 1.039999999999999909e-03, 0., 0., 3.446009999999999907e-01, 4.348000000000000302e-03, 6.000000000000000152e-05, 6.999999999999999387e-05, 8.312150000000000372e-01, 2.514230000000000076e-01, 1.579999999999999916e-04, 3.358099999999999974e-02, 9.289690000000000447e-01, 3.817960000000000242e-01, 3.855900000000000299e-02, 2.386200000000000127e-02, 2.359361999999999959, 2.448999999999999788e-03, 0., 5.529999999999999976e-04, 3.803739999999999899e-01, 9.008000000000000382e-03, 1.026999999999999918e-03, 3.63500000000000021e-03, 2.898791000000000118, 5.990000000000000316e-04, 5.999320000000000208e-01, 2.297807000000000155, 4.873170000000000002e-01, 1.997480000000000089e-01, 4.693944000000000116, 1.482999999999999943e-03, 3.593899999999999872e-02, 1.089585000000000026, 1.247299999999999971e-02, 1.41000000000000012e-04, 1.565199999999999925e-02, 4.972929999999999851e-01],[5.815293999999999741, 2.738550000000000151e-01, 1.197613999999999956, 9.368400000000000061e-01, 1.316696000000000089, 2.169799999999999854e-02, 8.790499999999999703e-02, 4.32918000000000025e-01, 0., 4.03913000000000022e-01, 3.916186999999999863, 1.644621000000000111, 7.800080000000000346e-01, 1.233099999999999995e-02, 3.057139999999999858e-01, 1.160390000000000033e-01, 1.242140000000000022, 2.554400000000000073e-02, 2.889999999999999774e-04, 4.111150000000000082e-01, 4.935080000000000022e-01, 3.840000000000000097e-04, 0., 1.15110000000000004e-02, 1.949764000000000053, 1.113671000000000078, 2.41885899999999987, 7.450523999999999702, 4.094320000000000181e-01, 6.000000000000000152e-05, 0., 4.747000000000000351e-03, 6.681730000000000169e-01, 7.179999999999999967e-04, 4.099999999999999912e-04, 3.047400000000000109e-02, 4.617290000000000005e-01, 0., 0., 1.385199999999999973e-02, 9.384390000000000231e-01, 8.210000000000000067e-04, 6.956700000000000383e-02, 3.765700000000000297e-02, 5.606419999999999737e-01, 2.049999999999999956e-04, 1.029999999999999964e-04, 3.211599999999999872e-02, 6.090899999999999787e-02, 4.243210000000000037e-01, 1.094735999999999931, 2.04399999999999981e-03, 1.150000000000000035e-04, 4.789000000000000201e-02, 3.088300000000000073e-02, 1.45245000000000013e-01, 1.443879999999999886e-01, 4.23773999999999984e-01, 1.260000000000000009e-02, 1.717999999999999909e-03, 1.40516000000000002e-01],[3.342240000000000211e-01, 4.127466000000000079, 9.28876000000000035e-01, 6.437889999999999446e-01, 4.410839999999999761e-01, 4.699374999999999858, 2.871847999999999956, 6.228679999999999772e-01, 4.03913000000000022e-01, 0., 1.286990000000000078, 8.579805999999999599, 2.153899999999999912e-02, 2.38532999999999995e-01, 3.045809999999999906e-01, 3.114000000000000101e-02, 2.327009999999999912e-01, 1.28252199999999994, 1.418382999999999949, 5.060000000000000261e-03, 5.194999999999999965e-03, 1.337628999999999957, 1.046809999999999963e-01, 1.247000000000000062e-03, 3.54544999999999999e-01, 1.320875000000000021, 1.360141000000000044, 3.879409999999999803e-01, 2.71799999999999993e-03, 3.005129999999999746e-01, 1.729999999999999941e-02, 3.299999999999999982e-04, 3.083719999999999795e-01, 2.00533399999999995, 8.226430000000000131e-01, 1.248100000000000077e-02, 6.335300000000000653e-02, 2.21473500000000012, 2.002049999999999941e-01, 5.328000000000000271e-03, 2.987380000000000035e-01, 2.392605999999999788, 1.149845999999999924, 3.260350000000000192e-01, 6.570000000000000319e-04, 3.81286999999999987e-01, 4.159999999999999636e-03, 2.190000000000000106e-04, 3.468899999999999761e-01, 1.160000000000000007e-04, 1.049876999999999949, 8.92975999999999992e-01, 9.818281000000000702, 9.476199999999999901e-02, 1.372357000000000049, 1.671380000000000088e-01, 2.480989999999999862e-01, 4.319999999999999838e-04, 1.667059999999999931e-01, 5.790000000000000008e-03, 9.299999999999999727e-05],[1.86819399999999991, 6.00415000000000032e-01, 7.316622999999999877, 4.543470000000000009e-01, 5.119679999999999787e-01, 1.407009999999999927e-01, 7.654950000000000365e-01, 3.096559999999999868e-01, 3.916186999999999863, 1.286990000000000078, 0., 1.477695999999999898, 3.174660000000000259e-01, 6.236900000000000083e-02, 9.058100000000000041e-01, 9.354200000000000015e-02, 3.785999999999999869e-03, 1.690220000000000056e-01, 1.148387000000000047, 1.409430000000000127e-01, 9.225000000000000561e-03, 3.324400000000000271e-02, 2.738760000000000083e-01, 6.043199999999999961e-02, 5.287418999999999869, 4.087042000000000286, 8.531553000000000608, 6.798629000000000033, 9.510000000000000224e-04, 9.520000000000000467e-04, 4.032000000000000167e-02, 9.560000000000000789e-03, 4.420000000000000318e-03, 8.985999999999999197e-03, 1.195789999999999909, 1.576299999999999923e-02, 4.420000000000000318e-03, 1.76800000000000004e-03, 1.87831999999999999e-01, 4.537399999999999767e-02, 1.65587000000000012e-01, 1.222700000000000002e-02, 1.558783999999999947, 4.7437e-02, 2.062000000000000031e-03, 2.062000000000000031e-03, 3.143790000000000195e-01, 5.170899999999999802e-02, 2.695100000000000273e-01, 2.004990000000000105e-01, 9.261000000000000135e-03, 2.871500000000000094e-02, 5.143919999999999604e-01, 6.399399999999999533e-02, 7.053299999999999847e-02, 4.967059999999999809e-01, 1.221860000000000029e-01, 2.469999999999999865e-04, 5.677100000000000202e-02, 5.06840999999999986e-01, 8.330999999999999517e-02],[1.29386000000000001, 5.86685000000000012e-01, 3.890040000000000164e-01, 4.971506999999999898, 2.397415000000000074, 2.758650000000000269e-01, 5.635660000000000114e-01, 4.943438999999999695, 1.644621000000000111, 8.579805999999999599, 1.477695999999999898, 0., 2.698619999999999908e-01, 1.872700000000000059e-02, 3.063750000000000084e-01, 3.591829999999999745e-01, 1.177718000000000043, 4.530000000000000064e-04, 8.326100000000000168e-02, 1.293228000000000044, 2.104800000000000074e-02, 2.880000000000000073e-04, 1.066000000000000107e-03, 1.035015000000000018, 5.308810000000000473e-01, 1.814599999999999894e-02, 2.500600000000000045e-02, 7.723489999999999522e-01, 9.511999999999999622e-03, 6.000000000000000152e-05, 1.050000000000000044e-04, 3.228070000000000106e-01, 8.325919999999999987e-01, 3.879999999999999985e-04, 1.290979999999999905e-01, 1.702817000000000025, 1.263819999999999943e-01, 4.850000000000000253e-04, 6.401999999999999705e-03, 2.323090999999999795, 1.179052999999999907, 5.402499999999999664e-02, 6.849680000000000213e-01, 2.382451000000000096, 6.304999999999999841e-03, 9.699999999999999963e-05, 1.358000000000000049e-03, 5.014560000000000128e-01, 1.800000000000000113e-04, 5.064699999999999758e-01, 5.964323000000000263, 8.363600000000000201e-02, 6.815750000000000419e-01, 2.169045000000000112, 1.817940000000000111e-01, 1.390460000000000029e-01, 2.007767999999999997, 1.092899999999999948e-02, 4.699999999999999724e-05, 9.289000000000000382e-03, 2.255540000000000045e-01],[6.67397000000000018e-01, 2.083700000000000135e-02, 5.626699999999999757e-02, 2.56282999999999983e-01, 2.260423999999999989, 1.670100000000000057e-02, 1.54440999999999995e-01, 3.518819999999999726e-01, 7.800080000000000346e-01, 2.153899999999999912e-02, 3.174660000000000259e-01, 2.698619999999999908e-01, 0., 5.784671999999999592, 2.230691000000000201, 6.415611000000000175, 3.900870000000000171e-01, 2.719999999999999979e-04, 4.800000000000000122e-05, 4.010899999999999882e-02, 4.805209999999999759e-01, 0., 0., 2.014000000000000165e-03, 1.21855000000000005e-01, 0., 0., 0., 4.400610000000000355, 1.361479999999999912e-01, 4.888200000000000184e-02, 1.260239000000000109, 3.614029999999999743e-01, 0., 7.799999999999999859e-05, 1.170999999999999949e-03, 9.839259999999999673e-01, 0., 7.799999999999999859e-05, 1.794999999999999938e-03, 1.943189999999999917e-01, 0., 7.799999999999999859e-05, 1.559999999999999972e-04, 1.271061999999999914, 1.542070000000000107e-01, 9.111930000000000307e-01, 2.577577999999999925, 2.545400000000000093e-02, 5.730129999999999946e-01, 4.034349999999999881e-01, 0., 0., 4.240000000000000062e-04, 1.213799999999999948e-02, 1.700409999999999977e-01, 6.955500000000000571e-02, 5.159074999999999633, 6.496799999999999797e-02, 1.065536999999999956, 1.075186999999999893],[2.30199999999999988e-02, 1.754910000000000081e-01, 1.164049999999999946e-01, 1.435099999999999917e-02, 4.890200000000000102e-02, 1.066284999999999927, 3.117590000000000083e-01, 7.5878000000000001e-02, 1.233099999999999995e-02, 2.38532999999999995e-01, 6.236900000000000083e-02, 1.872700000000000059e-02, 5.784671999999999592, 0., 1.428293000000000035, 3.609309999999999796, 1.054300000000000029e-02, 1.278990000000000127e-01, 1.058850000000000069e-01, 4.690000000000000158e-04, 4.479999999999999933e-04, 2.702740000000000142e-01, 2.172299999999999925e-02, 9.600000000000000243e-05, 1.247999999999999977e-03, 2.388389999999999957e-01, 3.063999999999999883e-03, 1.179999999999999951e-04, 2.03017000000000003e-01, 3.76569699999999985, 2.469249000000000027, 3.901899999999999813e-01, 9.173999999999999863e-03, 3.244699999999999668e-02, 3.198399999999999854e-02, 4.199999999999999768e-05, 5.890000000000000053e-04, 5.363620000000000054e-01, 4.629000000000000302e-03, 2.530000000000000239e-04, 8.399999999999999535e-05, 5.542500000000000204e-02, 2.950000000000000148e-04, 0., 3.137789999999999746e-01, 7.487815999999999583, 3.487341999999999942, 5.759210000000000163e-01, 2.559750000000000081e-01, 1.160000000000000007e-04, 9.600000000000000243e-05, 1.159749999999999948e-01, 3.440000000000000132e-04, 0., 3.096430000000000016e-01, 1.368489999999999984e-01, 3.110000000000000243e-04, 4.211199999999999666e-02, 1.006045000000000078, 4.780190000000000272e-01, 5.603799999999999754e-02],[2.753550000000000164e-01, 2.191700000000000037e-01, 4.975930000000000075e-01, 2.089239999999999986e-01, 8.537789999999999546e-01, 4.337590000000000057e-01, 1.376727000000000034, 4.198310000000000097e-01, 3.057139999999999858e-01, 3.045809999999999906e-01, 9.058100000000000041e-01, 3.063750000000000084e-01, 2.230691000000000201, 1.428293000000000035, 0., 1.155097999999999958, 4.436169999999999836e-01, 1.634059999999999957e-01, 8.349760000000000515e-01, 3.235879999999999868e-01, 4.200600000000000167e-02, 8.455000000000000709e-03, 1.934589999999999921e-01, 8.163099999999999523e-02, 1.559600000000000049e-02, 2.978599999999999998e-02, 4.086799999999999877e-01, 2.873600000000000113e-02, 1.635280999999999985, 1.434579000000000049, 2.236556999999999906, 1.220020000000000104, 3.399400000000000338e-02, 1.137900000000000023e-02, 2.624650000000000039e-01, 5.906499999999999945e-02, 5.17896000000000023e-01, 1.692639999999999978e-01, 8.373019999999999907e-01, 4.511339999999999795e-01, 3.772400000000000059e-02, 1.860300000000000148e-02, 4.101989999999999803e-01, 2.747899999999999995e-02, 5.690760000000000263e-01, 3.50472999999999979e-01, 1.399672999999999945, 4.301240000000000063e-01, 3.003540000000000099e-01, 2.943680000000000185e-01, 2.460940000000000072e-01, 4.228200000000000014e-02, 5.270049999999999457e-01, 9.349100000000000465e-02, 3.246129999999999849e-01, 3.216419999999999835e-01, 2.980909999999999949e-01, 1.418466000000000005, 8.006020000000000358e-01, 3.062806999999999835, 6.793700000000000294e-01],[2.215360000000000107e-01, 2.54050000000000005e-02, 4.143999999999999767e-02, 2.393879999999999897e-01, 2.960139999999999993e-01, 3.457299999999999957e-02, 9.06740000000000046e-02, 1.266653999999999947, 1.160390000000000033e-01, 3.114000000000000101e-02, 9.354200000000000015e-02, 3.591829999999999745e-01, 6.415611000000000175, 3.609309999999999796, 1.155097999999999958, 0., 7.892599999999999616e-02, 0., 3.859000000000000017e-03, 1.933279999999999998e-01, 2.596999999999999916e-03, 9.600000000000000243e-05, 2.460000000000000164e-04, 2.928549999999999764e-01, 4.159999999999999744e-04, 0., 0., 7.643400000000000194e-02, 1.328581000000000012, 1.840100000000000069e-01, 8.93079999999999985e-02, 3.330792999999999893, 3.861200000000000049e-02, 0., 3.31199999999999984e-03, 6.696599999999999775e-02, 2.262000000000000122e-03, 4.000000000000000327e-05, 8.100000000000000375e-05, 5.363320000000000309e-01, 2.829999999999999942e-04, 2.829999999999999942e-04, 8.100000000000000375e-05, 6.999500000000000166e-02, 2.581653999999999893, 4.586219999999999741e-01, 9.53353000000000006e-01, 6.546162999999999954, 1.800000000000000113e-04, 3.527310000000000167e-01, 3.860000000000000041e-04, 0., 0., 1.724030000000000007e-01, 4.049999999999999781e-04, 7.831200000000000661e-02, 4.314560000000000062e-01, 2.130663000000000196, 5.995600000000000235e-02, 1.292934999999999945, 1.119410999999999934],[3.215816999999999926, 3.77446999999999977e-01, 4.613829999999999876e-01, 1.759732000000000074, 1.660884999999999945, 6.65189999999999948e-02, 2.8540000000000002e-03, 3.744190000000000018e-01, 1.242140000000000022, 2.327009999999999912e-01, 3.785999999999999869e-03, 1.177718000000000043, 3.900870000000000171e-01, 1.054300000000000029e-02, 4.436169999999999836e-01, 7.892599999999999616e-02, 0., 7.519040000000000168e-01, 7.923045000000000115, 2.473438999999999943, 1.052040000000000086, 7.484599999999999587e-02, 6.336600000000000565e-02, 4.351090000000000235e-01, 4.725839999999999819, 1.489399999999999891e-01, 2.999780000000000224e-01, 1.164261999999999908, 1.205737999999999976, 7.179399999999999671e-02, 3.337199999999999889e-02, 5.290449999999999875e-01, 3.081614000000000075, 1.213889999999999969e-01, 3.433140000000000081e-01, 7.067820000000000213e-01, 1.274118000000000084, 1.881400000000000086e-02, 1.16500000000000002e-03, 2.729500000000000259e-01, 5.51493000000000011e-01, 1.619299999999999906e-02, 3.029000000000000008e-03, 4.281200000000000283e-02, 6.069449999999999568e-01, 6.756999999999999985e-03, 4.659999999999999971e-04, 1.508039999999999936e-01, 7.923600000000000088e-02, 4.862810000000000188e-01, 2.066955000000000098, 8.038299999999999612e-02, 2.178999999999999947e-03, 5.083079999999999821e-01, 3.223199999999999676e-02, 5.516299999999999676e-02, 1.631740000000000135e-01, 5.764759999999999884e-01, 1.662800000000000042e-02, 7.507999999999999917e-03, 1.263199999999999878e-01],[1.434789999999999954e-01, 2.203539000000000136, 5.714690000000000047e-01, 1.885870000000000046e-01, 2.191999999999999851e-02, 9.693869999999999987e-01, 1.03080000000000005e-01, 2.719999999999999979e-04, 2.554400000000000073e-02, 1.28252199999999994, 1.690220000000000056e-01, 4.530000000000000064e-04, 2.719999999999999979e-04, 1.278990000000000127e-01, 1.634059999999999957e-01, 0., 7.519040000000000168e-01, 0., 2.503267999999999827, 8.685700999999999894, 8.983499999999999819e-02, 7.303060000000000107e-01, 3.641289999999999805e-01, 6.158299999999999885e-02, 5.26904000000000039e-01, 2.478358000000000061, 2.208429999999999893, 2.772649999999999837e-01, 5.99270000000000011e-02, 6.176939999999999653e-01, 3.30035999999999996e-01, 5.861399999999999944e-02, 1.060689999999999966e-01, 9.75727000000000011e-01, 5.660340000000000371e-01, 4.673900000000000277e-02, 4.982000000000000317e-03, 6.96015999999999968e-01, 1.900370000000000115e-01, 9.100000000000000287e-05, 4.982000000000000317e-03, 5.667590000000000128e-01, 5.371399999999999786e-02, 9.100000000000000287e-05, 2.808000000000000166e-03, 4.91034000000000026e-01, 4.411199999999999843e-02, 9.100000000000000287e-05, 3.193995999999999835, 2.657660000000000022e-01, 1.447000000000000022e-02, 1.144692000000000043, 1.14551e-01, 5.929999999999999941e-04, 4.830760000000000054e-01, 3.692730000000000179e-01, 1.55e-04, 1.230000000000000082e-04, 7.617709999999999759e-01, 2.162999999999999992e-03, 4.670000000000000214e-04],[2.853840000000000265e-01, 9.851450000000000484e-01, 2.285051999999999861, 2.068510000000000071e-01, 1.301999999999999989e-03, 6.174640000000000128e-01, 1.766961000000000004, 2.908799999999999927e-02, 2.889999999999999774e-04, 1.418382999999999949, 1.148387000000000047, 8.326100000000000168e-02, 4.800000000000000122e-05, 1.058850000000000069e-01, 8.349760000000000515e-01, 3.859000000000000017e-03, 7.923045000000000115, 2.503267999999999827, 0., 1.106179000000000023, 1.843269999999999909e-01, 5.295940000000000092e-01, 7.157160000000000188e-01, 1.074340000000000017e-01, 6.173199999999999799e-01, 2.029914000000000218, 4.718199000000000254, 3.408109999999999751e-01, 1.054490000000000011e-01, 4.226710000000000189e-01, 7.037949999999999484e-01, 7.911899999999999489e-02, 5.365670000000000162e-01, 9.283190000000000053e-01, 3.036767000000000216, 1.308729999999999893e-01, 2.219000000000000052e-03, 6.349270000000000191e-01, 1.544626000000000055, 4.090699999999999892e-02, 2.889999999999999774e-04, 3.362769999999999926e-01, 6.342029999999999612e-01, 3.376999999999999794e-03, 1.450000000000000009e-04, 6.932000000000000661e-02, 4.754959999999999742e-01, 9.599999999999999159e-03, 3.323960000000000248e-01, 9.206999999999999906e-02, 2.122000000000000188e-03, 4.233819999999999806e-01, 1.519211000000000089, 4.924599999999999811e-02, 1.055969999999999964e-01, 2.474899999999999878e-01, 5.791000000000000314e-02, 0., 1.072179999999999939e-01, 2.507480000000000264e-01, 9.759999999999999579e-03],[8.992620000000000058e-01, 4.609699999999999909e-01, 3.245250000000000079e-01, 2.691225999999999896, 8.237300000000000177e-02, 1.124999999999999915e-03, 7.693800000000000638e-02, 8.987939999999999818e-01, 4.111150000000000082e-01, 5.060000000000000261e-03, 1.409430000000000127e-01, 1.293228000000000044, 4.010899999999999882e-02, 4.690000000000000158e-04, 3.235879999999999868e-01, 1.933279999999999998e-01, 2.473438999999999943, 8.685700999999999894, 1.106179000000000023, 0., 2.862520000000000064e-01, 9.127599999999999603e-02, 5.402099999999999957e-02, 7.752539999999999987e-01, 1.353860000000000063, 1.700879999999999892e-01, 3.163719999999999866e-01, 2.460976000000000052, 4.386479999999999824e-01, 5.732799999999999702e-02, 4.474199999999999705e-02, 6.64865999999999957e-01, 4.524420000000000108e-01, 1.009280000000000038e-01, 1.592169999999999974e-01, 7.467920000000000114e-01, 3.926500000000000129e-02, 5.619999999999999996e-04, 8.012400000000000078e-02, 4.205800000000000094e-01, 9.755400000000000182e-02, 8.429999999999999993e-04, 8.405999999999999583e-02, 3.88156000000000001e-01, 1.958599999999999924e-02, 3.750000000000000078e-04, 3.223700000000000176e-02, 3.382069999999999799e-01, 3.405409999999999826e-01, 3.08848099999999981, 1.281110000000000027e-01, 2.137000000000000011e-03, 7.373000000000000387e-02, 1.253945000000000087, 1.482999999999999943e-03, 1.950729999999999964e-01, 6.340649999999999897e-01, 2.655100000000000168e-02, 1.312000000000000015e-03, 4.02749999999999983e-02, 6.386960000000000415e-01],[1.042456999999999967, 7.416100000000000469e-02, 1.200200000000000052e-02, 9.610399999999999499e-02, 1.018005000000000049, 2.713799999999999893e-02, 8.347499999999999365e-02, 3.45544999999999991e-01, 4.935080000000000022e-01, 5.194999999999999965e-03, 9.225000000000000561e-03, 2.104800000000000074e-02, 4.805209999999999759e-01, 4.479999999999999933e-04, 4.200600000000000167e-02, 2.596999999999999916e-03, 1.052040000000000086, 8.983499999999999819e-02, 1.843269999999999909e-01, 2.862520000000000064e-01, 0., 5.426732999999999585, 5.127582000000000306, 9.227009999999999934e-01, 6.266030000000000211e-01, 1.701999999999999954e-03, 1.030000000000000013e-02, 6.341299999999999715e-02, 1.073790000000000022, 1.660899999999999876e-02, 4.091700000000000198e-02, 6.566900000000000515e-02, 8.908220000000000027e-01, 3.671999999999999917e-03, 1.791000000000000057e-03, 1.478730000000000044e-01, 1.236456999999999917, 1.307700000000000008e-02, 1.782399999999999957e-02, 3.469780000000000086e-01, 5.562040000000000317e-01, 9.000000000000000567e-05, 1.253999999999999906e-03, 2.507999999999999813e-03, 7.321109999999999562e-01, 5.370000000000000424e-04, 7.169999999999999724e-04, 9.225000000000000561e-03, 2.587300000000000016e-02, 3.21400000000000019e-02, 3.121656000000000208, 1.387420000000000042e-01, 1.515890000000000015e-01, 4.875419999999999754e-01, 1.025000000000000043e-02, 7.03079999999999955e-02, 2.795000000000000175e-03, 2.610689999999999955e-01, 6.557999999999999594e-03, 5.534999999999999989e-03, 2.521699999999999983e-02],[1.23940000000000005e-02, 5.320920000000000094e-01, 3.036130000000000217e-01, 1.920000000000000049e-04, 2.622999999999999984e-02, 8.709670000000000467e-01, 4.35242999999999991e-01, 5.380499999999999866e-02, 3.840000000000000097e-04, 1.337628999999999957, 3.324400000000000271e-02, 2.880000000000000073e-04, 0., 2.702740000000000142e-01, 8.455000000000000709e-03, 9.600000000000000243e-05, 7.484599999999999587e-02, 7.303060000000000107e-01, 5.295940000000000092e-01, 9.127599999999999603e-02, 5.426732999999999585, 0., 3.453780000000000072, 3.496083000000000052, 1.540169999999999872e-01, 5.637990000000000501e-01, 8.971010000000000373e-01, 1.242319999999999952e-01, 4.008699999999999763e-02, 6.487690000000000401e-01, 1.497709999999999875e-01, 2.657100000000000087e-02, 1.051119999999999971e-01, 9.761750000000000149e-01, 2.94294e-01, 7.690000000000000438e-04, 6.975399999999999656e-02, 1.394892000000000021, 4.175650000000000195e-01, 7.302100000000000257e-02, 3.840000000000000097e-04, 6.369160000000000377e-01, 1.441000000000000007e-03, 2.880000000000000073e-04, 1.920000000000000049e-04, 7.600900000000000434e-01, 1.536999999999999955e-03, 1.920000000000000049e-04, 3.104160000000000252e-01, 1.160000000000000007e-04, 7.235199999999999965e-02, 2.487136000000000013, 4.325200000000000156e-01, 1.012040000000000023e-01, 2.157789999999999986e-01, 3.256400000000000267e-02, 0., 0., 2.856349999999999723e-01, 3.820000000000000153e-04, 1.399999999999999877e-04],[4.099999999999999912e-04, 9.541800000000000281e-02, 5.615229999999999944e-01, 2.704999999999999939e-03, 1.500100000000000044e-02, 5.270939999999999515e-01, 9.622950000000000115e-01, 1.147600000000000009e-02, 0., 1.046809999999999963e-01, 2.738760000000000083e-01, 1.066000000000000107e-03, 0., 2.172299999999999925e-02, 1.934589999999999921e-01, 2.460000000000000164e-04, 6.336600000000000565e-02, 3.641289999999999805e-01, 7.157160000000000188e-01, 5.402099999999999957e-02, 5.127582000000000306, 3.453780000000000072, 0., 2.918259999999999743e-01, 9.107300000000000118e-02, 7.983460000000000001e-01, 1.164525000000000032, 4.467600000000000043e-02, 1.644199999999999828e-02, 1.182290000000000008e-01, 4.95176000000000005e-01, 7.978000000000000716e-03, 5.409999999999999878e-03, 6.442350000000000021e-01, 9.903300000000000436e-01, 3.155999999999999778e-02, 8.738400000000000334e-02, 9.711480000000000112e-01, 1.950083000000000011, 1.352599999999999983e-02, 1.640000000000000019e-04, 3.957709999999999839e-01, 7.030920000000000503e-01, 1.312000000000000015e-03, 8.200000000000000095e-05, 3.164200000000000346e-02, 6.024279999999999635e-01, 2.460000000000000164e-04, 3.737200000000000244e-02, 4.177000000000000157e-03, 6.49239999999999956e-02, 3.710629999999999762e-01, 2.075225999999999793, 2.144400000000000125e-02, 4.584999999999999666e-03, 2.157880000000000076e-01, 1.55e-04, 0., 7.916099999999999526e-02, 1.129990000000000022e-01, 4.062999999999999771e-03],[2.471949999999999981e-01, 9.59e-04, 2.208160000000000123e-01, 7.873400000000000398e-01, 3.685379999999999767e-01, 4.412499999999999756e-02, 7.971200000000000507e-02, 1.050362999999999936, 1.15110000000000004e-02, 1.247000000000000062e-03, 6.043199999999999961e-02, 1.035015000000000018, 2.014000000000000165e-03, 9.600000000000000243e-05, 8.163099999999999523e-02, 2.928549999999999764e-01, 4.351090000000000235e-01, 6.158299999999999885e-02, 1.074340000000000017e-01, 7.752539999999999987e-01, 9.227009999999999934e-01, 3.496083000000000052, 2.918259999999999743e-01, 0., 3.528069999999999817e-01, 2.397999999999999958e-03, 9.879999999999999893e-03, 5.004330000000000167e-01, 1.814109999999999889e-01, 3.62540000000000015e-02, 1.438799999999999975e-02, 8.226430000000000131e-01, 1.847489999999999966e-01, 9.600000000000000243e-05, 3.443700000000000233e-02, 6.617760000000000309e-01, 3.359240000000000004e-01, 2.206199999999999828e-02, 1.410100000000000069e-02, 1.272426000000000057, 3.549000000000000071e-03, 9.600000000000000243e-05, 1.918e-03, 4.188020000000000076e-01, 1.150999999999999896e-03, 1.920000000000000049e-04, 3.840000000000000097e-04, 7.083949999999999969e-01, 4.789999999999999879e-04, 3.378789999999999849e-01, 5.444740000000000135e-01, 1.963580000000000048e-01, 7.87759999999999988e-02, 2.846677000000000124, 2.700000000000000035e-04, 6.183299999999999907e-02, 2.397150000000000114e-01, 1.358000000000000049e-03, 1.41000000000000012e-04, 3.49899999999999994e-03, 3.243679999999999897e-01],[3.065510000000000179, 1.663600000000000148e-02, 3.451900000000000107e-02, 9.981000000000000288e-03, 3.605749999999999789e-01, 2.079000000000000119e-03, 2.910999999999999959e-03, 1.039999999999999909e-03, 1.949764000000000053, 3.54544999999999999e-01, 5.287418999999999869, 5.308810000000000473e-01, 1.21855000000000005e-01, 1.247999999999999977e-03, 1.559600000000000049e-02, 4.159999999999999744e-04, 4.725839999999999819, 5.26904000000000039e-01, 6.173199999999999799e-01, 1.353860000000000063, 6.266030000000000211e-01, 1.540169999999999872e-01, 9.107300000000000118e-02, 3.528069999999999817e-01, 0., 2.677656999999999954, 5.746310000000000029e-01, 9.5954429999999995, 9.181979999999999587e-01, 1.123949999999999949e-01, 4.196899999999999936e-02, 4.246070000000000122e-01, 4.40217000000000025e-01, 9.981000000000000288e-03, 1.039999999999999909e-03, 7.069999999999999896e-03, 2.865469999999999962e-01, 4.159999999999999744e-04, 6.239999999999999887e-04, 1.87100000000000005e-03, 2.472449999999999926e-01, 8.942000000000000295e-03, 1.434809999999999974e-01, 4.200500000000000067e-02, 2.551470000000000127e-01, 1.87100000000000005e-03, 8.319999999999999488e-04, 3.742999999999999799e-03, 5.168600000000000277e-02, 4.391699999999999771e-02, 5.570150000000000379e-01, 4.088999999999999753e-03, 3.210999999999999879e-03, 6.102999999999999918e-03, 1.661499999999999921e-01, 1.465009999999999923e-01, 2.327279999999999904e-01, 1.366469999999999907e-01, 1.601999999999999952e-02, 1.526999999999999929e-03, 3.012099999999999847e-02],[2.963580000000000103e-01, 8.631910000000000416e-01, 2.721042999999999878, 6.799999999999999946e-05, 0., 1.481721000000000066, 1.424300000000000045e-02, 0., 1.113671000000000078, 1.320875000000000021, 4.087042000000000286, 1.814599999999999894e-02, 0., 2.388389999999999957e-01, 2.978599999999999998e-02, 0., 1.489399999999999891e-01, 2.478358000000000061, 2.029914000000000218, 1.700879999999999892e-01, 1.701999999999999954e-03, 5.637990000000000501e-01, 7.983460000000000001e-01, 2.397999999999999958e-03, 2.677656999999999954, 0., 5.563093000000000288, 7.244097000000000008, 5.43599999999999986e-03, 5.44827999999999979e-01, 5.639560000000000128e-01, 1.602200000000000152e-02, 2.567799999999999944e-02, 9.155050000000000132e-01, 5.286920000000000508e-01, 0., 6.799999999999999946e-05, 1.610247999999999902, 8.3743999999999999e-02, 0., 7.529999999999999801e-04, 6.76049000000000011e-01, 9.716500000000000137e-02, 4.656000000000000416e-03, 0., 6.485229999999999606e-01, 3.286999999999999991e-03, 0., 6.04540999999999995e-01, 1.160000000000000007e-04, 0., 6.858119999999999772e-01, 3.210600000000000259e-02, 0., 5.169270000000000254e-01, 1.76475999999999994e-01, 1.288599999999999988e-02, 0., 2.008060000000000123e-01, 6.39999999999999971e-05, 0.],[1.103200000000000014e-02, 6.521200000000000607e-02, 3.832199999999999829, 9.810000000000001011e-04, 0., 1.77740000000000016e-02, 2.985421000000000102, 0., 2.41885899999999987, 1.360141000000000044, 8.531553000000000608, 2.500600000000000045e-02, 0., 3.063999999999999883e-03, 4.086799999999999877e-01, 0., 2.999780000000000224e-01, 2.208429999999999893, 4.718199000000000254, 3.163719999999999866e-01, 1.030000000000000013e-02, 8.971010000000000373e-01, 1.164525000000000032, 9.879999999999999893e-03, 5.746310000000000029e-01, 5.563093000000000288, 0., 2.868484000000000034, 4.090200000000000086e-02, 6.404950000000000365e-01, 7.943660000000000165e-01, 3.942799999999999777e-02, 8.580000000000000387e-04, 1.505269999999999941e-01, 2.171984000000000137, 3.680000000000000003e-04, 1.230000000000000082e-04, 2.047099999999999961e-02, 3.40917799999999982, 0., 1.041899999999999944e-02, 7.037280000000000202e-01, 5.908330000000000526e-01, 1.176800000000000068e-02, 0., 5.026000000000000086e-03, 7.013989999999999947e-01, 0., 8.193100000000000382e-02, 3.713000000000000154e-03, 0., 4.832000000000000357e-03, 1.903570999999999902, 8.500000000000000611e-05, 1.831430000000000002e-01, 1.135909999999999975, 2.39089999999999997e-02, 0., 2.735500000000000084e-02, 1.276960000000000039e-01, 9.340000000000000429e-04],[1.76987899999999998, 3.180000000000000101e-03, 5.608309999999999684e-01, 6.822540000000000271e-01, 5.890000000000000053e-04, 1.059999999999999961e-03, 4.592999999999999861e-03, 3.446009999999999907e-01, 7.450523999999999702, 3.879409999999999803e-01, 6.798629000000000033, 7.723489999999999522e-01, 0., 1.179999999999999951e-04, 2.873600000000000113e-02, 7.643400000000000194e-02, 1.164261999999999908, 2.772649999999999837e-01, 3.408109999999999751e-01, 2.460976000000000052, 6.341299999999999715e-02, 1.242319999999999952e-01, 4.467600000000000043e-02, 5.004330000000000167e-01, 9.5954429999999995, 7.244097000000000008, 2.868484000000000034, 0., 1.343940000000000135e-01, 6.875799999999999967e-02, 1.501899999999999936e-02, 6.638770000000000504e-01, 3.497800000000000215e-02, 2.359999999999999902e-04, 7.891000000000000444e-03, 1.625250000000000028e-01, 5.890000000000000053e-04, 2.359999999999999902e-04, 1.531000000000000026e-03, 3.242269999999999874e-01, 1.531000000000000069e-02, 2.143499999999999919e-02, 4.322199999999999653e-02, 2.411969999999999947e-01, 3.530000000000000152e-04, 5.890000000000000053e-04, 1.412999999999999977e-03, 3.368280000000000163e-01, 1.376999999999999969e-03, 5.343750000000000444e-01, 5.789999999999999791e-04, 1.208000000000000089e-03, 1.719999999999999958e-03, 6.606220000000000425e-01, 7.781499999999999528e-02, 1.96960000000000017e-02, 7.269079999999999986e-01, 7.410000000000000137e-04, 9.399999999999999448e-05, 3.053999999999999857e-03, 1.438319999999999876e-01],[4.336200000000000054e-01, 1.454000000000000084e-02, 6.790000000000000245e-04, 1.956799999999999859e-02, 9.445599999999999552e-01, 6.790000000000000245e-04, 4.079999999999999968e-04, 4.348000000000000302e-03, 4.094320000000000181e-01, 2.71799999999999993e-03, 9.510000000000000224e-04, 9.511999999999999622e-03, 4.400610000000000355, 2.03017000000000003e-01, 1.635280999999999985, 1.328581000000000012, 1.205737999999999976, 5.99270000000000011e-02, 1.054490000000000011e-01, 4.386479999999999824e-01, 1.073790000000000022, 4.008699999999999763e-02, 1.644199999999999828e-02, 1.814109999999999889e-01, 9.181979999999999587e-01, 5.43599999999999986e-03, 4.090200000000000086e-02, 1.343940000000000135e-01, 0., 8.808275000000000077, 8.319767000000000579, 1.437257000000000007, 3.134950000000000236e-01, 1.358999999999999965e-03, 1.359999999999999989e-04, 1.236600000000000026e-02, 7.411349999999999882e-01, 1.359999999999999989e-04, 0., 4.076999999999999895e-03, 1.657839999999999869e-01, 0., 0., 2.719999999999999979e-04, 2.047159000000000173, 4.375600000000000322e-02, 1.731219999999999981e-01, 5.551040000000000418e-01, 1.19780000000000008e-02, 1.66500000000000016e-02, 4.960459999999999869e-01, 1.859999999999999945e-04, 1.150000000000000035e-04, 6.780000000000000002e-04, 2.157799999999999996e-02, 1.710599999999999968e-02, 2.064900000000000069e-02, 7.219895000000000174, 1.985580000000000123e-01, 6.560965999999999632, 1.036473999999999895],[2.14299999999999994e-03, 1.878799999999999915e-01, 2.238400000000000112e-02, 0., 1.190000000000000058e-04, 8.9749000000000001e-01, 5.950000000000000427e-04, 6.000000000000000152e-05, 6.000000000000000152e-05, 3.005129999999999746e-01, 9.520000000000000467e-04, 6.000000000000000152e-05, 1.361479999999999912e-01, 3.76569699999999985, 1.434579000000000049, 1.840100000000000069e-01, 7.179399999999999671e-02, 6.176939999999999653e-01, 4.226710000000000189e-01, 5.732799999999999702e-02, 1.660899999999999876e-02, 6.487690000000000401e-01, 1.182290000000000008e-01, 3.62540000000000015e-02, 1.123949999999999949e-01, 5.44827999999999979e-01, 6.404950000000000365e-01, 6.875799999999999967e-02, 8.808275000000000077, 0., 5.484087999999999852, 5.874441000000000024, 2.678999999999999958e-03, 1.352549999999999863e-01, 1.00610000000000005e-02, 0., 3.57000000000000004e-04, 1.191513999999999962, 8.930000000000000221e-04, 4.169999999999999987e-04, 6.000000000000000152e-05, 2.405049999999999966e-01, 1.190000000000000058e-04, 6.000000000000000152e-05, 3.173000000000000126e-02, 2.720152999999999821, 4.774390000000000023e-01, 7.286600000000000021e-02, 6.220890000000000031e-01, 1.160000000000000007e-04, 9.600000000000000243e-05, 3.428129999999999789e-01, 3.440000000000000132e-04, 8.500000000000000611e-05, 6.741759999999999975e-01, 1.137009999999999965e-01, 4.659999999999999971e-04, 1.373823000000000016, 2.306109999999999882, 5.65160299999999971, 8.36839999999999945e-02],[3.499999999999999693e-05, 3.491600000000000259e-02, 1.330320000000000114e-01, 1.399999999999999877e-04, 6.999999999999999387e-05, 7.365700000000000025e-02, 7.332020000000000204e-01, 6.999999999999999387e-05, 0., 1.729999999999999941e-02, 4.032000000000000167e-02, 1.050000000000000044e-04, 4.888200000000000184e-02, 2.469249000000000027, 2.236556999999999906, 8.93079999999999985e-02, 3.337199999999999889e-02, 3.30035999999999996e-01, 7.037949999999999484e-01, 4.474199999999999705e-02, 4.091700000000000198e-02, 1.497709999999999875e-01, 4.95176000000000005e-01, 1.438799999999999975e-02, 4.196899999999999936e-02, 5.639560000000000128e-01, 7.943660000000000165e-01, 1.501899999999999936e-02, 8.319767000000000579, 5.484087999999999852, 0., 4.802017000000000202, 1.399999999999999877e-04, 1.568599999999999856e-02, 1.763000000000000123e-01, 4.910000000000000085e-04, 3.510000000000000208e-04, 1.037659999999999971e-01, 1.524024000000000045, 7.720000000000000083e-04, 6.999999999999999387e-05, 4.726799999999999752e-02, 1.85038000000000008e-01, 1.749999999999999982e-04, 2.052899999999999864e-02, 1.085169999999999968, 2.262490000000000112, 1.158000000000000002e-02, 3.088589999999999947e-01, 4.814999999999999836e-03, 0., 1.021999999999999905e-03, 2.669429999999999858e-01, 0., 2.659480000000000177e-01, 5.04866000000000037e-01, 2.638999999999999853e-03, 1.045943000000000067, 1.341143999999999892, 2.455337000000000103, 7.355000000000000426e-02],[6.092199999999999699e-02, 3.299999999999999982e-04, 3.936200000000000115e-02, 2.593799999999999994e-01, 8.570000000000000144e-04, 3.959999999999999762e-04, 2.640000000000000202e-04, 8.312150000000000372e-01, 4.747000000000000351e-03, 3.299999999999999982e-04, 9.560000000000000789e-03, 3.228070000000000106e-01, 1.260239000000000109, 3.901899999999999813e-01, 1.220020000000000104, 3.330792999999999893, 5.290449999999999875e-01, 5.861399999999999944e-02, 7.911899999999999489e-02, 6.64865999999999957e-01, 6.566900000000000515e-02, 2.657100000000000087e-02, 7.978000000000000716e-03, 8.226430000000000131e-01, 4.246070000000000122e-01, 1.602200000000000152e-02, 3.942799999999999777e-02, 6.638770000000000504e-01, 1.437257000000000007, 5.874441000000000024, 4.802017000000000202, 0., 3.955999999999999794e-02, 6.600000000000000506e-05, 4.219999999999999793e-03, 1.29491999999999996e-01, 2.373999999999999808e-03, 1.320000000000000101e-04, 6.600000000000000506e-05, 8.797409999999999952e-01, 3.299999999999999982e-04, 0., 6.600000000000000506e-05, 1.697770000000000112e-01, 5.095950000000000202e-01, 1.053609999999999963e-01, 9.184399999999999509e-02, 1.897149999999999892, 2.990000000000000036e-04, 4.854689999999999839e-01, 2.889999999999999774e-04, 1.859999999999999945e-04, 0., 2.779289999999999816e-01, 6.740000000000000114e-04, 1.012200000000000079e-02, 5.432399999999999451e-01, 2.035722999999999949, 2.076919999999999877e-01, 1.16151099999999996, 2.016256999999999966],[2.258321000000000023, 1.935439999999999938e-01, 3.088509999999999867e-01, 9.755819999999999492e-01, 1.164865999999999957, 1.096639999999999976e-01, 3.464000000000000065e-03, 2.514230000000000076e-01, 6.681730000000000169e-01, 3.083719999999999795e-01, 4.420000000000000318e-03, 8.325919999999999987e-01, 3.614029999999999743e-01, 9.173999999999999863e-03, 3.399400000000000338e-02, 3.861200000000000049e-02, 3.081614000000000075, 1.060689999999999966e-01, 5.365670000000000162e-01, 4.524420000000000108e-01, 8.908220000000000027e-01, 1.051119999999999971e-01, 5.409999999999999878e-03, 1.847489999999999966e-01, 4.40217000000000025e-01, 2.567799999999999944e-02, 8.580000000000000387e-04, 3.497800000000000215e-02, 3.134950000000000236e-01, 2.678999999999999958e-03, 1.399999999999999877e-04, 3.955999999999999794e-02, 0., 8.929030000000000022e-01, 2.984713999999999867, 2.738551999999999875, 9.054879999999999596e-01, 1.405460000000000043e-01, 2.27527000000000007e-01, 5.02354999999999996e-01, 6.391250000000000542e-01, 3.058500000000000107e-02, 1.369370000000000032e-01, 8.914800000000000502e-02, 4.692810000000000037e-01, 4.256499999999999867e-02, 5.502499999999999752e-02, 2.764989999999999948e-01, 4.372100000000000292e-02, 2.571220000000000172e-01, 1.265487000000000029, 8.568000000000000616e-02, 2.178999999999999947e-03, 3.304810000000000247e-01, 3.641000000000000139e-03, 9.965999999999999165e-03, 2.887800000000000089e-02, 2.873729999999999896e-01, 6.464000000000000128e-03, 5.472000000000000301e-03, 8.494500000000000661e-02],[5.316799999999999998e-02, 2.729646999999999935, 4.266840000000000077e-01, 1.67040999999999995e-01, 3.35400000000000021e-03, 1.013424000000000103, 9.520699999999999996e-02, 1.579999999999999916e-04, 7.179999999999999967e-04, 2.00533399999999995, 8.985999999999999197e-03, 3.879999999999999985e-04, 0., 3.244699999999999668e-02, 1.137900000000000023e-02, 0., 1.213889999999999969e-01, 9.75727000000000011e-01, 9.283190000000000053e-01, 1.009280000000000038e-01, 3.671999999999999917e-03, 9.761750000000000149e-01, 6.442350000000000021e-01, 9.600000000000000243e-05, 9.981000000000000288e-03, 9.155050000000000132e-01, 1.505269999999999941e-01, 2.359999999999999902e-04, 1.358999999999999965e-03, 1.352549999999999863e-01, 1.568599999999999856e-02, 6.600000000000000506e-05, 8.929030000000000022e-01, 0., 3.19569800000000015, 4.214693999999999718, 2.791199999999999931e-02, 8.025160000000000071e-01, 7.025940000000000518e-01, 1.86170000000000016e-02, 6.743100000000000482e-02, 1.228004000000000095, 4.035210000000000186e-01, 3.511999999999999844e-02, 6.775999999999999905e-03, 1.190620000000000012e-01, 4.127999999999999725e-02, 4.100999999999999611e-03, 1.847040000000000071e-01, 1.003700000000000078e-02, 7.427999999999999707e-03, 1.023141999999999996, 6.70108000000000037e-01, 2.53999999999999994e-04, 7.16119999999999951e-02, 6.638399999999999856e-02, 0., 6.20000000000000027e-05, 5.536599999999999855e-02, 6.807999999999999816e-03, 0.],[1.592480000000000007e-01, 3.727190000000000225e-01, 1.563846000000000069, 1.495779999999999887e-01, 8.379999999999999862e-04, 3.601960000000000162e-01, 1.447392000000000012, 3.358099999999999974e-02, 4.099999999999999912e-04, 8.226430000000000131e-01, 1.195789999999999909, 1.290979999999999905e-01, 7.799999999999999859e-05, 3.198399999999999854e-02, 2.624650000000000039e-01, 3.31199999999999984e-03, 3.433140000000000081e-01, 5.660340000000000371e-01, 3.036767000000000216, 1.592169999999999974e-01, 1.791000000000000057e-03, 2.94294e-01, 9.903300000000000436e-01, 3.443700000000000233e-02, 1.039999999999999909e-03, 5.286920000000000508e-01, 2.171984000000000137, 7.891000000000000444e-03, 1.359999999999999989e-04, 1.00610000000000005e-02, 1.763000000000000123e-01, 4.219999999999999793e-03, 2.984713999999999867, 3.19569800000000015, 0., 1.091223999999999972, 1.576049999999999951e-01, 9.385860000000000314e-01, 1.251589000000000063, 1.062570000000000042e-01, 5.374799999999999717e-02, 2.397249999999999936e-01, 9.681459999999999511e-01, 3.022299999999999986e-02, 5.301700000000000162e-02, 2.450189999999999868e-01, 3.623279999999999834e-01, 4.984199999999999742e-02, 1.364319999999999977e-01, 4.281499999999999889e-02, 1.061000000000000094e-03, 2.834320000000000173e-01, 1.029128000000000043, 4.2380000000000001e-02, 1.321600000000000032e-02, 1.376340000000000063e-01, 1.443900000000000045e-02, 0., 3.442800000000000027e-02, 1.599550000000000138e-01, 1.097399999999999938e-02],[6.048590000000000355e-01, 3.716849999999999876e-01, 1.880969999999999864e-01, 3.529593000000000202, 9.298800000000000121e-02, 5.590000000000000351e-04, 4.259500000000000092e-02, 9.289690000000000447e-01, 3.047400000000000109e-02, 1.248100000000000077e-02, 1.576299999999999923e-02, 1.702817000000000025, 1.170999999999999949e-03, 4.199999999999999768e-05, 5.906499999999999945e-02, 6.696599999999999775e-02, 7.067820000000000213e-01, 4.673900000000000277e-02, 1.308729999999999893e-01, 7.467920000000000114e-01, 1.478730000000000044e-01, 7.690000000000000438e-04, 3.155999999999999778e-02, 6.617760000000000309e-01, 7.069999999999999896e-03, 0., 3.680000000000000003e-04, 1.625250000000000028e-01, 1.236600000000000026e-02, 0., 4.910000000000000085e-04, 1.29491999999999996e-01, 2.738551999999999875, 4.214693999999999718, 1.091223999999999972, 0., 1.890900000000000081e-01, 1.514000000000000068e-02, 4.319800000000000029e-02, 3.965210000000000123e-01, 3.750970000000000137e-01, 3.746100000000000124e-02, 2.357470000000000121e-01, 6.292429999999999968e-01, 7.838100000000000622e-02, 7.112000000000000266e-03, 1.149099999999999948e-02, 1.534179999999999988e-01, 1.545200000000000046e-02, 2.237629999999999897e-01, 3.4844799999999998e-01, 3.716999999999999818e-03, 1.175329999999999986e-01, 1.120532000000000084, 1.350000000000000017e-04, 2.82489999999999998e-02, 9.998500000000000443e-02, 4.211199999999999666e-02, 0., 3.855700000000000099e-02, 6.439699999999999591e-02],[9.236440000000000206e-01, 4.143499999999999961e-02, 4.381999999999999611e-03, 8.462000000000000077e-02, 2.735831000000000124, 7.734099999999999309e-02, 3.185740000000000238e-01, 3.817960000000000242e-01, 4.617290000000000005e-01, 6.335300000000000653e-02, 4.420000000000000318e-03, 1.263819999999999943e-01, 9.839259999999999673e-01, 5.890000000000000053e-04, 5.17896000000000023e-01, 2.262000000000000122e-03, 1.274118000000000084, 4.982000000000000317e-03, 2.219000000000000052e-03, 3.926500000000000129e-02, 1.236456999999999917, 6.975399999999999656e-02, 8.738400000000000334e-02, 3.359240000000000004e-01, 2.865469999999999962e-01, 6.799999999999999946e-05, 1.230000000000000082e-04, 5.890000000000000053e-04, 7.411349999999999882e-01, 3.57000000000000004e-04, 3.510000000000000208e-04, 2.373999999999999808e-03, 9.054879999999999596e-01, 2.791199999999999931e-02, 1.576049999999999951e-01, 1.890900000000000081e-01, 0., 6.746559999999999668, 1.561123999999999956, 4.400553000000000381, 1.693997999999999893, 2.797300000000000134e-02, 6.720770000000000355e-01, 5.850710000000000077e-01, 3.415722000000000147, 9.240500000000000103e-02, 4.157179999999999764e-01, 7.187189999999999968e-01, 3.473699999999999705e-02, 1.768289999999999862e-01, 4.380678999999999768, 5.584999999999999964e-01, 5.056770000000000431e-01, 1.9313499999999999, 2.973709999999999964e-01, 3.146600000000000091e-02, 8.065539999999999932e-01, 1.041312000000000015, 1.653500000000000109e-02, 1.940599999999999964e-02, 1.099750000000000033e-01],[5.499999999999999681e-03, 5.659680000000000266e-01, 3.739480000000000026e-01, 4.500000000000000283e-05, 1.966499999999999845e-02, 2.159327999999999914, 4.985040000000000027e-01, 3.855900000000000299e-02, 0., 2.21473500000000012, 1.76800000000000004e-03, 4.850000000000000253e-04, 0., 5.363620000000000054e-01, 1.692639999999999978e-01, 4.000000000000000327e-05, 1.881400000000000086e-02, 6.96015999999999968e-01, 6.349270000000000191e-01, 5.619999999999999996e-04, 1.307700000000000008e-02, 1.394892000000000021, 9.711480000000000112e-01, 2.206199999999999828e-02, 4.159999999999999744e-04, 1.610247999999999902, 2.047099999999999961e-02, 2.359999999999999902e-04, 1.359999999999999989e-04, 1.191513999999999962, 1.037659999999999971e-01, 1.320000000000000101e-04, 1.405460000000000043e-01, 8.025160000000000071e-01, 9.385860000000000314e-01, 1.514000000000000068e-02, 6.746559999999999668, 0., 9.37313699999999983, 9.612709000000000614, 3.602199999999999847e-02, 1.797671000000000019, 4.965519999999999934e-01, 8.692300000000000026e-02, 2.856900000000000064e-02, 2.62083300000000019, 6.825790000000000468e-01, 4.658299999999999941e-02, 3.807880000000000154e-01, 5.800000000000000034e-05, 8.421800000000000119e-02, 3.452570000000000139, 1.978447999999999984, 1.119679999999999981e-01, 1.514097000000000026, 4.417800000000000199e-02, 4.659999999999999971e-04, 0., 5.122029999999999639e-01, 1.654000000000000088e-03, 9.299999999999999727e-05],[4.820000000000000066e-04, 6.850100000000000633e-02, 7.59132000000000029e-01, 3.771000000000000046e-03, 4.984800000000000342e-02, 7.288909999999999556e-01, 2.86632499999999979, 2.386200000000000127e-02, 0., 2.002049999999999941e-01, 1.87831999999999999e-01, 6.401999999999999705e-03, 7.799999999999999859e-05, 4.629000000000000302e-03, 8.373019999999999907e-01, 8.100000000000000375e-05, 1.16500000000000002e-03, 1.900370000000000115e-01, 1.544626000000000055, 8.012400000000000078e-02, 1.782399999999999957e-02, 4.175650000000000195e-01, 1.950083000000000011, 1.410100000000000069e-02, 6.239999999999999887e-04, 8.3743999999999999e-02, 3.40917799999999982, 1.531000000000000026e-03, 0., 8.930000000000000221e-04, 1.524024000000000045, 6.600000000000000506e-05, 2.27527000000000007e-01, 7.025940000000000518e-01, 1.251589000000000063, 4.319800000000000029e-02, 1.561123999999999956, 9.37313699999999983, 0., 5.140068000000000303, 4.658799999999999747e-02, 1.398079000000000072, 1.52614099999999997, 8.355200000000000127e-02, 8.186100000000000321e-02, 9.683509999999999618e-01, 2.21148800000000012, 5.404899999999999982e-02, 1.061870000000000036e-01, 2.7035e-02, 1.505890000000000006e-01, 1.262618000000000018, 4.658653000000000155, 1.033229999999999982e-01, 5.861110000000000486e-01, 4.460149999999999948e-01, 2.856699999999999864e-02, 0., 7.485100000000000087e-02, 2.209079999999999933e-01, 5.884000000000000341e-03],[2.162439999999999918e-01, 1.329000000000000103e-03, 2.686620000000000119e-01, 6.43159999999999954e-01, 3.241620000000000057e-01, 1.201210000000000055e-01, 1.085010000000000002e-01, 2.359361999999999959, 1.385199999999999973e-02, 5.328000000000000271e-03, 4.537399999999999767e-02, 2.323090999999999795, 1.794999999999999938e-03, 2.530000000000000239e-04, 4.511339999999999795e-01, 5.363320000000000309e-01, 2.729500000000000259e-01, 9.100000000000000287e-05, 4.090699999999999892e-02, 4.205800000000000094e-01, 3.469780000000000086e-01, 7.302100000000000257e-02, 1.352599999999999983e-02, 1.272426000000000057, 1.87100000000000005e-03, 0., 0., 3.242269999999999874e-01, 4.076999999999999895e-03, 4.169999999999999987e-04, 7.720000000000000083e-04, 8.797409999999999952e-01, 5.02354999999999996e-01, 1.86170000000000016e-02, 1.062570000000000042e-01, 3.965210000000000123e-01, 4.400553000000000381, 9.612709000000000614, 5.140068000000000303, 0., 6.58541000000000043e-01, 2.221400000000000111e-02, 2.389070000000000082e-01, 1.572807999999999984, 6.625780000000000003e-01, 1.319289999999999907e-01, 1.522149999999999892e-01, 2.600427999999999962, 4.189999999999999931e-04, 3.703089999999999993e-01, 1.82587799999999989, 7.717709999999999848e-01, 2.505450000000000177e-01, 3.994416999999999884, 1.173300000000000037e-02, 3.586000000000000298e-02, 1.899864999999999915, 8.892000000000000598e-03, 2.339999999999999958e-04, 3.563000000000000195e-02, 4.835630000000000206e-01],[7.139609999999999568e-01, 2.803999999999999826e-01, 1.760000000000000063e-03, 9.098610000000000309e-01, 4.667700000000000182e-01, 1.119999999999999983e-04, 1.869999999999999917e-04, 2.448999999999999788e-03, 9.384390000000000231e-01, 2.987380000000000035e-01, 1.65587000000000012e-01, 1.179052999999999907, 1.943189999999999917e-01, 8.399999999999999535e-05, 3.772400000000000059e-02, 2.829999999999999942e-04, 5.51493000000000011e-01, 4.982000000000000317e-03, 2.889999999999999774e-04, 9.755400000000000182e-02, 5.562040000000000317e-01, 3.840000000000000097e-04, 1.640000000000000019e-04, 3.549000000000000071e-03, 2.472449999999999926e-01, 7.529999999999999801e-04, 1.041899999999999944e-02, 1.531000000000000069e-02, 1.657839999999999869e-01, 6.000000000000000152e-05, 6.999999999999999387e-05, 3.299999999999999982e-04, 6.391250000000000542e-01, 6.743100000000000482e-02, 5.374799999999999717e-02, 3.750970000000000137e-01, 1.693997999999999893, 3.602199999999999847e-02, 4.658799999999999747e-02, 6.58541000000000043e-01, 0., 5.214688999999999908, 5.640859999999999985, 1.171294999999999975, 3.246959999999999846e-01, 9.773000000000000437e-03, 1.68389999999999998e-02, 8.033700000000000563e-02, 2.982599999999999835e-02, 8.23229999999999934e-02, 1.720919000000000088, 1.951000000000000043e-03, 1.719999999999999958e-03, 1.212099999999999983e-02, 6.149700000000000305e-02, 7.36819999999999975e-02, 1.976410000000000111e-01, 2.01112000000000013e-01, 1.831500000000000142e-02, 1.082000000000000062e-03, 1.139909999999999951e-01],[2.863000000000000093e-03, 1.110726000000000102, 1.762239999999999918e-01, 1.12199999999999995e-03, 0., 5.189030000000000031e-01, 6.459000000000000331e-03, 0., 8.210000000000000067e-04, 2.392605999999999788, 1.222700000000000002e-02, 5.402499999999999664e-02, 0., 5.542500000000000204e-02, 1.860300000000000148e-02, 2.829999999999999942e-04, 1.619299999999999906e-02, 5.667590000000000128e-01, 3.362769999999999926e-01, 8.429999999999999993e-04, 9.000000000000000567e-05, 6.369160000000000377e-01, 3.957709999999999839e-01, 9.600000000000000243e-05, 8.942000000000000295e-03, 6.76049000000000011e-01, 7.037280000000000202e-01, 2.143499999999999919e-02, 0., 2.405049999999999966e-01, 4.726799999999999752e-02, 0., 3.058500000000000107e-02, 1.228004000000000095, 2.397249999999999936e-01, 3.746100000000000124e-02, 2.797300000000000134e-02, 1.797671000000000019, 1.398079000000000072, 2.221400000000000111e-02, 5.214688999999999908, 0., 8.675226999999999578, 3.93595000000000006, 1.557000000000000007e-03, 2.014769999999999894e-01, 5.10480000000000031e-02, 2.050000000000000173e-03, 1.273880000000000012e-01, 5.800000000000000034e-05, 2.889999999999999774e-04, 8.800320000000000364e-01, 3.560380000000000211e-01, 8.500000000000000611e-05, 3.093739999999999823e-01, 1.053049999999999958e-01, 7.608000000000000179e-03, 0., 1.728889999999999871e-01, 1.910000000000000077e-04, 0.],[1.157999999999999958e-03, 2.938839999999999786e-01, 7.439999999999999947e-01, 1.949639999999999984e-01, 6.099999999999999737e-04, 4.470000000000000232e-04, 7.164409999999999945e-01, 5.529999999999999976e-04, 6.956700000000000383e-02, 1.149845999999999924, 1.558783999999999947, 6.849680000000000213e-01, 7.799999999999999859e-05, 2.950000000000000148e-04, 4.101989999999999803e-01, 8.100000000000000375e-05, 3.029000000000000008e-03, 5.371399999999999786e-02, 6.342029999999999612e-01, 8.405999999999999583e-02, 1.253999999999999906e-03, 1.441000000000000007e-03, 7.030920000000000503e-01, 1.918e-03, 1.434809999999999974e-01, 9.716500000000000137e-02, 5.908330000000000526e-01, 4.322199999999999653e-02, 0., 1.190000000000000058e-04, 1.85038000000000008e-01, 6.600000000000000506e-05, 1.369370000000000032e-01, 4.035210000000000186e-01, 9.681459999999999511e-01, 2.357470000000000121e-01, 6.720770000000000355e-01, 4.965519999999999934e-01, 1.52614099999999997, 2.389070000000000082e-01, 5.640859999999999985, 8.675226999999999578, 0., 3.981616999999999962, 7.453600000000000503e-02, 6.422700000000000631e-02, 2.762760000000000216e-01, 3.217699999999999727e-02, 1.431400000000000033e-02, 7.948000000000000204e-03, 3.376000000000000095e-03, 2.974000000000000081e-03, 2.163174999999999848, 2.797000000000000007e-03, 1.839520000000000044e-01, 3.816709999999999825e-01, 1.058840000000000059e-01, 0., 3.203899999999999804e-02, 1.758609999999999896e-01, 1.877300000000000149e-02],[4.873000000000000248e-02, 5.904999999999999659e-03, 2.164900000000000158e-02, 1.322233999999999909, 5.339999999999999695e-04, 1.119999999999999983e-04, 3.739999999999999835e-04, 3.803739999999999899e-01, 3.765700000000000297e-02, 3.260350000000000192e-01, 4.7437e-02, 2.382451000000000096, 1.559999999999999972e-04, 0., 2.747899999999999995e-02, 6.999500000000000166e-02, 4.281200000000000283e-02, 9.100000000000000287e-05, 3.376999999999999794e-03, 3.88156000000000001e-01, 2.507999999999999813e-03, 2.880000000000000073e-04, 1.312000000000000015e-03, 4.188020000000000076e-01, 4.200500000000000067e-02, 4.656000000000000416e-03, 1.176800000000000068e-02, 2.411969999999999947e-01, 2.719999999999999979e-04, 6.000000000000000152e-05, 1.749999999999999982e-04, 1.697770000000000112e-01, 8.914800000000000502e-02, 3.511999999999999844e-02, 3.022299999999999986e-02, 6.292429999999999968e-01, 5.850710000000000077e-01, 8.692300000000000026e-02, 8.355200000000000127e-02, 1.572807999999999984, 1.171294999999999975, 3.93595000000000006, 3.981616999999999962, 0., 7.252100000000000213e-02, 1.677599999999999925e-02, 2.488299999999999887e-02, 1.641430000000000111e-01, 1.20000000000000003e-04, 1.309400000000000008e-01, 1.167299999999999935e-02, 1.951000000000000043e-03, 7.108999999999999868e-03, 9.761849999999999694e-01, 4.504400000000000071e-02, 3.931300000000000072e-02, 4.208990000000000231e-01, 7.410000000000000137e-04, 1.41000000000000012e-04, 3.880999999999999901e-03, 1.646589999999999998e-01],[7.082039999999999447e-01, 2.36199999999999995e-03, 5.240000000000000517e-04, 8.843999999999999431e-03, 3.879354999999999887, 1.956999999999999972e-03, 2.527999999999999865e-03, 9.008000000000000382e-03, 5.606419999999999737e-01, 6.570000000000000319e-04, 2.062000000000000031e-03, 6.304999999999999841e-03, 1.271061999999999914, 3.137789999999999746e-01, 5.690760000000000263e-01, 2.581653999999999893, 6.069449999999999568e-01, 2.808000000000000166e-03, 1.450000000000000009e-04, 1.958599999999999924e-02, 7.321109999999999562e-01, 1.920000000000000049e-04, 8.200000000000000095e-05, 1.150999999999999896e-03, 2.551470000000000127e-01, 0., 0., 3.530000000000000152e-04, 2.047159000000000173, 3.173000000000000126e-02, 2.052899999999999864e-02, 5.095950000000000202e-01, 4.692810000000000037e-01, 6.775999999999999905e-03, 5.301700000000000162e-02, 7.838100000000000622e-02, 3.415722000000000147, 2.856900000000000064e-02, 8.186100000000000321e-02, 6.625780000000000003e-01, 3.246959999999999846e-01, 1.557000000000000007e-03, 7.453600000000000503e-02, 7.252100000000000213e-02, 0., 5.637508999999999659, 3.945647000000000126, 5.313949000000000034, 6.042999999999999761e-02, 2.36179e-01, 8.137199999999999989e-01, 2.790000000000000054e-04, 1.150000000000000035e-04, 1.356e-03, 8.698599999999999388e-02, 5.861600000000000144e-02, 7.542330000000000423e-01, 2.299542999999999893, 4.740300000000000069e-02, 7.624250000000000194e-01, 5.655660000000000132e-01],[1.930000000000000075e-03, 2.154919999999999891e-01, 5.614500000000000046e-02, 0., 2.514999999999999875e-03, 2.862216000000000093, 1.029799999999999986e-02, 1.026999999999999918e-03, 2.049999999999999956e-04, 3.81286999999999987e-01, 2.062000000000000031e-03, 9.699999999999999963e-05, 1.542070000000000107e-01, 7.487815999999999583, 3.50472999999999979e-01, 4.586219999999999741e-01, 6.756999999999999985e-03, 4.91034000000000026e-01, 6.932000000000000661e-02, 3.750000000000000078e-04, 5.370000000000000424e-04, 7.600900000000000434e-01, 3.164200000000000346e-02, 1.920000000000000049e-04, 1.87100000000000005e-03, 6.485229999999999606e-01, 5.026000000000000086e-03, 5.890000000000000053e-04, 4.375600000000000322e-02, 2.720152999999999821, 1.085169999999999968, 1.053609999999999963e-01, 4.256499999999999867e-02, 1.190620000000000012e-01, 2.450189999999999868e-01, 7.112000000000000266e-03, 9.240500000000000103e-02, 2.62083300000000019, 9.683509999999999618e-01, 1.319289999999999907e-01, 9.773000000000000437e-03, 2.014769999999999894e-01, 6.422700000000000631e-02, 1.677599999999999925e-02, 5.637508999999999659, 0., 8.74444500000000069, 9.569170000000000176e-01, 5.828010000000000135e-01, 1.160000000000000007e-04, 9.600000000000000243e-05, 3.968969999999999998e-01, 1.260999999999999968e-03, 8.500000000000000611e-05, 1.27390800000000004, 9.204400000000000082e-02, 1.087000000000000076e-03, 5.989999999999999665e-03, 9.46135999999999977e-01, 1.408669999999999922e-01, 2.63380000000000003e-02],[1.930000000000000021e-04, 1.358200000000000032e-02, 3.118850000000000233e-01, 6.279999999999999775e-04, 1.143300000000000045e-02, 8.964300000000000046e-02, 3.092499999999999805, 3.63500000000000021e-03, 1.029999999999999964e-04, 4.159999999999999636e-03, 3.143790000000000195e-01, 1.358000000000000049e-03, 9.111930000000000307e-01, 3.487341999999999942, 1.399672999999999945, 9.53353000000000006e-01, 4.659999999999999971e-04, 4.411199999999999843e-02, 4.754959999999999742e-01, 3.223700000000000176e-02, 7.169999999999999724e-04, 1.536999999999999955e-03, 6.024279999999999635e-01, 3.840000000000000097e-04, 8.319999999999999488e-04, 3.286999999999999991e-03, 7.013989999999999947e-01, 1.412999999999999977e-03, 1.731219999999999981e-01, 4.774390000000000023e-01, 2.262490000000000112, 9.184399999999999509e-02, 5.502499999999999752e-02, 4.127999999999999725e-02, 3.623279999999999834e-01, 1.149099999999999948e-02, 4.157179999999999764e-01, 6.825790000000000468e-01, 2.21148800000000012, 1.522149999999999892e-01, 1.68389999999999998e-02, 5.10480000000000031e-02, 2.762760000000000216e-01, 2.488299999999999887e-02, 3.945647000000000126, 8.74444500000000069, 0., 8.832620999999999611, 1.163089999999999957e-01, 9.629999999999999671e-03, 7.720000000000000083e-04, 1.394000000000000057e-03, 4.518989999999999951e-01, 2.53999999999999994e-04, 5.302780000000000271e-01, 2.77071999999999985e-01, 1.268440000000000123e-01, 2.469899999999999873e-02, 3.710720000000000129e-01, 1.108802000000000065, 6.892700000000000216e-02],[2.014799999999999924e-01, 2.950000000000000148e-04, 7.213799999999999379e-02, 3.185950000000000171e-01, 5.625000000000000139e-02, 3.020000000000000115e-03, 4.867999999999999931e-03, 2.898791000000000118, 3.211599999999999872e-02, 2.190000000000000106e-04, 5.170899999999999802e-02, 5.014560000000000128e-01, 2.577577999999999925, 5.759210000000000163e-01, 4.301240000000000063e-01, 6.546162999999999954, 1.508039999999999936e-01, 9.100000000000000287e-05, 9.599999999999999159e-03, 3.382069999999999799e-01, 9.225000000000000561e-03, 1.920000000000000049e-04, 2.460000000000000164e-04, 7.083949999999999969e-01, 3.742999999999999799e-03, 0., 0., 3.368280000000000163e-01, 5.551040000000000418e-01, 7.286600000000000021e-02, 1.158000000000000002e-02, 1.897149999999999892, 2.764989999999999948e-01, 4.100999999999999611e-03, 4.984199999999999742e-02, 1.534179999999999988e-01, 7.187189999999999968e-01, 4.658299999999999941e-02, 5.404899999999999982e-02, 2.600427999999999962, 8.033700000000000563e-02, 2.050000000000000173e-03, 3.217699999999999727e-02, 1.641430000000000111e-01, 5.313949000000000034, 9.569170000000000176e-01, 8.832620999999999611, 0., 3.589999999999999984e-04, 5.715050000000000407e-01, 2.219000000000000052e-03, 1.859999999999999945e-04, 1.150000000000000035e-04, 5.639950000000000241e-01, 4.316000000000000392e-03, 3.876299999999999885e-02, 1.598824000000000023, 7.481959999999999722e-01, 6.590500000000000524e-02, 5.296189999999999509e-01, 8.639700000000000157e-01],[4.2942000000000001e-02, 4.878140000000000254e-01, 1.408639999999999892e-01, 4.27620000000000014e-02, 5.336300000000000071e-02, 3.935449999999999782e-01, 1.777569999999999983e-01, 5.990000000000000316e-04, 6.090899999999999787e-02, 3.468899999999999761e-01, 2.695100000000000273e-01, 1.800000000000000113e-04, 2.545400000000000093e-02, 2.559750000000000081e-01, 3.003540000000000099e-01, 1.800000000000000113e-04, 7.923600000000000088e-02, 3.193995999999999835, 3.323960000000000248e-01, 3.405409999999999826e-01, 2.587300000000000016e-02, 3.104160000000000252e-01, 3.737200000000000244e-02, 4.789999999999999879e-04, 5.168600000000000277e-02, 6.04540999999999995e-01, 8.193100000000000382e-02, 1.376999999999999969e-03, 1.19780000000000008e-02, 6.220890000000000031e-01, 3.088589999999999947e-01, 2.990000000000000036e-04, 4.372100000000000292e-02, 1.847040000000000071e-01, 1.364319999999999977e-01, 1.545200000000000046e-02, 3.473699999999999705e-02, 3.807880000000000154e-01, 1.061870000000000036e-01, 4.189999999999999931e-04, 2.982599999999999835e-02, 1.273880000000000012e-01, 1.431400000000000033e-02, 1.20000000000000003e-04, 6.042999999999999761e-02, 5.828010000000000135e-01, 1.163089999999999957e-01, 3.589999999999999984e-04, 0., 4.177764999999999951, 7.080899999999999694e-02, 5.241160000000000263e-01, 2.139669999999999905e-01, 6.958799999999999708e-02, 6.284380000000000521e-01, 1.421996000000000038, 5.485999999999999904e-02, 3.352900000000000325e-02, 4.483501000000000403, 1.778329999999999911e-01, 4.810420000000000251e-01],[4.671359999999999957e-01, 4.658600000000000241e-02, 7.286700000000000121e-02, 7.478700000000000347e-01, 2.080410000000000037e-01, 1.160000000000000007e-04, 4.211899999999999672e-02, 5.999320000000000208e-01, 4.243210000000000037e-01, 1.160000000000000007e-04, 2.004990000000000105e-01, 5.064699999999999758e-01, 5.730129999999999946e-01, 1.160000000000000007e-04, 2.943680000000000185e-01, 3.527310000000000167e-01, 4.862810000000000188e-01, 2.657660000000000022e-01, 9.206999999999999906e-02, 3.08848099999999981, 3.21400000000000019e-02, 1.160000000000000007e-04, 4.177000000000000157e-03, 3.378789999999999849e-01, 4.391699999999999771e-02, 1.160000000000000007e-04, 3.713000000000000154e-03, 5.343750000000000444e-01, 1.66500000000000016e-02, 1.160000000000000007e-04, 4.814999999999999836e-03, 4.854689999999999839e-01, 2.571220000000000172e-01, 1.003700000000000078e-02, 4.281499999999999889e-02, 2.237629999999999897e-01, 1.768289999999999862e-01, 5.800000000000000034e-05, 2.7035e-02, 3.703089999999999993e-01, 8.23229999999999934e-02, 5.800000000000000034e-05, 7.948000000000000204e-03, 1.309400000000000008e-01, 2.36179e-01, 1.160000000000000007e-04, 9.629999999999999671e-03, 5.715050000000000407e-01, 4.177764999999999951, 0., 3.417910000000000115e-01, 4.711499999999999716e-02, 5.813600000000000018e-02, 6.881690000000000307e-01, 6.834199999999999997e-02, 1.140050999999999926, 8.229990000000000361e-01, 7.985820000000000141e-01, 5.033969999999999834e-01, 3.372789999999999955e-01, 4.317980999999999625],[1.496628000000000069, 1.87825999999999993e-01, 4.438000000000000105e-03, 8.720839999999999703e-01, 5.709933000000000369, 1.501069999999999904e-01, 5.165939999999999976e-01, 2.297807000000000155, 1.094735999999999931, 1.049876999999999949, 9.261000000000000135e-03, 5.964323000000000263, 4.034349999999999881e-01, 9.600000000000000243e-05, 2.460940000000000072e-01, 3.860000000000000041e-04, 2.066955000000000098, 1.447000000000000022e-02, 2.122000000000000188e-03, 1.281110000000000027e-01, 3.121656000000000208, 7.235199999999999965e-02, 6.49239999999999956e-02, 5.444740000000000135e-01, 5.570150000000000379e-01, 0., 0., 5.789999999999999791e-04, 4.960459999999999869e-01, 9.600000000000000243e-05, 0., 2.889999999999999774e-04, 1.265487000000000029, 7.427999999999999707e-03, 1.061000000000000094e-03, 3.4844799999999998e-01, 4.380678999999999768, 8.421800000000000119e-02, 1.505890000000000006e-01, 1.82587799999999989, 1.720919000000000088, 2.889999999999999774e-04, 3.376000000000000095e-03, 1.167299999999999935e-02, 8.137199999999999989e-01, 9.600000000000000243e-05, 7.720000000000000083e-04, 2.219000000000000052e-03, 7.080899999999999694e-02, 3.417910000000000115e-01, 0., 5.982573000000000363, 7.424222000000000321, 5.921778999999999904, 1.219370000000000037e-01, 1.958330000000000071e-01, 7.519799999999999818e-01, 1.184812999999999894, 5.667699999999999821e-02, 6.118869999999999587e-01, 2.780900000000000039e-01],[2.09090000000000005e-02, 1.118208000000000091, 2.516499999999999848e-01, 9.290000000000000297e-04, 4.097210000000000019e-01, 3.829579999999999984, 1.562591000000000063, 4.873170000000000002e-01, 2.04399999999999981e-03, 8.92975999999999992e-01, 2.871500000000000094e-02, 8.363600000000000201e-02, 0., 1.159749999999999948e-01, 4.228200000000000014e-02, 0., 8.038299999999999612e-02, 1.144692000000000043, 4.233819999999999806e-01, 2.137000000000000011e-03, 1.387420000000000042e-01, 2.487136000000000013, 3.710629999999999762e-01, 1.963580000000000048e-01, 4.088999999999999753e-03, 6.858119999999999772e-01, 4.832000000000000357e-03, 1.208000000000000089e-03, 1.859999999999999945e-04, 3.428129999999999789e-01, 1.021999999999999905e-03, 1.859999999999999945e-04, 8.568000000000000616e-02, 1.023141999999999996, 2.834320000000000173e-01, 3.716999999999999818e-03, 5.584999999999999964e-01, 3.452570000000000139, 1.262618000000000018, 7.717709999999999848e-01, 1.951000000000000043e-03, 8.800320000000000364e-01, 2.974000000000000081e-03, 1.951000000000000043e-03, 2.790000000000000054e-04, 3.968969999999999998e-01, 1.394000000000000057e-03, 1.859999999999999945e-04, 5.241160000000000263e-01, 4.711499999999999716e-02, 5.982573000000000363, 0., 5.359077000000000091, 3.65508999999999995, 1.323765000000000081, 8.131199999999999539e-02, 3.434630000000000183e-01, 1.160899999999999953e-02, 6.560040000000000315e-01, 1.588729999999999865e-01, 3.007400000000000004e-02],[4.589999999999999896e-04, 7.258360000000000367e-01, 7.686070000000000402e-01, 4.070599999999999913e-02, 3.498459999999999903e-01, 2.395833000000000101, 4.919173999999999936, 1.997480000000000089e-01, 1.150000000000000035e-04, 9.818281000000000702, 5.143919999999999604e-01, 6.815750000000000419e-01, 0., 3.440000000000000132e-04, 5.270049999999999457e-01, 0., 2.178999999999999947e-03, 1.14551e-01, 1.519211000000000089, 7.373000000000000387e-02, 1.515890000000000015e-01, 4.325200000000000156e-01, 2.075225999999999793, 7.87759999999999988e-02, 3.210999999999999879e-03, 3.210600000000000259e-02, 1.903570999999999902, 1.719999999999999958e-03, 1.150000000000000035e-04, 3.440000000000000132e-04, 2.669429999999999858e-01, 0., 2.178999999999999947e-03, 6.70108000000000037e-01, 1.029128000000000043, 1.175329999999999986e-01, 5.056770000000000431e-01, 1.978447999999999984, 4.658653000000000155, 2.505450000000000177e-01, 1.719999999999999958e-03, 3.560380000000000211e-01, 2.163174999999999848, 7.108999999999999868e-03, 1.150000000000000035e-04, 1.260999999999999968e-03, 4.518989999999999951e-01, 1.150000000000000035e-04, 2.139669999999999905e-01, 5.813600000000000018e-02, 7.424222000000000321, 5.359077000000000091, 0., 1.510964999999999892, 4.931789999999999785e-01, 4.100460000000000216e-01, 1.434469999999999912e-01, 1.018799999999999914e-02, 1.982770000000000088e-01, 6.940910000000000135e-01, 3.413700000000000068e-02],[3.409909999999999886e-01, 3.389999999999999784e-03, 1.56467999999999996e-01, 1.773101999999999956, 2.018482999999999805, 1.969829999999999914e-01, 3.61163999999999985e-01, 4.693944000000000116, 4.789000000000000201e-02, 9.476199999999999901e-02, 6.399399999999999533e-02, 2.169045000000000112, 4.240000000000000062e-04, 0., 9.349100000000000465e-02, 1.724030000000000007e-01, 5.083079999999999821e-01, 5.929999999999999941e-04, 4.924599999999999811e-02, 1.253945000000000087, 4.875419999999999754e-01, 1.012040000000000023e-01, 2.144400000000000125e-02, 2.846677000000000124, 6.102999999999999918e-03, 0., 8.500000000000000611e-05, 6.606220000000000425e-01, 6.780000000000000002e-04, 8.500000000000000611e-05, 0., 2.779289999999999816e-01, 3.304810000000000247e-01, 2.53999999999999994e-04, 4.2380000000000001e-02, 1.120532000000000084, 1.9313499999999999, 1.119679999999999981e-01, 1.033229999999999982e-01, 3.994416999999999884, 1.212099999999999983e-02, 8.500000000000000611e-05, 2.797000000000000007e-03, 9.761849999999999694e-01, 1.356e-03, 8.500000000000000611e-05, 2.53999999999999994e-04, 5.639950000000000241e-01, 6.958799999999999708e-02, 6.881690000000000307e-01, 5.921778999999999904, 3.65508999999999995, 1.510964999999999892, 0., 1.382440000000000058e-01, 6.975800000000000056e-02, 1.811752999999999947, 2.497070000000000123e-01, 5.260200000000000292e-02, 2.749900000000000122e-01, 7.739350000000000396e-01],[4.316000000000000392e-03, 3.254219999999999891e-01, 3.479399999999999854e-02, 1.350000000000000017e-04, 6.12269999999999967e-02, 8.06070999999999982e-01, 1.732980000000000076e-01, 1.482999999999999943e-03, 3.088300000000000073e-02, 1.372357000000000049, 7.053299999999999847e-02, 1.817940000000000111e-01, 1.213799999999999948e-02, 3.096430000000000016e-01, 3.246129999999999849e-01, 4.049999999999999781e-04, 3.223199999999999676e-02, 4.830760000000000054e-01, 1.055969999999999964e-01, 1.482999999999999943e-03, 1.025000000000000043e-02, 2.157789999999999986e-01, 4.584999999999999666e-03, 2.700000000000000035e-04, 1.661499999999999921e-01, 5.169270000000000254e-01, 1.831430000000000002e-01, 7.781499999999999528e-02, 2.157799999999999996e-02, 6.741759999999999975e-01, 2.659480000000000177e-01, 6.740000000000000114e-04, 3.641000000000000139e-03, 7.16119999999999951e-02, 1.321600000000000032e-02, 1.350000000000000017e-04, 2.973709999999999964e-01, 1.514097000000000026, 5.861110000000000486e-01, 1.173300000000000037e-02, 6.149700000000000305e-02, 3.093739999999999823e-01, 1.839520000000000044e-01, 4.504400000000000071e-02, 8.698599999999999388e-02, 1.27390800000000004, 5.302780000000000271e-01, 4.316000000000000392e-03, 6.284380000000000521e-01, 6.834199999999999997e-02, 1.219370000000000037e-01, 1.323765000000000081, 4.931789999999999785e-01, 1.382440000000000058e-01, 0., 2.101149999999999962e-01, 6.838377999999999624, 4.001199999999999896e-02, 5.616200000000000081e-01, 2.406320000000000126e-01, 4.595099999999999879e-02],[5.100500000000000173e-02, 5.390799999999999759e-02, 1.052260000000000001e-01, 7.485899999999999499e-02, 6.042100000000000248e-02, 3.782200000000000145e-02, 3.626809999999999756e-01, 3.593899999999999872e-02, 1.45245000000000013e-01, 1.671380000000000088e-01, 4.967059999999999809e-01, 1.390460000000000029e-01, 1.700409999999999977e-01, 1.368489999999999984e-01, 3.216419999999999835e-01, 7.831200000000000661e-02, 5.516299999999999676e-02, 3.692730000000000179e-01, 2.474899999999999878e-01, 1.950729999999999964e-01, 7.03079999999999955e-02, 3.256400000000000267e-02, 2.157880000000000076e-01, 6.183299999999999907e-02, 1.465009999999999923e-01, 1.76475999999999994e-01, 1.135909999999999975, 1.96960000000000017e-02, 1.710599999999999968e-02, 1.137009999999999965e-01, 5.04866000000000037e-01, 1.012200000000000079e-02, 9.965999999999999165e-03, 6.638399999999999856e-02, 1.376340000000000063e-01, 2.82489999999999998e-02, 3.146600000000000091e-02, 4.417800000000000199e-02, 4.460149999999999948e-01, 3.586000000000000298e-02, 7.36819999999999975e-02, 1.053049999999999958e-01, 3.816709999999999825e-01, 3.931300000000000072e-02, 5.861600000000000144e-02, 9.204400000000000082e-02, 2.77071999999999985e-01, 3.876299999999999885e-02, 1.421996000000000038, 1.140050999999999926, 1.958330000000000071e-01, 8.131199999999999539e-02, 4.100460000000000216e-01, 6.975800000000000056e-02, 2.101149999999999962e-01, 0., 2.645560000000000134e-01, 2.710719999999999796e-01, 1.183337000000000083, 6.329470000000000374e-01, 7.868709999999999871e-01],[9.951899999999999635e-02, 9.319999999999999942e-04, 1.148899999999999921e-02, 3.600380000000000247e-01, 4.157750000000000057e-01, 7.759999999999999971e-04, 5.387399999999999828e-02, 1.089585000000000026, 1.443879999999999886e-01, 2.480989999999999862e-01, 1.221860000000000029e-01, 2.007767999999999997, 6.955500000000000571e-02, 3.110000000000000243e-04, 2.980909999999999949e-01, 4.314560000000000062e-01, 1.631740000000000135e-01, 1.55e-04, 5.791000000000000314e-02, 6.340649999999999897e-01, 2.795000000000000175e-03, 0., 1.55e-04, 2.397150000000000114e-01, 2.327279999999999904e-01, 1.288599999999999988e-02, 2.39089999999999997e-02, 7.269079999999999986e-01, 2.064900000000000069e-02, 4.659999999999999971e-04, 2.638999999999999853e-03, 5.432399999999999451e-01, 2.887800000000000089e-02, 0., 1.443900000000000045e-02, 9.998500000000000443e-02, 8.065539999999999932e-01, 4.659999999999999971e-04, 2.856699999999999864e-02, 1.899864999999999915, 1.976410000000000111e-01, 7.608000000000000179e-03, 1.058840000000000059e-01, 4.208990000000000231e-01, 7.542330000000000423e-01, 1.087000000000000076e-03, 1.268440000000000123e-01, 1.598824000000000023, 5.485999999999999904e-02, 8.229990000000000361e-01, 7.519799999999999818e-01, 3.434630000000000183e-01, 1.434469999999999912e-01, 1.811752999999999947, 6.838377999999999624, 2.645560000000000134e-01, 0., 6.455710000000000059e-01, 7.691199999999999426e-02, 3.959420000000000162e-01, 7.335869999999999891e-01],[6.126599999999999824e-01, 2.840000000000000076e-03, 6.20000000000000027e-05, 2.716279999999999806e-01, 8.715680000000000094e-01, 6.20000000000000027e-05, 6.20000000000000027e-05, 1.247299999999999971e-02, 4.23773999999999984e-01, 4.319999999999999838e-04, 2.469999999999999865e-04, 1.092899999999999948e-02, 5.159074999999999633, 4.211199999999999666e-02, 1.418466000000000005, 2.130663000000000196, 5.764759999999999884e-01, 1.230000000000000082e-04, 0., 2.655100000000000168e-02, 2.610689999999999955e-01, 0., 0., 1.358000000000000049e-03, 1.366469999999999907e-01, 0., 0., 7.410000000000000137e-04, 7.219895000000000174, 1.373823000000000016, 1.045943000000000067, 2.035722999999999949, 2.873729999999999896e-01, 6.20000000000000027e-05, 0., 4.211199999999999666e-02, 1.041312000000000015, 0., 0., 8.892000000000000598e-03, 2.01112000000000013e-01, 0., 0., 7.410000000000000137e-04, 2.299542999999999893, 5.989999999999999665e-03, 2.469899999999999873e-02, 7.481959999999999722e-01, 3.352900000000000325e-02, 7.985820000000000141e-01, 1.184812999999999894, 1.160899999999999953e-02, 1.018799999999999914e-02, 2.497070000000000123e-01, 4.001199999999999896e-02, 2.710719999999999796e-01, 6.455710000000000059e-01, 0., 1.51857999999999993e-01, 8.541945999999999373, 2.395821999999999896],[5.995999999999999594e-03, 1.436139999999999917e-01, 4.360900000000000193e-02, 9.399999999999999448e-05, 1.053899999999999976e-02, 3.715410000000000101e-01, 3.64890000000000006e-02, 1.41000000000000012e-04, 1.260000000000000009e-02, 1.667059999999999931e-01, 5.677100000000000202e-02, 4.699999999999999724e-05, 6.496799999999999797e-02, 1.006045000000000078, 8.006020000000000358e-01, 5.995600000000000235e-02, 1.662800000000000042e-02, 7.617709999999999759e-01, 1.072179999999999939e-01, 1.312000000000000015e-03, 6.557999999999999594e-03, 2.856349999999999723e-01, 7.916099999999999526e-02, 1.41000000000000012e-04, 1.601999999999999952e-02, 2.008060000000000123e-01, 2.735500000000000084e-02, 9.399999999999999448e-05, 1.985580000000000123e-01, 2.306109999999999882, 1.341143999999999892, 2.076919999999999877e-01, 6.464000000000000128e-03, 5.536599999999999855e-02, 3.442800000000000027e-02, 0., 1.653500000000000109e-02, 5.122029999999999639e-01, 7.485100000000000087e-02, 2.339999999999999958e-04, 1.831500000000000142e-02, 1.728889999999999871e-01, 3.203899999999999804e-02, 1.41000000000000012e-04, 4.740300000000000069e-02, 9.46135999999999977e-01, 3.710720000000000129e-01, 6.590500000000000524e-02, 4.483501000000000403, 5.033969999999999834e-01, 5.667699999999999821e-02, 6.560040000000000315e-01, 1.982770000000000088e-01, 5.260200000000000292e-02, 5.616200000000000081e-01, 1.183337000000000083, 7.691199999999999426e-02, 1.51857999999999993e-01, 0., 6.755370000000000541e-01, 6.011530999999999736],[4.963000000000000397e-03, 6.069900000000000295e-02, 3.337800000000000211e-01, 7.787800000000000278e-02, 1.11339999999999998e-02, 2.990000000000000036e-03, 5.868179999999999508e-01, 1.565199999999999925e-02, 1.717999999999999909e-03, 5.790000000000000008e-03, 5.06840999999999986e-01, 9.289000000000000382e-03, 1.065536999999999956, 4.780190000000000272e-01, 3.062806999999999835, 1.292934999999999945, 7.507999999999999917e-03, 2.162999999999999992e-03, 2.507480000000000264e-01, 4.02749999999999983e-02, 5.534999999999999989e-03, 3.820000000000000153e-04, 1.129990000000000022e-01, 3.49899999999999994e-03, 1.526999999999999929e-03, 6.39999999999999971e-05, 1.276960000000000039e-01, 3.053999999999999857e-03, 6.560965999999999632, 5.65160299999999971, 2.455337000000000103, 1.16151099999999996, 5.472000000000000301e-03, 6.807999999999999816e-03, 1.599550000000000138e-01, 3.855700000000000099e-02, 1.940599999999999964e-02, 1.654000000000000088e-03, 2.209079999999999933e-01, 3.563000000000000195e-02, 1.082000000000000062e-03, 1.910000000000000077e-04, 1.758609999999999896e-01, 3.880999999999999901e-03, 7.624250000000000194e-01, 1.408669999999999922e-01, 1.108802000000000065, 5.296189999999999509e-01, 1.778329999999999911e-01, 3.372789999999999955e-01, 6.118869999999999587e-01, 1.588729999999999865e-01, 6.940910000000000135e-01, 2.749900000000000122e-01, 2.406320000000000126e-01, 6.329470000000000374e-01, 3.959420000000000162e-01, 8.541945999999999373, 6.755370000000000541e-01, 0., 1.204355999999999982],[1.482680000000000109e-01, 9.299999999999999727e-05, 1.312199999999999998e-02, 2.635669999999999957e-01, 7.994800000000000517e-02, 9.299999999999999727e-05, 8.03199999999999921e-03, 4.972929999999999851e-01, 1.40516000000000002e-01, 9.299999999999999727e-05, 8.330999999999999517e-02, 2.255540000000000045e-01, 1.075186999999999893, 5.603799999999999754e-02, 6.793700000000000294e-01, 1.119410999999999934, 1.263199999999999878e-01, 4.670000000000000214e-04, 9.759999999999999579e-03, 6.386960000000000415e-01, 2.521699999999999983e-02, 1.399999999999999877e-04, 4.062999999999999771e-03, 3.243679999999999897e-01, 3.012099999999999847e-02, 0., 9.340000000000000429e-04, 1.438319999999999876e-01, 1.036473999999999895, 8.36839999999999945e-02, 7.355000000000000426e-02, 2.016256999999999966, 8.494500000000000661e-02, 0., 1.097399999999999938e-02, 6.439699999999999591e-02, 1.099750000000000033e-01, 9.299999999999999727e-05, 5.884000000000000341e-03, 4.835630000000000206e-01, 1.139909999999999951e-01, 0., 1.877300000000000149e-02, 1.646589999999999998e-01, 5.655660000000000132e-01, 2.63380000000000003e-02, 6.892700000000000216e-02, 8.639700000000000157e-01, 4.810420000000000251e-01, 4.317980999999999625, 2.780900000000000039e-01, 3.007400000000000004e-02, 3.413700000000000068e-02, 7.739350000000000396e-01, 4.595099999999999879e-02, 7.868709999999999871e-01, 7.335869999999999891e-01, 2.395821999999999896, 6.011530999999999736, 1.204355999999999982, 0.]



ecmrest_freqs = [0.03000113, 0.02017108, 0.02634411, 0.02300609, 0.01552806, 0.02020108, 0.01214205, 0.01342405, 0.01037204, 0.01167905, 0.00819503, 0.01014204, 0.01355105, 0.02344109, 0.02010208, 0.0255761 , 0.01607606, 0.01170305, 0.02021108, 0.01109704, 0.01064204, 0.01010004, 0.01184305, 0.01000704, 0.00480002, 0.01414806, 0.00783703, 0.00831103, 0.00760003, 0.01738607, 0.02883912, 0.01446706, 0.03322313, 0.0245321 , 0.03187813, 0.02819811, 0.01590806, 0.02830711, 0.01885308, 0.01900508, 0.01579606, 0.02298209, 0.01019104, 0.01685207, 0.01090104, 0.01893808, 0.02274709, 0.01904708, 0.01578206, 0.01596506, 0.00975004, 0.01113104, 0.00895604, 0.01188005, 0.00702903, 0.01188005, 0.00602502, 0.01638707, 0.02138309, 0.01542506, 0.02210309] 
ecmrest_matrix = [0., 0.36626701, 7.628770000000000273e-01, 4.929483000000000281, 3.919360000000000177, 0., 0., 0., 8.423761999999999972, 0., 0., 0., 2.647619999999999862, 0., 0., 0., 6.404435999999999574, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.811398000000000064, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[3.662670000000000092e-01, 0., 9.828930000000000167e-01, 3.863647999999999971, 0., 2.13473999999999986, 0., 0., 0., 7.784767999999999688, 0., 0., 0., 2.92690999999999979e-01, 0., 0., 0., 4.105602000000000196, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.686074000000000073, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.283610000000000084e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[7.628770000000000273e-01, 9.828930000000000167e-01, 0., 1.01021200000000011, 0., 0., 5.869856999999999658, 0., 0., 0., 1.00035800000000008, 0., 0., 0., 9.750739999999999963e-01, 0., 0., 0., 2.715692000000000217, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.090641000000000194, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[4.929483000000000281, 3.863647999999999971, 1.01021200000000011, 0., 0., 0., 0., 1.715476000000000001, 0., 0., 0., 6.623529000000000444, 0., 0., 0., 5.010539999999999994e-01, 0., 0., 0., 5.004762000000000377, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6.091654000000000124, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.245404999999999873, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[3.919360000000000177, 0., 0., 0., 0., 6.96765499999999971, 2.678802000000000127, 8.307876000000000261, 7.540550000000000308e-01, 0., 0., 0., 4.962349999999999817, 0., 0., 0., 0., 0., 0., 0., 9.255750000000000366e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.064068999999999932, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6.033932000000000073, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 2.13473999999999986, 0., 0., 6.96765499999999971, 0., 8.414968999999999255, 6.035739999999999661, 0., 1.337943000000000104, 0., 0., 0., 2.231468000000000007, 0., 0., 0., 0., 0., 0., 0., 1.434549999999999992, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.312254999999999949, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.793594999999999828, 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 5.869856999999999658, 0., 2.678802000000000127, 8.414968999999999255, 0., 9.578981999999999886, 0., 0., 2.57727100000000009, 0., 0., 0., 8.155284999999999229, 0., 0., 0., 0., 0., 0., 0., 1.238450000000000051, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.461548999999999765, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7.103903999999999996, 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 1.715476000000000001, 8.307876000000000261, 6.035739999999999661, 9.578981999999999886, 0., 0., 0., 0., 9.399321999999999733, 0., 0., 0., 2.801563999999999943, 0., 0., 0., 0., 0., 0., 0., 6.578975999999999935, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.107629000000000197, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 8.229100000000000747, 0., 0., 0., 0., 0., 0., 0.],[8.423761999999999972, 0., 0., 0., 7.540550000000000308e-01, 0., 0., 0., 0., 1.208999999999999936e-01, 6.292704999999999771, 1.792245000000000088, 1.903175000000000061, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.372237999999999847, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.432409999999999961, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 7.784767999999999688, 0., 0., 0., 1.337943000000000104, 0., 0., 1.208999999999999936e-01, 0., 6.011969999999999814, 6.63766799999999968, 0., 4.377789999999999737e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.033629999999999605, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4.285542999999999658, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.047654000000000085, 0., 0., 0., 0., 0., 0.],[0., 0., 1.00035800000000008, 0., 0., 0., 2.57727100000000009, 0., 6.292704999999999771, 6.011969999999999814, 0., 3.324580999999999786, 0., 0., 2.231662000000000035, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.296291000000000082, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.388513999999999804, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 8.250819999999999821e-01, 0., 0., 0., 0., 0.],[0., 0., 0., 6.623529000000000444, 0., 0., 0., 9.399321999999999733, 1.792245000000000088, 6.63766799999999968, 3.324580999999999786, 0., 0., 0., 0., 5.781180000000000208e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.834665999999999908, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.907799999999999718e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4.719489000000000267, 0., 0., 0., 0.],[2.647619999999999862, 0., 0., 0., 4.962349999999999817, 0., 0., 0., 1.903175000000000061, 0., 0., 0., 0., 4.623935999999999602, 2.082127999999999979, 8.298899999999999721, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.134458999999999662, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.294298000000000393, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.165879999999999972e-01, 0., 0., 0.],[0., 2.92690999999999979e-01, 0., 0., 0., 2.231468000000000007, 0., 0., 0., 4.377789999999999737e-01, 0., 0., 4.623935999999999602, 0., 1.303951000000000082, 1.40727999999999992e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6.381840999999999653, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.373369999999999869e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7.860430000000000472e-01, 0., 0.],[0., 0., 9.750739999999999963e-01, 0., 0., 0., 8.155284999999999229, 0., 0., 0., 2.231662000000000035, 0., 2.082127999999999979, 1.303951000000000082, 0., 1.281784000000000034, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.570123000000000157, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.07844400000000018, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7.911095999999999684, 0.],[0., 0., 0., 5.010539999999999994e-01, 0., 0., 0., 2.801563999999999943, 0., 0., 0., 5.781180000000000208e-01, 8.298899999999999721, 1.40727999999999992e-01, 1.281784000000000034, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4.301224999999999632, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7.096281000000000283, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.682028999999999996],[6.404435999999999574, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.918903999999999943, 4.959151000000000309, 3.440380000000000216, 5.381867999999999874, 0., 0., 0., 6.415757000000000154, 0., 0., 0., 7.419057999999999709, 0., 0., 0., 4.485369000000000383, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 4.105602000000000196, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.918903999999999943, 0., 5.369462999999999653, 8.08615999999999957, 0., 3.774544000000000121, 0., 0., 0., 7.016899000000000441, 0., 0., 0., 3.23075100000000015, 0., 0., 0., 3.006826999999999916, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7.087800999999999796, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 2.715692000000000217, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4.959151000000000309, 5.369462999999999653, 0., 1.086327000000000043, 0., 0., 1.794388000000000094, 0., 0., 0., 9.920977000000000601, 0., 0., 0., 1.81254000000000004, 0., 0., 0., 7.686782000000000004, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 5.004762000000000377, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.440380000000000216, 8.08615999999999957, 1.086327000000000043, 0., 0., 0., 0., 1.021681999999999979, 0., 0., 0., 3.01972599999999991, 0., 0., 0., 1.583115999999999968, 0., 0., 0., 3.837059999999999915e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.444964000000000137, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 9.255750000000000366e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.381867999999999874, 0., 0., 0., 0., 2.053827000000000069, 1.295212999999999948, 5.480963000000000029, 1.693662000000000001, 0., 0., 0., 1.39368000000000003, 0., 0., 0., 0., 0., 0., 0., 2.923972000000000016, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.31281099999999995, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 1.434549999999999992, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.774544000000000121, 0., 0., 2.053827000000000069, 0., 8.557938999999999297, 7.46162700000000001, 0., 1.69930200000000009, 0., 0., 0., 1.389734999999999943, 0., 0., 0., 0., 0., 0., 0., 3.120188999999999879, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.704600999999999811, 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 1.238450000000000051, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.794388000000000094, 0., 1.295212999999999948, 8.557938999999999297, 0., 8.407090999999999426, 0., 0., 3.144296000000000202, 0., 0., 0., 4.77615999999999985e-01, 0., 0., 0., 0., 0., 0., 0., 6.034856000000000442, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.303479999999999972, 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 6.578975999999999935, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.021681999999999979, 5.480963000000000029, 7.46162700000000001, 8.407090999999999426, 0., 0., 0., 0., 3.341649999999999898e-01, 0., 0., 0., 1.263838000000000017, 0., 0., 0., 0., 0., 0., 0., 1.15918499999999991, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.769355000000000011, 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 2.372237999999999847, 0., 0., 0., 0., 0., 0., 0., 6.415757000000000154, 0., 0., 0., 1.693662000000000001, 0., 0., 0., 0., 4.930265999999999593, 3.919751999999999903, 9.459951000000000221, 3.023938999999999933, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 9.104099999999999693e-02, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 5.033629999999999605, 0., 0., 0., 0., 0., 0., 0., 7.016899000000000441, 0., 0., 0., 1.69930200000000009, 0., 0., 4.930265999999999593, 0., 9.483729999999999549, 4.603856999999999644, 0., 2.250770000000000159, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.252469999999999972, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.632945000000000091, 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.296291000000000082, 0., 0., 0., 0., 0., 0., 0., 9.920977000000000601, 0., 0., 0., 3.144296000000000202, 0., 3.919751999999999903, 9.483729999999999549, 0., 8.047499999999999654e-01, 0., 0., 1.46294499999999994, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4.803738000000000063, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.026085999999999832, 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.834665999999999908, 0., 0., 0., 0., 0., 0., 0., 3.01972599999999991, 0., 0., 0., 3.341649999999999898e-01, 9.459951000000000221, 4.603856999999999644, 8.047499999999999654e-01, 0., 0., 0., 0., 7.795649999999999524e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4.114999999999999908e-02, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.617091000000000056, 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.134458999999999662, 0., 0., 0., 7.419057999999999709, 0., 0., 0., 1.39368000000000003, 0., 0., 0., 3.023938999999999933, 0., 0., 0., 0., 7.811205000000000176, 5.650115999999999694, 6.803875999999999813, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.737489000000000061, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.75263800000000014, 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6.381840999999999653, 0., 0., 0., 3.23075100000000015, 0., 0., 0., 1.389734999999999943, 0., 0., 0., 2.250770000000000159, 0., 0., 7.811205000000000176, 0., 2.078564000000000078, 8.905483999999999511, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.914971999999999674, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.266373000000000193, 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.570123000000000157, 0., 0., 0., 1.81254000000000004, 0., 0., 0., 4.77615999999999985e-01, 0., 0., 0., 1.46294499999999994, 0., 5.650115999999999694, 2.078564000000000078, 0., 8.432339000000000695, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.164804999999999868, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 8.772180000000000533e-01, 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4.301224999999999632, 0., 0., 0., 1.583115999999999968, 0., 0., 0., 1.263838000000000017, 0., 0., 0., 7.795649999999999524e-01, 6.803875999999999813, 8.905483999999999511, 8.432339000000000695, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.473622999999999905, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.090751000000000026],[2.811398000000000064, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4.485369000000000383, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6.500879999999999992e-01, 1.535700000000000121e-01, 2.710609999999999964, 2.77444500000000005, 0., 0., 0., 8.739999999999999991e-01, 0., 0., 0., 1.277860999999999914, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 3.686074000000000073, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.006826999999999916, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6.500879999999999992e-01, 0., 3.779053000000000218, 6.058989999999999654e-01, 0., 1.86656500000000003, 0., 0., 0., 1.561628999999999934, 0., 0., 0., 2.085220000000000129e-01, 0., 0., 2.947020000000000195e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 2.090641000000000194, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7.686782000000000004, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.535700000000000121e-01, 3.779053000000000218, 0., 1.296294000000000057, 0., 0., 9.441919000000000395, 0., 0., 0., 1.393809999999999993, 0., 0., 0., 4.761050000000000004e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 6.091654000000000124, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.837059999999999915e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.710609999999999964, 6.058989999999999654e-01, 1.296294000000000057, 0., 0., 0., 0., 6.930260000000000309e-01, 0., 0., 0., 1.042623999999999995, 0., 0., 0., 3.529149999999999787e-01, 0., 3.675530000000000186e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 3.064068999999999932, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.923972000000000016, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.77444500000000005, 0., 0., 0., 0., 5.090423000000000364, 9.529140999999999195, 1.910225000000000062, 2.985092999999999996, 0., 0., 0., 6.29114799999999974, 0., 0., 0., 0., 0., 9.880382000000000886, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 2.312254999999999949, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.120188999999999879, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.86656500000000003, 0., 0., 5.090423000000000364, 0., 7.153469999999999551e-01, 6.516319000000000194, 0., 2.303487000000000062, 0., 0., 0., 4.308415000000000106, 0., 0., 0., 0., 0., 7.675837999999999717, 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 5.461548999999999765, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6.034856000000000442, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 9.441919000000000395, 0., 9.529140999999999195, 7.153469999999999551e-01, 0., 5.512585999999999764, 0., 0., 6.644970999999999961, 0., 0., 0., 6.166553999999999647, 0., 0., 0., 0., 0., 1.863158000000000092, 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 5.107629000000000197, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.15918499999999991, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6.930260000000000309e-01, 1.910225000000000062, 6.516319000000000194, 5.512585999999999764, 0., 0., 0., 0., 1.541379000000000055, 0., 0., 0., 3.682091999999999921, 0., 0., 0., 0., 0., 5.540052000000000199, 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 1.432409999999999961, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 9.104099999999999693e-02, 0., 0., 0., 0., 0., 0., 0., 8.739999999999999991e-01, 0., 0., 0., 2.985092999999999996, 0., 0., 0., 0., 4.120953000000000088, 9.084270999999999319, 5.18100000000000005e-01, 7.024110000000000076e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 4.285542999999999658, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.252469999999999972, 0., 0., 0., 0., 0., 0., 0., 1.561628999999999934, 0., 0., 0., 2.303487000000000062, 0., 0., 4.120953000000000088, 0., 8.06482600000000005, 9.488519999999999399, 0., 5.42717000000000005e-01, 0., 0., 0., 0., 0., 0., 0., 0., 5.528509999999999813e-01, 0., 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.388513999999999804, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4.803738000000000063, 0., 0., 0., 0., 0., 0., 0., 1.393809999999999993, 0., 0., 0., 6.644970999999999961, 0., 9.084270999999999319, 8.06482600000000005, 0., 3.246935999999999822, 0., 0., 3.025010000000000199e-01, 0., 0., 0., 0., 0., 0., 0., 0., 8.108560000000000212e-01, 0., 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.907799999999999718e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4.114999999999999908e-02, 0., 0., 0., 0., 0., 0., 0., 1.042623999999999995, 0., 0., 0., 1.541379000000000055, 5.18100000000000005e-01, 9.488519999999999399, 3.246935999999999822, 0., 0., 0., 0., 5.033849999999999714e-01, 0., 0., 0., 0., 0., 0., 0., 0., 1.104727000000000015, 0., 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.294298000000000393, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.737489000000000061, 0., 0., 0., 1.277860999999999914, 0., 0., 0., 6.29114799999999974, 0., 0., 0., 7.024110000000000076e-01, 0., 0., 0., 0., 3.531461000000000183, 1.898141000000000078, 6.045078000000000173, 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.362719999999999931, 0., 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.373369999999999869e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.914971999999999674, 0., 0., 0., 2.085220000000000129e-01, 0., 0., 0., 4.308415000000000106, 0., 0., 0., 5.42717000000000005e-01, 0., 0., 3.531461000000000183, 0., 1.657664000000000026, 6.669954999999999856, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.923391999999999991, 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.07844400000000018, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.164804999999999868, 0., 0., 0., 4.761050000000000004e-01, 0., 0., 0., 6.166553999999999647, 0., 0., 0., 3.025010000000000199e-01, 0., 1.898141000000000078, 1.657664000000000026, 0., 8.901166999999999163, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.022101000000000148, 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7.096281000000000283, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.473622999999999905, 0., 0., 0., 3.529149999999999787e-01, 0., 0., 0., 3.682091999999999921, 0., 0., 0., 5.033849999999999714e-01, 6.045078000000000173, 6.669954999999999856, 8.901166999999999163, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.261813000000000073],[0., 2.283610000000000084e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7.087800999999999796, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.947020000000000195e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 9.942818000000000822, 0., 5.615471999999999575, 0., 0., 1.442779999999999896e-01, 0., 0., 0., 5.177929999999999922, 0., 0.],[0., 0., 0., 2.245404999999999873, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.444964000000000137, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.675530000000000186e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 9.942818000000000822, 0., 0., 0., 0., 2.206053999999999959, 0., 0., 5.820840000000000458e-01, 0., 0., 0., 6.610894000000000048],[0., 0., 0., 0., 6.033932000000000073, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.31281099999999995, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 9.880382000000000886, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.681751000000000218, 2.991861000000000104, 4.40795500000000029, 0., 0., 0., 2.952332000000000178, 0., 0., 0.],[0., 0., 0., 0., 0., 5.793594999999999828, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.704600999999999811, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7.675837999999999717, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.615471999999999575, 0., 3.681751000000000218, 0., 5.097020999999999802, 3.889101999999999837, 9.339206000000000785, 0., 0., 0., 1.913570999999999911, 0., 0.],[0., 0., 0., 0., 0., 0., 7.103903999999999996, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.303479999999999972, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.863158000000000092, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.991861000000000104, 5.097020999999999802, 0., 7.057443000000000133, 0., 4.662001000000000062, 0., 0., 0., 8.126913999999999305, 0.],[0., 0., 0., 0., 0., 0., 0., 8.229100000000000747, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.769355000000000011, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.540052000000000199, 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.206053999999999959, 4.40795500000000029, 3.889101999999999837, 7.057443000000000133, 0., 0., 0., 6.191480999999999568, 0., 0., 0., 1.658050999999999942],[0., 0., 0., 0., 0., 0., 0., 0., 0., 2.047654000000000085, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.632945000000000091, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.528509999999999813e-01, 0., 0., 0., 0., 0., 0., 1.442779999999999896e-01, 0., 0., 9.339206000000000785, 0., 0., 0., 7.326799999999999979e-02, 4.777963999999999878, 0., 1.558523000000000103, 0., 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 8.250819999999999821e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3.026085999999999832, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 8.108560000000000212e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 4.662001000000000062, 0., 7.326799999999999979e-02, 0., 6.771770000000000289e-01, 0., 0., 5.369644000000000084, 0.],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4.719489000000000267, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.617091000000000056, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.104727000000000015, 0., 0., 0., 0., 0., 5.820840000000000458e-01, 0., 0., 0., 6.191480999999999568, 4.777963999999999878, 6.771770000000000289e-01, 0., 0., 0., 0., 3.347363999999999784],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.165879999999999972e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5.75263800000000014, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.362719999999999931, 0., 0., 0., 0., 0., 2.952332000000000178, 0., 0., 0., 0., 0., 0., 0., 1.089599999999999944e-02, 4.748755000000000059, 1.315609999999999946],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7.860430000000000472e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.266373000000000193, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.923391999999999991, 0., 0., 5.177929999999999922, 0., 0., 1.913570999999999911, 0., 0., 1.558523000000000103, 0., 0., 1.089599999999999944e-02, 0., 4.756287999999999627, 1.192023999999999972],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7.911095999999999684, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 8.772180000000000533e-01, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.022101000000000148, 0., 0., 0., 0., 0., 8.126913999999999305, 0., 0., 5.369644000000000084, 0., 4.748755000000000059, 4.756287999999999627, 0., 5.427075999999999567],[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1.682028999999999996, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.090751000000000026, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2.261813000000000073, 0., 6.610894000000000048, 0., 0., 0., 1.658050999999999942, 0., 0., 3.347363999999999784, 1.315609999999999946, 1.192023999999999972, 5.427075999999999567, 0.]


############################################ AMINO ACID MODELS ###################################################
ab_freqs = [0.06541704, 0.02150693, 0.04688141, 0.02842211, 0.03478555, 0.1005278, 0.009812606, 0.03424424, 0.04844488, 0.06222565, 0.0176037, 0.03168984, 0.03962469, 0.04240711, 0.04708366, 0.1280566, 0.08199314, 0.04948141, 0.03393045, 0.07586119]
ab_matrix = [[0.0, 0.008929181, 1.241095, 0.9521821, 0.1130146, 1.851951, 5.241316, 0.1140412, 0.07388355, 0.06969101, 0.06299271, 0.0929129, 1.800713, 0.1992269, 0.1784266, 0.9988358, 2.912317, 3.774477, 0.07939549, 0.1433528], [0.008929181, 0.0, 0.02340019, 7.519215e-11, 0.1993818, 0.05891123, 3.963388, 0.0006594967, 3.722878e-16, 0.006079219, 0.007213178, 1.374268e-06, 0.004878395, 1.046446e-08, 0.1821885, 0.2639482, 3.225214e-06, 0.02243512, 0.4440833, 0.7741612], [1.241095, 0.02340019, 0.0, 7.426619, 0.1031734, 2.1124, 11.26995, 0.03916999, 0.06622772, 0.03020502, 0.03357577, 7.185182, 0.1509482, 0.1843856, 0.05795374, 0.5822988, 0.1516881, 0.4076074, 0.01423897, 0.9078338], [0.9521821, 7.519215e-11, 7.426619, 0.0, 0.05288625, 1.38937, 7.29808, 0.0001029959, 3.608816, 0.001283121, 0.07659566, 0.5038373, 0.02889815, 3.691671, 0.06273863, 0.06776709, 0.06016624, 0.5795409, 0.02252612, 0.1240642], [0.1130146, 0.1993818, 0.1031734, 0.05288625, 0.0, 0.1984772, 5.642309, 2.714705, 0.004649035, 3.390618, 3.94794, 0.1955446, 0.3556198, 0.00149661, 0.08208677, 0.9813064, 0.03674486, 1.643946, 0.2199856, 7.074464], [1.851951, 0.05891123, 2.1124, 1.38937, 0.1984772, 0.0, 9.139518, 0.03560482, 0.055044, 0.02157936, 0.02187264, 0.4868901, 0.07915056, 0.0551634, 1.0894, 0.9984215, 0.07862767, 0.42282, 0.1386853, 0.2295842], [5.241316, 3.963388, 11.26995, 7.29808, 5.642309, 9.139518, 0.0, 4.706586, 1.455741, 5.879103, 2.298295, 14.05444, 10.49496, 8.908434, 10.4955, 5.439116, 3.443285, 6.890244, 7.01389, 20.55414], [0.1140412, 0.0006594967, 0.03916999, 0.0001029959, 2.714705, 0.03560482, 4.706586, 0.0, 0.5059793, 1.601123, 10.96748, 1.762721, 0.05016568, 6.712736e-06, 0.3245175, 0.6007607, 3.087152, 7.926675, 0.06318748, 0.2903165], [0.07388355, 3.722878e-16, 0.06622772, 3.608816, 0.004649035, 0.055044, 1.455741, 0.5059793, 0.0, 0.02158451, 1.238634, 6.190318, 0.009948994, 3.030805, 7.54924, 0.08688405, 1.039298, 0.0349344, 0.008024263, 0.07109973], [0.06969101, 0.006079219, 0.03020502, 0.001283121, 3.390618, 0.02157936, 5.879103, 1.601123, 0.02158451, 0.0, 5.647985, 0.02769442, 1.149931, 0.6802781, 0.3932002, 0.1580539, 0.5702792, 3.59531, 0.3378544, 0.152132], [0.06299271, 0.007213178, 0.03357577, 0.07659566, 3.94794, 0.02187264, 2.298295, 10.96748, 1.238634, 5.647985, 0.0, 0.03972173, 0.07417279, 0.001233336, 0.3362326, 0.01861354, 1.415612, 4.39672, 0.1011149, 0.002246759], [0.0929129, 1.374268e-06, 7.185182, 0.5038373, 0.1955446, 0.4868901, 14.05444, 1.762721, 6.190318, 0.02769442, 0.03972173, 0.0, 0.007342554, 0.08705989, 0.782913, 7.348346, 2.147175, 0.04931206, 0.0007310937, 2.622763], [1.800713, 0.004878395, 0.1509482, 0.02889815, 0.3556198, 0.07915056, 10.49496, 0.05016568, 0.009948994, 1.149931, 0.07417279, 0.007342554, 0.0, 0.7426909, 0.3498713, 1.284651, 0.9057112, 0.2217442, 0.005516074, 0.1992133], [0.1992269, 1.046446e-08, 0.1843856, 3.691671, 0.00149661, 0.0551634, 8.908434, 6.712736e-06, 3.030805, 0.6802781, 0.001233336, 0.08705989, 0.7426909, 0.0, 1.923901, 0.0005906405, 0.1202094, 0.009047737, 4.332983e-05, 0.02737091], [0.1784266, 0.1821885, 0.05795374, 0.06273863, 0.08208677, 1.0894, 10.4955, 0.3245175, 7.54924, 0.3932002, 0.3362326, 0.782913, 0.3498713, 1.923901, 0.0, 1.926435, 1.135258, 0.1366145, 0.5724286, 0.1711315], [0.9988358, 0.2639482, 0.5822988, 0.06776709, 0.9813064, 0.9984215, 5.439116, 0.6007607, 0.08688405, 0.1580539, 0.01861354, 7.348346, 1.284651, 0.0005906405, 1.926435, 0.0, 3.058575, 0.07477041, 0.1385142, 0.8104751], [2.912317, 3.225214e-06, 0.1516881, 0.06016624, 0.03674486, 0.07862767, 3.443285, 3.087152, 1.039298, 0.5702792, 1.415612, 2.147175, 0.9057112, 0.1202094, 1.135258, 3.058575, 0.0, 0.2166054, 0.01412361, 0.09984255], [3.774477, 0.02243512, 0.4076074, 0.5795409, 1.643946, 0.42282, 6.890244, 7.926675, 0.0349344, 3.59531, 4.39672, 0.04931206, 0.2217442, 0.009047737, 0.1366145, 0.07477041, 0.2166054, 0.0, 0.09663569, 0.5010635], [0.07939549, 0.4440833, 0.01423897, 0.02252612, 0.2199856, 0.1386853, 7.01389, 0.06318748, 0.008024263, 0.3378544, 0.1011149, 0.0007310937, 0.005516074, 4.332983e-05, 0.5724286, 0.1385142, 0.01412361, 0.09663569, 0.0, 0.6121284], [0.1433528, 0.7741612, 0.9078338, 0.1240642, 7.074464, 0.2295842, 20.55414, 0.2903165, 0.07109973, 0.152132, 0.002246759, 2.622763, 0.1992133, 0.02737091, 0.1711315, 0.8104751, 0.09984255, 0.5010635, 0.6121284, 0.0]]


blosum62_freqs = [0.074, 0.025, 0.054, 0.054, 0.047, 0.074, 0.026, 0.068, 0.058, 0.099, 0.025, 0.045, 0.039, 0.034, 0.052, 0.057, 0.051, 0.073, 0.013, 0.032]
blosum62_matrix = [[0.0, 1.45999531047, 0.543161820899, 1.1709490428, 0.492964679748, 1.95588357496, 0.716241444998, 0.605899003687, 1.295201266783, 0.800016530518, 1.253758266664, 0.485391055466, 1.173275900924, 1.199705704602, 0.735790389698, 4.325092687057, 1.729178019485, 2.187774522005, 0.465839367725, 0.718206697586], [1.45999531047, 0.0, 0.240836614802, 0.140748891814, 0.441337471187, 0.418203192284, 0.354058109831, 0.774894022794, 0.285078800906, 0.831842640142, 0.76768882348, 0.397358949897, 0.356008498769, 0.32980150463, 0.227826574209, 1.197188415094, 1.119831358516, 1.116352478606, 0.527664418872, 0.470237733696], [0.543161820899, 0.240836614802, 0.0, 3.761625208368, 0.281730694207, 0.798473248968, 0.778142664022, 0.418555732462, 1.032447924952, 0.218131577594, 0.222621897958, 3.180100048216, 0.730628272998, 1.190945703396, 0.500964408555, 1.582754142065, 0.934187509431, 0.258129289418, 0.145345046279, 0.261422208965], [1.1709490428, 0.140748891814, 3.761625208368, 0.0, 0.291409084165, 0.423579992176, 1.626891056982, 0.186848046932, 2.802427151679, 0.372625175087, 0.55541539747, 1.24048850864, 0.926563934846, 5.528919177928, 1.36057419042, 1.769893238937, 1.071097236007, 0.524253846338, 0.407635648938, 0.596719300346], [0.492964679748, 0.441337471187, 0.281730694207, 0.291409084165, 0.0, 0.368166464453, 0.714533703928, 1.517359325954, 0.266924750511, 2.064839703237, 1.77385516883, 0.354861249223, 0.233597909629, 0.14435695975, 0.371644693209, 0.540027644824, 0.488206118793, 0.838119610178, 2.074324893497, 6.747260430801], [1.95588357496, 0.418203192284, 0.798473248968, 0.423579992176, 0.368166464453, 0.0, 0.539859124954, 0.189296292376, 0.752042440303, 0.217721159236, 0.459436173579, 1.355872344485, 0.504086599527, 0.609846305383, 0.418763308518, 1.509326253224, 0.641436011405, 0.25334079019, 0.508358924638, 0.308055737035], [0.716241444998, 0.354058109831, 0.778142664022, 1.626891056982, 0.714533703928, 0.539859124954, 0.0, 0.252718447885, 1.022507035889, 0.348072209797, 0.984311525359, 2.414501434208, 0.527007339151, 2.43534113114, 1.456141166336, 1.11702976291, 0.585407090225, 0.20155597175, 0.30124860078, 4.218953969389], [0.605899003687, 0.774894022794, 0.418555732462, 0.186848046932, 1.517359325954, 0.189296292376, 0.252718447885, 0.0, 0.406193586642, 3.890963773304, 3.364797763104, 0.283017326278, 0.388355409206, 0.236202451204, 0.232036445142, 0.35754441246, 1.17909119726, 8.311839405458, 0.34198578754, 0.674617093228], [1.295201266783, 0.285078800906, 1.032447924952, 2.802427151679, 0.266924750511, 0.752042440303, 1.022507035889, 0.406193586642, 0.0, 0.445570274261, 1.073061184332, 1.593137043457, 1.047383450722, 3.945277674515, 5.411115141489, 1.752165917819, 1.303875200799, 0.498138475304, 0.332243040634, 0.7179934869], [0.800016530518, 0.831842640142, 0.218131577594, 0.372625175087, 2.064839703237, 0.217721159236, 0.348072209797, 3.890963773304, 0.445570274261, 0.0, 6.030559379572, 0.211888159615, 0.374555687471, 0.580737093181, 0.622711669692, 0.352969184527, 0.915259857694, 2.231405688913, 0.6914746346, 0.811245856323], [1.253758266664, 0.76768882348, 0.222621897958, 0.55541539747, 1.77385516883, 0.459436173579, 0.984311525359, 3.364797763104, 1.073061184332, 6.030559379572, 0.0, 0.648441278787, 0.454123625103, 2.494896077113, 0.983692987457, 0.918723415746, 1.488548053722, 2.575850755315, 0.888101098152, 0.951682162246], [0.485391055466, 0.397358949897, 3.180100048216, 1.24048850864, 0.354861249223, 1.355872344485, 2.414501434208, 0.283017326278, 1.593137043457, 0.211888159615, 0.648441278787, 0.0, 0.494887043702, 1.839216146992, 1.297446705134, 2.904101656456, 1.898173634533, 0.312858797993, 0.191482046247, 0.538222519037], [1.173275900924, 0.356008498769, 0.730628272998, 0.926563934846, 0.233597909629, 0.504086599527, 0.527007339151, 0.388355409206, 1.047383450722, 0.374555687471, 0.454123625103, 0.494887043702, 0.0, 0.858570575674, 0.448133661718, 1.169129577716, 1.005451683149, 0.496908410676, 0.252214830027, 0.369405319355], [1.199705704602, 0.32980150463, 1.190945703396, 5.528919177928, 0.14435695975, 0.609846305383, 2.43534113114, 0.236202451204, 3.945277674515, 0.580737093181, 2.494896077113, 1.839216146992, 0.858570575674, 0.0, 3.020833610064, 1.934870924596, 1.277480294596, 0.530785790125, 0.758653808642, 0.95898974285], [0.735790389698, 0.227826574209, 0.500964408555, 1.36057419042, 0.371644693209, 0.418763308518, 1.456141166336, 0.232036445142, 5.411115141489, 0.622711669692, 0.983692987457, 1.297446705134, 0.448133661718, 3.020833610064, 0.0, 1.12278310421, 0.914665954563, 0.438388343772, 0.426382310122, 0.720517441216], [4.325092687057, 1.197188415094, 1.582754142065, 1.769893238937, 0.540027644824, 1.509326253224, 1.11702976291, 0.35754441246, 1.752165917819, 0.352969184527, 0.918723415746, 2.904101656456, 1.169129577716, 1.934870924596, 1.12278310421, 0.0, 5.15155629227, 0.561925457442, 0.387925622098, 0.796751520761], [1.729178019485, 1.119831358516, 0.934187509431, 1.071097236007, 0.488206118793, 0.641436011405, 0.585407090225, 1.17909119726, 1.303875200799, 0.915259857694, 1.488548053722, 1.898173634533, 1.005451683149, 1.277480294596, 0.914665954563, 5.15155629227, 0.0, 2.253074051176, 0.513128126891, 0.801010243199], [2.187774522005, 1.116352478606, 0.258129289418, 0.524253846338, 0.838119610178, 0.25334079019, 0.20155597175, 8.311839405458, 0.498138475304, 2.231405688913, 2.575850755315, 0.312858797993, 0.496908410676, 0.530785790125, 0.438388343772, 0.561925457442, 2.253074051176, 0.0, 0.266508731426, 1.0], [0.465839367725, 0.527664418872, 0.145345046279, 0.407635648938, 2.074324893497, 0.508358924638, 0.30124860078, 0.34198578754, 0.332243040634, 0.6914746346, 0.888101098152, 0.191482046247, 0.252214830027, 0.758653808642, 0.426382310122, 0.387925622098, 0.513128126891, 0.266508731426, 0.0, 4.054419006558], [0.718206697586, 0.470237733696, 0.261422208965, 0.596719300346, 6.747260430801, 0.308055737035, 4.218953969389, 0.674617093228, 0.7179934869, 0.811245856323, 0.951682162246, 0.538222519037, 0.369405319355, 0.95898974285, 0.720517441216, 0.796751520761, 0.801010243199, 1.0, 4.054419006558, 0.0]]


dayhoff_freqs = [0.08712691, 0.03347397, 0.04687195, 0.04952995, 0.03977196, 0.08861191, 0.03361897, 0.03688596, 0.08048092, 0.08535691, 0.01475299, 0.04043196, 0.05067995, 0.03825496, 0.04090396, 0.06957693, 0.05854194, 0.06471794, 0.01049399, 0.02991597]
dayhoff_matrix = [[0.0, 36.0, 120.0, 198.0, 18.0, 240.0, 23.0, 65.0, 26.0, 41.0, 72.0, 98.0, 250.0, 89.0, 27.0, 409.0, 371.0, 208.0, 0.0, 24.0], [36.0, 0.0, 0.0, 0.0, 0.0, 11.0, 28.0, 44.0, 0.0, 0.0, 0.0, 0.0, 19.0, 0.0, 23.0, 161.0, 16.0, 49.0, 0.0, 96.0], [120.0, 0.0, 0.0, 1153.0, 0.0, 125.0, 86.0, 24.0, 71.0, 0.0, 0.0, 905.0, 13.0, 134.0, 0.0, 95.0, 66.0, 18.0, 0.0, 0.0], [198.0, 0.0, 1153.0, 0.0, 0.0, 81.0, 43.0, 61.0, 83.0, 11.0, 30.0, 148.0, 51.0, 716.0, 1.0, 79.0, 34.0, 37.0, 0.0, 22.0], [18.0, 0.0, 0.0, 0.0, 0.0, 15.0, 48.0, 196.0, 0.0, 157.0, 92.0, 14.0, 11.0, 0.0, 14.0, 46.0, 13.0, 12.0, 76.0, 698.0], [240.0, 11.0, 125.0, 81.0, 15.0, 0.0, 10.0, 0.0, 27.0, 7.0, 17.0, 139.0, 34.0, 28.0, 9.0, 234.0, 30.0, 54.0, 0.0, 0.0], [23.0, 28.0, 86.0, 43.0, 48.0, 10.0, 0.0, 7.0, 26.0, 44.0, 0.0, 535.0, 94.0, 606.0, 240.0, 35.0, 22.0, 44.0, 27.0, 127.0], [65.0, 44.0, 24.0, 61.0, 196.0, 0.0, 7.0, 0.0, 46.0, 257.0, 336.0, 77.0, 12.0, 18.0, 64.0, 24.0, 192.0, 889.0, 0.0, 37.0], [26.0, 0.0, 71.0, 83.0, 0.0, 27.0, 26.0, 46.0, 0.0, 18.0, 243.0, 318.0, 33.0, 153.0, 464.0, 96.0, 136.0, 10.0, 0.0, 13.0], [41.0, 0.0, 0.0, 11.0, 157.0, 7.0, 44.0, 257.0, 18.0, 0.0, 527.0, 34.0, 32.0, 73.0, 15.0, 17.0, 33.0, 175.0, 46.0, 28.0], [72.0, 0.0, 0.0, 30.0, 92.0, 17.0, 0.0, 336.0, 243.0, 527.0, 0.0, 1.0, 17.0, 114.0, 90.0, 62.0, 104.0, 258.0, 0.0, 0.0], [98.0, 0.0, 905.0, 148.0, 14.0, 139.0, 535.0, 77.0, 318.0, 34.0, 1.0, 0.0, 42.0, 103.0, 32.0, 495.0, 229.0, 15.0, 23.0, 95.0], [250.0, 19.0, 13.0, 51.0, 11.0, 34.0, 94.0, 12.0, 33.0, 32.0, 17.0, 42.0, 0.0, 153.0, 103.0, 245.0, 78.0, 48.0, 0.0, 0.0], [89.0, 0.0, 134.0, 716.0, 0.0, 28.0, 606.0, 18.0, 153.0, 73.0, 114.0, 103.0, 153.0, 0.0, 246.0, 56.0, 53.0, 35.0, 0.0, 0.0], [27.0, 23.0, 0.0, 1.0, 14.0, 9.0, 240.0, 64.0, 464.0, 15.0, 90.0, 32.0, 103.0, 246.0, 0.0, 154.0, 26.0, 24.0, 201.0, 8.0], [409.0, 161.0, 95.0, 79.0, 46.0, 234.0, 35.0, 24.0, 96.0, 17.0, 62.0, 495.0, 245.0, 56.0, 154.0, 0.0, 550.0, 30.0, 75.0, 34.0], [371.0, 16.0, 66.0, 34.0, 13.0, 30.0, 22.0, 192.0, 136.0, 33.0, 104.0, 229.0, 78.0, 53.0, 26.0, 550.0, 0.0, 157.0, 0.0, 42.0], [208.0, 49.0, 18.0, 37.0, 12.0, 54.0, 44.0, 889.0, 10.0, 175.0, 258.0, 15.0, 48.0, 35.0, 24.0, 30.0, 157.0, 0.0, 0.0, 28.0], [0.0, 0.0, 0.0, 0.0, 76.0, 0.0, 27.0, 0.0, 0.0, 46.0, 0.0, 23.0, 0.0, 0.0, 201.0, 75.0, 0.0, 0.0, 0.0, 61.0], [24.0, 96.0, 0.0, 22.0, 698.0, 0.0, 127.0, 37.0, 13.0, 28.0, 0.0, 95.0, 0.0, 0.0, 8.0, 34.0, 42.0, 28.0, 61.0, 0.0]]


dayhoffdcmut_freqs = [0.08712691287308712, 0.03347396652603347, 0.046871953128046866, 0.04952995047004952, 0.03977196022803977, 0.08861191138808859, 0.033618966381033615, 0.036885963114036885, 0.08048091951908047, 0.08535691464308534, 0.014752985247014752, 0.04043195956804043, 0.050679949320050675, 0.03825496174503825, 0.0409039590960409, 0.06957693042306956, 0.05854194145805853, 0.06471793528206471, 0.010493989506010493, 0.029915970084029915]
dayhoffdcmut_matrix = [[0.0, 0.360016, 1.199805, 1.961167, 0.183641, 2.386111, 0.228116, 0.653416, 0.258635, 0.406431, 0.71784, 0.984474, 2.48592, 0.887753, 0.267828, 4.05187, 3.680365, 2.059564, 0.0, 0.244139], [0.360016, 0.0, 0.0, 0.0, 0.0, 0.107278, 0.282729, 0.438074, 0.0, 0.0, 0.0, 0.0, 0.18755, 0.0, 0.232374, 1.598356, 0.162366, 0.484678, 0.0, 0.953164], [1.199805, 0.0, 0.0, 11.388659, 0.0, 1.240981, 0.868241, 0.239248, 0.716913, 0.0, 0.0, 8.931515, 0.13394, 1.348551, 0.0, 0.956097, 0.66093, 0.178316, 0.0, 0.0], [1.961167, 0.0, 11.388659, 0.0, 0.0, 0.811907, 0.439469, 0.609526, 0.830078, 0.11288, 0.304803, 1.493409, 0.507003, 7.086022, 0.0, 0.793999, 0.340156, 0.36725, 0.0, 0.214717], [0.183641, 0.0, 0.0, 0.0, 0.0, 0.153478, 0.475927, 1.951951, 0.0, 1.56516, 0.92186, 0.138503, 0.110506, 0.0, 0.136906, 0.459901, 0.136655, 0.123606, 0.762354, 6.952629], [2.386111, 0.107278, 1.240981, 0.811907, 0.153478, 0.0, 0.106802, 0.0, 0.267683, 0.071514, 0.170372, 1.385352, 0.347153, 0.281581, 0.087791, 2.322243, 0.306662, 0.538165, 0.0, 0.0], [0.228116, 0.282729, 0.868241, 0.439469, 0.475927, 0.106802, 0.0, 0.076981, 0.270475, 0.443504, 0.0, 5.290024, 0.933709, 6.011613, 2.383148, 0.353643, 0.226333, 0.438715, 0.270564, 1.2654], [0.653416, 0.438074, 0.239248, 0.609526, 1.951951, 0.0, 0.076981, 0.0, 0.460857, 2.556685, 3.332732, 0.768024, 0.119152, 0.180393, 0.632629, 0.247955, 1.900739, 8.810038, 0.0, 0.374834], [0.258635, 0.0, 0.716913, 0.830078, 0.0, 0.267683, 0.270475, 0.460857, 0.0, 0.180629, 2.411739, 3.148371, 0.335419, 1.519078, 4.610124, 0.954557, 1.350599, 0.10385, 0.0, 0.132142], [0.406431, 0.0, 0.0, 0.11288, 1.56516, 0.071514, 0.443504, 2.556685, 0.180629, 0.0, 5.230115, 0.341113, 0.316258, 0.730772, 0.154924, 0.171432, 0.33109, 1.745156, 0.461776, 0.286572], [0.71784, 0.0, 0.0, 0.304803, 0.92186, 0.170372, 0.0, 3.332732, 2.411739, 5.230115, 0.0, 0.0, 0.170205, 1.127499, 0.896321, 0.619951, 1.031534, 2.565955, 0.0, 0.0], [0.984474, 0.0, 8.931515, 1.493409, 0.138503, 1.385352, 5.290024, 0.768024, 3.148371, 0.341113, 0.0, 0.0, 0.419244, 1.028509, 0.327059, 4.885892, 2.271697, 0.158067, 0.224968, 0.94694], [2.48592, 0.18755, 0.13394, 0.507003, 0.110506, 0.347153, 0.933709, 0.119152, 0.335419, 0.316258, 0.170205, 0.419244, 0.0, 1.526188, 1.028313, 2.427202, 0.782857, 0.485026, 0.0, 0.0], [0.887753, 0.0, 1.348551, 7.086022, 0.0, 0.281581, 6.011613, 0.180393, 1.519078, 0.730772, 1.127499, 1.028509, 1.526188, 0.0, 2.439939, 0.561828, 0.525651, 0.346983, 0.0, 0.0], [0.267828, 0.232374, 0.0, 0.0, 0.136906, 0.087791, 2.383148, 0.632629, 4.610124, 0.154924, 0.896321, 0.327059, 1.028313, 2.439939, 0.0, 1.53159, 0.265745, 0.240368, 2.001375, 0.078012], [4.05187, 1.598356, 0.956097, 0.793999, 0.459901, 2.322243, 0.353643, 0.247955, 0.954557, 0.171432, 0.619951, 4.885892, 2.427202, 0.561828, 1.53159, 0.0, 5.436674, 0.303836, 0.740819, 0.336289], [3.680365, 0.162366, 0.66093, 0.340156, 0.136655, 0.306662, 0.226333, 1.900739, 1.350599, 0.33109, 1.031534, 2.271697, 0.782857, 0.525651, 0.265745, 5.436674, 0.0, 1.561997, 0.0, 0.417839], [2.059564, 0.484678, 0.178316, 0.36725, 0.123606, 0.538165, 0.438715, 8.810038, 0.10385, 1.745156, 2.565955, 0.158067, 0.485026, 0.346983, 0.240368, 0.303836, 1.561997, 0.0, 0.0, 0.279379], [0.0, 0.0, 0.0, 0.0, 0.762354, 0.0, 0.270564, 0.0, 0.0, 0.461776, 0.0, 0.224968, 0.0, 0.0, 2.001375, 0.740819, 0.0, 0.0, 0.0, 0.60807], [0.244139, 0.953164, 0.0, 0.214717, 6.952629, 0.0, 1.2654, 0.374834, 0.132142, 0.286572, 0.0, 0.94694, 0.0, 0.0, 0.078012, 0.336289, 0.417839, 0.279379, 0.60807, 0.0]]


flu_freqs = [0.04707195, 0.02502197, 0.04785995, 0.05458695, 0.03049597, 0.07637292, 0.01996398, 0.06713393, 0.05678494, 0.07149793, 0.01815098, 0.07421393, 0.05065595, 0.03330397, 0.05090995, 0.08840891, 0.07433893, 0.06322894, 0.01852398, 0.03147397]
flu_matrix = [[0.0, 0.026447095, 0.584852306, 1.484234503, 0.080490909, 1.132313122, 0.214757862, 0.149926734, 0.47433361, 0.023116952, 0.058745423, 0.053366579, 0.659311478, 0.353753982, 0.138658765, 3.011344519, 5.418298175, 3.53200527, 0.196, 0.018289288], [0.026447095, 0.0, 0.0141, 0.0, 0.104053666, 0.116941459, 0.0218, 0.001112158, 3.83e-06, 0.005613627, 0.11145731, 1.3e-05, 0.0, 0.002547334, 0.167207008, 0.336263345, 0.011975266, 0.054904564, 0.09410668, 0.601692431], [0.584852306, 0.0141, 0.0, 5.370511279, 1.06e-06, 1.934832784, 0.887570549, 0.014085917, 0.29004298, 0.005730682, 0.041762964, 7.737392871, 0.188539456, 0.145469388, 0.006771843, 0.338372183, 0.135481233, 0.297123975, 1.49e-05, 0.525398543], [1.484234503, 0.0, 5.370511279, 0.0, 0.001003501, 1.593098825, 0.256491863, 0.0142, 3.881488809, 0.016499536, 0.313974351, 0.061652192, 0.319558828, 1.195629122, 0.124897617, 0.307140298, 0.280124895, 0.285047948, 0.155245492, 0.10409287], [0.080490909, 0.104053666, 1.06e-06, 0.001003501, 0.0, 0.001236645, 0.119028506, 1.463357278, 0.32, 2.986800036, 0.279910509, 0.000836, 0.00713243, 0.032680657, 0.0161, 0.99668567, 0.000134906, 0.592587985, 0.814753094, 5.393924245], [1.132313122, 0.116941459, 1.934832784, 1.593098825, 0.001236645, 0.0, 0.058774527, 1.63e-05, 0.264148929, 0.006516229, 0.001500467, 0.322524648, 0.038631761, 0.108051341, 1.190624465, 1.585646577, 0.01880803, 0.337229619, 0.196486447, 0.074814997], [0.214757862, 0.0218, 0.887570549, 0.256491863, 0.119028506, 0.058774527, 0.0, 0.243190142, 0.347302791, 0.321611694, 0.001273509, 1.387096032, 0.924466914, 5.330313412, 1.879569938, 0.58070425, 0.368713573, 0.098631355, 0.0224, 6.448954446], [0.149926734, 0.001112158, 0.014085917, 0.0142, 1.463357278, 1.63e-05, 0.243190142, 0.0, 0.227707997, 3.512072282, 9.017954203, 0.218571975, 0.080543327, 0.02883995, 0.246117172, 0.290381075, 2.904052286, 14.39405219, 0.03213215, 0.273934263], [0.47433361, 3.83e-06, 0.29004298, 3.881488809, 0.32, 0.264148929, 0.347302791, 0.227707997, 0.0, 0.129223639, 1.331291619, 2.646847965, 0.195750632, 2.559587177, 15.30009662, 0.283807672, 1.5269642, 0.07312793, 4.98e-05, 0.012416222], [0.023116952, 0.005613627, 0.005730682, 0.016499536, 2.986800036, 0.006516229, 0.321611694, 3.512072282, 0.129223639, 0.0, 6.746936485, 0.000836, 0.634308521, 1.020366955, 0.296045557, 0.570766693, 0.044926357, 0.890598579, 0.431277663, 0.340058468], [0.058745423, 0.11145731, 0.041762964, 0.313974351, 0.279910509, 0.001500467, 0.001273509, 9.017954203, 1.331291619, 6.746936485, 0.0, 0.005251688, 0.0569, 0.190259181, 0.890162346, 0.007026588, 2.031511321, 4.904842235, 0.070460039, 0.874272175], [0.053366579, 1.3e-05, 7.737392871, 0.061652192, 0.000836, 0.322524648, 1.387096032, 0.218571975, 2.646847965, 0.000836, 0.005251688, 0.0, 0.0364, 0.530642655, 0.161000889, 3.881310531, 2.140332316, 0.010257517, 0.000536, 0.373101927], [0.659311478, 0.0, 0.188539456, 0.319558828, 0.00713243, 0.038631761, 0.924466914, 0.080543327, 0.195750632, 0.634308521, 0.0569, 0.0364, 0.0, 0.712769599, 0.15402718, 2.087385344, 0.542251094, 0.058971975, 0.000431021, 0.000182], [0.353753982, 0.002547334, 0.145469388, 1.195629122, 0.032680657, 0.108051341, 5.330313412, 0.02883995, 2.559587177, 1.020366955, 0.190259181, 0.530642655, 0.712769599, 0.0, 3.292716942, 0.487822499, 0.602340963, 0.406697814, 0.044, 0.072205935], [0.138658765, 0.167207008, 0.006771843, 0.124897617, 0.0161, 1.190624465, 1.879569938, 0.246117172, 15.30009662, 0.296045557, 0.890162346, 0.161000889, 0.15402718, 3.292716942, 0.0, 0.95013841, 0.183076905, 0.103964386, 1.369429408, 0.099855497], [3.011344519, 0.336263345, 0.338372183, 0.307140298, 0.99668567, 1.585646577, 0.58070425, 0.290381075, 0.283807672, 0.570766693, 0.007026588, 3.881310531, 2.087385344, 0.487822499, 0.95013841, 0.0, 2.206859934, 0.088256423, 0.099835753, 0.39255224], [5.418298175, 0.011975266, 0.135481233, 0.280124895, 0.000134906, 0.01880803, 0.368713573, 2.904052286, 1.5269642, 0.044926357, 2.031511321, 2.140332316, 0.542251094, 0.602340963, 0.183076905, 2.206859934, 0.0, 0.654109108, 0.207066206, 0.12489802], [3.53200527, 0.054904564, 0.297123975, 0.285047948, 0.592587985, 0.337229619, 0.098631355, 14.39405219, 0.07312793, 0.890598579, 4.904842235, 0.010257517, 0.058971975, 0.406697814, 0.103964386, 0.088256423, 0.654109108, 0.0, 0.256900461, 0.167581647], [0.196, 0.09410668, 1.49e-05, 0.155245492, 0.814753094, 0.196486447, 0.0224, 0.03213215, 4.98e-05, 0.431277663, 0.070460039, 0.000536, 0.000431021, 0.044, 1.369429408, 0.099835753, 0.207066206, 0.256900461, 0.0, 0.42775543], [0.018289288, 0.601692431, 0.525398543, 0.10409287, 5.393924245, 0.074814997, 6.448954446, 0.273934263, 0.012416222, 0.340058468, 0.874272175, 0.373101927, 0.000182, 0.072205935, 0.099855497, 0.39255224, 0.12489802, 0.167581647, 0.42775543, 0.0]]


hivb_freqs = [0.060490222, 0.020075899, 0.042109048, 0.071567447, 0.028809447, 0.072308239, 0.022293943, 0.069730629, 0.056968211, 0.098851122, 0.019768318, 0.044127815, 0.046025282, 0.053606488, 0.066039665, 0.05060433, 0.053636813, 0.061625237, 0.033011601, 0.028350243]
hivb_matrix = [[0.0, 0.123758, 1.45504, 1.48135, 0.0141269, 2.13536, 0.0847613, 0.005, 0.005, 0.215256, 0.0186643, 0.005, 2.12217, 0.0551128, 0.307507, 2.46633, 15.9183, 7.61428, 0.005, 0.005], [0.123758, 0.0, 0.005, 0.005, 9.29815, 0.897871, 0.240073, 0.005, 0.005, 0.129777, 0.005, 0.0860642, 0.005, 0.005, 0.351721, 4.69314, 0.739969, 0.420027, 2.63277, 7.57932], [1.45504, 0.005, 0.0, 10.5872, 0.005, 2.83806, 1.9169, 0.0176792, 0.005, 0.00876048, 0.005, 17.6612, 0.0342658, 0.005, 0.005, 0.52823, 0.274724, 1.04793, 0.005, 0.674653], [1.48135, 0.005, 10.5872, 0.0, 0.005, 3.92775, 0.11974, 0.00609079, 4.61482, 0.005, 0.175789, 0.0792633, 0.0120226, 2.5602, 0.0749218, 0.005, 0.289774, 1.02847, 0.005, 0.0792633], [0.0141269, 9.29815, 0.005, 0.005, 0.0, 0.291561, 0.145558, 3.39836, 0.0342658, 8.52484, 0.188025, 0.005, 0.005, 0.005, 0.005, 0.956472, 0.0141269, 0.723274, 0.829343, 15.34], [2.13536, 0.897871, 2.83806, 3.92775, 0.291561, 0.0, 0.005, 0.005, 0.521705, 0.005, 0.005, 0.323401, 0.005, 0.0619137, 3.65345, 4.38041, 0.369615, 0.953155, 1.21674, 0.005], [0.0847613, 0.240073, 1.9169, 0.11974, 0.145558, 0.005, 0.0, 0.103111, 0.005, 1.74171, 0.005, 7.64585, 2.45318, 7.05545, 9.04044, 0.382747, 0.711594, 0.005, 0.0695179, 18.6943], [0.005, 0.005, 0.0176792, 0.00609079, 3.39836, 0.005, 0.103111, 0.0, 0.322319, 5.95879, 11.2065, 0.680565, 0.0410593, 0.005, 0.677289, 1.21803, 8.61217, 17.7389, 0.005, 0.148168], [0.005, 0.005, 0.005, 4.61482, 0.0342658, 0.521705, 0.005, 0.322319, 0.0, 0.0814995, 1.28246, 7.90443, 0.0313862, 6.54737, 20.45, 0.504111, 4.67142, 0.265829, 0.005, 0.005], [0.215256, 0.129777, 0.00876048, 0.005, 8.52484, 0.005, 1.74171, 5.95879, 0.0814995, 0.0, 5.31961, 0.005, 2.07757, 1.49456, 0.701427, 0.927656, 0.0437673, 1.41036, 0.748843, 0.111986], [0.0186643, 0.005, 0.005, 0.175789, 0.188025, 0.005, 0.005, 11.2065, 1.28246, 5.31961, 0.0, 0.005, 0.005, 0.303676, 2.51394, 0.005, 4.94026, 6.8532, 0.089078, 0.005], [0.005, 0.0860642, 17.6612, 0.0792633, 0.005, 0.323401, 7.64585, 0.680565, 7.90443, 0.005, 0.005, 0.0, 0.00739578, 0.672052, 0.295543, 13.1447, 6.88667, 0.026656, 0.005, 1.76417], [2.12217, 0.005, 0.0342658, 0.0120226, 0.005, 0.005, 2.45318, 0.0410593, 0.0313862, 2.07757, 0.005, 0.00739578, 0.0, 4.47211, 1.28355, 5.37762, 2.01417, 0.005, 0.0444506, 0.0304381], [0.0551128, 0.005, 0.005, 2.5602, 0.005, 0.0619137, 7.05545, 0.005, 6.54737, 1.49456, 0.303676, 0.672052, 4.47211, 0.0, 3.4215, 0.116311, 0.243589, 0.0209153, 0.026656, 0.113033], [0.307507, 0.351721, 0.005, 0.0749218, 0.005, 3.65345, 9.04044, 0.677289, 20.45, 0.701427, 2.51394, 0.295543, 1.28355, 3.4215, 0.0, 3.4791, 2.86868, 0.0812454, 0.991338, 0.00991826], [2.46633, 4.69314, 0.52823, 0.005, 0.956472, 4.38041, 0.382747, 1.21803, 0.504111, 0.927656, 0.005, 13.1447, 5.37762, 0.116311, 3.4791, 0.0, 8.93107, 0.0749218, 0.0248728, 0.648024], [15.9183, 0.739969, 0.274724, 0.289774, 0.0141269, 0.369615, 0.711594, 8.61217, 4.67142, 0.0437673, 4.94026, 6.88667, 2.01417, 0.243589, 2.86868, 8.93107, 0.0, 0.709226, 0.005, 0.105652], [7.61428, 0.420027, 1.04793, 1.02847, 0.723274, 0.953155, 0.005, 17.7389, 0.265829, 1.41036, 6.8532, 0.026656, 0.005, 0.0209153, 0.0812454, 0.0749218, 0.709226, 0.0, 0.005, 0.0410593], [0.005, 2.63277, 0.005, 0.005, 0.829343, 1.21674, 0.0695179, 0.005, 0.005, 0.748843, 0.089078, 0.005, 0.0444506, 0.026656, 0.991338, 0.0248728, 0.005, 0.005, 0.0, 1.28022], [0.005, 7.57932, 0.674653, 0.0792633, 15.34, 0.005, 18.6943, 0.148168, 0.005, 0.111986, 0.005, 1.76417, 0.0304381, 0.113033, 0.00991826, 0.648024, 0.105652, 0.0410593, 1.28022, 0.0]]


hivw_freqs = [0.0377494, 0.0240105, 0.0342034, 0.0618606, 0.0422741, 0.0838496, 0.0156076, 0.0983641, 0.0641682, 0.0577867, 0.0158419, 0.0891129, 0.0458601, 0.0437824, 0.057321, 0.0550846, 0.0813774, 0.0515638, 0.019597, 0.0205847]
hivw_matrix = [[0.0, 0.167653, 4.43521, 5.56325, 0.597923, 1.8685, 0.005, 0.005, 0.592784, 0.16024, 0.005, 0.617509, 1.00981, 0.005, 0.0744808, 8.5942, 24.1422, 24.8094, 0.005, 0.005], [0.167653, 0.0, 0.005, 0.005, 0.362959, 0.0489798, 0.005, 0.005, 0.005, 0.005, 0.005, 0.0604932, 0.005, 0.005, 2.86364, 1.12195, 0.005, 0.005, 5.49894, 8.34835], [4.43521, 0.005, 0.0, 12.1233, 0.005, 10.3969, 2.31779, 0.145124, 0.894313, 0.005, 0.005, 29.4087, 0.005, 0.005, 0.0674539, 0.427881, 0.630395, 2.91786, 0.005, 2.28154], [5.56325, 0.005, 12.1233, 0.0, 0.005, 14.7801, 0.005, 0.0390512, 23.9626, 0.129839, 0.005, 0.201526, 0.005, 3.20656, 0.0251632, 0.005, 0.458743, 2.19952, 0.005, 0.005], [0.597923, 0.362959, 0.005, 0.005, 0.0, 0.005, 0.005, 1.48288, 0.005, 7.48781, 0.005, 0.005, 0.0342252, 0.005, 0.005, 4.27939, 0.114512, 2.28, 0.005, 4.12728], [1.8685, 0.0489798, 10.3969, 14.7801, 0.005, 0.0, 0.005, 0.005, 0.279425, 0.0489798, 0.0489798, 0.0604932, 0.005, 0.0604932, 13.4379, 6.27966, 0.0489798, 2.79622, 2.8258, 0.005], [0.005, 0.005, 2.31779, 0.005, 0.005, 0.005, 0.0, 0.005, 0.22406, 1.76382, 0.005, 8.59876, 13.9444, 18.5465, 6.84405, 0.725157, 0.95956, 0.827479, 0.005, 47.4889], [0.005, 0.005, 0.145124, 0.0390512, 1.48288, 0.005, 0.005, 0.0, 0.817481, 9.10246, 17.3064, 0.987028, 0.005, 0.0342252, 1.34069, 0.740091, 9.36345, 24.8231, 0.005, 0.114512], [0.592784, 0.005, 0.894313, 23.9626, 0.005, 0.279425, 0.22406, 0.817481, 0.0, 0.005, 4.09564, 10.6655, 0.111928, 13.0705, 39.8897, 0.005, 4.04802, 0.128065, 0.005, 0.005], [0.16024, 0.005, 0.005, 0.129839, 7.48781, 0.0489798, 1.76382, 9.10246, 0.005, 0.0, 11.3839, 0.005, 9.83095, 2.89048, 0.586757, 6.14396, 0.005, 2.95344, 1.37031, 0.005], [0.005, 0.005, 0.005, 0.005, 0.005, 0.0489798, 0.005, 17.3064, 4.09564, 11.3839, 0.0, 0.201526, 0.005, 0.005, 3.28652, 0.392575, 7.41313, 14.7683, 0.005, 0.579198], [0.617509, 0.0604932, 29.4087, 0.201526, 0.005, 0.0604932, 8.59876, 0.987028, 10.6655, 0.005, 0.201526, 0.0, 0.344848, 0.342068, 0.16024, 14.5699, 4.54206, 0.0744808, 0.005, 5.06475], [1.00981, 0.005, 0.005, 0.005, 0.0342252, 0.005, 13.9444, 0.005, 0.111928, 9.83095, 0.005, 0.344848, 0.0, 3.04502, 0.404723, 14.249, 4.33701, 0.005, 0.005, 0.005], [0.005, 0.005, 0.005, 3.20656, 0.005, 0.0604932, 18.5465, 0.0342252, 13.0705, 2.89048, 0.005, 0.342068, 3.04502, 0.0, 10.6746, 0.16024, 0.203091, 0.005, 0.0443298, 0.005], [0.0744808, 2.86364, 0.0674539, 0.0251632, 0.005, 13.4379, 6.84405, 1.34069, 39.8897, 0.586757, 3.28652, 0.16024, 0.404723, 10.6746, 0.0, 8.35024, 0.928203, 0.279425, 5.96564, 0.005], [8.5942, 1.12195, 0.427881, 0.005, 4.27939, 6.27966, 0.725157, 0.740091, 0.005, 6.14396, 0.392575, 14.5699, 14.249, 0.16024, 8.35024, 0.0, 6.34079, 0.862637, 1.10156, 0.933142], [24.1422, 0.005, 0.630395, 0.458743, 0.114512, 0.0489798, 0.95956, 9.36345, 4.04802, 0.005, 7.41313, 4.54206, 4.33701, 0.203091, 0.928203, 6.34079, 0.0, 0.005, 0.005, 0.490608], [24.8094, 0.005, 2.91786, 2.19952, 2.28, 2.79622, 0.827479, 24.8231, 0.128065, 2.95344, 14.7683, 0.0744808, 0.005, 0.005, 0.279425, 0.862637, 0.005, 0.0, 0.005, 1.35482], [0.005, 5.49894, 0.005, 0.005, 0.005, 2.8258, 0.005, 0.005, 0.005, 1.37031, 0.005, 0.005, 0.005, 0.0443298, 5.96564, 1.10156, 0.005, 0.005, 0.0, 0.005], [0.005, 8.34835, 2.28154, 0.005, 4.12728, 0.005, 47.4889, 0.114512, 0.005, 0.005, 0.579198, 5.06475, 0.005, 0.005, 0.005, 0.933142, 0.490608, 1.35482, 0.005, 0.0]]


jtt_freqs = [0.07674791846504161, 0.019802979603940406, 0.05154394896912101, 0.06182993876340122, 0.04012595919748081, 0.07315192853696142, 0.022943979541120405, 0.05376094892478102, 0.05867593882648122, 0.09190390816192183, 0.02382597952348041, 0.042644959147100814, 0.05090094898198102, 0.04075195918496081, 0.05169094896618102, 0.06876492862470142, 0.05856493882870122, 0.06600492867990142, 0.014260989714780204, 0.032101969357960614]
jtt_matrix = [[0.0, 56.0, 81.0, 105.0, 15.0, 179.0, 27.0, 36.0, 35.0, 30.0, 54.0, 54.0, 194.0, 57.0, 58.0, 378.0, 475.0, 298.0, 9.0, 11.0], [56.0, 0.0, 10.0, 5.0, 78.0, 59.0, 69.0, 17.0, 7.0, 23.0, 31.0, 34.0, 14.0, 9.0, 113.0, 223.0, 42.0, 62.0, 115.0, 209.0], [81.0, 10.0, 0.0, 767.0, 4.0, 130.0, 112.0, 11.0, 26.0, 7.0, 15.0, 528.0, 15.0, 49.0, 16.0, 59.0, 38.0, 31.0, 4.0, 46.0], [105.0, 5.0, 767.0, 0.0, 5.0, 119.0, 26.0, 12.0, 181.0, 9.0, 18.0, 58.0, 18.0, 323.0, 29.0, 30.0, 32.0, 45.0, 10.0, 7.0], [15.0, 78.0, 4.0, 5.0, 0.0, 5.0, 40.0, 89.0, 4.0, 248.0, 43.0, 10.0, 17.0, 4.0, 5.0, 92.0, 12.0, 62.0, 53.0, 536.0], [179.0, 59.0, 130.0, 119.0, 5.0, 0.0, 23.0, 6.0, 27.0, 6.0, 14.0, 81.0, 24.0, 26.0, 137.0, 201.0, 33.0, 47.0, 55.0, 8.0], [27.0, 69.0, 112.0, 26.0, 40.0, 23.0, 0.0, 16.0, 45.0, 56.0, 33.0, 391.0, 115.0, 597.0, 328.0, 73.0, 46.0, 11.0, 8.0, 573.0], [36.0, 17.0, 11.0, 12.0, 89.0, 6.0, 16.0, 0.0, 21.0, 229.0, 479.0, 47.0, 10.0, 9.0, 22.0, 40.0, 245.0, 961.0, 9.0, 32.0], [35.0, 7.0, 26.0, 181.0, 4.0, 27.0, 45.0, 21.0, 0.0, 14.0, 65.0, 263.0, 21.0, 292.0, 646.0, 47.0, 103.0, 14.0, 10.0, 8.0], [30.0, 23.0, 7.0, 9.0, 248.0, 6.0, 56.0, 229.0, 14.0, 0.0, 388.0, 12.0, 102.0, 72.0, 38.0, 59.0, 25.0, 180.0, 52.0, 24.0], [54.0, 31.0, 15.0, 18.0, 43.0, 14.0, 33.0, 479.0, 65.0, 388.0, 0.0, 30.0, 16.0, 43.0, 44.0, 29.0, 226.0, 323.0, 24.0, 18.0], [54.0, 34.0, 528.0, 58.0, 10.0, 81.0, 391.0, 47.0, 263.0, 12.0, 30.0, 0.0, 15.0, 86.0, 45.0, 503.0, 232.0, 16.0, 8.0, 70.0], [194.0, 14.0, 15.0, 18.0, 17.0, 24.0, 115.0, 10.0, 21.0, 102.0, 16.0, 15.0, 0.0, 164.0, 74.0, 285.0, 118.0, 23.0, 6.0, 10.0], [57.0, 9.0, 49.0, 323.0, 4.0, 26.0, 597.0, 9.0, 292.0, 72.0, 43.0, 86.0, 164.0, 0.0, 310.0, 53.0, 51.0, 20.0, 18.0, 24.0], [58.0, 113.0, 16.0, 29.0, 5.0, 137.0, 328.0, 22.0, 646.0, 38.0, 44.0, 45.0, 74.0, 310.0, 0.0, 101.0, 64.0, 17.0, 126.0, 20.0], [378.0, 223.0, 59.0, 30.0, 92.0, 201.0, 73.0, 40.0, 47.0, 59.0, 29.0, 503.0, 285.0, 53.0, 101.0, 0.0, 477.0, 38.0, 35.0, 63.0], [475.0, 42.0, 38.0, 32.0, 12.0, 33.0, 46.0, 245.0, 103.0, 25.0, 226.0, 232.0, 118.0, 51.0, 64.0, 477.0, 0.0, 112.0, 12.0, 21.0], [298.0, 62.0, 31.0, 45.0, 62.0, 47.0, 11.0, 961.0, 14.0, 180.0, 323.0, 16.0, 23.0, 20.0, 17.0, 38.0, 112.0, 0.0, 25.0, 16.0], [9.0, 115.0, 4.0, 10.0, 53.0, 55.0, 8.0, 9.0, 10.0, 52.0, 24.0, 8.0, 6.0, 18.0, 126.0, 35.0, 12.0, 25.0, 0.0, 71.0], [11.0, 209.0, 46.0, 7.0, 536.0, 8.0, 573.0, 32.0, 8.0, 24.0, 18.0, 70.0, 10.0, 24.0, 20.0, 63.0, 21.0, 16.0, 71.0, 0.0]]


jttdcmut_freqs = [0.07686192313807685, 0.020278979721020274, 0.05126894873105126, 0.06181993818006181, 0.04052995947004052, 0.0747139252860747, 0.02298297701702298, 0.05256894743105256, 0.05949794050205949, 0.0911109088890911, 0.02341397658602341, 0.04254595745404254, 0.05053194946805053, 0.041060958939041055, 0.051056948943051045, 0.0682249317750682, 0.05851794148205851, 0.06637393362606636, 0.014335985664014334, 0.032302967697032295]
jttdcmut_matrix = [[0.0, 0.574478, 0.827445, 1.066681, 0.138293, 1.740159, 0.21997, 0.361684, 0.369437, 0.310007, 0.469395, 0.557967, 1.959599, 0.556725, 0.531678, 3.887095, 4.582565, 2.924161, 0.084329, 0.139492], [0.574478, 0.0, 0.105625, 0.053907, 0.678335, 0.546389, 0.724998, 0.150559, 0.049009, 0.164593, 0.409202, 0.313311, 0.123653, 0.091304, 1.019843, 2.155331, 0.469823, 0.621323, 1.104181, 2.114852], [0.827445, 0.105625, 0.0, 7.766557, 0.032522, 1.272434, 1.032342, 0.115968, 0.282466, 0.061486, 0.190001, 5.54953, 0.127164, 0.521646, 0.154899, 0.589268, 0.425159, 0.315261, 0.057466, 0.453952], [1.066681, 0.053907, 7.766557, 0.0, 0.043829, 1.115632, 0.243768, 0.111773, 1.731684, 0.097485, 0.175084, 0.578115, 0.191994, 3.417706, 0.318483, 0.312449, 0.331584, 0.465271, 0.114381, 0.063452], [0.138293, 0.678335, 0.032522, 0.043829, 0.0, 0.050212, 0.453428, 0.77709, 0.024521, 2.500294, 0.436181, 0.073481, 0.148483, 0.045683, 0.065314, 0.943971, 0.138904, 0.593478, 0.537922, 5.484236], [1.740159, 0.546389, 1.272434, 1.115632, 0.050212, 0.0, 0.201696, 0.053769, 0.26984, 0.069492, 0.130379, 0.773313, 0.208081, 0.231294, 1.359652, 1.874296, 0.316862, 0.47014, 0.54418, 0.0525], [0.21997, 0.724998, 1.032342, 0.243768, 0.453428, 0.201696, 0.0, 0.181788, 0.525096, 0.540571, 0.32966, 4.025778, 1.141961, 5.68408, 3.210671, 0.743458, 0.477355, 0.121827, 0.128193, 5.8484], [0.361684, 0.150559, 0.115968, 0.111773, 0.77709, 0.053769, 0.181788, 0.0, 0.202562, 2.335139, 4.831666, 0.491003, 0.09858, 0.07827, 0.239195, 0.405119, 2.553806, 9.533943, 0.13451, 0.303445], [0.369437, 0.049009, 0.282466, 1.731684, 0.024521, 0.26984, 0.525096, 0.202562, 0.0, 0.146481, 0.624581, 2.529517, 0.216345, 2.966732, 6.529255, 0.474478, 0.965641, 0.124066, 0.089134, 0.087904], [0.310007, 0.164593, 0.061486, 0.097485, 2.500294, 0.069492, 0.540571, 2.335139, 0.146481, 0.0, 3.856906, 0.137289, 1.060504, 0.709004, 0.372261, 0.592511, 0.272514, 1.761439, 0.530324, 0.241094], [0.469395, 0.409202, 0.190001, 0.175084, 0.436181, 0.130379, 0.32966, 4.831666, 0.624581, 3.856906, 0.0, 0.33072, 0.164215, 0.456901, 0.431045, 0.285564, 2.114728, 3.038533, 0.201334, 0.18987], [0.557967, 0.313311, 5.54953, 0.578115, 0.073481, 0.773313, 4.025778, 0.491003, 2.529517, 0.137289, 0.33072, 0.0, 0.121804, 0.768834, 0.451095, 5.057964, 2.351311, 0.164525, 0.0277, 0.700693], [1.959599, 0.123653, 0.127164, 0.191994, 0.148483, 0.208081, 1.141961, 0.09858, 0.216345, 1.060504, 0.164215, 0.121804, 0.0, 1.608126, 0.710489, 2.788406, 1.176961, 0.211561, 0.069965, 0.11385], [0.556725, 0.091304, 0.521646, 3.417706, 0.045683, 0.231294, 5.68408, 0.07827, 2.966732, 0.709004, 0.456901, 0.768834, 1.608126, 0.0, 3.021995, 0.548807, 0.523825, 0.179771, 0.172206, 0.254745], [0.531678, 1.019843, 0.154899, 0.318483, 0.065314, 1.359652, 3.210671, 0.239195, 6.529255, 0.372261, 0.431045, 0.451095, 0.710489, 3.021995, 0.0, 1.001551, 0.650282, 0.171995, 1.257961, 0.235601], [3.887095, 2.155331, 0.589268, 0.312449, 0.943971, 1.874296, 0.743458, 0.405119, 0.474478, 0.592511, 0.285564, 5.057964, 2.788406, 0.548807, 1.001551, 0.0, 4.777647, 0.408532, 0.310927, 0.628608], [4.582565, 0.469823, 0.425159, 0.331584, 0.138904, 0.316862, 0.477355, 2.553806, 0.965641, 0.272514, 2.114728, 2.351311, 1.176961, 0.523825, 0.650282, 4.777647, 0.0, 1.14398, 0.080556, 0.201094], [2.924161, 0.621323, 0.315261, 0.465271, 0.593478, 0.47014, 0.121827, 9.533943, 0.124066, 1.761439, 3.038533, 0.164525, 0.211561, 0.179771, 0.171995, 0.408532, 1.14398, 0.0, 0.239697, 0.165473], [0.084329, 1.104181, 0.057466, 0.114381, 0.537922, 0.54418, 0.128193, 0.13451, 0.089134, 0.530324, 0.201334, 0.0277, 0.069965, 0.172206, 1.257961, 0.310927, 0.080556, 0.239697, 0.0, 0.747889], [0.139492, 2.114852, 0.453952, 0.063452, 5.484236, 0.0525, 5.8484, 0.303445, 0.087904, 0.241094, 0.18987, 0.700693, 0.11385, 0.254745, 0.235601, 0.628608, 0.201094, 0.165473, 0.747889, 0.0]]


lg_freqs = [0.07906592093407908, 0.012936987063012939, 0.053051946948053055, 0.07158592841407159, 0.042301957698042306, 0.05733694266305734, 0.022354977645022357, 0.06215693784306216, 0.0645999354000646, 0.09908090091909909, 0.022950977049022953, 0.04197695802304198, 0.04403995596004404, 0.040766959233040766, 0.05594094405905594, 0.0611969388030612, 0.05328694671305329, 0.06914693085306915, 0.012065987934012068, 0.034154965845034156]
lg_matrix = [[0.0, 2.489084, 0.395144, 1.038545, 0.253701, 2.06604, 0.358858, 0.14983, 0.536518, 0.395337, 1.124035, 0.276818, 1.177651, 0.969894, 0.425093, 4.727182, 2.139501, 2.54787, 0.180717, 0.218959], [2.489084, 0.0, 0.062556, 0.003499, 1.105251, 0.569265, 0.640543, 0.320627, 0.013266, 0.594007, 0.89368, 0.528768, 0.075382, 0.084808, 0.534551, 2.784478, 1.14348, 1.959291, 0.670128, 1.165532], [0.395144, 0.062556, 0.0, 5.24387, 0.017416, 0.844926, 0.927114, 0.01069, 0.282959, 0.015076, 0.025548, 5.076149, 0.394456, 0.523386, 0.123954, 1.240275, 0.42586, 0.037967, 0.02989, 0.135107], [1.038545, 0.003499, 5.24387, 0.0, 0.018811, 0.348847, 0.423881, 0.044265, 1.807177, 0.069673, 0.173735, 0.541712, 0.419409, 4.128591, 0.36397, 0.611973, 0.604545, 0.245034, 0.077852, 0.120037], [0.253701, 1.105251, 0.017416, 0.018811, 0.0, 0.089586, 0.682139, 1.112727, 0.023918, 2.592692, 1.798853, 0.089525, 0.094464, 0.035855, 0.052722, 0.361819, 0.165001, 0.654683, 2.457121, 7.803902], [2.06604, 0.569265, 0.844926, 0.348847, 0.089586, 0.0, 0.311484, 0.008705, 0.296636, 0.044261, 0.139538, 1.437645, 0.196961, 0.267959, 0.390192, 1.73999, 0.129836, 0.076701, 0.268491, 0.054679], [0.358858, 0.640543, 0.927114, 0.423881, 0.682139, 0.311484, 0.0, 0.108882, 0.697264, 0.366317, 0.442472, 4.509238, 0.508851, 4.813505, 2.426601, 0.990012, 0.584262, 0.119013, 0.597054, 5.306834], [0.14983, 0.320627, 0.01069, 0.044265, 1.112727, 0.008705, 0.108882, 0.0, 0.159069, 4.145067, 4.273607, 0.191503, 0.078281, 0.072854, 0.126991, 0.064105, 1.033739, 10.649107, 0.11166, 0.232523], [0.536518, 0.013266, 0.282959, 1.807177, 0.023918, 0.296636, 0.697264, 0.159069, 0.0, 0.1375, 0.656604, 2.145078, 0.390322, 3.234294, 6.326067, 0.748683, 1.136863, 0.185202, 0.049906, 0.131932], [0.395337, 0.594007, 0.015076, 0.069673, 2.592692, 0.044261, 0.366317, 4.145067, 0.1375, 0.0, 6.312358, 0.068427, 0.24906, 0.582457, 0.301848, 0.182287, 0.302936, 1.702745, 0.619632, 0.299648], [1.124035, 0.89368, 0.025548, 0.173735, 1.798853, 0.139538, 0.442472, 4.273607, 0.656604, 6.312358, 0.0, 0.371004, 0.099849, 1.672569, 0.484133, 0.34696, 2.020366, 1.898718, 0.696175, 0.481306], [0.276818, 0.528768, 5.076149, 0.541712, 0.089525, 1.437645, 4.509238, 0.191503, 2.145078, 0.068427, 0.371004, 0.0, 0.161787, 1.695752, 0.751878, 4.008358, 2.000679, 0.083688, 0.045376, 0.612025], [1.177651, 0.075382, 0.394456, 0.419409, 0.094464, 0.196961, 0.508851, 0.078281, 0.390322, 0.24906, 0.099849, 0.161787, 0.0, 0.624294, 0.332533, 1.338132, 0.571468, 0.296501, 0.095131, 0.089613], [0.969894, 0.084808, 0.523386, 4.128591, 0.035855, 0.267959, 4.813505, 0.072854, 3.234294, 0.582457, 1.672569, 1.695752, 0.624294, 0.0, 2.807908, 1.223828, 1.080136, 0.210332, 0.236199, 0.257336], [0.425093, 0.534551, 0.123954, 0.36397, 0.052722, 0.390192, 2.426601, 0.126991, 6.326067, 0.301848, 0.484133, 0.751878, 0.332533, 2.807908, 0.0, 0.858151, 0.578987, 0.170887, 0.593607, 0.31444], [4.727182, 2.784478, 1.240275, 0.611973, 0.361819, 1.73999, 0.990012, 0.064105, 0.748683, 0.182287, 0.34696, 4.008358, 1.338132, 1.223828, 0.858151, 0.0, 6.472279, 0.098369, 0.248862, 0.400547], [2.139501, 1.14348, 0.42586, 0.604545, 0.165001, 0.129836, 0.584262, 1.033739, 1.136863, 0.302936, 2.020366, 2.000679, 0.571468, 1.080136, 0.578987, 6.472279, 0.0, 2.188158, 0.140825, 0.245841], [2.54787, 1.959291, 0.037967, 0.245034, 0.654683, 0.076701, 0.119013, 10.649107, 0.185202, 1.702745, 1.898718, 0.083688, 0.296501, 0.210332, 0.170887, 0.098369, 2.188158, 0.0, 0.18951, 0.249313], [0.180717, 0.670128, 0.02989, 0.077852, 2.457121, 0.268491, 0.597054, 0.11166, 0.049906, 0.619632, 0.696175, 0.045376, 0.095131, 0.236199, 0.593607, 0.248862, 0.140825, 0.18951, 0.0, 3.151815], [0.218959, 1.165532, 0.135107, 0.120037, 7.803902, 0.054679, 5.306834, 0.232523, 0.131932, 0.299648, 0.481306, 0.612025, 0.089613, 0.257336, 0.31444, 0.400547, 0.245841, 0.249313, 3.151815, 0.0]]


mtzoa_freqs = [0.06887993112006886, 0.009965990034009964, 0.020695979304020694, 0.024988975011024987, 0.0817119182880817, 0.07196792803207196, 0.02681397318602681, 0.08507191492808505, 0.019275980724019273, 0.1567168432831567, 0.050651949348050646, 0.030389969610030387, 0.0448029551970448, 0.01862298137701862, 0.021036978963021036, 0.08053491946508051, 0.056385943614056376, 0.06608293391706607, 0.027997972002027992, 0.0374039625960374]
mtzoa_matrix = [[0.0, 272.5, 16.1, 17.1, 26.5, 289.3, 2.3, 33.2, 0.2, 15.6, 136.5, 1.7, 61.8, 7.3, 3.3, 644.9, 378.1, 321.9, 3.1, 2.1], [272.5, 0.0, 9.5, 3.4, 167.8, 82.4, 37.5, 48.8, 0.2, 59.7, 264.8, 94.6, 8.1, 49.1, 61.1, 656.3, 199.0, 243.8, 36.1, 76.7], [16.1, 9.5, 0.0, 883.6, 2.0, 26.0, 55.6, 1.5, 0.2, 0.5, 0.2, 617.0, 0.2, 19.3, 3.2, 51.4, 2.3, 3.7, 0.2, 13.9], [17.1, 3.4, 883.6, 0.0, 0.2, 43.1, 14.9, 7.3, 163.2, 1.0, 0.2, 174.0, 20.6, 349.4, 6.4, 38.4, 34.5, 16.3, 3.5, 10.0], [26.5, 167.8, 2.0, 0.2, 0.0, 5.8, 13.1, 90.3, 16.3, 234.2, 215.6, 12.9, 10.5, 9.5, 0.2, 32.2, 19.3, 59.6, 58.2, 590.5], [289.3, 82.4, 26.0, 43.1, 5.8, 0.0, 7.4, 3.4, 10.1, 3.5, 52.2, 99.3, 1.3, 8.9, 7.2, 257.1, 5.2, 23.7, 12.3, 4.3], [2.3, 37.5, 55.6, 14.9, 13.1, 7.4, 0.0, 1.6, 23.9, 6.6, 7.1, 228.9, 15.6, 421.8, 61.7, 23.1, 19.4, 0.3, 4.5, 266.5], [33.2, 48.8, 1.5, 7.3, 90.3, 3.4, 1.6, 0.0, 8.4, 425.2, 449.7, 24.3, 2.6, 0.2, 0.2, 7.2, 222.3, 1710.6, 9.7, 13.1], [0.2, 0.2, 0.2, 163.2, 16.3, 10.1, 23.9, 8.4, 0.0, 6.7, 83.0, 413.4, 24.3, 334.0, 292.3, 144.9, 75.5, 11.1, 6.6, 45.0], [15.6, 59.7, 0.5, 1.0, 234.2, 3.5, 6.6, 425.2, 6.7, 0.0, 636.3, 7.9, 11.4, 23.0, 4.1, 15.2, 50.0, 126.1, 27.2, 5.7], [136.5, 264.8, 0.2, 0.2, 215.6, 52.2, 7.1, 449.7, 83.0, 636.3, 0.0, 73.7, 5.4, 83.9, 3.8, 95.3, 305.1, 279.6, 48.7, 41.4], [1.7, 94.6, 617.0, 174.0, 12.9, 99.3, 228.9, 24.3, 413.4, 7.9, 73.7, 0.0, 22.6, 190.3, 33.6, 420.2, 184.6, 7.1, 6.4, 141.6], [61.8, 8.1, 0.2, 20.6, 10.5, 1.3, 15.6, 2.6, 24.3, 11.4, 5.4, 22.6, 0.0, 52.2, 7.5, 79.7, 56.9, 17.9, 1.3, 4.2], [7.3, 49.1, 19.3, 349.4, 9.5, 8.9, 421.8, 0.2, 334.0, 23.0, 83.9, 190.3, 52.2, 0.0, 231.0, 96.4, 39.4, 9.0, 6.1, 52.3], [3.3, 61.1, 3.2, 6.4, 0.2, 7.2, 61.7, 0.2, 292.3, 4.1, 3.8, 33.6, 7.5, 231.0, 0.0, 11.8, 3.2, 5.1, 16.9, 13.8], [644.9, 656.3, 51.4, 38.4, 32.2, 257.1, 23.1, 7.2, 144.9, 15.2, 95.3, 420.2, 79.7, 96.4, 11.8, 0.0, 666.3, 49.5, 10.3, 29.7], [378.1, 199.0, 2.3, 34.5, 19.3, 5.2, 19.4, 222.3, 75.5, 50.0, 305.1, 184.6, 56.9, 39.4, 3.2, 666.3, 0.0, 396.4, 3.6, 29.0], [321.9, 243.8, 3.7, 16.3, 59.6, 23.7, 0.3, 1710.6, 11.1, 126.1, 279.6, 7.1, 17.9, 9.0, 5.1, 49.5, 396.4, 0.0, 13.7, 15.6], [3.1, 36.1, 0.2, 3.5, 58.2, 12.3, 4.5, 9.7, 6.6, 27.2, 48.7, 6.4, 1.3, 6.1, 16.9, 10.3, 3.6, 13.7, 0.0, 79.8], [2.1, 76.7, 13.9, 10.0, 590.5, 4.3, 266.5, 13.1, 45.0, 5.7, 41.4, 141.6, 4.2, 52.3, 13.8, 29.7, 29.0, 15.6, 79.8, 0.0]]


pmb_freqs = [0.07559244, 0.02849715, 0.04469553, 0.05349465, 0.0449955, 0.0779922, 0.029997, 0.05989401, 0.0519948, 0.09579042, 0.02189781, 0.03769623, 0.0419958, 0.03389661, 0.05379462, 0.06819318, 0.05639436, 0.07149285, 0.01569843, 0.0359964]
pmb_matrix = [[0.0, 1.065445546, 0.462499504, 1.046334652, 0.546169219, 1.587964372, 0.580830874, 0.464590585, 0.831998835, 0.804404505, 1.546725076, 0.589645178, 1.241586045, 1.111766964, 0.674995699, 3.452308792, 1.751412803, 2.063050067, 0.35011051, 0.573154753], [1.065445546, 0.0, 0.246951424, 0.091071867, 0.669206193, 0.31706632, 0.411543728, 0.417547309, 0.274163536, 0.450795211, 0.618614612, 0.589852457, 0.198679914, 0.245163782, 0.31444833, 0.99870098, 0.847312432, 0.998911631, 0.445669347, 0.55626163], [0.462499504, 0.246951424, 0.0, 4.399995525, 0.219005213, 0.734992057, 0.839348444, 0.266775558, 1.114178954, 0.269124919, 0.341932741, 3.573373315, 0.775624818, 1.686058219, 0.605460903, 1.440896785, 0.994227284, 0.275658381, 0.362495245, 0.436220437], [1.046334652, 0.091071867, 4.399995525, 0.0, 0.224154698, 0.463812837, 0.877842609, 0.30421529, 2.415974716, 0.32078471, 0.531773639, 1.277836748, 0.794584081, 4.15967899, 1.201770702, 1.205509425, 0.949599791, 0.527640634, 0.261258229, 0.50720003], [0.546169219, 0.669206193, 0.219005213, 0.224154698, 0.0, 0.35402891, 0.576231691, 1.495264661, 0.269496317, 2.392638293, 2.306919847, 0.425193716, 0.481144863, 0.406042546, 0.303437244, 0.613230817, 0.718895136, 0.983844803, 3.29519344, 5.894735673], [1.587964372, 0.31706632, 0.734992057, 0.463812837, 0.35402891, 0.0, 0.476331437, 0.180198883, 0.581001076, 0.259854426, 0.465349326, 1.374854049, 0.588254139, 0.596789898, 0.523770553, 1.402122097, 0.542185658, 0.314700907, 0.37874827, 0.284727562], [0.580830874, 0.411543728, 0.839348444, 0.877842609, 0.576231691, 0.476331437, 0.0, 0.285186418, 0.985885486, 0.363981358, 0.380925433, 2.283037894, 0.456058589, 1.812173605, 1.457127446, 0.799966711, 0.83039281, 0.305792277, 0.72436751, 2.210952064], [0.464590585, 0.417547309, 0.266775558, 0.30421529, 1.495264661, 0.180198883, 0.285186418, 0.0, 0.374784947, 4.162454693, 3.65807012, 0.426069419, 0.366232942, 0.315256838, 0.35964586, 0.530641901, 1.114132523, 8.002789424, 0.516260502, 0.570562395], [0.831998835, 0.274163536, 1.114178954, 2.415974716, 0.269496317, 0.581001076, 0.985885486, 0.374784947, 0.0, 0.498011337, 0.661095832, 2.037575629, 1.036079005, 3.521346591, 4.956476453, 1.234648153, 1.290709079, 0.526184203, 0.43340962, 0.664884513], [0.804404505, 0.450795211, 0.269124919, 0.32078471, 2.392638293, 0.259854426, 0.363981358, 4.162454693, 0.498011337, 0.0, 5.002338375, 0.41009447, 0.430073179, 0.625792937, 0.520701585, 0.402471997, 0.779827336, 2.113077156, 0.794797115, 0.811019594], [1.546725076, 0.618614612, 0.341932741, 0.531773639, 2.306919847, 0.465349326, 0.380925433, 3.65807012, 0.661095832, 5.002338375, 0.0, 0.737846301, 0.337502282, 2.067388546, 0.81346254, 0.945453716, 1.551488041, 1.737356217, 0.768395107, 0.93253606], [0.589645178, 0.589852457, 3.573373315, 1.277836748, 0.425193716, 1.374854049, 2.283037894, 0.426069419, 2.037575629, 0.41009447, 0.737846301, 0.0, 0.711495595, 2.299755865, 1.189067034, 2.572577221, 1.823161023, 0.474418852, 0.422407388, 0.720013799], [1.241586045, 0.198679914, 0.775624818, 0.794584081, 0.481144863, 0.588254139, 0.456058589, 0.366232942, 1.036079005, 0.430073179, 0.337502282, 0.711495595, 0.0, 0.850116543, 0.65577338, 1.217683028, 0.780913179, 0.551333603, 0.499869138, 0.433748126], [1.111766964, 0.245163782, 1.686058219, 4.15967899, 0.406042546, 0.596789898, 1.812173605, 0.315256838, 3.521346591, 0.625792937, 2.067388546, 2.299755865, 0.850116543, 0.0, 2.967840934, 1.348272505, 1.320626678, 0.634408285, 0.72038474, 0.728970584], [0.674995699, 0.31444833, 0.605460903, 1.201770702, 0.303437244, 0.523770553, 1.457127446, 0.35964586, 4.956476453, 0.520701585, 0.81346254, 1.189067034, 0.65577338, 2.967840934, 0.0, 0.910144334, 0.89517149, 0.388680158, 0.618778365, 0.628599063], [3.452308792, 0.99870098, 1.440896785, 1.205509425, 0.613230817, 1.402122097, 0.799966711, 0.530641901, 1.234648153, 0.402471997, 0.945453716, 2.572577221, 1.217683028, 1.348272505, 0.910144334, 0.0, 4.448982584, 0.507506011, 0.496334956, 0.593795813], [1.751412803, 0.847312432, 0.994227284, 0.949599791, 0.718895136, 0.542185658, 0.83039281, 1.114132523, 1.290709079, 0.779827336, 1.551488041, 1.823161023, 0.780913179, 1.320626678, 0.89517149, 4.448982584, 0.0, 1.89965079, 0.38372361, 0.523549536], [2.063050067, 0.998911631, 0.275658381, 0.527640634, 0.983844803, 0.314700907, 0.305792277, 8.002789424, 0.526184203, 2.113077156, 1.737356217, 0.474418852, 0.551333603, 0.634408285, 0.388680158, 0.507506011, 1.89965079, 0.0, 0.429570747, 0.716795463], [0.35011051, 0.445669347, 0.362495245, 0.261258229, 3.29519344, 0.37874827, 0.72436751, 0.516260502, 0.43340962, 0.794797115, 0.768395107, 0.422407388, 0.499869138, 0.72038474, 0.618778365, 0.496334956, 0.38372361, 0.429570747, 0.0, 2.996248013], [0.573154753, 0.55626163, 0.436220437, 0.50720003, 5.894735673, 0.284727562, 2.210952064, 0.570562395, 0.664884513, 0.811019594, 0.93253606, 0.720013799, 0.433748126, 0.728970584, 0.628599063, 0.593795813, 0.523549536, 0.716795463, 2.996248013, 0.0]]


vt_freqs = [0.0770764620135024, 0.0144533387583345, 0.0537929860758246, 0.0633579339160905, 0.041350852183426, 0.0655672355884439, 0.0218802687005936, 0.0591969699027449, 0.059207941082273, 0.0976461276528445, 0.0220695876653368, 0.0462377395993731, 0.0476871596856874, 0.0408923608974345, 0.0500819370772208, 0.0707295165111524, 0.0567759161524817, 0.0669190817443274, 0.0127019797647213, 0.0323746050281867]
vt_matrix = [[0.0, 2.4731223087544874, 1.3759368509441177, 2.337991120749506, 0.6883439026872615, 3.3386555146457697, 0.9615841926910841, 0.890820306192551, 1.4932055816372476, 1.0778497408764076, 1.9006455961717605, 1.2184237953498958, 2.735562008995355, 2.215516780513747, 1.2412691067876198, 6.420896185914288, 5.289251416977644, 4.650189469180321, 0.548857847810693, 0.5411769916657778], [2.4731223087544874, 0.0, 0.2272488448121475, 0.4519167943192672, 1.6953951980808002, 1.1034605684472507, 1.5196756759380692, 0.9126668032539315, 0.3371091785647479, 1.4081315998413697, 1.2213054800811556, 0.9784679122774127, 0.4326227078645523, 0.4587469126746136, 1.4414262567428417, 3.6366815408744255, 1.7557065205837685, 2.262745699629089, 1.6275179891253113, 2.1579775140421025], [1.3759368509441177, 0.2272488448121475, 0.0, 9.688345187568506, 0.1675129724559251, 1.9142079025990228, 2.145964061013378, 0.2161660372725585, 1.4521790561663968, 0.3574207468998517, 0.4075239926000898, 7.8584219153689405, 1.0714605979577547, 1.656249563817604, 0.7550654439001206, 2.216194459674183, 1.5066839872944762, 0.4594535241660911, 0.249658418815177, 0.7447620891784513], [2.337991120749506, 0.4519167943192672, 9.688345187568506, 0.0, 0.2317194387691585, 1.3860121390169038, 1.6360079688522375, 0.4035497929633328, 4.329008652958283, 0.5610717242294755, 0.7471936218068498, 2.009343477839811, 1.5132807416252063, 6.8124601839937675, 1.3542404860613146, 1.8273535587773553, 1.583998170858469, 0.894057287554733, 0.4198391148111098, 0.5818111331782764], [0.6883439026872615, 1.6953951980808002, 0.1675129724559251, 0.2317194387691585, 0.0, 0.369372264098046, 1.3629765501081097, 2.2864286949316077, 0.3910559903834828, 4.361154806355578, 2.320137354629635, 0.5044944273324311, 0.3746821107962129, 0.3573432522499545, 0.422494519727629, 1.1079144700606407, 0.6882725908872254, 1.7039730522675411, 3.3448437239772266, 10.384852333133459], [3.3386555146457697, 1.1034605684472507, 1.9142079025990228, 1.3860121390169038, 0.369372264098046, 0.0, 0.8561248973045037, 0.2888075033037488, 0.8945563662345198, 0.3578662395745526, 0.5954812791740037, 2.411763289886181, 0.7744933618134962, 0.8776110594765502, 1.3121700301622004, 3.063777619371761, 0.7147489676267383, 0.6193321034173915, 0.9349753595598769, 0.3374467649724478], [0.9615841926910841, 1.5196756759380692, 2.145964061013378, 1.6360079688522375, 1.3629765501081097, 0.8561248973045037, 0.0, 0.578793711540794, 1.8085136096039203, 1.0765007949562073, 1.3808291710019667, 6.197438497788411, 1.837055585207065, 7.9943228564946525, 4.923866828394527, 1.9699895187387506, 1.6136654573285647, 0.5333220944030346, 0.6301954684360302, 7.758744230914604], [0.890820306192551, 0.9126668032539315, 0.2161660372725585, 0.4035497929633328, 2.2864286949316077, 0.2888075033037488, 0.578793711540794, 0.0, 0.6244297525127139, 6.001911025842636, 6.759789977204542, 0.917929117533152, 0.4811402387911145, 0.4882733432879921, 0.4323005487925516, 0.6047491507504744, 2.634477838444273, 14.872933461519061, 0.5604648274060783, 0.8626796044156272], [1.4932055816372476, 0.3371091785647479, 1.4521790561663968, 4.329008652958283, 0.3910559903834828, 0.8945563662345198, 1.8085136096039203, 0.6244297525127139, 0.0, 0.5642322882556321, 1.7129670976916258, 4.403454757896257, 1.3918935593582853, 6.051908524311881, 10.017330817366002, 1.9776630140912268, 2.551378131266028, 0.7801080335991272, 0.5851920879490173, 0.7835447533710449], [1.0778497408764076, 1.4081315998413697, 0.3574207468998517, 0.5610717242294755, 4.361154806355578, 0.3578662395745526, 1.0765007949562073, 6.001911025842636, 0.5642322882556321, 0.0, 8.032779294742115, 0.4098311270816011, 1.0084320519837335, 1.3318097154194044, 0.8386701149158265, 0.8953754669269811, 1.019200437250654, 3.5458093276667237, 1.518311443467934, 1.2452243224541324], [1.9006455961717605, 1.2213054800811556, 0.4075239926000898, 0.7471936218068498, 2.320137354629635, 0.5954812791740037, 1.3808291710019667, 6.759789977204542, 1.7129670976916258, 8.032779294742115, 0.0, 0.9378803706165143, 0.4953193808676289, 1.9106190827629084, 1.2488638689609959, 1.0657482318076852, 3.3628488360462363, 4.05845771567534, 1.4680478689711018, 1.089916577095682], [1.2184237953498958, 0.9784679122774127, 7.8584219153689405, 2.009343477839811, 0.5044944273324311, 2.411763289886181, 6.197438497788411, 0.917929117533152, 4.403454757896257, 0.4098311270816011, 0.9378803706165143, 0.0, 0.7103720531974738, 3.014320167092482, 1.572077075332688, 6.123451239680176, 3.885250610592223, 0.4586061981719967, 0.1808525752605976, 1.0894926581511342], [2.735562008995355, 0.4326227078645523, 1.0714605979577547, 1.5132807416252063, 0.3746821107962129, 0.7744933618134962, 1.837055585207065, 0.4811402387911145, 1.3918935593582853, 1.0084320519837335, 0.4953193808676289, 0.7103720531974738, 0.0, 2.301917772830073, 1.3091837782420783, 3.5465914843628927, 1.9485376673137556, 0.5985498912985666, 0.4326058001438786, 0.4819109019647465], [2.215516780513747, 0.4587469126746136, 1.656249563817604, 6.8124601839937675, 0.3573432522499545, 0.8776110594765502, 7.9943228564946525, 0.4882733432879921, 6.051908524311881, 1.3318097154194044, 1.9106190827629084, 3.014320167092482, 2.301917772830073, 0.0, 5.512081970524868, 2.319370364323722, 2.157651010347144, 0.6366932501396869, 0.8959082681546182, 0.9183596801412757], [1.2412691067876198, 1.4414262567428417, 0.7550654439001206, 1.3542404860613146, 0.422494519727629, 1.3121700301622004, 4.923866828394527, 0.4323005487925516, 10.017330817366002, 0.8386701149158265, 1.2488638689609959, 1.572077075332688, 1.3091837782420783, 5.512081970524868, 0.0, 1.9202994262316166, 1.33634017405606, 0.7807017855806767, 1.517014215396284, 0.8912614404565405], [6.420896185914288, 3.6366815408744255, 2.216194459674183, 1.8273535587773553, 1.1079144700606407, 3.063777619371761, 1.9699895187387506, 0.6047491507504744, 1.9776630140912268, 0.8953754669269811, 1.0657482318076852, 6.123451239680176, 3.5465914843628927, 2.319370364323722, 1.9202994262316166, 0.0, 8.847998406124818, 0.9305232113028208, 0.6791126595939816, 0.9547229305958682], [5.289251416977644, 1.7557065205837685, 1.5066839872944762, 1.583998170858469, 0.6882725908872254, 0.7147489676267383, 1.6136654573285647, 2.634477838444273, 2.551378131266028, 1.019200437250654, 3.3628488360462363, 3.885250610592223, 1.9485376673137556, 2.157651010347144, 1.33634017405606, 8.847998406124818, 0.0, 3.4242218450865543, 0.4514203099376473, 0.8564314184691215], [4.650189469180321, 2.262745699629089, 0.4594535241660911, 0.894057287554733, 1.7039730522675411, 0.6193321034173915, 0.5333220944030346, 14.872933461519061, 0.7801080335991272, 3.5458093276667237, 4.05845771567534, 0.4586061981719967, 0.5985498912985666, 0.6366932501396869, 0.7807017855806767, 0.9305232113028208, 3.4242218450865543, 0.0, 0.5658969249032649, 1.0], [0.548857847810693, 1.6275179891253113, 0.249658418815177, 0.4198391148111098, 3.3448437239772266, 0.9349753595598769, 0.6301954684360302, 0.5604648274060783, 0.5851920879490173, 1.518311443467934, 1.4680478689711018, 0.1808525752605976, 0.4326058001438786, 0.8959082681546182, 1.517014215396284, 0.6791126595939816, 0.4514203099376473, 0.5658969249032649, 0.0, 4.537723579040539], [0.5411769916657778, 2.1579775140421025, 0.7447620891784513, 0.5818111331782764, 10.384852333133459, 0.3374467649724478, 7.758744230914604, 0.8626796044156272, 0.7835447533710449, 1.2452243224541324, 1.089916577095682, 1.0894926581511342, 0.4819109019647465, 0.9183596801412757, 0.8912614404565405, 0.9547229305958682, 0.8564314184691215, 1.0, 4.537723579040539, 0.0]]


wag_freqs = [0.08662790866279085, 0.019307801930780192, 0.05704510570451057, 0.05805890580589058, 0.03843190384319038, 0.08325180832518082, 0.024431302443130243, 0.048466004846600484, 0.06202860620286062, 0.08620900862090085, 0.019502701950270197, 0.03908940390894039, 0.04576310457631046, 0.03672810367281037, 0.043972004397200434, 0.06951790695179068, 0.06101270610127061, 0.0708956070895607, 0.014385901438590143, 0.03527420352742035]
wag_matrix = [[0.0, 1.02704, 0.738998, 1.58285, 0.210494, 1.41672, 0.316954, 0.193335, 0.906265, 0.397915, 0.893496, 0.509848, 1.43855, 0.908598, 0.551571, 3.37079, 2.12111, 2.00601, 0.113133, 0.240735], [1.02704, 0.0, 0.0302949, 0.021352, 0.39802, 0.306674, 0.248972, 0.170135, 0.0740339, 0.384287, 0.390482, 0.265256, 0.109404, 0.0988179, 0.528191, 1.40766, 0.512984, 1.00214, 0.71707, 0.543833], [0.738998, 0.0302949, 0.0, 6.17416, 0.0467304, 0.865584, 0.930676, 0.039437, 0.479855, 0.0848047, 0.103754, 5.42942, 0.423984, 0.616783, 0.147304, 1.07176, 0.374866, 0.152335, 0.129767, 0.325711], [1.58285, 0.021352, 6.17416, 0.0, 0.0811339, 0.567717, 0.570025, 0.127395, 2.58443, 0.154263, 0.315124, 0.947198, 0.682355, 5.46947, 0.439157, 0.704939, 0.822765, 0.588731, 0.156557, 0.196303], [0.210494, 0.39802, 0.0467304, 0.0811339, 0.0, 0.049931, 0.679371, 1.05947, 0.088836, 2.11517, 1.19063, 0.0961621, 0.161444, 0.0999208, 0.102711, 0.545931, 0.171903, 0.649892, 1.52964, 6.45428], [1.41672, 0.306674, 0.865584, 0.567717, 0.049931, 0.0, 0.24941, 0.0304501, 0.373558, 0.0613037, 0.1741, 1.12556, 0.24357, 0.330052, 0.584665, 1.34182, 0.225833, 0.187247, 0.336983, 0.103604], [0.316954, 0.248972, 0.930676, 0.570025, 0.679371, 0.24941, 0.0, 0.13819, 0.890432, 0.499462, 0.404141, 3.95629, 0.696198, 4.29411, 2.13715, 0.740169, 0.473307, 0.118358, 0.262569, 3.87344], [0.193335, 0.170135, 0.039437, 0.127395, 1.05947, 0.0304501, 0.13819, 0.0, 0.323832, 3.17097, 4.25746, 0.554236, 0.0999288, 0.113917, 0.186979, 0.31944, 1.45816, 7.8213, 0.212483, 0.42017], [0.906265, 0.0740339, 0.479855, 2.58443, 0.088836, 0.373558, 0.890432, 0.323832, 0.0, 0.257555, 0.934276, 3.01201, 0.556896, 3.8949, 5.35142, 0.96713, 1.38698, 0.305434, 0.137505, 0.133264], [0.397915, 0.384287, 0.0848047, 0.154263, 2.11517, 0.0613037, 0.499462, 3.17097, 0.257555, 0.0, 4.85402, 0.131528, 0.415844, 0.869489, 0.497671, 0.344739, 0.326622, 1.80034, 0.665309, 0.398618], [0.893496, 0.390482, 0.103754, 0.315124, 1.19063, 0.1741, 0.404141, 4.25746, 0.934276, 4.85402, 0.0, 0.198221, 0.171329, 1.54526, 0.683162, 0.493905, 1.51612, 2.05845, 0.515706, 0.428437], [0.509848, 0.265256, 5.42942, 0.947198, 0.0961621, 1.12556, 3.95629, 0.554236, 3.01201, 0.131528, 0.198221, 0.0, 0.195081, 1.54364, 0.635346, 3.97423, 2.03006, 0.196246, 0.0719167, 1.086], [1.43855, 0.109404, 0.423984, 0.682355, 0.161444, 0.24357, 0.696198, 0.0999288, 0.556896, 0.415844, 0.171329, 0.195081, 0.0, 0.933372, 0.679489, 1.61328, 0.795384, 0.314887, 0.139405, 0.216046], [0.908598, 0.0988179, 0.616783, 5.46947, 0.0999208, 0.330052, 4.29411, 0.113917, 3.8949, 0.869489, 1.54526, 1.54364, 0.933372, 0.0, 3.0355, 1.02887, 0.857928, 0.301281, 0.215737, 0.22771], [0.551571, 0.528191, 0.147304, 0.439157, 0.102711, 0.584665, 2.13715, 0.186979, 5.35142, 0.497671, 0.683162, 0.635346, 0.679489, 3.0355, 0.0, 1.22419, 0.554413, 0.251849, 1.16392, 0.381533], [3.37079, 1.40766, 1.07176, 0.704939, 0.545931, 1.34182, 0.740169, 0.31944, 0.96713, 0.344739, 0.493905, 3.97423, 1.61328, 1.02887, 1.22419, 0.0, 4.37802, 0.232739, 0.523742, 0.786993], [2.12111, 0.512984, 0.374866, 0.822765, 0.171903, 0.225833, 0.473307, 1.45816, 1.38698, 0.326622, 1.51612, 2.03006, 0.795384, 0.857928, 0.554413, 4.37802, 0.0, 1.38823, 0.110864, 0.291148], [2.00601, 1.00214, 0.152335, 0.588731, 0.649892, 0.187247, 0.118358, 7.8213, 0.305434, 1.80034, 2.05845, 0.196246, 0.314887, 0.301281, 0.251849, 0.232739, 1.38823, 0.0, 0.365369, 0.31473], [0.113133, 0.71707, 0.129767, 0.156557, 1.52964, 0.336983, 0.262569, 0.212483, 0.137505, 0.665309, 0.515706, 0.0719167, 0.139405, 0.215737, 1.16392, 0.523742, 0.110864, 0.365369, 0.0, 2.48539], [0.240735, 0.543833, 0.325711, 0.196303, 6.45428, 0.103604, 3.87344, 0.42017, 0.133264, 0.398618, 0.428437, 1.086, 0.216046, 0.22771, 0.381533, 0.786993, 0.291148, 0.31473, 2.48539, 0.0]]


cprev_freqs = [0.0755, 0.0091, 0.0371, 0.0495, 0.0506, 0.0838, 0.0246, 0.0806, 0.0504, 0.1011, 0.022, 0.041, 0.0431, 0.0382, 0.0621, 0.0622, 0.0543, 0.066, 0.0181, 0.0307]
cprev_matrix = [[0.0, 669.0, 175.0, 499.0, 68.0, 665.0, 66.0, 145.0, 236.0, 197.0, 185.0, 227.0, 490.0, 157.0, 105.0, 2440.0, 1340.0, 968.0, 14.0, 56.0], [669.0, 0.0, 10.0, 10.0, 726.0, 303.0, 441.0, 280.0, 48.0, 396.0, 159.0, 538.0, 285.0, 10.0, 823.0, 2331.0, 576.0, 592.0, 435.0, 1466.0], [175.0, 10.0, 0.0, 3691.0, 22.0, 431.0, 331.0, 10.0, 412.0, 10.0, 47.0, 4435.0, 170.0, 400.0, 43.0, 590.0, 266.0, 75.0, 18.0, 281.0], [499.0, 10.0, 3691.0, 0.0, 145.0, 379.0, 162.0, 148.0, 2629.0, 82.0, 113.0, 1055.0, 185.0, 3122.0, 152.0, 568.0, 369.0, 200.0, 63.0, 142.0], [68.0, 726.0, 22.0, 145.0, 0.0, 25.0, 127.0, 454.0, 72.0, 1268.0, 327.0, 97.0, 43.0, 10.0, 53.0, 487.0, 148.0, 317.0, 468.0, 2370.0], [665.0, 303.0, 431.0, 379.0, 25.0, 0.0, 19.0, 40.0, 263.0, 20.0, 21.0, 653.0, 28.0, 133.0, 243.0, 691.0, 92.0, 91.0, 82.0, 10.0], [66.0, 441.0, 331.0, 162.0, 127.0, 19.0, 0.0, 29.0, 305.0, 66.0, 10.0, 1405.0, 152.0, 1269.0, 715.0, 303.0, 32.0, 25.0, 69.0, 1971.0], [145.0, 280.0, 10.0, 148.0, 454.0, 40.0, 29.0, 0.0, 345.0, 1745.0, 1772.0, 168.0, 117.0, 92.0, 136.0, 216.0, 1040.0, 4797.0, 42.0, 89.0], [236.0, 48.0, 412.0, 2629.0, 72.0, 263.0, 305.0, 345.0, 0.0, 218.0, 193.0, 2430.0, 302.0, 3313.0, 4482.0, 868.0, 918.0, 249.0, 10.0, 247.0], [197.0, 396.0, 10.0, 82.0, 1268.0, 20.0, 66.0, 1745.0, 218.0, 0.0, 1351.0, 113.0, 219.0, 286.0, 203.0, 516.0, 156.0, 865.0, 159.0, 189.0], [185.0, 159.0, 47.0, 113.0, 327.0, 21.0, 10.0, 1772.0, 193.0, 1351.0, 0.0, 61.0, 100.0, 202.0, 125.0, 93.0, 645.0, 475.0, 86.0, 215.0], [227.0, 538.0, 4435.0, 1055.0, 97.0, 653.0, 1405.0, 168.0, 2430.0, 113.0, 61.0, 0.0, 173.0, 768.0, 357.0, 2085.0, 1393.0, 83.0, 40.0, 754.0], [490.0, 285.0, 170.0, 185.0, 43.0, 28.0, 152.0, 117.0, 302.0, 219.0, 100.0, 173.0, 0.0, 323.0, 87.0, 1202.0, 260.0, 122.0, 49.0, 97.0], [157.0, 10.0, 400.0, 3122.0, 10.0, 133.0, 1269.0, 92.0, 3313.0, 286.0, 202.0, 768.0, 323.0, 0.0, 1745.0, 396.0, 241.0, 54.0, 53.0, 391.0], [105.0, 823.0, 43.0, 152.0, 53.0, 243.0, 715.0, 136.0, 4482.0, 203.0, 125.0, 357.0, 87.0, 1745.0, 0.0, 385.0, 314.0, 92.0, 230.0, 323.0], [2440.0, 2331.0, 590.0, 568.0, 487.0, 691.0, 303.0, 216.0, 868.0, 516.0, 93.0, 2085.0, 1202.0, 396.0, 385.0, 0.0, 2151.0, 167.0, 73.0, 522.0], [1340.0, 576.0, 266.0, 369.0, 148.0, 92.0, 32.0, 1040.0, 918.0, 156.0, 645.0, 1393.0, 260.0, 241.0, 314.0, 2151.0, 0.0, 760.0, 29.0, 71.0], [968.0, 592.0, 75.0, 200.0, 317.0, 91.0, 25.0, 4797.0, 249.0, 865.0, 475.0, 83.0, 122.0, 54.0, 92.0, 167.0, 760.0, 0.0, 10.0, 119.0], [14.0, 435.0, 18.0, 63.0, 468.0, 82.0, 69.0, 42.0, 10.0, 159.0, 86.0, 40.0, 49.0, 53.0, 230.0, 73.0, 29.0, 10.0, 0.0, 346.0], [56.0, 1466.0, 281.0, 142.0, 2370.0, 10.0, 1971.0, 89.0, 247.0, 189.0, 215.0, 754.0, 97.0, 391.0, 323.0, 522.0, 71.0, 119.0, 346.0, 0.0]]


mtart_freqs = [0.054116, 0.009709, 0.02016, 0.024289, 0.088668, 0.068183, 0.024518, 0.092638, 0.021718, 0.148658, 0.061453, 0.039903, 0.041826, 0.018781, 0.018227, 0.09103, 0.049194, 0.0577, 0.029786, 0.039443]
mtart_matrix = [[0.0, 254.0, 1.0, 0.2, 13.0, 200.0, 0.2, 26.0, 0.2, 4.0, 121.0, 0.2, 49.0, 0.2, 0.2, 673.0, 244.0, 340.0, 0.2, 1.0], [254.0, 0.0, 11.0, 0.2, 184.0, 81.0, 12.0, 63.0, 0.2, 79.0, 312.0, 98.0, 0.2, 0.2, 36.0, 664.0, 183.0, 350.0, 22.0, 72.0], [1.0, 11.0, 0.0, 862.0, 0.2, 12.0, 0.2, 7.0, 2.0, 1.0, 0.2, 500.0, 0.2, 0.2, 4.0, 44.0, 0.2, 0.2, 0.2, 0.2], [0.2, 0.2, 862.0, 0.0, 0.2, 44.0, 15.0, 7.0, 106.0, 2.0, 0.2, 183.0, 8.0, 262.0, 0.2, 31.0, 43.0, 14.0, 11.0, 8.0], [13.0, 184.0, 0.2, 0.2, 0.0, 1.0, 14.0, 118.0, 11.0, 263.0, 322.0, 20.0, 15.0, 0.2, 5.0, 36.0, 14.0, 52.0, 54.0, 792.0], [200.0, 81.0, 12.0, 44.0, 1.0, 0.0, 0.2, 3.0, 0.2, 1.0, 56.0, 121.0, 0.2, 3.0, 0.2, 226.0, 0.2, 3.0, 2.0, 9.0], [0.2, 12.0, 0.2, 15.0, 14.0, 0.2, 0.0, 0.2, 0.2, 6.0, 0.2, 180.0, 1.0, 314.0, 41.0, 11.0, 19.0, 0.2, 0.2, 191.0], [26.0, 63.0, 7.0, 7.0, 118.0, 3.0, 0.2, 0.0, 3.0, 515.0, 515.0, 21.0, 0.2, 11.0, 2.0, 7.0, 204.0, 1855.0, 0.2, 12.0], [0.2, 0.2, 2.0, 106.0, 11.0, 0.2, 0.2, 3.0, 0.0, 4.0, 106.0, 467.0, 17.0, 349.0, 209.0, 144.0, 70.0, 26.0, 16.0, 117.0], [4.0, 79.0, 1.0, 2.0, 263.0, 1.0, 6.0, 515.0, 4.0, 0.0, 885.0, 13.0, 12.0, 16.0, 2.0, 8.0, 48.0, 85.0, 21.0, 20.0], [121.0, 312.0, 0.2, 0.2, 322.0, 56.0, 0.2, 515.0, 106.0, 885.0, 0.0, 79.0, 5.0, 67.0, 5.0, 112.0, 289.0, 281.0, 71.0, 71.0], [0.2, 98.0, 500.0, 183.0, 20.0, 121.0, 180.0, 21.0, 467.0, 13.0, 79.0, 0.0, 17.0, 262.0, 0.2, 398.0, 166.0, 23.0, 8.0, 251.0], [49.0, 0.2, 0.2, 8.0, 15.0, 0.2, 1.0, 0.2, 17.0, 12.0, 5.0, 17.0, 0.0, 39.0, 0.2, 87.0, 47.0, 32.0, 0.2, 18.0], [0.2, 0.2, 0.2, 262.0, 0.2, 3.0, 314.0, 11.0, 349.0, 16.0, 67.0, 262.0, 39.0, 0.0, 154.0, 52.0, 44.0, 0.2, 7.0, 87.0], [0.2, 36.0, 4.0, 0.2, 5.0, 0.2, 41.0, 2.0, 209.0, 2.0, 5.0, 0.2, 0.2, 154.0, 0.0, 3.0, 0.2, 0.2, 0.2, 4.0], [673.0, 664.0, 44.0, 31.0, 36.0, 226.0, 11.0, 7.0, 144.0, 8.0, 112.0, 398.0, 87.0, 52.0, 3.0, 0.0, 660.0, 61.0, 2.0, 30.0], [244.0, 183.0, 0.2, 43.0, 14.0, 0.2, 19.0, 204.0, 70.0, 48.0, 289.0, 166.0, 47.0, 44.0, 0.2, 660.0, 0.0, 544.0, 0.2, 46.0], [340.0, 350.0, 0.2, 14.0, 52.0, 3.0, 0.2, 1855.0, 26.0, 85.0, 281.0, 23.0, 32.0, 0.2, 0.2, 61.0, 544.0, 0.0, 0.2, 2.0], [0.2, 22.0, 0.2, 11.0, 54.0, 2.0, 0.2, 0.2, 16.0, 21.0, 71.0, 8.0, 0.2, 7.0, 0.2, 2.0, 0.2, 0.2, 0.0, 38.0], [1.0, 72.0, 0.2, 8.0, 792.0, 9.0, 191.0, 12.0, 117.0, 20.0, 71.0, 251.0, 18.0, 87.0, 4.0, 30.0, 46.0, 2.0, 38.0, 0.0]]


mtinv_freqs = [0.031742312696925, 0.013570105428042, 0.016149206459683, 0.022311208924484, 0.102287040914816, 0.047847519139008, 0.011641804656722, 0.094322337728935, 0.044438717775487, 0.149407059762824, 0.077262530905012, 0.06157922463169, 0.026290210516084, 0.014644105857642, 0.010900704360282, 0.105939042375617, 0.042869117147647, 0.05954002381601, 0.020701008280403, 0.046556718622687]
mtinv_matrix = [[0.0, 1.30366367453432, 0.100963342614647, 0.145240519903769, 0.111082013567177, 1.93155428137798, 0.045194564922167, 0.209390225243876, 0.014824597070159, 0.153999806400053, 0.592864803853984, 0.023989052404375, 0.629531950187119, 0.090980768607678, 0.074334218266301, 3.3687526494984, 3.32704176318276, 2.75136222245467, 0.026501471399407, 0.021939769224089], [1.30366367453432, 0.0, 0.058303793678473, 0.047068462172608, 0.887097013161053, 0.883545088581823, 0.341191895523187, 0.287547507980951, 0.004392611242955, 0.381393499442539, 0.461585949365546, 0.279969423012186, 0.069312726274898, 0.163006102797533, 0.680711975715101, 3.0427840238859, 0.73686162925523, 1.55539690584099, 0.758571851571138, 1.34295198381899], [0.100963342614647, 0.058303793678473, 0.0, 6.96250928999517, 0.017157066137171, 0.591216665513239, 0.358935283425829, 0.017124804150076, 0.096074070570356, 0.010524108790355, 0.049089594364154, 3.47172283031031, 0.104690593123746, 0.204531412187402, 0.070670662731724, 0.505643420742551, 0.141991497203378, 0.088077392769029, 0.071630764347683, 0.192759935895995], [0.145240519903769, 0.047068462172608, 6.96250928999517, 0.0, 0.027169124132346, 0.599017294392986, 0.217387593044928, 0.020795063681971, 1.17248689200506, 0.033099595760156, 0.189458582216537, 1.15908247336683, 0.120987616604934, 2.55996510601355, 0.121635259345877, 0.580233013906702, 0.241928620228513, 0.231186486525368, 0.107622585950948, 0.13764964594012], [0.111082013567177, 0.887097013161053, 0.017157066137171, 0.027169124132346, 0.0, 0.103612477554992, 0.151813232274683, 0.879509584196026, 0.098766126493534, 1.73513889094417, 0.916539999383854, 0.194205108317926, 0.10510813395673, 0.052545508981788, 0.015357906856835, 0.398961585415302, 0.121269516492174, 0.534676724129225, 0.478876889449168, 3.23468151012688], [1.93155428137798, 0.883545088581823, 0.591216665513239, 0.599017294392986, 0.103612477554992, 0.0, 0.064352344259052, 0.024809855076054, 0.156144354542233, 0.050781943687214, 0.207637097945128, 0.551419739432016, 0.028323516670589, 0.114080027367971, 0.217695106921922, 2.02014026494357, 0.043791194483515, 0.396428077428706, 0.244698162120696, 0.072268115092742], [0.045194564922167, 0.341191895523187, 0.358935283425829, 0.217387593044928, 0.151813232274683, 0.064352344259052, 0.0, 0.025529460788212, 0.250218937912385, 0.080842277663076, 0.070807578676957, 1.72863495154574, 0.312042686182876, 4.70803070378697, 1.28336660965315, 0.368422261631036, 0.270595503761755, 0.008043434782625, 0.081171865531241, 2.32170190031887], [0.209390225243876, 0.287547507980951, 0.017124804150076, 0.020795063681971, 0.879509584196026, 0.024809855076054, 0.025529460788212, 0.0, 0.100258540896568, 2.15957327717034, 2.83088827564424, 0.310892189643074, 0.070886389645433, 0.025100268959888, 0.028420823631666, 0.126690032323967, 1.95851803959247, 8.54258937396289, 0.062889026844379, 0.177138315144646], [0.014824597070159, 0.004392611242955, 0.096074070570356, 1.17248689200506, 0.098766126493534, 0.156144354542233, 0.250218937912385, 0.100258540896568, 0.0, 0.081982070207159, 0.694473233210596, 2.64231972707169, 0.183146598741331, 1.93367217353082, 1.63188537324559, 0.879840867063512, 0.511283878486367, 0.056252073499162, 0.106016335593449, 0.348477651608884], [0.153999806400053, 0.381393499442539, 0.010524108790355, 0.033099595760156, 1.73513889094417, 0.050781943687214, 0.080842277663076, 2.15957327717034, 0.081982070207159, 0.0, 3.49491517203337, 0.07511461895414, 0.154372892250818, 0.211473478410575, 0.052763470894603, 0.225488005804762, 0.298279746688054, 1.07587285565069, 0.298463138614697, 0.161052630578922], [0.592864803853984, 0.461585949365546, 0.049089594364154, 0.189458582216537, 0.916539999383854, 0.207637097945128, 0.070807578676957, 2.83088827564424, 0.694473233210596, 3.49491517203337, 0.0, 0.566989926203939, 0.092516642993328, 0.397060773175627, 0.022385985045602, 0.633585250565799, 2.19205866017619, 1.50985217105889, 0.254195659321696, 0.393193176722666], [0.023989052404375, 0.279969423012186, 3.47172283031031, 1.15908247336683, 0.194205108317926, 0.551419739432016, 1.72863495154574, 0.310892189643074, 2.64231972707169, 0.07511461895414, 0.566989926203939, 0.0, 0.224156768337257, 1.2871889911242, 0.147604222958287, 2.08446924721197, 1.18626534249367, 0.065420927831618, 0.07539864384053, 1.1391650413338], [0.629531950187119, 0.069312726274898, 0.104690593123746, 0.120987616604934, 0.10510813395673, 0.028323516670589, 0.312042686182876, 0.070886389645433, 0.183146598741331, 0.154372892250818, 0.092516642993328, 0.224156768337257, 0.0, 0.581011232595414, 0.130198008920776, 1.04250971999595, 0.746916803233159, 0.162975872809625, 0.05973782510486, 0.08139531644186], [0.090980768607678, 0.163006102797533, 0.204531412187402, 2.55996510601355, 0.052545508981788, 0.114080027367971, 4.70803070378697, 0.025100268959888, 1.93367217353082, 0.211473478410575, 0.397060773175627, 1.2871889911242, 0.581011232595414, 0.0, 2.50773703190479, 0.538789467484127, 0.554297413280946, 0.065221940911213, 0.118046810781257, 0.476209340516188], [0.074334218266301, 0.680711975715101, 0.070670662731724, 0.121635259345877, 0.015357906856835, 0.217695106921922, 1.28336660965315, 0.028420823631666, 1.63188537324559, 0.052763470894603, 0.022385985045602, 0.147604222958287, 0.130198008920776, 2.50773703190479, 0.0, 0.309426794229233, 0.108593900562422, 0.072153227138698, 0.321740677303678, 0.18276250189497], [3.3687526494984, 3.0427840238859, 0.505643420742551, 0.580233013906702, 0.398961585415302, 2.02014026494357, 0.368422261631036, 0.126690032323967, 0.879840867063512, 0.225488005804762, 0.633585250565799, 2.08446924721197, 1.04250971999595, 0.538789467484127, 0.309426794229233, 0.0, 3.83329876167988, 0.377288666084473, 0.204318441272591, 0.345719568712117], [3.32704176318276, 0.73686162925523, 0.141991497203378, 0.241928620228513, 0.121269516492174, 0.043791194483515, 0.270595503761755, 1.95851803959247, 0.511283878486367, 0.298279746688054, 2.19205866017619, 1.18626534249367, 0.746916803233159, 0.554297413280946, 0.108593900562422, 3.83329876167988, 0.0, 1.88533856986427, 0.049859203056311, 0.174898633040519], [2.75136222245467, 1.55539690584099, 0.088077392769029, 0.231186486525368, 0.534676724129225, 0.396428077428706, 0.008043434782625, 8.54258937396289, 0.056252073499162, 1.07587285565069, 1.50985217105889, 0.065420927831618, 0.162975872809625, 0.065221940911213, 0.072153227138698, 0.377288666084473, 1.88533856986427, 0.0, 0.128598566560553, 0.080346083861554], [0.026501471399407, 0.758571851571138, 0.071630764347683, 0.107622585950948, 0.478876889449168, 0.244698162120696, 0.081171865531241, 0.062889026844379, 0.106016335593449, 0.298463138614697, 0.254195659321696, 0.07539864384053, 0.05973782510486, 0.118046810781257, 0.321740677303678, 0.204318441272591, 0.049859203056311, 0.128598566560553, 0.0, 0.636664640334042], [0.021939769224089, 1.34295198381899, 0.192759935895995, 0.13764964594012, 3.23468151012688, 0.072268115092742, 2.32170190031887, 0.177138315144646, 0.348477651608884, 0.161052630578922, 0.393193176722666, 1.1391650413338, 0.08139531644186, 0.476209340516188, 0.18276250189497, 0.345719568712117, 0.174898633040519, 0.080346083861554, 0.636664640334042, 0.0]]


mtmam_freqs = [0.0692, 0.0065, 0.0186, 0.0236, 0.0611, 0.0557, 0.0277, 0.0905, 0.0221, 0.1675, 0.0561, 0.04, 0.0536, 0.0238, 0.0184, 0.0725, 0.087, 0.0428, 0.0293, 0.034]
mtmam_matrix = [[0.0, 1e-06, 11.0, 1e-06, 1e-06, 78.0, 8.0, 75.0, 1e-06, 21.0, 76.0, 2.0, 53.0, 1e-06, 32.0, 342.0, 681.0, 398.0, 5.0, 1e-06], [1e-06, 0.0, 1e-06, 1e-06, 7.0, 1e-06, 305.0, 41.0, 1e-06, 27.0, 1e-06, 1e-06, 1e-06, 1e-06, 186.0, 347.0, 114.0, 1e-06, 65.0, 530.0], [11.0, 1e-06, 0.0, 569.0, 5.0, 79.0, 11.0, 1e-06, 1e-06, 1e-06, 1e-06, 864.0, 2.0, 49.0, 1e-06, 16.0, 1e-06, 10.0, 1e-06, 1e-06], [1e-06, 1e-06, 569.0, 0.0, 1e-06, 22.0, 22.0, 1e-06, 215.0, 1e-06, 1e-06, 1e-06, 1e-06, 274.0, 1e-06, 21.0, 4.0, 20.0, 1e-06, 1e-06], [1e-06, 7.0, 5.0, 1e-06, 0.0, 1e-06, 1e-06, 57.0, 1e-06, 246.0, 11.0, 6.0, 17.0, 1e-06, 1e-06, 90.0, 8.0, 6.0, 1e-06, 682.0], [78.0, 1e-06, 79.0, 22.0, 1e-06, 0.0, 1e-06, 1e-06, 1e-06, 1e-06, 1e-06, 47.0, 1e-06, 1e-06, 18.0, 112.0, 1e-06, 5.0, 1e-06, 1.0], [8.0, 305.0, 11.0, 22.0, 1e-06, 1e-06, 0.0, 1e-06, 1e-06, 26.0, 1e-06, 458.0, 53.0, 550.0, 232.0, 20.0, 1.0, 1e-06, 1e-06, 1525.0], [75.0, 41.0, 1e-06, 1e-06, 57.0, 1e-06, 1e-06, 0.0, 6.0, 232.0, 378.0, 19.0, 5.0, 1e-06, 1e-06, 1e-06, 360.0, 2220.0, 1e-06, 16.0], [1e-06, 1e-06, 1e-06, 215.0, 1e-06, 1e-06, 1e-06, 6.0, 0.0, 4.0, 59.0, 408.0, 18.0, 242.0, 50.0, 65.0, 50.0, 1e-06, 1e-06, 67.0], [21.0, 27.0, 1e-06, 1e-06, 246.0, 1e-06, 26.0, 232.0, 4.0, 0.0, 609.0, 1e-06, 43.0, 20.0, 6.0, 74.0, 34.0, 100.0, 12.0, 25.0], [76.0, 1e-06, 1e-06, 1e-06, 11.0, 1e-06, 1e-06, 378.0, 59.0, 609.0, 0.0, 21.0, 1e-06, 22.0, 1e-06, 47.0, 691.0, 832.0, 13.0, 1e-06], [2.0, 1e-06, 864.0, 1e-06, 6.0, 47.0, 458.0, 19.0, 408.0, 1e-06, 21.0, 0.0, 33.0, 8.0, 4.0, 446.0, 110.0, 1e-06, 6.0, 156.0], [53.0, 1e-06, 2.0, 1e-06, 17.0, 1e-06, 53.0, 5.0, 18.0, 43.0, 1e-06, 33.0, 0.0, 51.0, 9.0, 202.0, 78.0, 1e-06, 7.0, 8.0], [1e-06, 1e-06, 49.0, 274.0, 1e-06, 1e-06, 550.0, 1e-06, 242.0, 20.0, 22.0, 8.0, 51.0, 0.0, 246.0, 30.0, 1e-06, 33.0, 1e-06, 54.0], [32.0, 186.0, 1e-06, 1e-06, 1e-06, 18.0, 232.0, 1e-06, 50.0, 6.0, 1e-06, 4.0, 9.0, 246.0, 0.0, 3.0, 1e-06, 1e-06, 16.0, 1e-06], [342.0, 347.0, 16.0, 21.0, 90.0, 112.0, 20.0, 1e-06, 65.0, 74.0, 47.0, 446.0, 202.0, 30.0, 3.0, 0.0, 614.0, 1e-06, 17.0, 107.0], [681.0, 114.0, 1e-06, 4.0, 8.0, 1e-06, 1.0, 360.0, 50.0, 34.0, 691.0, 110.0, 78.0, 1e-06, 1e-06, 614.0, 0.0, 237.0, 1e-06, 1e-06], [398.0, 1e-06, 10.0, 20.0, 6.0, 5.0, 1e-06, 2220.0, 1e-06, 100.0, 832.0, 1e-06, 1e-06, 33.0, 1e-06, 1e-06, 237.0, 0.0, 1e-06, 1e-06], [5.0, 65.0, 1e-06, 1e-06, 1e-06, 1e-06, 1e-06, 1e-06, 1e-06, 12.0, 13.0, 6.0, 7.0, 1e-06, 16.0, 17.0, 1e-06, 1e-06, 0.0, 14.0], [1e-06, 530.0, 1e-06, 1e-06, 682.0, 1.0, 1525.0, 16.0, 67.0, 25.0, 1e-06, 156.0, 8.0, 54.0, 1e-06, 107.0, 1e-06, 1e-06, 14.0, 0.0]]


mtmet_freqs = [0.043793213137964, 0.011330503399151, 0.016899005069702, 0.022538506761552, 0.088448026534408, 0.047050114115034, 0.017183705155112, 0.089779426933828, 0.039913511974054, 0.155226046567814, 0.067444320233296, 0.057001317100395, 0.037528211258463, 0.018018105405432, 0.012957803887341, 0.093752228125668, 0.063579019073706, 0.053317415995225, 0.022671306801392, 0.041568212470464]
mtmet_matrix = [[0.0, 0.633255658023246, 0.119156819252943, 0.179163834250834, 0.062762236171324, 1.46586184024132, 0.030192120942361, 0.367600338719865, 0.020509501847148, 0.10987273303817, 0.653363796990802, 0.032893910131824, 0.408076930576884, 0.052454931263516, 0.058078177576542, 2.7716851834942, 6.73088314073445, 2.81516224045107, 0.01359999592, 0.014501402649578], [0.633255658023246, 0.0, 0.07739997678, 0.05059998482, 0.925810586256741, 0.914125315762323, 0.6039998188, 0.235804174258726, 0.01579999526, 0.299518907144301, 0.492339996297957, 0.2929999121, 0.02939999118, 0.152595162221438, 0.739813635055843, 3.28301388609554, 0.338668094399541, 1.39452762564159, 1.01841017947685, 1.96737066478862], [0.119156819252943, 0.07739997678, 0.0, 6.03378717186331, 0.01259999622, 0.63075310977401, 0.479790968062666, 0.010668852799343, 0.049007441297763, 0.005529142341257, 0.026109939167016, 4.65841867347398, 0.044609549617131, 0.131355662593289, 0.049700397089876, 0.360804672758566, 0.102136190359134, 0.084589003623291, 0.04089998773, 0.160289909913013], [0.179163834250834, 0.05059998482, 6.03378717186331, 0.0, 0.017716302685108, 0.768853064344011, 0.105414703375579, 0.0139999958, 1.37921736923467, 0.019157613252714, 0.128410015476984, 0.812240880327663, 0.04878628436411, 2.23661695201471, 0.080835456749356, 0.36310435706866, 0.134802630559199, 0.227826982651885, 0.086028769191362, 0.093214693035584], [0.062762236171324, 0.925810586256741, 0.01259999622, 0.017716302685108, 0.0, 0.068139260558216, 0.09035303989408, 0.750900315729838, 0.09709997087, 1.81110068966963, 0.748424772472501, 0.1389999583, 0.054271872718433, 0.026306317108103, 0.008039997588, 0.49934975119503, 0.053947726815677, 0.466243302126967, 0.330781828765422, 3.20908234027501], [1.46586184024132, 0.914125315762323, 0.63075310977401, 0.768853064344011, 0.068139260558216, 0.0, 0.025252648424203, 0.01379999586, 0.134187134743847, 0.027264545820634, 0.14533142240056, 0.543750593874773, 0.005914204225738, 0.072395514281339, 0.219967058009863, 1.74656962102896, 0.024558282632513, 0.417148828855314, 0.233963300810989, 0.046746326976098], [0.030192120942361, 0.6039998188, 0.479790968062666, 0.105414703375579, 0.09035303989408, 0.025252648424203, 0.0, 0.017140133857958, 0.135153622453901, 0.111638903508319, 0.032834304149706, 1.73867912239611, 0.519954219013687, 4.51844953546473, 1.52225640832294, 0.297585994724175, 0.221010542696817, 0.003511006946698, 0.03749998875, 3.90791737862443], [0.367600338719865, 0.235804174258726, 0.010668852799343, 0.0139999958, 0.750900315729838, 0.01379999586, 0.017140133857958, 0.0, 0.064936591519017, 1.89797379860769, 2.91835233249404, 0.24493469151957, 0.024850013544994, 0.008875683337294, 0.012428572271427, 0.096272835118141, 2.45345740696256, 10.9534225539722, 0.028656788402961, 0.135319420404162], [0.020509501847148, 0.01579999526, 0.049007441297763, 1.37921736923467, 0.09709997087, 0.134187134743847, 0.135153622453901, 0.064936591519017, 0.0, 0.061324501602644, 0.659310562206772, 2.53039767088047, 0.121234884629524, 1.82721763783454, 1.05718531584431, 0.695087919473562, 0.393851585844489, 0.05546141836157, 0.07349997795, 0.281699089490248], [0.10987273303817, 0.299518907144301, 0.005529142341257, 0.019157613252714, 1.81110068966963, 0.027264545820634, 0.111638903508319, 1.89797379860769, 0.061324501602644, 0.0, 3.42555268133389, 0.04629998611, 0.270260699921766, 0.25445239066426, 0.058179997545996, 0.311525037542461, 0.253366627989989, 0.958273455517877, 0.253242937027096, 0.1235552949334], [0.653363796990802, 0.492339996297957, 0.026109939167016, 0.128410015476984, 0.748424772472501, 0.14533142240056, 0.032834304149706, 2.91835233249404, 0.659310562206772, 3.42555268133389, 0.0, 0.399827603051683, 0.03269999019, 0.23709429487169, 0.01349402995179, 0.458733958379771, 3.03521481543528, 2.56248412625453, 0.167575267727405, 0.316598936020291], [0.032893910131824, 0.2929999121, 4.65841867347398, 0.812240880327663, 0.1389999583, 0.543750593874773, 1.73867912239611, 0.24493469151957, 2.53039767088047, 0.04629998611, 0.399827603051683, 0.0, 0.08029997591, 0.83279128316254, 0.141364232590718, 2.63437772368645, 0.961284804614472, 0.051741611477512, 0.0489999853, 1.02078518476435], [0.408076930576884, 0.02939999118, 0.044609549617131, 0.04878628436411, 0.054271872718433, 0.005914204225738, 0.519954219013687, 0.024850013544994, 0.121234884629524, 0.270260699921766, 0.03269999019, 0.08029997591, 0.0, 0.849512180146269, 0.15500851949743, 1.23118044964575, 0.734604689618527, 0.05407851677644, 0.02943385716984, 0.0539999838], [0.052454931263516, 0.152595162221438, 0.131355662593289, 2.23661695201471, 0.026306317108103, 0.072395514281339, 4.51844953546473, 0.008875683337294, 1.82721763783454, 0.25445239066426, 0.23709429487169, 0.83279128316254, 0.849512180146269, 0.0, 2.67310728706757, 0.384800168559915, 0.274195864741216, 0.02766922469923, 0.1229999631, 0.319105692268264], [0.058078177576542, 0.739813635055843, 0.049700397089876, 0.080835456749356, 0.008039997588, 0.219967058009863, 1.52225640832294, 0.012428572271427, 1.05718531584431, 0.058179997545996, 0.01349402995179, 0.141364232590718, 0.15500851949743, 2.67310728706757, 0.0, 0.197379125786245, 0.056079796176056, 0.041063671680895, 0.370819780754032, 0.1275192937442], [2.7716851834942, 3.28301388609554, 0.360804672758566, 0.36310435706866, 0.49934975119503, 1.74656962102896, 0.297585994724175, 0.096272835118141, 0.695087919473562, 0.311525037542461, 0.458733958379771, 2.63437772368645, 1.23118044964575, 0.384800168559915, 0.197379125786245, 0.0, 3.11474197257713, 0.26710938486716, 0.169211978236391, 0.374184173744714], [6.73088314073445, 0.338668094399541, 0.102136190359134, 0.134802630559199, 0.053947726815677, 0.024558282632513, 0.221010542696817, 2.45345740696256, 0.393851585844489, 0.253366627989989, 3.03521481543528, 0.961284804614472, 0.734604689618527, 0.274195864741216, 0.056079796176056, 3.11474197257713, 0.0, 1.5140592197821, 0.014378611686415, 0.091031759690464], [2.81516224045107, 1.39452762564159, 0.084589003623291, 0.227826982651885, 0.466243302126967, 0.417148828855314, 0.003511006946698, 10.9534225539722, 0.05546141836157, 0.958273455517877, 2.56248412625453, 0.051741611477512, 0.05407851677644, 0.02766922469923, 0.041063671680895, 0.26710938486716, 1.5140592197821, 0.0, 0.093136228059123, 0.069964519010638], [0.01359999592, 1.01841017947685, 0.04089998773, 0.086028769191362, 0.330781828765422, 0.233963300810989, 0.03749998875, 0.028656788402961, 0.07349997795, 0.253242937027096, 0.167575267727405, 0.0489999853, 0.02943385716984, 0.1229999631, 0.370819780754032, 0.169211978236391, 0.014378611686415, 0.093136228059123, 0.0, 0.481044171686705], [0.014501402649578, 1.96737066478862, 0.160289909913013, 0.093214693035584, 3.20908234027501, 0.046746326976098, 3.90791737862443, 0.135319420404162, 0.281699089490248, 0.1235552949334, 0.316598936020291, 1.02078518476435, 0.0539999838, 0.319105692268264, 0.1275192937442, 0.374184173744714, 0.091031759690464, 0.069964519010638, 0.481044171686705, 0.0]]


mtrev24_freqs = [0.072, 0.006, 0.019, 0.024, 0.061, 0.056, 0.028, 0.088, 0.023, 0.169, 0.054, 0.039, 0.054, 0.025, 0.019, 0.072, 0.086, 0.043, 0.029, 0.033]
mtrev24_matrix = [[0.0, 59.93, 17.67, 9.77, 6.37, 120.71, 13.9, 96.49, 8.36, 25.46, 141.88, 26.95, 54.31, 1.9, 23.18, 387.86, 480.72, 195.06, 1.9, 6.48], [59.93, 0.0, 1.9, 1.9, 70.8, 30.71, 141.49, 62.73, 1.9, 25.65, 6.18, 58.94, 31.26, 75.24, 103.33, 277.05, 179.97, 1.9, 33.6, 254.77], [17.67, 1.9, 0.0, 583.55, 4.98, 56.77, 113.99, 4.34, 2.31, 1.9, 1.9, 794.38, 13.43, 55.28, 1.9, 69.02, 28.01, 1.9, 19.86, 21.21], [9.77, 1.9, 583.55, 0.0, 2.67, 28.28, 49.12, 3.31, 313.86, 1.9, 1.9, 63.05, 12.83, 313.56, 1.9, 54.71, 14.82, 21.14, 1.9, 13.12], [6.37, 70.8, 4.98, 2.67, 0.0, 1.9, 48.16, 84.67, 6.44, 216.06, 90.82, 15.2, 17.31, 19.11, 4.69, 64.29, 33.85, 6.35, 7.84, 465.58], [120.71, 30.71, 56.77, 28.28, 1.9, 0.0, 1.9, 5.98, 22.73, 2.41, 1.9, 53.3, 1.9, 6.75, 23.03, 125.93, 11.17, 2.53, 10.92, 3.21], [13.9, 141.49, 113.99, 49.12, 48.16, 1.9, 0.0, 12.26, 127.67, 11.49, 11.97, 496.13, 60.97, 582.4, 165.23, 77.46, 44.78, 1.9, 7.08, 670.14], [96.49, 62.73, 4.34, 3.31, 84.67, 5.98, 12.26, 0.0, 19.57, 329.09, 517.98, 27.1, 20.63, 8.34, 1.9, 47.7, 368.43, 1222.94, 1.9, 25.01], [8.36, 1.9, 2.31, 313.86, 6.44, 22.73, 127.67, 19.57, 0.0, 14.88, 91.37, 608.7, 50.1, 465.58, 141.4, 105.79, 136.33, 1.9, 24.0, 51.17], [25.46, 25.65, 1.9, 1.9, 216.06, 2.41, 11.49, 329.09, 14.88, 0.0, 537.53, 15.16, 40.1, 39.7, 15.58, 73.61, 126.4, 91.67, 32.44, 44.15], [141.88, 6.18, 1.9, 1.9, 90.82, 1.9, 11.97, 517.98, 91.37, 537.53, 0.0, 65.41, 18.84, 47.37, 1.9, 111.16, 528.17, 387.54, 21.71, 39.96], [26.95, 58.94, 794.38, 63.05, 15.2, 53.3, 496.13, 27.1, 608.7, 15.16, 65.41, 0.0, 73.31, 173.56, 13.24, 494.39, 238.46, 1.9, 10.68, 191.36], [54.31, 31.26, 13.43, 12.83, 17.31, 1.9, 60.97, 20.63, 50.1, 40.1, 18.84, 73.31, 0.0, 137.29, 23.64, 169.9, 128.22, 8.23, 4.21, 16.21], [1.9, 75.24, 55.28, 313.56, 19.11, 6.75, 582.4, 8.34, 465.58, 39.7, 47.37, 173.56, 137.29, 0.0, 220.99, 54.11, 94.93, 19.0, 1.9, 38.82], [23.18, 103.33, 1.9, 1.9, 4.69, 23.03, 165.23, 1.9, 141.4, 15.58, 1.9, 13.24, 23.64, 220.99, 0.0, 6.04, 2.08, 7.64, 21.95, 1.9], [387.86, 277.05, 69.02, 54.71, 64.29, 125.93, 77.46, 47.7, 105.79, 73.61, 111.16, 494.39, 169.9, 54.11, 6.04, 0.0, 597.21, 1.9, 38.58, 64.92], [480.72, 179.97, 28.01, 14.82, 33.85, 11.17, 44.78, 368.43, 136.33, 126.4, 528.17, 238.46, 128.22, 94.93, 2.08, 597.21, 0.0, 204.54, 9.99, 38.73], [195.06, 1.9, 1.9, 21.14, 6.35, 2.53, 1.9, 1222.94, 1.9, 91.67, 387.54, 1.9, 8.23, 19.0, 7.64, 1.9, 204.54, 0.0, 5.37, 1.9], [1.9, 33.6, 19.86, 1.9, 7.84, 10.92, 7.08, 1.9, 24.0, 32.44, 21.71, 10.68, 4.21, 1.9, 21.95, 38.58, 9.99, 5.37, 0.0, 26.25], [6.48, 254.77, 21.21, 13.12, 465.58, 3.21, 670.14, 25.01, 51.17, 44.15, 39.96, 191.36, 16.21, 38.82, 1.9, 64.92, 38.73, 1.9, 26.25, 0.0]]


mtver_freqs = [0.070820264589868, 0.006814196592902, 0.014793692603154, 0.021495189252405, 0.049775775112112, 0.044239977880011, 0.024230987884506, 0.090735054632473, 0.027381186309407, 0.172309913845043, 0.056193971903014, 0.045209877395061, 0.054386272806864, 0.026340886829557, 0.014049892975054, 0.074421862789069, 0.108809945595027, 0.045853677073162, 0.025652687173656, 0.026484686757657]
mtver_matrix = [[0.0, 0.246553724276801, 0.159447300723611, 0.191894227947066, 0.064446525223247, 1.0942009391002, 0.023294179647084, 0.412485044242419, 0.020785858392924, 0.078175506087734, 0.751880839940232, 0.032311373155679, 0.285569393784626, 0.030870542435264, 0.064684593342281, 2.48181789490833, 5.56270161234942, 3.19693807046824, 0.00842000421, 0.012484943242469], [0.246553724276801, 0.0, 0.1210000605, 0.0364000182, 1.07195028797488, 0.916865240432391, 1.4000007, 0.067512580756274, 0.0248000124, 0.170993012496464, 0.084565948282953, 0.336000168, 0.01890000945, 0.116173343086643, 1.22366768383354, 3.35914875457354, 0.152312893156409, 0.38186013092997, 1.77885974342943, 5.24821958310848], [0.159447300723611, 0.1210000605, 0.0, 6.60363863281767, 0.005850002925, 0.99925693962822, 0.818112173055882, 0.002450024225012, 0.01952784976392, 0.002303982151991, 0.005454655727327, 8.76049710424636, 0.027518484759236, 0.083338219669089, 0.060872136436053, 0.371726663863239, 0.090462201231078, 0.128208017103977, 0.02690001345, 0.186328057163982], [0.191894227947066, 0.0364000182, 6.60363863281767, 0.0, 0.00033294016647, 1.1627159783577, 0.081141411570686, 0.001250000625, 2.1541796840893, 0.007547828773913, 0.064939181469575, 0.335734154866994, 0.027495640747814, 2.01814389707144, 0.094355879177916, 0.097749778874865, 0.095055222527588, 0.21626094813042, 0.06234139117068, 0.037356125678054], [0.064446525223247, 1.07195028797488, 0.005850002925, 0.00033294016647, 0.0, 0.015567819783906, 0.173363959681937, 0.516016662008202, 0.0104000052, 2.40341945970913, 0.123894605947272, 0.01030000515, 0.070221307110636, 0.012628428314211, 0.00248000124, 0.886724514362035, 0.061993007996489, 0.336159506079669, 0.091906956953456, 3.98726086262944], [1.0942009391002, 0.916865240432391, 0.99925693962822, 1.1627159783577, 0.015567819783906, 0.0, 0.013333256666625, 0.00312000156, 0.106373697186822, 0.007030631515314, 0.034441699220841, 0.566907089453403, 0.001858863929432, 0.042512995256487, 0.29247126723556, 1.2472836256415, 0.008518901259449, 0.442992988496384, 0.258646151323011, 0.021047207523599], [0.023294179647084, 1.4000007, 0.818112173055882, 0.081141411570686, 0.173363959681937, 0.013333256666625, 0.0, 0.022239993119991, 0.176407170203541, 0.148659642329784, 0.024341806170897, 2.46227166313522, 0.679485296742479, 4.28273355936571, 2.20473565536728, 0.445289314644546, 0.150502737251331, 0.00275996137998, 0.0306000153, 9.17581243690393], [0.412485044242419, 0.067512580756274, 0.002450024225012, 0.001250000625, 0.516016662008202, 0.00312000156, 0.022239993119991, 0.0, 0.005826060913029, 1.37898192149062, 2.70908527054196, 0.126395609197773, 0.018484697242344, 0.004179092089545, 0.001173176586588, 0.044145011072495, 2.43917856158867, 13.5051442325687, 0.00190113995057, 0.045429850714914], [0.020785858392924, 0.0248000124, 0.01952784976392, 2.1541796840893, 0.0104000052, 0.106373697186822, 0.176407170203541, 0.005826060913029, 0.0, 0.022236503118246, 0.440831886415833, 2.45822387511132, 0.141827309913619, 2.00170557385229, 0.418858706429249, 0.187506484753196, 0.399752584876193, 0.025253726626857, 0.0294000147, 0.062036757018363], [0.078175506087734, 0.170993012496464, 0.002303982151991, 0.007547828773913, 2.40341945970913, 0.007030631515314, 0.148659642329784, 1.37898192149062, 0.022236503118246, 0.0, 3.10254928527387, 0.00452000226, 0.366808261404039, 0.25158378479183, 0.078821952410957, 0.440667041333411, 0.173310979655447, 0.856259496129534, 0.186367686183797, 0.103344604672277], [0.751880839940232, 0.084565948282953, 0.005454655727327, 0.064939181469575, 0.123894605947272, 0.034441699220841, 0.024341806170897, 2.70908527054196, 0.440831886415833, 3.10254928527387, 0.0, 0.036342279171131, 0.03090001545, 0.118300117150029, 0.003339427669713, 0.137172898586415, 3.73680650940232, 4.49932602066189, 0.056840260420116, 0.079617080808521], [0.032311373155679, 0.336000168, 8.76049710424636, 0.335734154866994, 0.01030000515, 0.566907089453403, 2.46227166313522, 0.126395609197773, 2.45822387511132, 0.00452000226, 0.036342279171131, 0.0, 0.03450001725, 0.392967223483514, 0.153152767576346, 3.85477709838759, 0.865443620721594, 0.013796210898102, 0.00668000334, 0.85696980948469], [0.285569393784626, 0.01890000945, 0.027518484759236, 0.027495640747814, 0.070221307110636, 0.001858863929432, 0.679485296742479, 0.018484697242344, 0.141827309913619, 0.366808261404039, 0.03090001545, 0.03450001725, 0.0, 0.918408714204128, 0.223106325553107, 1.96139566969734, 0.573808396904055, 0.025768082884035, 0.02000890900445, 0.07190003595], [0.030870542435264, 0.116173343086643, 0.083338219669089, 2.01814389707144, 0.012628428314211, 0.042512995256487, 4.28273355936571, 0.004179092089545, 2.00170557385229, 0.25158378479183, 0.118300117150029, 0.392967223483514, 0.918408714204128, 0.0, 3.17038713919278, 0.243906745953312, 0.113601717800831, 0.010633051316523, 0.124000062, 0.228833221416554], [0.064684593342281, 1.22366768383354, 0.060872136436053, 0.094355879177916, 0.00248000124, 0.29247126723556, 2.20473565536728, 0.001173176586588, 0.418858706429249, 0.078821952410957, 0.003339427669713, 0.153152767576346, 0.223106325553107, 3.17038713919278, 0.0, 0.135104231552082, 0.028643207321597, 0.037629752814867, 0.558540909270315, 0.14634275217134], [2.48181789490833, 3.35914875457354, 0.371726663863239, 0.097749778874865, 0.886724514362035, 1.2472836256415, 0.445289314644546, 0.044145011072495, 0.187506484753196, 0.440667041333411, 0.137172898586415, 3.85477709838759, 1.96139566969734, 0.243906745953312, 0.135104231552082, 0.0, 2.84537355068606, 0.058280992140482, 0.144081317040623, 0.543167000583365], [5.56270161234942, 0.152312893156409, 0.090462201231078, 0.095055222527588, 0.061993007996489, 0.008518901259449, 0.150502737251331, 2.43917856158867, 0.399752584876193, 0.173310979655447, 3.73680650940232, 0.865443620721594, 0.573808396904055, 0.113601717800831, 0.028643207321597, 2.84537355068606, 0.0, 1.31793099596517, 0.003186142593071, 0.084368299184129], [3.19693807046824, 0.38186013092997, 0.128208017103977, 0.21626094813042, 0.336159506079669, 0.442992988496384, 0.00275996137998, 13.5051442325687, 0.025253726626857, 0.856259496129534, 4.49932602066189, 0.013796210898102, 0.025768082884035, 0.010633051316523, 0.037629752814867, 0.058280992140482, 1.31793099596517, 0.0, 0.047174784587381, 0.028686388343187], [0.00842000421, 1.77885974342943, 0.02690001345, 0.06234139117068, 0.091906956953456, 0.258646151323011, 0.0306000153, 0.00190113995057, 0.0294000147, 0.186367686183797, 0.056840260420116, 0.00668000334, 0.02000890900445, 0.124000062, 0.558540909270315, 0.144081317040623, 0.003186142593071, 0.047174784587381, 0.0, 0.288348349174103], [0.012484943242469, 5.24821958310848, 0.186328057163982, 0.037356125678054, 3.98726086262944, 0.021047207523599, 9.17581243690393, 0.045429850714914, 0.062036757018363, 0.103344604672277, 0.079617080808521, 0.85696980948469, 0.07190003595, 0.228833221416554, 0.14634275217134, 0.543167000583365, 0.084368299184129, 0.028686388343187, 0.288348349174103, 0.0]]


rtrev_freqs = [0.0646, 0.0114, 0.0422, 0.0607, 0.0287, 0.0639, 0.0273, 0.0679, 0.0751, 0.1018, 0.015, 0.0376, 0.0681, 0.0606, 0.0453, 0.0488, 0.0622, 0.0619, 0.0251, 0.0318]
rtrev_matrix = [[0.0, 439.0, 10.0, 81.0, 1.0, 135.0, 30.0, 1.0, 38.0, 45.0, 235.0, 51.0, 97.0, 32.0, 34.0, 460.0, 258.0, 197.0, 5.0, 55.0], [439.0, 0.0, 1.0, 1.0, 70.0, 48.0, 124.0, 104.0, 16.0, 110.0, 156.0, 128.0, 1.0, 70.0, 92.0, 75.0, 117.0, 295.0, 55.0, 131.0], [10.0, 1.0, 0.0, 542.0, 1.0, 61.0, 91.0, 1.0, 20.0, 5.0, 1.0, 384.0, 55.0, 78.0, 30.0, 136.0, 55.0, 6.0, 1.0, 1.0], [81.0, 1.0, 542.0, 0.0, 1.0, 70.0, 34.0, 1.0, 141.0, 21.0, 1.0, 79.0, 52.0, 372.0, 10.0, 95.0, 82.0, 35.0, 17.0, 1.0], [1.0, 70.0, 1.0, 1.0, 0.0, 7.0, 141.0, 64.0, 14.0, 179.0, 247.0, 49.0, 11.0, 1.0, 7.0, 20.0, 69.0, 92.0, 182.0, 1017.0], [135.0, 48.0, 61.0, 70.0, 7.0, 0.0, 68.0, 1.0, 30.0, 3.0, 37.0, 94.0, 17.0, 18.0, 41.0, 152.0, 7.0, 3.0, 23.0, 21.0], [30.0, 124.0, 91.0, 34.0, 141.0, 68.0, 0.0, 34.0, 76.0, 51.0, 116.0, 320.0, 44.0, 387.0, 90.0, 183.0, 49.0, 1.0, 48.0, 307.0], [1.0, 104.0, 1.0, 1.0, 64.0, 1.0, 34.0, 0.0, 34.0, 385.0, 375.0, 35.0, 10.0, 33.0, 24.0, 4.0, 72.0, 1048.0, 39.0, 26.0], [38.0, 16.0, 20.0, 141.0, 14.0, 30.0, 76.0, 34.0, 0.0, 23.0, 134.0, 123.0, 43.0, 309.0, 593.0, 77.0, 110.0, 19.0, 6.0, 1.0], [45.0, 110.0, 5.0, 21.0, 179.0, 3.0, 51.0, 385.0, 23.0, 0.0, 581.0, 15.0, 22.0, 54.0, 18.0, 24.0, 25.0, 112.0, 47.0, 64.0], [235.0, 156.0, 1.0, 1.0, 247.0, 37.0, 116.0, 375.0, 134.0, 581.0, 0.0, 1.0, 1.0, 158.0, 57.0, 1.0, 131.0, 236.0, 111.0, 74.0], [51.0, 128.0, 384.0, 79.0, 49.0, 94.0, 320.0, 35.0, 123.0, 15.0, 1.0, 0.0, 33.0, 236.0, 35.0, 294.0, 148.0, 21.0, 16.0, 28.0], [97.0, 1.0, 55.0, 52.0, 11.0, 17.0, 44.0, 10.0, 43.0, 22.0, 1.0, 33.0, 0.0, 68.0, 24.0, 134.0, 62.0, 25.0, 9.0, 14.0], [32.0, 70.0, 78.0, 372.0, 1.0, 18.0, 387.0, 33.0, 309.0, 54.0, 158.0, 236.0, 68.0, 0.0, 221.0, 225.0, 146.0, 36.0, 10.0, 45.0], [34.0, 92.0, 30.0, 10.0, 7.0, 41.0, 90.0, 24.0, 593.0, 18.0, 57.0, 35.0, 24.0, 221.0, 0.0, 102.0, 64.0, 29.0, 13.0, 47.0], [460.0, 75.0, 136.0, 95.0, 20.0, 152.0, 183.0, 4.0, 77.0, 24.0, 1.0, 294.0, 134.0, 225.0, 102.0, 0.0, 671.0, 39.0, 14.0, 31.0], [258.0, 117.0, 55.0, 82.0, 69.0, 7.0, 49.0, 72.0, 110.0, 25.0, 131.0, 148.0, 62.0, 146.0, 64.0, 671.0, 0.0, 196.0, 1.0, 34.0], [197.0, 295.0, 6.0, 35.0, 92.0, 3.0, 1.0, 1048.0, 19.0, 112.0, 236.0, 21.0, 25.0, 36.0, 29.0, 39.0, 196.0, 0.0, 26.0, 59.0], [5.0, 55.0, 1.0, 17.0, 182.0, 23.0, 48.0, 39.0, 6.0, 47.0, 111.0, 16.0, 9.0, 10.0, 13.0, 14.0, 1.0, 26.0, 0.0, 176.0], [55.0, 131.0, 1.0, 1.0, 1017.0, 21.0, 307.0, 26.0, 1.0, 64.0, 74.0, 28.0, 14.0, 45.0, 47.0, 31.0, 34.0, 59.0, 176.0, 0.0]]




jc69_freqs = [0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05]
jc69_matrix = [0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.]


poisson_freqs = [0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05]
poisson_matrix = [0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0, 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0., 1.0],[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.]


gcprev_matrix = [[0.0, 699.4, 87.7, 288.3, 59.3, 677.9, 32.0, 39.5, 78.3, 33.8, 197.1, 59.1, 505.8, 199.5, 12.2, 2443.9, 1646.2, 1143.8, 30.0, 27.9], [699.4, 0.0, 125.3, 102.4, 1540.1, 433.6, 574.8, 96.0, 89.2, 446.5, 288.5, 133.7, 124.9, 195.1, 1867.9, 3029.8, 516.8, 722.2, 562.6, 1571.2], [87.7, 125.3, 0.0, 3638.7, 15.9, 464.8, 527.7, 16.8, 78.3, 8.7, 33.1, 5083.8, 43.6, 387.6, 40.6, 142.1, 66.1, 18.5, 35.0, 272.1], [288.3, 102.4, 3638.7, 0.0, 30.7, 393.8, 144.6, 23.4, 1870.9, 26.8, 33.3, 230.9, 39.4, 2965.3, 51.9, 156.7, 230.0, 103.8, 57.2, 79.2], [59.3, 1540.1, 15.9, 30.7, 0.0, 10.1, 87.2, 354.4, 9.0, 1585.8, 183.4, 13.4, 82.1, 10.7, 26.1, 790.5, 29.8, 180.6, 558.3, 2360.2], [677.9, 433.6, 464.8, 393.8, 10.1, 0.0, 35.6, 11.8, 193.4, 4.3, 11.8, 446.5, 11.8, 40.8, 391.2, 709.0, 65.5, 72.6, 92.6, 20.6], [32.0, 574.8, 527.7, 144.6, 87.2, 35.6, 0.0, 38.1, 96.9, 46.1, 54.5, 2156.8, 185.1, 1889.6, 1228.7, 277.0, 77.1, 22.8, 58.5, 4117.5], [39.5, 96.0, 16.8, 23.4, 354.4, 11.8, 38.1, 0.0, 125.7, 1657.9, 2493.4, 146.0, 63.1, 48.5, 105.4, 75.6, 1227.2, 6006.5, 21.1, 35.8], [78.3, 89.2, 78.3, 1870.9, 9.0, 193.4, 96.9, 125.7, 0.0, 37.6, 220.1, 1930.8, 49.8, 2571.2, 4666.4, 209.3, 648.5, 66.2, 15.9, 84.2], [33.8, 446.5, 8.7, 26.8, 1585.8, 4.3, 46.1, 1657.9, 37.6, 0.0, 1389.6, 11.6, 347.7, 235.4, 124.9, 584.9, 62.9, 661.7, 218.2, 82.0], [197.1, 288.5, 33.1, 33.3, 183.4, 11.8, 54.5, 2493.4, 220.1, 1389.6, 0.0, 41.4, 19.2, 341.8, 112.1, 32.9, 1143.5, 465.7, 70.5, 41.1], [59.1, 133.7, 5083.8, 230.9, 13.4, 446.5, 2156.8, 146.0, 1930.8, 11.6, 41.4, 0.0, 18.7, 827.8, 313.0, 2505.4, 1373.3, 27.6, 19.9, 316.2], [505.8, 124.9, 43.6, 39.4, 82.1, 11.8, 185.1, 63.1, 49.8, 347.7, 19.2, 18.7, 0.0, 223.1, 89.4, 1154.5, 322.8, 75.5, 18.5, 15.8], [199.5, 195.1, 387.6, 2965.3, 10.7, 40.8, 1889.6, 48.5, 2571.2, 235.4, 341.8, 827.8, 223.1, 0.0, 2321.3, 246.9, 128.5, 50.2, 24.6, 179.1], [12.2, 1867.9, 40.6, 51.9, 26.1, 391.2, 1228.7, 105.4, 4666.4, 124.9, 112.1, 313.0, 89.4, 2321.3, 0.0, 269.6, 173.4, 62.0, 257.8, 137.0], [2443.9, 3029.8, 142.1, 156.7, 790.5, 709.0, 277.0, 75.6, 209.3, 584.9, 32.9, 2505.4, 1154.5, 246.9, 269.6, 0.0, 2042.5, 61.2, 102.6, 501.9], [1646.2, 516.8, 66.1, 230.0, 29.8, 65.5, 77.1, 1227.2, 648.5, 62.9, 1143.5, 1373.3, 322.8, 128.5, 173.4, 2042.5, 0.0, 583.7, 22.0, 64.6], [1143.8, 722.2, 18.5, 103.8, 180.6, 72.6, 22.8, 6006.5, 66.2, 661.7, 465.7, 27.6, 75.5, 50.2, 62.0, 61.2, 583.7, 0.0, 10.8, 37.3], [30.0, 562.6, 35.0, 57.2, 558.3, 92.6, 58.5, 21.1, 15.9, 218.2, 70.5, 19.9, 18.5, 24.6, 257.8, 102.6, 22.0, 10.8, 0.0, 296.3], [27.9, 1571.2, 272.1, 79.2, 2360.2, 20.6, 4117.5, 35.8, 84.2, 82.0, 41.1, 316.2, 15.8, 179.1, 137.0, 501.9, 64.6, 37.3, 296.3, 0.0]]
gcprev_freqs = [0.07951, 0.009051, 0.03322, 0.049675, 0.047731, 0.080233, 0.02188, 0.080496, 0.049324, 0.107512, 0.020776, 0.040459, 0.039916, 0.037505, 0.056001, 0.07382, 0.053615, 0.071781, 0.016705, 0.03079]


