import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BatchPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#account_name BatchPool#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#display_name BatchPool#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#id BatchPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#max_tasks_per_node BatchPool#max_tasks_per_node}
    */
    readonly maxTasksPerNode?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#metadata BatchPool#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#name BatchPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#node_agent_sku_id BatchPool#node_agent_sku_id}
    */
    readonly nodeAgentSkuId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#resource_group_name BatchPool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#stop_pending_resize_operation BatchPool#stop_pending_resize_operation}
    */
    readonly stopPendingResizeOperation?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#vm_size BatchPool#vm_size}
    */
    readonly vmSize: string;
    /**
    * auto_scale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#auto_scale BatchPool#auto_scale}
    */
    readonly autoScale?: BatchPoolAutoScale;
    /**
    * certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#certificate BatchPool#certificate}
    */
    readonly certificate?: BatchPoolCertificate[] | cdktf.IResolvable;
    /**
    * container_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#container_configuration BatchPool#container_configuration}
    */
    readonly containerConfiguration?: BatchPoolContainerConfiguration;
    /**
    * fixed_scale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#fixed_scale BatchPool#fixed_scale}
    */
    readonly fixedScale?: BatchPoolFixedScale;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#identity BatchPool#identity}
    */
    readonly identity?: BatchPoolIdentity;
    /**
    * network_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#network_configuration BatchPool#network_configuration}
    */
    readonly networkConfiguration?: BatchPoolNetworkConfiguration;
    /**
    * start_task block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#start_task BatchPool#start_task}
    */
    readonly startTask?: BatchPoolStartTask;
    /**
    * storage_image_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#storage_image_reference BatchPool#storage_image_reference}
    */
    readonly storageImageReference: BatchPoolStorageImageReference;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#timeouts BatchPool#timeouts}
    */
    readonly timeouts?: BatchPoolTimeouts;
}
export interface BatchPoolAutoScale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#evaluation_interval BatchPool#evaluation_interval}
    */
    readonly evaluationInterval?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#formula BatchPool#formula}
    */
    readonly formula: string;
}
export declare function batchPoolAutoScaleToTerraform(struct?: BatchPoolAutoScaleOutputReference | BatchPoolAutoScale): any;
export declare class BatchPoolAutoScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolAutoScale | undefined;
    set internalValue(value: BatchPoolAutoScale | undefined);
    private _evaluationInterval?;
    get evaluationInterval(): string;
    set evaluationInterval(value: string);
    resetEvaluationInterval(): void;
    get evaluationIntervalInput(): string | undefined;
    private _formula?;
    get formula(): string;
    set formula(value: string);
    get formulaInput(): string | undefined;
}
export interface BatchPoolCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#id BatchPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#store_location BatchPool#store_location}
    */
    readonly storeLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#store_name BatchPool#store_name}
    */
    readonly storeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#visibility BatchPool#visibility}
    */
    readonly visibility?: string[];
}
export declare function batchPoolCertificateToTerraform(struct?: BatchPoolCertificate | cdktf.IResolvable): any;
export declare class BatchPoolCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolCertificate | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _storeLocation?;
    get storeLocation(): string;
    set storeLocation(value: string);
    get storeLocationInput(): string | undefined;
    private _storeName?;
    get storeName(): string;
    set storeName(value: string);
    resetStoreName(): void;
    get storeNameInput(): string | undefined;
    private _visibility?;
    get visibility(): string[];
    set visibility(value: string[]);
    resetVisibility(): void;
    get visibilityInput(): string[] | undefined;
}
export declare class BatchPoolCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolCertificateOutputReference;
}
export interface BatchPoolContainerConfigurationContainerRegistries {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#password BatchPool#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#registry_server BatchPool#registry_server}
    */
    readonly registryServer?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#user_assigned_identity_id BatchPool#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#user_name BatchPool#user_name}
    */
    readonly userName?: string;
}
export declare function batchPoolContainerConfigurationContainerRegistriesToTerraform(struct?: BatchPoolContainerConfigurationContainerRegistries | cdktf.IResolvable): any;
export declare class BatchPoolContainerConfigurationContainerRegistriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolContainerConfigurationContainerRegistries | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolContainerConfigurationContainerRegistries | cdktf.IResolvable | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _registryServer?;
    get registryServer(): string;
    set registryServer(value: string);
    resetRegistryServer(): void;
    get registryServerInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
}
export declare class BatchPoolContainerConfigurationContainerRegistriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolContainerConfigurationContainerRegistries[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolContainerConfigurationContainerRegistriesOutputReference;
}
export interface BatchPoolContainerConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#container_image_names BatchPool#container_image_names}
    */
    readonly containerImageNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#container_registries BatchPool#container_registries}
    */
    readonly containerRegistries?: BatchPoolContainerConfigurationContainerRegistries[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#type BatchPool#type}
    */
    readonly type?: string;
}
export declare function batchPoolContainerConfigurationToTerraform(struct?: BatchPoolContainerConfigurationOutputReference | BatchPoolContainerConfiguration): any;
export declare class BatchPoolContainerConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolContainerConfiguration | undefined;
    set internalValue(value: BatchPoolContainerConfiguration | undefined);
    private _containerImageNames?;
    get containerImageNames(): string[];
    set containerImageNames(value: string[]);
    resetContainerImageNames(): void;
    get containerImageNamesInput(): string[] | undefined;
    private _containerRegistries;
    get containerRegistries(): BatchPoolContainerConfigurationContainerRegistriesList;
    putContainerRegistries(value: BatchPoolContainerConfigurationContainerRegistries[] | cdktf.IResolvable): void;
    resetContainerRegistries(): void;
    get containerRegistriesInput(): cdktf.IResolvable | BatchPoolContainerConfigurationContainerRegistries[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface BatchPoolFixedScale {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#resize_timeout BatchPool#resize_timeout}
    */
    readonly resizeTimeout?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#target_dedicated_nodes BatchPool#target_dedicated_nodes}
    */
    readonly targetDedicatedNodes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#target_low_priority_nodes BatchPool#target_low_priority_nodes}
    */
    readonly targetLowPriorityNodes?: number;
}
export declare function batchPoolFixedScaleToTerraform(struct?: BatchPoolFixedScaleOutputReference | BatchPoolFixedScale): any;
export declare class BatchPoolFixedScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolFixedScale | undefined;
    set internalValue(value: BatchPoolFixedScale | undefined);
    private _resizeTimeout?;
    get resizeTimeout(): string;
    set resizeTimeout(value: string);
    resetResizeTimeout(): void;
    get resizeTimeoutInput(): string | undefined;
    private _targetDedicatedNodes?;
    get targetDedicatedNodes(): number;
    set targetDedicatedNodes(value: number);
    resetTargetDedicatedNodes(): void;
    get targetDedicatedNodesInput(): number | undefined;
    private _targetLowPriorityNodes?;
    get targetLowPriorityNodes(): number;
    set targetLowPriorityNodes(value: number);
    resetTargetLowPriorityNodes(): void;
    get targetLowPriorityNodesInput(): number | undefined;
}
export interface BatchPoolIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#identity_ids BatchPool#identity_ids}
    */
    readonly identityIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#type BatchPool#type}
    */
    readonly type: string;
}
export declare function batchPoolIdentityToTerraform(struct?: BatchPoolIdentityOutputReference | BatchPoolIdentity): any;
export declare class BatchPoolIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolIdentity | undefined;
    set internalValue(value: BatchPoolIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    get identityIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#access BatchPool#access}
    */
    readonly access: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#priority BatchPool#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#source_address_prefix BatchPool#source_address_prefix}
    */
    readonly sourceAddressPrefix: string;
}
export declare function batchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesToTerraform(struct?: BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules | cdktf.IResolvable): any;
export declare class BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules | cdktf.IResolvable | undefined);
    private _access?;
    get access(): string;
    set access(value: string);
    get accessInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _sourceAddressPrefix?;
    get sourceAddressPrefix(): string;
    set sourceAddressPrefix(value: string);
    get sourceAddressPrefixInput(): string | undefined;
}
export declare class BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesOutputReference;
}
export interface BatchPoolNetworkConfigurationEndpointConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#backend_port BatchPool#backend_port}
    */
    readonly backendPort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#frontend_port_range BatchPool#frontend_port_range}
    */
    readonly frontendPortRange: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#name BatchPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#protocol BatchPool#protocol}
    */
    readonly protocol: string;
    /**
    * network_security_group_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#network_security_group_rules BatchPool#network_security_group_rules}
    */
    readonly networkSecurityGroupRules?: BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules[] | cdktf.IResolvable;
}
export declare function batchPoolNetworkConfigurationEndpointConfigurationToTerraform(struct?: BatchPoolNetworkConfigurationEndpointConfiguration | cdktf.IResolvable): any;
export declare class BatchPoolNetworkConfigurationEndpointConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolNetworkConfigurationEndpointConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolNetworkConfigurationEndpointConfiguration | cdktf.IResolvable | undefined);
    private _backendPort?;
    get backendPort(): number;
    set backendPort(value: number);
    get backendPortInput(): number | undefined;
    private _frontendPortRange?;
    get frontendPortRange(): string;
    set frontendPortRange(value: string);
    get frontendPortRangeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _networkSecurityGroupRules;
    get networkSecurityGroupRules(): BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesList;
    putNetworkSecurityGroupRules(value: BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules[] | cdktf.IResolvable): void;
    resetNetworkSecurityGroupRules(): void;
    get networkSecurityGroupRulesInput(): cdktf.IResolvable | BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules[] | undefined;
}
export declare class BatchPoolNetworkConfigurationEndpointConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolNetworkConfigurationEndpointConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolNetworkConfigurationEndpointConfigurationOutputReference;
}
export interface BatchPoolNetworkConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#public_address_provisioning_type BatchPool#public_address_provisioning_type}
    */
    readonly publicAddressProvisioningType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#public_ips BatchPool#public_ips}
    */
    readonly publicIps?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#subnet_id BatchPool#subnet_id}
    */
    readonly subnetId: string;
    /**
    * endpoint_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#endpoint_configuration BatchPool#endpoint_configuration}
    */
    readonly endpointConfiguration?: BatchPoolNetworkConfigurationEndpointConfiguration[] | cdktf.IResolvable;
}
export declare function batchPoolNetworkConfigurationToTerraform(struct?: BatchPoolNetworkConfigurationOutputReference | BatchPoolNetworkConfiguration): any;
export declare class BatchPoolNetworkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolNetworkConfiguration | undefined;
    set internalValue(value: BatchPoolNetworkConfiguration | undefined);
    private _publicAddressProvisioningType?;
    get publicAddressProvisioningType(): string;
    set publicAddressProvisioningType(value: string);
    resetPublicAddressProvisioningType(): void;
    get publicAddressProvisioningTypeInput(): string | undefined;
    private _publicIps?;
    get publicIps(): string[];
    set publicIps(value: string[]);
    resetPublicIps(): void;
    get publicIpsInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _endpointConfiguration;
    get endpointConfiguration(): BatchPoolNetworkConfigurationEndpointConfigurationList;
    putEndpointConfiguration(value: BatchPoolNetworkConfigurationEndpointConfiguration[] | cdktf.IResolvable): void;
    resetEndpointConfiguration(): void;
    get endpointConfigurationInput(): cdktf.IResolvable | BatchPoolNetworkConfigurationEndpointConfiguration[] | undefined;
}
export interface BatchPoolStartTaskResourceFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#auto_storage_container_name BatchPool#auto_storage_container_name}
    */
    readonly autoStorageContainerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#blob_prefix BatchPool#blob_prefix}
    */
    readonly blobPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#file_mode BatchPool#file_mode}
    */
    readonly fileMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#file_path BatchPool#file_path}
    */
    readonly filePath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#http_url BatchPool#http_url}
    */
    readonly httpUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#storage_container_url BatchPool#storage_container_url}
    */
    readonly storageContainerUrl?: string;
}
export declare function batchPoolStartTaskResourceFileToTerraform(struct?: BatchPoolStartTaskResourceFile | cdktf.IResolvable): any;
export declare class BatchPoolStartTaskResourceFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchPoolStartTaskResourceFile | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolStartTaskResourceFile | cdktf.IResolvable | undefined);
    private _autoStorageContainerName?;
    get autoStorageContainerName(): string;
    set autoStorageContainerName(value: string);
    resetAutoStorageContainerName(): void;
    get autoStorageContainerNameInput(): string | undefined;
    private _blobPrefix?;
    get blobPrefix(): string;
    set blobPrefix(value: string);
    resetBlobPrefix(): void;
    get blobPrefixInput(): string | undefined;
    private _fileMode?;
    get fileMode(): string;
    set fileMode(value: string);
    resetFileMode(): void;
    get fileModeInput(): string | undefined;
    private _filePath?;
    get filePath(): string;
    set filePath(value: string);
    resetFilePath(): void;
    get filePathInput(): string | undefined;
    private _httpUrl?;
    get httpUrl(): string;
    set httpUrl(value: string);
    resetHttpUrl(): void;
    get httpUrlInput(): string | undefined;
    private _storageContainerUrl?;
    get storageContainerUrl(): string;
    set storageContainerUrl(value: string);
    resetStorageContainerUrl(): void;
    get storageContainerUrlInput(): string | undefined;
}
export declare class BatchPoolStartTaskResourceFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchPoolStartTaskResourceFile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchPoolStartTaskResourceFileOutputReference;
}
export interface BatchPoolStartTaskUserIdentityAutoUser {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#elevation_level BatchPool#elevation_level}
    */
    readonly elevationLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#scope BatchPool#scope}
    */
    readonly scope?: string;
}
export declare function batchPoolStartTaskUserIdentityAutoUserToTerraform(struct?: BatchPoolStartTaskUserIdentityAutoUserOutputReference | BatchPoolStartTaskUserIdentityAutoUser): any;
export declare class BatchPoolStartTaskUserIdentityAutoUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolStartTaskUserIdentityAutoUser | undefined;
    set internalValue(value: BatchPoolStartTaskUserIdentityAutoUser | undefined);
    private _elevationLevel?;
    get elevationLevel(): string;
    set elevationLevel(value: string);
    resetElevationLevel(): void;
    get elevationLevelInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
}
export interface BatchPoolStartTaskUserIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#user_name BatchPool#user_name}
    */
    readonly userName?: string;
    /**
    * auto_user block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#auto_user BatchPool#auto_user}
    */
    readonly autoUser?: BatchPoolStartTaskUserIdentityAutoUser;
}
export declare function batchPoolStartTaskUserIdentityToTerraform(struct?: BatchPoolStartTaskUserIdentityOutputReference | BatchPoolStartTaskUserIdentity): any;
export declare class BatchPoolStartTaskUserIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolStartTaskUserIdentity | undefined;
    set internalValue(value: BatchPoolStartTaskUserIdentity | undefined);
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
    private _autoUser;
    get autoUser(): BatchPoolStartTaskUserIdentityAutoUserOutputReference;
    putAutoUser(value: BatchPoolStartTaskUserIdentityAutoUser): void;
    resetAutoUser(): void;
    get autoUserInput(): BatchPoolStartTaskUserIdentityAutoUser | undefined;
}
export interface BatchPoolStartTask {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#command_line BatchPool#command_line}
    */
    readonly commandLine: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#common_environment_properties BatchPool#common_environment_properties}
    */
    readonly commonEnvironmentProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#task_retry_maximum BatchPool#task_retry_maximum}
    */
    readonly taskRetryMaximum?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#wait_for_success BatchPool#wait_for_success}
    */
    readonly waitForSuccess?: boolean | cdktf.IResolvable;
    /**
    * resource_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#resource_file BatchPool#resource_file}
    */
    readonly resourceFile?: BatchPoolStartTaskResourceFile[] | cdktf.IResolvable;
    /**
    * user_identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#user_identity BatchPool#user_identity}
    */
    readonly userIdentity: BatchPoolStartTaskUserIdentity;
}
export declare function batchPoolStartTaskToTerraform(struct?: BatchPoolStartTaskOutputReference | BatchPoolStartTask): any;
export declare class BatchPoolStartTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolStartTask | undefined;
    set internalValue(value: BatchPoolStartTask | undefined);
    private _commandLine?;
    get commandLine(): string;
    set commandLine(value: string);
    get commandLineInput(): string | undefined;
    private _commonEnvironmentProperties?;
    get commonEnvironmentProperties(): {
        [key: string]: string;
    };
    set commonEnvironmentProperties(value: {
        [key: string]: string;
    });
    resetCommonEnvironmentProperties(): void;
    get commonEnvironmentPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _taskRetryMaximum?;
    get taskRetryMaximum(): number;
    set taskRetryMaximum(value: number);
    resetTaskRetryMaximum(): void;
    get taskRetryMaximumInput(): number | undefined;
    private _waitForSuccess?;
    get waitForSuccess(): boolean | cdktf.IResolvable;
    set waitForSuccess(value: boolean | cdktf.IResolvable);
    resetWaitForSuccess(): void;
    get waitForSuccessInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceFile;
    get resourceFile(): BatchPoolStartTaskResourceFileList;
    putResourceFile(value: BatchPoolStartTaskResourceFile[] | cdktf.IResolvable): void;
    resetResourceFile(): void;
    get resourceFileInput(): cdktf.IResolvable | BatchPoolStartTaskResourceFile[] | undefined;
    private _userIdentity;
    get userIdentity(): BatchPoolStartTaskUserIdentityOutputReference;
    putUserIdentity(value: BatchPoolStartTaskUserIdentity): void;
    get userIdentityInput(): BatchPoolStartTaskUserIdentity | undefined;
}
export interface BatchPoolStorageImageReference {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#id BatchPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#offer BatchPool#offer}
    */
    readonly offer?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#publisher BatchPool#publisher}
    */
    readonly publisher?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#sku BatchPool#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#version BatchPool#version}
    */
    readonly version?: string;
}
export declare function batchPoolStorageImageReferenceToTerraform(struct?: BatchPoolStorageImageReferenceOutputReference | BatchPoolStorageImageReference): any;
export declare class BatchPoolStorageImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolStorageImageReference | undefined;
    set internalValue(value: BatchPoolStorageImageReference | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _offer?;
    get offer(): string;
    set offer(value: string);
    resetOffer(): void;
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    resetPublisher(): void;
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface BatchPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#create BatchPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#delete BatchPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#read BatchPool#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#update BatchPool#update}
    */
    readonly update?: string;
}
export declare function batchPoolTimeoutsToTerraform(struct?: BatchPoolTimeoutsOutputReference | BatchPoolTimeouts | cdktf.IResolvable): any;
export declare class BatchPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BatchPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool azurerm_batch_pool}
*/
export declare class BatchPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_batch_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool azurerm_batch_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BatchPoolConfig
    */
    constructor(scope: Construct, id: string, config: BatchPoolConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxTasksPerNode?;
    get maxTasksPerNode(): number;
    set maxTasksPerNode(value: number);
    resetMaxTasksPerNode(): void;
    get maxTasksPerNodeInput(): number | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeAgentSkuId?;
    get nodeAgentSkuId(): string;
    set nodeAgentSkuId(value: string);
    get nodeAgentSkuIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _stopPendingResizeOperation?;
    get stopPendingResizeOperation(): boolean | cdktf.IResolvable;
    set stopPendingResizeOperation(value: boolean | cdktf.IResolvable);
    resetStopPendingResizeOperation(): void;
    get stopPendingResizeOperationInput(): boolean | cdktf.IResolvable | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _autoScale;
    get autoScale(): BatchPoolAutoScaleOutputReference;
    putAutoScale(value: BatchPoolAutoScale): void;
    resetAutoScale(): void;
    get autoScaleInput(): BatchPoolAutoScale | undefined;
    private _certificate;
    get certificate(): BatchPoolCertificateList;
    putCertificate(value: BatchPoolCertificate[] | cdktf.IResolvable): void;
    resetCertificate(): void;
    get certificateInput(): cdktf.IResolvable | BatchPoolCertificate[] | undefined;
    private _containerConfiguration;
    get containerConfiguration(): BatchPoolContainerConfigurationOutputReference;
    putContainerConfiguration(value: BatchPoolContainerConfiguration): void;
    resetContainerConfiguration(): void;
    get containerConfigurationInput(): BatchPoolContainerConfiguration | undefined;
    private _fixedScale;
    get fixedScale(): BatchPoolFixedScaleOutputReference;
    putFixedScale(value: BatchPoolFixedScale): void;
    resetFixedScale(): void;
    get fixedScaleInput(): BatchPoolFixedScale | undefined;
    private _identity;
    get identity(): BatchPoolIdentityOutputReference;
    putIdentity(value: BatchPoolIdentity): void;
    resetIdentity(): void;
    get identityInput(): BatchPoolIdentity | undefined;
    private _networkConfiguration;
    get networkConfiguration(): BatchPoolNetworkConfigurationOutputReference;
    putNetworkConfiguration(value: BatchPoolNetworkConfiguration): void;
    resetNetworkConfiguration(): void;
    get networkConfigurationInput(): BatchPoolNetworkConfiguration | undefined;
    private _startTask;
    get startTask(): BatchPoolStartTaskOutputReference;
    putStartTask(value: BatchPoolStartTask): void;
    resetStartTask(): void;
    get startTaskInput(): BatchPoolStartTask | undefined;
    private _storageImageReference;
    get storageImageReference(): BatchPoolStorageImageReferenceOutputReference;
    putStorageImageReference(value: BatchPoolStorageImageReference): void;
    get storageImageReferenceInput(): BatchPoolStorageImageReference | undefined;
    private _timeouts;
    get timeouts(): BatchPoolTimeoutsOutputReference;
    putTimeouts(value: BatchPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BatchPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
