import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HdinsightHadoopClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#cluster_version HdinsightHadoopCluster#cluster_version}
    */
    readonly clusterVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#id HdinsightHadoopCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#location HdinsightHadoopCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#name HdinsightHadoopCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#resource_group_name HdinsightHadoopCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#tags HdinsightHadoopCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#tier HdinsightHadoopCluster#tier}
    */
    readonly tier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#tls_min_version HdinsightHadoopCluster#tls_min_version}
    */
    readonly tlsMinVersion?: string;
    /**
    * component_version block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#component_version HdinsightHadoopCluster#component_version}
    */
    readonly componentVersion: HdinsightHadoopClusterComponentVersion;
    /**
    * gateway block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#gateway HdinsightHadoopCluster#gateway}
    */
    readonly gateway: HdinsightHadoopClusterGateway;
    /**
    * metastores block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#metastores HdinsightHadoopCluster#metastores}
    */
    readonly metastores?: HdinsightHadoopClusterMetastores;
    /**
    * monitor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#monitor HdinsightHadoopCluster#monitor}
    */
    readonly monitor?: HdinsightHadoopClusterMonitor;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#network HdinsightHadoopCluster#network}
    */
    readonly network?: HdinsightHadoopClusterNetwork;
    /**
    * roles block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#roles HdinsightHadoopCluster#roles}
    */
    readonly roles: HdinsightHadoopClusterRoles;
    /**
    * security_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#security_profile HdinsightHadoopCluster#security_profile}
    */
    readonly securityProfile?: HdinsightHadoopClusterSecurityProfile;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#storage_account HdinsightHadoopCluster#storage_account}
    */
    readonly storageAccount?: HdinsightHadoopClusterStorageAccount[] | cdktf.IResolvable;
    /**
    * storage_account_gen2 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#storage_account_gen2 HdinsightHadoopCluster#storage_account_gen2}
    */
    readonly storageAccountGen2?: HdinsightHadoopClusterStorageAccountGen2;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#timeouts HdinsightHadoopCluster#timeouts}
    */
    readonly timeouts?: HdinsightHadoopClusterTimeouts;
}
export interface HdinsightHadoopClusterComponentVersion {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#hadoop HdinsightHadoopCluster#hadoop}
    */
    readonly hadoop: string;
}
export declare function hdinsightHadoopClusterComponentVersionToTerraform(struct?: HdinsightHadoopClusterComponentVersionOutputReference | HdinsightHadoopClusterComponentVersion): any;
export declare class HdinsightHadoopClusterComponentVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterComponentVersion | undefined;
    set internalValue(value: HdinsightHadoopClusterComponentVersion | undefined);
    private _hadoop?;
    get hadoop(): string;
    set hadoop(value: string);
    get hadoopInput(): string | undefined;
}
export interface HdinsightHadoopClusterGateway {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightHadoopClusterGatewayToTerraform(struct?: HdinsightHadoopClusterGatewayOutputReference | HdinsightHadoopClusterGateway): any;
export declare class HdinsightHadoopClusterGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterGateway | undefined;
    set internalValue(value: HdinsightHadoopClusterGateway | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightHadoopClusterMetastoresAmbari {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#database_name HdinsightHadoopCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#server HdinsightHadoopCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightHadoopClusterMetastoresAmbariToTerraform(struct?: HdinsightHadoopClusterMetastoresAmbariOutputReference | HdinsightHadoopClusterMetastoresAmbari): any;
export declare class HdinsightHadoopClusterMetastoresAmbariOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterMetastoresAmbari | undefined;
    set internalValue(value: HdinsightHadoopClusterMetastoresAmbari | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightHadoopClusterMetastoresHive {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#database_name HdinsightHadoopCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#server HdinsightHadoopCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightHadoopClusterMetastoresHiveToTerraform(struct?: HdinsightHadoopClusterMetastoresHiveOutputReference | HdinsightHadoopClusterMetastoresHive): any;
export declare class HdinsightHadoopClusterMetastoresHiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterMetastoresHive | undefined;
    set internalValue(value: HdinsightHadoopClusterMetastoresHive | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightHadoopClusterMetastoresOozie {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#database_name HdinsightHadoopCluster#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#server HdinsightHadoopCluster#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}
    */
    readonly username: string;
}
export declare function hdinsightHadoopClusterMetastoresOozieToTerraform(struct?: HdinsightHadoopClusterMetastoresOozieOutputReference | HdinsightHadoopClusterMetastoresOozie): any;
export declare class HdinsightHadoopClusterMetastoresOozieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterMetastoresOozie | undefined;
    set internalValue(value: HdinsightHadoopClusterMetastoresOozie | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HdinsightHadoopClusterMetastores {
    /**
    * ambari block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#ambari HdinsightHadoopCluster#ambari}
    */
    readonly ambari?: HdinsightHadoopClusterMetastoresAmbari;
    /**
    * hive block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#hive HdinsightHadoopCluster#hive}
    */
    readonly hive?: HdinsightHadoopClusterMetastoresHive;
    /**
    * oozie block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#oozie HdinsightHadoopCluster#oozie}
    */
    readonly oozie?: HdinsightHadoopClusterMetastoresOozie;
}
export declare function hdinsightHadoopClusterMetastoresToTerraform(struct?: HdinsightHadoopClusterMetastoresOutputReference | HdinsightHadoopClusterMetastores): any;
export declare class HdinsightHadoopClusterMetastoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterMetastores | undefined;
    set internalValue(value: HdinsightHadoopClusterMetastores | undefined);
    private _ambari;
    get ambari(): HdinsightHadoopClusterMetastoresAmbariOutputReference;
    putAmbari(value: HdinsightHadoopClusterMetastoresAmbari): void;
    resetAmbari(): void;
    get ambariInput(): HdinsightHadoopClusterMetastoresAmbari | undefined;
    private _hive;
    get hive(): HdinsightHadoopClusterMetastoresHiveOutputReference;
    putHive(value: HdinsightHadoopClusterMetastoresHive): void;
    resetHive(): void;
    get hiveInput(): HdinsightHadoopClusterMetastoresHive | undefined;
    private _oozie;
    get oozie(): HdinsightHadoopClusterMetastoresOozieOutputReference;
    putOozie(value: HdinsightHadoopClusterMetastoresOozie): void;
    resetOozie(): void;
    get oozieInput(): HdinsightHadoopClusterMetastoresOozie | undefined;
}
export interface HdinsightHadoopClusterMonitor {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#log_analytics_workspace_id HdinsightHadoopCluster#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#primary_key HdinsightHadoopCluster#primary_key}
    */
    readonly primaryKey: string;
}
export declare function hdinsightHadoopClusterMonitorToTerraform(struct?: HdinsightHadoopClusterMonitorOutputReference | HdinsightHadoopClusterMonitor): any;
export declare class HdinsightHadoopClusterMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterMonitor | undefined;
    set internalValue(value: HdinsightHadoopClusterMonitor | undefined);
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    get primaryKeyInput(): string | undefined;
}
export interface HdinsightHadoopClusterNetwork {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#connection_direction HdinsightHadoopCluster#connection_direction}
    */
    readonly connectionDirection?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#private_link_enabled HdinsightHadoopCluster#private_link_enabled}
    */
    readonly privateLinkEnabled?: boolean | cdktf.IResolvable;
}
export declare function hdinsightHadoopClusterNetworkToTerraform(struct?: HdinsightHadoopClusterNetworkOutputReference | HdinsightHadoopClusterNetwork): any;
export declare class HdinsightHadoopClusterNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterNetwork | undefined;
    set internalValue(value: HdinsightHadoopClusterNetwork | undefined);
    private _connectionDirection?;
    get connectionDirection(): string;
    set connectionDirection(value: string);
    resetConnectionDirection(): void;
    get connectionDirectionInput(): string | undefined;
    private _privateLinkEnabled?;
    get privateLinkEnabled(): boolean | cdktf.IResolvable;
    set privateLinkEnabled(value: boolean | cdktf.IResolvable);
    resetPrivateLinkEnabled(): void;
    get privateLinkEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface HdinsightHadoopClusterRolesEdgeNodeHttpsEndpoints {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#access_modes HdinsightHadoopCluster#access_modes}
    */
    readonly accessModes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#destination_port HdinsightHadoopCluster#destination_port}
    */
    readonly destinationPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#disable_gateway_auth HdinsightHadoopCluster#disable_gateway_auth}
    */
    readonly disableGatewayAuth?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#private_ip_address HdinsightHadoopCluster#private_ip_address}
    */
    readonly privateIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#sub_domain_suffix HdinsightHadoopCluster#sub_domain_suffix}
    */
    readonly subDomainSuffix?: string;
}
export declare function hdinsightHadoopClusterRolesEdgeNodeHttpsEndpointsToTerraform(struct?: HdinsightHadoopClusterRolesEdgeNodeHttpsEndpoints | cdktf.IResolvable): any;
export declare class HdinsightHadoopClusterRolesEdgeNodeHttpsEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightHadoopClusterRolesEdgeNodeHttpsEndpoints | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHadoopClusterRolesEdgeNodeHttpsEndpoints | cdktf.IResolvable | undefined);
    private _accessModes?;
    get accessModes(): string[];
    set accessModes(value: string[]);
    resetAccessModes(): void;
    get accessModesInput(): string[] | undefined;
    private _destinationPort?;
    get destinationPort(): number;
    set destinationPort(value: number);
    resetDestinationPort(): void;
    get destinationPortInput(): number | undefined;
    private _disableGatewayAuth?;
    get disableGatewayAuth(): boolean | cdktf.IResolvable;
    set disableGatewayAuth(value: boolean | cdktf.IResolvable);
    resetDisableGatewayAuth(): void;
    get disableGatewayAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _privateIpAddress?;
    get privateIpAddress(): string;
    set privateIpAddress(value: string);
    resetPrivateIpAddress(): void;
    get privateIpAddressInput(): string | undefined;
    private _subDomainSuffix?;
    get subDomainSuffix(): string;
    set subDomainSuffix(value: string);
    resetSubDomainSuffix(): void;
    get subDomainSuffixInput(): string | undefined;
}
export declare class HdinsightHadoopClusterRolesEdgeNodeHttpsEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightHadoopClusterRolesEdgeNodeHttpsEndpoints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightHadoopClusterRolesEdgeNodeHttpsEndpointsOutputReference;
}
export interface HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#name HdinsightHadoopCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#parameters HdinsightHadoopCluster#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#uri HdinsightHadoopCluster#uri}
    */
    readonly uri: string;
}
export declare function hdinsightHadoopClusterRolesEdgeNodeInstallScriptActionToTerraform(struct?: HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction | cdktf.IResolvable): any;
export declare class HdinsightHadoopClusterRolesEdgeNodeInstallScriptActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class HdinsightHadoopClusterRolesEdgeNodeInstallScriptActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightHadoopClusterRolesEdgeNodeInstallScriptActionOutputReference;
}
export interface HdinsightHadoopClusterRolesEdgeNodeUninstallScriptActions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#name HdinsightHadoopCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#parameters HdinsightHadoopCluster#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#uri HdinsightHadoopCluster#uri}
    */
    readonly uri: string;
}
export declare function hdinsightHadoopClusterRolesEdgeNodeUninstallScriptActionsToTerraform(struct?: HdinsightHadoopClusterRolesEdgeNodeUninstallScriptActions | cdktf.IResolvable): any;
export declare class HdinsightHadoopClusterRolesEdgeNodeUninstallScriptActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightHadoopClusterRolesEdgeNodeUninstallScriptActions | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHadoopClusterRolesEdgeNodeUninstallScriptActions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export declare class HdinsightHadoopClusterRolesEdgeNodeUninstallScriptActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightHadoopClusterRolesEdgeNodeUninstallScriptActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightHadoopClusterRolesEdgeNodeUninstallScriptActionsOutputReference;
}
export interface HdinsightHadoopClusterRolesEdgeNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#target_instance_count HdinsightHadoopCluster#target_instance_count}
    */
    readonly targetInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#vm_size HdinsightHadoopCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * https_endpoints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#https_endpoints HdinsightHadoopCluster#https_endpoints}
    */
    readonly httpsEndpoints?: HdinsightHadoopClusterRolesEdgeNodeHttpsEndpoints[] | cdktf.IResolvable;
    /**
    * install_script_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#install_script_action HdinsightHadoopCluster#install_script_action}
    */
    readonly installScriptAction: HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction[] | cdktf.IResolvable;
    /**
    * uninstall_script_actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#uninstall_script_actions HdinsightHadoopCluster#uninstall_script_actions}
    */
    readonly uninstallScriptActions?: HdinsightHadoopClusterRolesEdgeNodeUninstallScriptActions[] | cdktf.IResolvable;
}
export declare function hdinsightHadoopClusterRolesEdgeNodeToTerraform(struct?: HdinsightHadoopClusterRolesEdgeNodeOutputReference | HdinsightHadoopClusterRolesEdgeNode): any;
export declare class HdinsightHadoopClusterRolesEdgeNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterRolesEdgeNode | undefined;
    set internalValue(value: HdinsightHadoopClusterRolesEdgeNode | undefined);
    private _targetInstanceCount?;
    get targetInstanceCount(): number;
    set targetInstanceCount(value: number);
    get targetInstanceCountInput(): number | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _httpsEndpoints;
    get httpsEndpoints(): HdinsightHadoopClusterRolesEdgeNodeHttpsEndpointsList;
    putHttpsEndpoints(value: HdinsightHadoopClusterRolesEdgeNodeHttpsEndpoints[] | cdktf.IResolvable): void;
    resetHttpsEndpoints(): void;
    get httpsEndpointsInput(): cdktf.IResolvable | HdinsightHadoopClusterRolesEdgeNodeHttpsEndpoints[] | undefined;
    private _installScriptAction;
    get installScriptAction(): HdinsightHadoopClusterRolesEdgeNodeInstallScriptActionList;
    putInstallScriptAction(value: HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction[] | cdktf.IResolvable): void;
    get installScriptActionInput(): cdktf.IResolvable | HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction[] | undefined;
    private _uninstallScriptActions;
    get uninstallScriptActions(): HdinsightHadoopClusterRolesEdgeNodeUninstallScriptActionsList;
    putUninstallScriptActions(value: HdinsightHadoopClusterRolesEdgeNodeUninstallScriptActions[] | cdktf.IResolvable): void;
    resetUninstallScriptActions(): void;
    get uninstallScriptActionsInput(): cdktf.IResolvable | HdinsightHadoopClusterRolesEdgeNodeUninstallScriptActions[] | undefined;
}
export interface HdinsightHadoopClusterRolesHeadNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#ssh_keys HdinsightHadoopCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#subnet_id HdinsightHadoopCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#virtual_network_id HdinsightHadoopCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#vm_size HdinsightHadoopCluster#vm_size}
    */
    readonly vmSize: string;
}
export declare function hdinsightHadoopClusterRolesHeadNodeToTerraform(struct?: HdinsightHadoopClusterRolesHeadNodeOutputReference | HdinsightHadoopClusterRolesHeadNode): any;
export declare class HdinsightHadoopClusterRolesHeadNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterRolesHeadNode | undefined;
    set internalValue(value: HdinsightHadoopClusterRolesHeadNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
}
export interface HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#max_instance_count HdinsightHadoopCluster#max_instance_count}
    */
    readonly maxInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#min_instance_count HdinsightHadoopCluster#min_instance_count}
    */
    readonly minInstanceCount: number;
}
export declare function hdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacityToTerraform(struct?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacityOutputReference | HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity): any;
export declare class HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity | undefined;
    set internalValue(value: HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity | undefined);
    private _maxInstanceCount?;
    get maxInstanceCount(): number;
    set maxInstanceCount(value: number);
    get maxInstanceCountInput(): number | undefined;
    private _minInstanceCount?;
    get minInstanceCount(): number;
    set minInstanceCount(value: number);
    get minInstanceCountInput(): number | undefined;
}
export interface HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#days HdinsightHadoopCluster#days}
    */
    readonly days: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#target_instance_count HdinsightHadoopCluster#target_instance_count}
    */
    readonly targetInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#time HdinsightHadoopCluster#time}
    */
    readonly time: string;
}
export declare function hdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceScheduleToTerraform(struct?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable): any;
export declare class HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable | undefined);
    private _days?;
    get days(): string[];
    set days(value: string[]);
    get daysInput(): string[] | undefined;
    private _targetInstanceCount?;
    get targetInstanceCount(): number;
    set targetInstanceCount(value: number);
    get targetInstanceCountInput(): number | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export declare class HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceScheduleOutputReference;
}
export interface HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#timezone HdinsightHadoopCluster#timezone}
    */
    readonly timezone: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#schedule HdinsightHadoopCluster#schedule}
    */
    readonly schedule: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable;
}
export declare function hdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceToTerraform(struct?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference | HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence): any;
export declare class HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
    set internalValue(value: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence | undefined);
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    get timezoneInput(): string | undefined;
    private _schedule;
    get schedule(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceScheduleList;
    putSchedule(value: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable): void;
    get scheduleInput(): cdktf.IResolvable | HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | undefined;
}
export interface HdinsightHadoopClusterRolesWorkerNodeAutoscale {
    /**
    * capacity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#capacity HdinsightHadoopCluster#capacity}
    */
    readonly capacity?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity;
    /**
    * recurrence block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#recurrence HdinsightHadoopCluster#recurrence}
    */
    readonly recurrence?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence;
}
export declare function hdinsightHadoopClusterRolesWorkerNodeAutoscaleToTerraform(struct?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleOutputReference | HdinsightHadoopClusterRolesWorkerNodeAutoscale): any;
export declare class HdinsightHadoopClusterRolesWorkerNodeAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterRolesWorkerNodeAutoscale | undefined;
    set internalValue(value: HdinsightHadoopClusterRolesWorkerNodeAutoscale | undefined);
    private _capacity;
    get capacity(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacityOutputReference;
    putCapacity(value: HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity): void;
    resetCapacity(): void;
    get capacityInput(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity | undefined;
    private _recurrence;
    get recurrence(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference;
    putRecurrence(value: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence): void;
    resetRecurrence(): void;
    get recurrenceInput(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
}
export interface HdinsightHadoopClusterRolesWorkerNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#ssh_keys HdinsightHadoopCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#subnet_id HdinsightHadoopCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#target_instance_count HdinsightHadoopCluster#target_instance_count}
    */
    readonly targetInstanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#virtual_network_id HdinsightHadoopCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#vm_size HdinsightHadoopCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * autoscale block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#autoscale HdinsightHadoopCluster#autoscale}
    */
    readonly autoscale?: HdinsightHadoopClusterRolesWorkerNodeAutoscale;
}
export declare function hdinsightHadoopClusterRolesWorkerNodeToTerraform(struct?: HdinsightHadoopClusterRolesWorkerNodeOutputReference | HdinsightHadoopClusterRolesWorkerNode): any;
export declare class HdinsightHadoopClusterRolesWorkerNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterRolesWorkerNode | undefined;
    set internalValue(value: HdinsightHadoopClusterRolesWorkerNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _targetInstanceCount?;
    get targetInstanceCount(): number;
    set targetInstanceCount(value: number);
    get targetInstanceCountInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _autoscale;
    get autoscale(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleOutputReference;
    putAutoscale(value: HdinsightHadoopClusterRolesWorkerNodeAutoscale): void;
    resetAutoscale(): void;
    get autoscaleInput(): HdinsightHadoopClusterRolesWorkerNodeAutoscale | undefined;
}
export interface HdinsightHadoopClusterRolesZookeeperNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#ssh_keys HdinsightHadoopCluster#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#subnet_id HdinsightHadoopCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}
    */
    readonly username: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#virtual_network_id HdinsightHadoopCluster#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#vm_size HdinsightHadoopCluster#vm_size}
    */
    readonly vmSize: string;
}
export declare function hdinsightHadoopClusterRolesZookeeperNodeToTerraform(struct?: HdinsightHadoopClusterRolesZookeeperNodeOutputReference | HdinsightHadoopClusterRolesZookeeperNode): any;
export declare class HdinsightHadoopClusterRolesZookeeperNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterRolesZookeeperNode | undefined;
    set internalValue(value: HdinsightHadoopClusterRolesZookeeperNode | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
}
export interface HdinsightHadoopClusterRoles {
    /**
    * edge_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#edge_node HdinsightHadoopCluster#edge_node}
    */
    readonly edgeNode?: HdinsightHadoopClusterRolesEdgeNode;
    /**
    * head_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#head_node HdinsightHadoopCluster#head_node}
    */
    readonly headNode: HdinsightHadoopClusterRolesHeadNode;
    /**
    * worker_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#worker_node HdinsightHadoopCluster#worker_node}
    */
    readonly workerNode: HdinsightHadoopClusterRolesWorkerNode;
    /**
    * zookeeper_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#zookeeper_node HdinsightHadoopCluster#zookeeper_node}
    */
    readonly zookeeperNode: HdinsightHadoopClusterRolesZookeeperNode;
}
export declare function hdinsightHadoopClusterRolesToTerraform(struct?: HdinsightHadoopClusterRolesOutputReference | HdinsightHadoopClusterRoles): any;
export declare class HdinsightHadoopClusterRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterRoles | undefined;
    set internalValue(value: HdinsightHadoopClusterRoles | undefined);
    private _edgeNode;
    get edgeNode(): HdinsightHadoopClusterRolesEdgeNodeOutputReference;
    putEdgeNode(value: HdinsightHadoopClusterRolesEdgeNode): void;
    resetEdgeNode(): void;
    get edgeNodeInput(): HdinsightHadoopClusterRolesEdgeNode | undefined;
    private _headNode;
    get headNode(): HdinsightHadoopClusterRolesHeadNodeOutputReference;
    putHeadNode(value: HdinsightHadoopClusterRolesHeadNode): void;
    get headNodeInput(): HdinsightHadoopClusterRolesHeadNode | undefined;
    private _workerNode;
    get workerNode(): HdinsightHadoopClusterRolesWorkerNodeOutputReference;
    putWorkerNode(value: HdinsightHadoopClusterRolesWorkerNode): void;
    get workerNodeInput(): HdinsightHadoopClusterRolesWorkerNode | undefined;
    private _zookeeperNode;
    get zookeeperNode(): HdinsightHadoopClusterRolesZookeeperNodeOutputReference;
    putZookeeperNode(value: HdinsightHadoopClusterRolesZookeeperNode): void;
    get zookeeperNodeInput(): HdinsightHadoopClusterRolesZookeeperNode | undefined;
}
export interface HdinsightHadoopClusterSecurityProfile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#aadds_resource_id HdinsightHadoopCluster#aadds_resource_id}
    */
    readonly aaddsResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#cluster_users_group_dns HdinsightHadoopCluster#cluster_users_group_dns}
    */
    readonly clusterUsersGroupDns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#domain_name HdinsightHadoopCluster#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#domain_user_password HdinsightHadoopCluster#domain_user_password}
    */
    readonly domainUserPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#domain_username HdinsightHadoopCluster#domain_username}
    */
    readonly domainUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#ldaps_urls HdinsightHadoopCluster#ldaps_urls}
    */
    readonly ldapsUrls: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#msi_resource_id HdinsightHadoopCluster#msi_resource_id}
    */
    readonly msiResourceId: string;
}
export declare function hdinsightHadoopClusterSecurityProfileToTerraform(struct?: HdinsightHadoopClusterSecurityProfileOutputReference | HdinsightHadoopClusterSecurityProfile): any;
export declare class HdinsightHadoopClusterSecurityProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterSecurityProfile | undefined;
    set internalValue(value: HdinsightHadoopClusterSecurityProfile | undefined);
    private _aaddsResourceId?;
    get aaddsResourceId(): string;
    set aaddsResourceId(value: string);
    get aaddsResourceIdInput(): string | undefined;
    private _clusterUsersGroupDns?;
    get clusterUsersGroupDns(): string[];
    set clusterUsersGroupDns(value: string[]);
    resetClusterUsersGroupDns(): void;
    get clusterUsersGroupDnsInput(): string[] | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _domainUserPassword?;
    get domainUserPassword(): string;
    set domainUserPassword(value: string);
    get domainUserPasswordInput(): string | undefined;
    private _domainUsername?;
    get domainUsername(): string;
    set domainUsername(value: string);
    get domainUsernameInput(): string | undefined;
    private _ldapsUrls?;
    get ldapsUrls(): string[];
    set ldapsUrls(value: string[]);
    get ldapsUrlsInput(): string[] | undefined;
    private _msiResourceId?;
    get msiResourceId(): string;
    set msiResourceId(value: string);
    get msiResourceIdInput(): string | undefined;
}
export interface HdinsightHadoopClusterStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#is_default HdinsightHadoopCluster#is_default}
    */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#storage_account_key HdinsightHadoopCluster#storage_account_key}
    */
    readonly storageAccountKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#storage_container_id HdinsightHadoopCluster#storage_container_id}
    */
    readonly storageContainerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#storage_resource_id HdinsightHadoopCluster#storage_resource_id}
    */
    readonly storageResourceId?: string;
}
export declare function hdinsightHadoopClusterStorageAccountToTerraform(struct?: HdinsightHadoopClusterStorageAccount | cdktf.IResolvable): any;
export declare class HdinsightHadoopClusterStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HdinsightHadoopClusterStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHadoopClusterStorageAccount | cdktf.IResolvable | undefined);
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _storageAccountKey?;
    get storageAccountKey(): string;
    set storageAccountKey(value: string);
    get storageAccountKeyInput(): string | undefined;
    private _storageContainerId?;
    get storageContainerId(): string;
    set storageContainerId(value: string);
    get storageContainerIdInput(): string | undefined;
    private _storageResourceId?;
    get storageResourceId(): string;
    set storageResourceId(value: string);
    resetStorageResourceId(): void;
    get storageResourceIdInput(): string | undefined;
}
export declare class HdinsightHadoopClusterStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HdinsightHadoopClusterStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HdinsightHadoopClusterStorageAccountOutputReference;
}
export interface HdinsightHadoopClusterStorageAccountGen2 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#filesystem_id HdinsightHadoopCluster#filesystem_id}
    */
    readonly filesystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#is_default HdinsightHadoopCluster#is_default}
    */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#managed_identity_resource_id HdinsightHadoopCluster#managed_identity_resource_id}
    */
    readonly managedIdentityResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#storage_resource_id HdinsightHadoopCluster#storage_resource_id}
    */
    readonly storageResourceId: string;
}
export declare function hdinsightHadoopClusterStorageAccountGen2ToTerraform(struct?: HdinsightHadoopClusterStorageAccountGen2OutputReference | HdinsightHadoopClusterStorageAccountGen2): any;
export declare class HdinsightHadoopClusterStorageAccountGen2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterStorageAccountGen2 | undefined;
    set internalValue(value: HdinsightHadoopClusterStorageAccountGen2 | undefined);
    private _filesystemId?;
    get filesystemId(): string;
    set filesystemId(value: string);
    get filesystemIdInput(): string | undefined;
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _managedIdentityResourceId?;
    get managedIdentityResourceId(): string;
    set managedIdentityResourceId(value: string);
    get managedIdentityResourceIdInput(): string | undefined;
    private _storageResourceId?;
    get storageResourceId(): string;
    set storageResourceId(value: string);
    get storageResourceIdInput(): string | undefined;
}
export interface HdinsightHadoopClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#create HdinsightHadoopCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#delete HdinsightHadoopCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#read HdinsightHadoopCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#update HdinsightHadoopCluster#update}
    */
    readonly update?: string;
}
export declare function hdinsightHadoopClusterTimeoutsToTerraform(struct?: HdinsightHadoopClusterTimeoutsOutputReference | HdinsightHadoopClusterTimeouts | cdktf.IResolvable): any;
export declare class HdinsightHadoopClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HdinsightHadoopClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: HdinsightHadoopClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster azurerm_hdinsight_hadoop_cluster}
*/
export declare class HdinsightHadoopCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_hdinsight_hadoop_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster azurerm_hdinsight_hadoop_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HdinsightHadoopClusterConfig
    */
    constructor(scope: Construct, id: string, config: HdinsightHadoopClusterConfig);
    private _clusterVersion?;
    get clusterVersion(): string;
    set clusterVersion(value: string);
    get clusterVersionInput(): string | undefined;
    get httpsEndpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sshEndpoint(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _tlsMinVersion?;
    get tlsMinVersion(): string;
    set tlsMinVersion(value: string);
    resetTlsMinVersion(): void;
    get tlsMinVersionInput(): string | undefined;
    private _componentVersion;
    get componentVersion(): HdinsightHadoopClusterComponentVersionOutputReference;
    putComponentVersion(value: HdinsightHadoopClusterComponentVersion): void;
    get componentVersionInput(): HdinsightHadoopClusterComponentVersion | undefined;
    private _gateway;
    get gateway(): HdinsightHadoopClusterGatewayOutputReference;
    putGateway(value: HdinsightHadoopClusterGateway): void;
    get gatewayInput(): HdinsightHadoopClusterGateway | undefined;
    private _metastores;
    get metastores(): HdinsightHadoopClusterMetastoresOutputReference;
    putMetastores(value: HdinsightHadoopClusterMetastores): void;
    resetMetastores(): void;
    get metastoresInput(): HdinsightHadoopClusterMetastores | undefined;
    private _monitor;
    get monitor(): HdinsightHadoopClusterMonitorOutputReference;
    putMonitor(value: HdinsightHadoopClusterMonitor): void;
    resetMonitor(): void;
    get monitorInput(): HdinsightHadoopClusterMonitor | undefined;
    private _network;
    get network(): HdinsightHadoopClusterNetworkOutputReference;
    putNetwork(value: HdinsightHadoopClusterNetwork): void;
    resetNetwork(): void;
    get networkInput(): HdinsightHadoopClusterNetwork | undefined;
    private _roles;
    get roles(): HdinsightHadoopClusterRolesOutputReference;
    putRoles(value: HdinsightHadoopClusterRoles): void;
    get rolesInput(): HdinsightHadoopClusterRoles | undefined;
    private _securityProfile;
    get securityProfile(): HdinsightHadoopClusterSecurityProfileOutputReference;
    putSecurityProfile(value: HdinsightHadoopClusterSecurityProfile): void;
    resetSecurityProfile(): void;
    get securityProfileInput(): HdinsightHadoopClusterSecurityProfile | undefined;
    private _storageAccount;
    get storageAccount(): HdinsightHadoopClusterStorageAccountList;
    putStorageAccount(value: HdinsightHadoopClusterStorageAccount[] | cdktf.IResolvable): void;
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | HdinsightHadoopClusterStorageAccount[] | undefined;
    private _storageAccountGen2;
    get storageAccountGen2(): HdinsightHadoopClusterStorageAccountGen2OutputReference;
    putStorageAccountGen2(value: HdinsightHadoopClusterStorageAccountGen2): void;
    resetStorageAccountGen2(): void;
    get storageAccountGen2Input(): HdinsightHadoopClusterStorageAccountGen2 | undefined;
    private _timeouts;
    get timeouts(): HdinsightHadoopClusterTimeoutsOutputReference;
    putTimeouts(value: HdinsightHadoopClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | HdinsightHadoopClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
