# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, RootModel, constr

from ...ListMeta import ListMeta
from ...ObjectMeta import ObjectMeta
from .. import UploadSource


class Error(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    code: Optional[int] = Field(None, description='Error code for the type of error')
    message: Optional[str] = Field(None, description='Human readable error message')


class ConnectorError(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    error: Optional[Error] = Field(
        None, description='Connector Error with error code and message.'
    )


class Config(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cloud_environment: str = Field(
        ..., alias='cloud.environment', description='The cloud environment type.'
    )
    cloud_provider: str = Field(
        ...,
        alias='cloud.provider',
        description='The cloud service provider, e.g. aws, azure, etc.',
    )
    connector_class: str = Field(
        ...,
        alias='connector.class',
        description='The connector class name. E.g. BigQuerySink, GcsSink, etc.',
    )
    name: str = Field(
        ..., description='Name or alias of the class (plugin) for this connector.'
    )
    kafka_endpoint: str = Field(
        ..., alias='kafka.endpoint', description='The kafka cluster endpoint.'
    )
    kafka_region: str = Field(
        ..., alias='kafka.region', description='The kafka cluster region.'
    )
    kafka_api_key: str = Field(
        ..., alias='kafka.api.key', description='The kafka cluster api key.'
    )
    kafka_api_secret: str = Field(
        ..., alias='kafka.api.secret', description='The kafka cluster api secret key.'
    )


class Task(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    connector: str = Field(
        ..., description='The name of the connector the task belongs to'
    )
    task: int = Field(..., description='Task ID within the connector')


class Type(Enum):
    sink = 'sink'
    source = 'source'


class Connector(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str = Field(..., description='Name of the connector')
    config: Config = Field(
        ...,
        description='Configuration parameters for the connector. These configurations\nare the minimum set of key-value pairs (KVP) which can be used to\ndefine how the connector connects Kafka to the external system.\nSome of these KVPs are common to all the connectors, such as\nconnection parameters to Kafka, connector metadata, etc. The list\nof common connector configurations is as follows\n\n- cloud.environment\n- cloud.provider\n- connector.class\n- kafka.api.key\n- kafka.api.secret\n- kafka.endpoint\n- kafka.region\n- name\n\nA specific connector such as `GcsSink` would have additional\nparameters such as `gcs.bucket.name`, `flush.size`, etc.',
    )
    tasks: Optional[List[Task]] = Field(
        None, description='List of active tasks generated by the connector'
    )
    type: Optional[Type] = Field(None, description='Type of connector, sink or source')


class ConfigModel(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cloud_environment: str = Field(
        ..., alias='cloud.environment', description='The cloud environment type.'
    )
    cloud_provider: str = Field(
        ...,
        alias='cloud.provider',
        description='The cloud service provider, e.g. aws, azure, etc.',
    )
    connector_class: str = Field(
        ...,
        alias='connector.class',
        description='The connector class name. E.g. BigQuerySink, GcsSink, etc.',
    )
    name: str = Field(
        ..., description='Name or alias of the class (plugin) for this connector.'
    )
    kafka_endpoint: str = Field(
        ..., alias='kafka.endpoint', description='The Kafka cluster endpoint.'
    )
    kafka_region: str = Field(
        ..., alias='kafka.region', description='The Kafka cluster region.'
    )
    kafka_api_key: str = Field(
        ..., alias='kafka.api.key', description='The Kafka cluster API key.'
    )
    kafka_api_secret: str = Field(
        ..., alias='kafka.api.secret', description='The Kafka cluster API secret.'
    )


class Id(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    connector: Optional[str] = Field(
        None, description='The name of the connector the task belongs to.'
    )
    task: Optional[int] = Field(None, description='Task ID within the connector.')


class ConfigModel1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cloud_environment: str = Field(
        ..., alias='cloud.environment', description='The cloud environment type.'
    )
    cloud_provider: str = Field(
        ...,
        alias='cloud.provider',
        description='The cloud service provider, e.g. aws, azure, etc.',
    )
    connector_class: str = Field(
        ...,
        alias='connector.class',
        description='The connector class name. E.g. BigQuerySink, GcsSink, etc.',
    )
    name: str = Field(
        ..., description='Name or alias of the class (plugin) for this connector.'
    )
    kafka_endpoint: str = Field(
        ..., alias='kafka.endpoint', description='The kafka cluster endpoint.'
    )
    kafka_region: str = Field(
        ..., alias='kafka.region', description='The kafka cluster region.'
    )
    kafka_api_key: str = Field(
        ..., alias='kafka.api.key', description='The kafka cluster api key.'
    )
    kafka_api_secret: str = Field(
        ..., alias='kafka.api.secret', description='The kafka cluster api secret key.'
    )


class ConnectorModel(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: Optional[Id] = Field(None, description='The ID of task.')
    config: Optional[ConfigModel1] = Field(
        None,
        description='Configuration parameters for the connector. These configurations\nare the minimum set of key-value pairs (KVP) which can be used to\ndefine how the connector connects Kafka to the external system.\nSome of these KVPs are common to all the connectors, such as\nconnection parameters to Kafka, connector metadata, etc. The list\nof common connector configurations is as follows\n\n  - cloud.environment\n  - cloud.provider\n  - connector.class\n  - kafka.api.key\n  - kafka.api.secret\n  - kafka.endpoint\n  - kafka.region\n  - name\n\nA specific connector such as `GcsSink` would have additional\nparameters such as `gcs.bucket.name`, `flush.size`, etc.',
    )


class Connectors(RootModel[List[ConnectorModel]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[ConnectorModel] = Field(
        ...,
        description='List of active task configs that have been created by the connector',
    )


class IdModel(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: Optional[str] = Field(None, description='The ID of the connector.')
    id_type: Optional[str] = Field(
        None, description='Type of the value in the `id` property.'
    )


class Info(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = Field(None, description='Name of the connector.')
    config: Optional[ConfigModel1] = Field(
        None,
        description='Configuration parameters for the connector. These configurations\nare the minimum set of key-value pairs (KVP) which are used to\ndefine how the connector connects Kafka to the external system.\nSome of these KVPs are common to all the connectors, such as\nconnection parameters to Kafka, connector metadata, etc. The list\nof common connector configurations is as follows\n\n  - cloud.environment\n  - cloud.provider\n  - connector.class\n  - kafka.api.key\n  - kafka.api.secret\n  - kafka.endpoint\n  - kafka.region\n  - name\n\nFor example, a connector like `GcsSink` would have additional\nparameters such as `gcs.bucket.name`, `flush.size`, etc.',
    )


class State(Enum):
    none = 'NONE'
    provisioning = 'PROVISIONING'
    running = 'RUNNING'
    degraded = 'DEGRADED'
    failed = 'FAILED'
    paused = 'PAUSED'
    deleted = 'DELETED'


class ConnectorModel1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    state: State = Field(..., description='The state of the connector.')
    worker_id: str = Field(..., description='The worker ID of the connector.')
    trace: Optional[str] = Field(
        None, description='Exception message in case of an error.'
    )


class TaskModel(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: int = Field(..., description='The ID of task.')
    state: str = Field(..., description='The state of the task.')
    worker_id: str = Field(..., description='The worker ID of the task.')
    msg: Optional[str] = None


class Status(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str = Field(..., description='The name of the connector.')
    type: Type = Field(..., description='Type of connector, sink or source.')
    connector: ConnectorModel1 = Field(
        ..., description='A map containing connector status.'
    )
    tasks: Optional[List[TaskModel]] = Field(
        None, description='A map containing the task status.'
    )


class ConnectorExpansion(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: Optional[IdModel] = Field(None, description='The ID of connector.')
    info: Optional[Info] = Field(None, description='Metadata of the connector.')
    status: Optional[Status] = Field(
        None, description='Status of the connector and its tasks.'
    )


class Offset(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    partition: Optional[Dict[str, Any]] = Field(
        None,
        description='The partition information. For sink connectors this is the kafka topic and \npartition. For source connectors this is depends on the partitions defined by the \nsource connector. For example, the table which this task is pulling data from in a\nJDBC based MySQL source connector.\nPlease refer to the [documentation](https://docs.confluent.io/cloud/current/connectors/offsets.html#manage-offsets-for-fully-managed-connectors-in-ccloud) for \nmore information.',
    )
    offset: Optional[Dict[str, Any]] = Field(
        None,
        description='The offset of the partition. For sink connectors this is the kafka offset. For \nsource connectors this is depends on the offset defined by the source connector. \nFor example, the timestamp and incrementing column info in a table, for a JDBC based \nMySQL source connector.\nPlease refer to the [documentation](https://docs.confluent.io/cloud/current/connectors/offsets.html#manage-offsets-for-fully-managed-connectors-in-ccloud) for \nmore information.',
    )


class Offsets(RootModel[List[Offset]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[Offset] = Field(
        ..., description='Array of offsets which are categorised into partitions.'
    )


class Metadata(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    observed_at: Optional[datetime] = Field(
        None,
        description='The time at which the offsets were observed. The time is in UTC, ISO 8601 format.',
        examples=['2024-02-20T15:14:19Z'],
    )


class ConnectorOffsets(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = Field(None, description='The name of the connector.')
    id: Optional[str] = Field(None, description='The ID of the connector.')
    offsets: Optional[Offsets] = None
    metadata: Optional[Metadata] = Field(
        None, description='Metadata of the connector offset.'
    )


class AlterOffsetRequestType(Enum):
    patch = 'PATCH'
    delete = 'DELETE'


class AlterOffsetRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: AlterOffsetRequestType
    offsets: Optional[Offsets] = None


class AlterOffsetRequestInfo(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str = Field(..., description='The ID of the connector.')
    name: str = Field(..., description='The name of the connector.')
    offsets: Optional[Offsets] = None
    requested_at: datetime = Field(
        ...,
        description='The time at which the request was made. The time is in UTC, ISO 8601 format.',
        examples=['2024-02-20T15:14:19Z'],
    )
    type: AlterOffsetRequestType


class StatusModel(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The phase of the alter offset operation. \n\nPENDING: The offset alter operation is in progress.\n\nAPPLIED: The offset alter operation has been applied to the connector.\n\nFAILED:  The offset alter operation has failed to be applied to the connector.',
    )
    message: Optional[str] = Field(
        None, description='An info message from the alter offset operation.'
    )


class AlterOffsetStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    request: AlterOffsetRequestInfo
    status: StatusModel = Field(
        ..., description='The response of the alter offsets operation.'
    )
    previous_offsets: Optional[Offsets] = None
    applied_at: Optional[datetime] = Field(
        None,
        description='The time at which the offsets were applied. The time is in UTC, ISO 8601 format.',
        examples=['2024-02-20T15:14:19Z'],
    )


class ApiVersion(Enum):
    connect_v1 = 'connect/v1'


class Kind(Enum):
    custom_connector_plugin = 'CustomConnectorPlugin'


class MetadataModel(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/connect/v1/custom-connector-plugins/ccp-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/custom-connector-plugin=ccp-12345'
        ],
    )


class KindModel(Enum):
    presigned_url = 'PresignedUrl'


class PresignedUrl(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[KindModel] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    content_format: Optional[str] = Field(
        None,
        description='Content format of the Custom Connector Plugin archive.',
        examples=['ZIP'],
    )
    cloud: Optional[str] = Field(
        None,
        description='Cloud provider where the Custom Connector Plugin archive is uploaded.',
        examples=['AWS'],
    )
    upload_id: Optional[str] = Field(
        None,
        description='Unique identifier of this upload.',
        examples=['e53bb2e8-8de3-49fa-9fb1-4e3fd9a16b66'],
    )
    upload_url: Optional[AnyUrl] = Field(
        None,
        description='Upload URL for the Custom Connector Plugin archive.',
        examples=[
            'https://confluent-custom-connectors-stag-us-west-2.s3.dualstack.us-west-2.amazonaws.com/'
        ],
    )
    upload_form_data: Optional[Dict[str, Any]] = Field(
        None,
        description='Upload form data of the Custom Connector Plugin. All values should be strings.',
        examples=[
            {
                'bucket': 'confluent-custom-connectors-stag-us-west-2',
                'key': 'staging/custom-plugin/2f37f0b6-f8da-4e8b-bc5f-282ebb0511be/connect-e53bb2e8-8de3-49fa-9fb1-4e3fd9a16b66/plugin.zip',
                'policy': 'string',
                'x-amz-algorithm': 'AWS4-HMAC-SHA256',
                'x-amz-credential': 'string',
                'x-amz-date': '20230725T013857Z',
                'x-amz-security-token': 'string',
                'x-amz-signature': 'string',
            }
        ],
    )


class KindModel1(Enum):
    presigned_url_request = 'PresignedUrlRequest'


class MetadataModel1(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/connect/v1/presigned-url-requests/pur-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/presigned-url-request=pur-12345'
        ],
    )


class PresignedUrlRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[KindModel1] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[MetadataModel1] = None
    content_format: Optional[str] = Field(
        None,
        description='Archive format of the Custom Connector Plugin.',
        examples=['ZIP'],
    )
    cloud: Optional[str] = Field(
        'AWS',
        description='Cloud provider where the Custom Connector Plugin archive is uploaded.',
        examples=['AWS'],
    )


class KindModel2(Enum):
    custom_connector_plugin_list = 'CustomConnectorPluginList'


class MetadataModel2(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/connect/v1/custom-connector-plugins'],
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/connect/v1/custom-connector-plugins?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/connect/v1/custom-connector-plugins?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/connect/v1/custom-connector-plugins?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class Kind1(Enum):
    custom_connector_plugin = 'CustomConnectorPlugin'


class Metadata1(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/connect/v1/custom-connector-plugins/ccp-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/custom-connector-plugin=ccp-12345'
        ],
    )


class CustomConnectorPluginUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1] = None
    display_name: Optional[constr(max_length=60)] = Field(
        None, description='Display name of Custom Connector Plugin.'
    )
    content_format: Optional[str] = Field(
        None, description='Archive format of Custom Connector Plugin.', examples=['ZIP']
    )
    description: Optional[constr(max_length=256)] = Field(
        None, description='Description of Custom Connector Plugin.'
    )
    documentation_link: Optional[
        constr(pattern=r'^$|^(http://|https://).+', max_length=512)
    ] = Field(
        None,
        description='Document link of Custom Connector Plugin.',
        examples=['https://github.com/confluentinc/kafka-connect-datagen'],
    )
    sensitive_config_properties: Optional[
        List[constr(pattern=r'^[\w\+\.-]+$', max_length=150)]
    ] = Field(
        None,
        description='A sensitive property is a connector configuration property that must be hidden after a user enters property value when setting up connector.',
        examples=[['passwords', 'keys', 'tokens']],
    )
    upload_source: Optional[UploadSource.PresignedUrl] = Field(
        None,
        description='[immutable] Upload source of Custom Connector Plugin. Only required in `create` request, will be ignored in `read`, `update` or `list`.',
        discriminator='location',
    )


class ConnectorWithOffsets(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str = Field(..., description='Name of the connector')
    config: ConfigModel = Field(
        ...,
        description='Configuration parameters for the connector. These configurations\nare the minimum set of key-value pairs which can be used to\ndefine how the connector connects Kafka to the external system.\nSome of these key-value pairs are common to all the connectors, such as\nconnection parameters to Kafka, connector metadata, etc. The list\nof common connector configurations is as follows\n- cloud.environment\n- cloud.provider\n- connector.class\n- kafka.api.key\n- kafka.api.secret\n- kafka.endpoint\n- kafka.region\n- name\nA specific connector such as `GcsSink` would have additional\nparameters such as `gcs.bucket.name`, `flush.size`, etc.',
    )
    tasks: Optional[List[Task]] = Field(
        None, description='List of active tasks generated by the connector'
    )
    type: Optional[Type] = Field(None, description='Type of connector, sink or source')
    offsets: Optional[Offsets] = None


class ConnectorExpansionMap(RootModel[Optional[Dict[str, ConnectorExpansion]]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Optional[Dict[str, ConnectorExpansion]] = None


class CustomConnectorPlugin(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[MetadataModel] = None
    display_name: Optional[constr(max_length=60)] = Field(
        None, description='Display name of Custom Connector Plugin.'
    )
    content_format: Optional[str] = Field(
        None, description='Archive format of Custom Connector Plugin.', examples=['ZIP']
    )
    description: Optional[constr(max_length=256)] = Field(
        None, description='Description of Custom Connector Plugin.'
    )
    documentation_link: Optional[
        constr(pattern=r'^$|^(http://|https://).+', max_length=512)
    ] = Field(
        None,
        description='Document link of Custom Connector Plugin.',
        examples=['https://github.com/confluentinc/kafka-connect-datagen'],
    )
    connector_class: Optional[
        constr(
            pattern=r'^(([a-zA-Z][a-zA-Z_$0-9]*(\.[a-zA-Z][a-zA-Z_$0-9]*)*)\.)?([a-zA-Z][a-zA-Z_$0-9]*)$',
            max_length=150,
        )
    ] = Field(
        None,
        description='Java class or alias for connector. You can get connector class from connector documentation provided by developer.',
        examples=['io.confluent.kafka.connect.datagen.DatagenConnector'],
    )
    connector_type: Optional[str] = Field(
        None, description='Custom Connector type.\n', examples=['SOURCE']
    )
    cloud: Optional[str] = Field(
        'AWS',
        description='Cloud provider where the Custom Connector Plugin archive is uploaded.',
        examples=['AWS'],
    )
    sensitive_config_properties: Optional[
        List[constr(pattern=r'^[\w\+\.-]+$', max_length=150)]
    ] = Field(
        None,
        description='A sensitive property is a connector configuration property that must be hidden after a user enters property value when setting up connector.',
        examples=[['passwords', 'keys', 'tokens']],
    )
    upload_source: Optional[UploadSource.PresignedUrl] = Field(
        None,
        description='[immutable] Upload source of Custom Connector Plugin. Only required in `create` request, will be ignored in `read`, `update` or `list`.',
        discriminator='location',
    )


class CustomConnectorPluginList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel2 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel2
    data: List[CustomConnectorPlugin] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
