"use strict";
const fs = require("fs");
const path = require("path");
const index_1 = require("../../lib/index");
function readJson(outdir, file) {
    return JSON.parse(fs.readFileSync(path.join(outdir, file), 'utf-8'));
}
module.exports = {
    'tree metadata is generated as expected'(test) {
        const app = new index_1.App();
        const stack = new index_1.Stack(app, 'mystack');
        new index_1.Construct(stack, 'myconstruct');
        const assembly = app.synth();
        const treeArtifact = assembly.tree();
        test.ok(treeArtifact);
        test.deepEqual(readJson(assembly.directory, treeArtifact.file), {
            version: 'tree-0.1',
            tree: {
                id: 'App',
                path: '',
                children: {
                    Tree: {
                        id: 'Tree',
                        path: 'Tree'
                    },
                    mystack: {
                        id: 'mystack',
                        path: 'mystack',
                        children: {
                            myconstruct: {
                                id: 'myconstruct',
                                path: 'mystack/myconstruct'
                            }
                        }
                    }
                }
            }
        });
        test.done();
    },
    'tree metadata for a Cfn resource'(test) {
        class MyCfnResource extends index_1.CfnResource {
            constructor(scope, id) {
                super(scope, id, {
                    type: 'CDK::UnitTest::MyCfnResource'
                });
            }
            inspect(inspector) {
                inspector.addAttribute('aws:cdk:cloudformation:type', 'CDK::UnitTest::MyCfnResource');
                inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
            }
            get cfnProperties() {
                return {
                    mystringpropkey: 'mystringpropval',
                    mylistpropkey: ['listitem1'],
                    mystructpropkey: {
                        myboolpropkey: true,
                        mynumpropkey: 50
                    }
                };
            }
        }
        const app = new index_1.App();
        const stack = new index_1.Stack(app, 'mystack');
        new MyCfnResource(stack, 'mycfnresource');
        const assembly = app.synth();
        const treeArtifact = assembly.tree();
        test.ok(treeArtifact);
        test.deepEqual(readJson(assembly.directory, treeArtifact.file), {
            version: 'tree-0.1',
            tree: {
                id: 'App',
                path: '',
                children: {
                    Tree: {
                        id: 'Tree',
                        path: 'Tree'
                    },
                    mystack: {
                        id: 'mystack',
                        path: 'mystack',
                        children: {
                            mycfnresource: {
                                id: 'mycfnresource',
                                path: 'mystack/mycfnresource',
                                attributes: {
                                    'aws:cdk:cloudformation:type': 'CDK::UnitTest::MyCfnResource',
                                    'aws:cdk:cloudformation:props': {
                                        mystringpropkey: 'mystringpropval',
                                        mylistpropkey: ['listitem1'],
                                        mystructpropkey: {
                                            myboolpropkey: true,
                                            mynumpropkey: 50
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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