/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection;

import ikor.collection.Dictionary;
import ikor.collection.DynamicList;
import ikor.collection.ReadOnlyCollection;
import ikor.collection.ReadOnlyDictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DynamicDictionary<K, V>
implements Dictionary<K, V> {
    private HashMap<K, V> map = new HashMap();

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public ReadOnlyCollection<K> keys() {
        DynamicList<K> list = new DynamicList<K>();
        for (K key : this.map.keySet()) {
            list.add(key);
        }
        return list;
    }

    @Override
    public ReadOnlyCollection<V> values() {
        DynamicList<V> list = new DynamicList<V>();
        for (V value : this.map.values()) {
            list.add(value);
        }
        return list;
    }

    @Override
    public ReadOnlyCollection<ReadOnlyDictionary.Entry<K, V>> entries() {
        DynamicList<ReadOnlyDictionary.Entry<K, V>> list = new DynamicList<ReadOnlyDictionary.Entry<K, V>>();
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            list.add(new ImmutableEntry(entry.getKey(), entry.getValue()));
        }
        return list;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public Iterator<K> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int add(K key) {
        this.map.put(key, null);
        return this.size() - 1;
    }

    @Override
    public boolean remove(K key) {
        this.map.remove(key);
        return true;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V set(K key, V value) {
        return this.map.put(key, value);
    }

    public String toString() {
        String str = "";
        ReadOnlyCollection<ReadOnlyDictionary.Entry<K, V>> entries = this.entries();
        for (ReadOnlyDictionary.Entry<K, V> entry : entries) {
            str = String.valueOf(str) + entry.getKey() + " = " + entry.getValue() + "\n";
        }
        return str;
    }

    public class ImmutableEntry
    implements ReadOnlyDictionary.Entry<K, V> {
        private K key;
        private V value;

        protected ImmutableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }
    }
}

