/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection;

import ikor.collection.List;
import ikor.collection.ListIterator;
import ikor.collection.ReadOnlyCollection;
import ikor.collection.ReadOnlyList;
import java.util.ArrayList;
import java.util.Iterator;

public class DynamicList<T>
implements List<T> {
    private ArrayList<T> list = new ArrayList();

    public DynamicList() {
    }

    public DynamicList(T[] array) {
        int i = 0;
        while (i < array.length) {
            this.add(array[i]);
            ++i;
        }
    }

    public DynamicList(ReadOnlyCollection<T> list) {
        for (T t : list) {
            this.add(t);
        }
    }

    @Override
    public T get(int index) {
        if (index >= 0 && index < this.list.size()) {
            return this.list.get(index);
        }
        return null;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new ListIterator(this);
    }

    @Override
    public int add(T object) {
        if (this.list.add(object)) {
            return this.size() - 1;
        }
        return -1;
    }

    @Override
    public boolean remove(T object) {
        return this.list.remove(object);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public T set(int index, T object) {
        if (index >= this.list.size()) {
            this.list.ensureCapacity(index + 1);
            while (this.list.size() <= index) {
                this.list.add(null);
            }
        }
        return this.list.set(index, object);
    }

    @Override
    public T remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean contains(T object) {
        return this.list.contains(object);
    }

    @Override
    public int index(T object) {
        return this.list.indexOf(object);
    }

    public ReadOnlyList<T> get(Class type) {
        DynamicList<T> result = new DynamicList<T>();
        int i = 0;
        while (i < this.size()) {
            T element = this.get(i);
            if (type.isInstance(element)) {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.size()) {
            str = String.valueOf(str) + "  " + this.get(i) + "\n";
            ++i;
        }
        return str;
    }
}

