/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection;

import ikor.collection.CollectionIterator;
import ikor.collection.Evaluator;
import ikor.collection.EvaluatorComparator;
import ikor.collection.PriorityQueue;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DynamicPriorityQueue<T>
implements PriorityQueue<T> {
    private static final int INITIAL_CAPACITY = 8;
    private java.util.PriorityQueue<T> queue;

    public DynamicPriorityQueue() {
        this.queue = new java.util.PriorityQueue(8);
    }

    public DynamicPriorityQueue(Comparator comparator) {
        this.queue = new java.util.PriorityQueue(8, comparator);
    }

    public DynamicPriorityQueue(Evaluator evaluator) {
        this.queue = new java.util.PriorityQueue(8, new EvaluatorComparator(evaluator));
    }

    @Override
    public int add(T object) {
        if (this.queue.add(object)) {
            return this.size() - 1;
        }
        return -1;
    }

    @Override
    public boolean remove(T object) {
        return this.queue.remove(object);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean contains(T object) {
        return this.queue.contains(object);
    }

    @Override
    public Iterator<T> iterator() {
        return new PriorityQueueIterator();
    }

    @Override
    public T peek() {
        return this.queue.peek();
    }

    @Override
    public T get() {
        return this.queue.poll();
    }

    @Override
    public Comparator comparator() {
        return this.queue.comparator();
    }

    private class PriorityQueueIterator
    extends CollectionIterator<T> {
        private java.util.PriorityQueue<T> copy;

        public PriorityQueueIterator() {
            int capacity = DynamicPriorityQueue.this.queue.size() > 0 ? DynamicPriorityQueue.this.queue.size() : 1;
            this.copy = new java.util.PriorityQueue(capacity, DynamicPriorityQueue.this.queue.comparator());
            for (Object t : DynamicPriorityQueue.this.queue) {
                this.copy.add(t);
            }
        }

        @Override
        public boolean hasNext() {
            return this.copy.size() > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.copy.poll();
        }
    }
}

