/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection;

import ikor.collection.CollectionIterator;
import ikor.collection.Evaluator;
import ikor.collection.EvaluatorComparator;
import ikor.collection.Indexer;
import ikor.collection.PriorityQueue;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IndexedPriorityQueue<T>
implements PriorityQueue<T> {
    private int capacity;
    private int size;
    private int[] pq;
    private int[] qp;
    private T[] keys;
    private Indexer indexer;
    private Comparator comparator;

    public IndexedPriorityQueue(int capacity, Evaluator<T> evaluator, Indexer<T> indexer) {
        this(capacity, new EvaluatorComparator<T>(evaluator), indexer);
    }

    public IndexedPriorityQueue(int capacity, Comparator<T> comparator, Indexer<T> indexer) {
        this.indexer = indexer;
        this.comparator = comparator;
        this.capacity = capacity;
        this.clear();
    }

    @Override
    public int add(T object) {
        if (!this.contains(object)) {
            int ndx = this.indexer.index(object);
            this.qp[ndx] = ++this.size;
            this.pq[this.size] = ndx;
            this.keys[ndx] = object;
            this.swim(this.size);
            return this.size - 1;
        }
        return -1;
    }

    @Override
    public boolean remove(T object) {
        int ndx = this.indexer.index(object);
        if (ndx >= 0) {
            int pos = this.qp[ndx];
            this.exchange(pos, this.size--);
            this.swim(pos);
            this.sink(pos);
            this.qp[ndx] = -1;
            this.keys[ndx] = null;
            this.pq[this.size + 1] = -1;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.keys = new Object[this.capacity + 1];
        this.pq = new int[this.capacity + 1];
        this.qp = new int[this.capacity + 1];
        this.size = 0;
        int i = 0;
        while (i <= this.capacity) {
            this.qp[i] = -1;
            ++i;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(T object) {
        int ndx = this.indexer.index(object);
        return this.qp[ndx] != -1;
    }

    @Override
    public T peek() {
        return this.keys[this.pq[1]];
    }

    @Override
    public T get() {
        if (this.size > 0) {
            int ndx = this.pq[1];
            T min = this.keys[ndx];
            this.exchange(1, this.size--);
            this.sink(1);
            this.qp[ndx] = -1;
            this.keys[this.pq[this.size + 1]] = null;
            this.pq[this.size + 1] = -1;
            return min;
        }
        return null;
    }

    @Override
    public Comparator<T> comparator() {
        return this.comparator;
    }

    public Indexer<T> indexer() {
        return this.indexer;
    }

    @Override
    public Iterator<T> iterator() {
        return new HeapIterator();
    }

    private boolean greater(int i, int j) {
        return this.comparator.compare(this.keys[this.pq[i]], this.keys[this.pq[j]]) > 0;
    }

    private void exchange(int i, int j) {
        int swap = this.pq[i];
        this.pq[i] = this.pq[j];
        this.pq[j] = swap;
        this.qp[this.pq[i]] = i;
        this.qp[this.pq[j]] = j;
    }

    private void swim(int k) {
        while (k > 1 && this.greater(k / 2, k)) {
            this.exchange(k, k / 2);
            k /= 2;
        }
    }

    private void sink(int k) {
        while (2 * k <= this.size) {
            int j = 2 * k;
            if (j < this.size && this.greater(j, j + 1)) {
                ++j;
            }
            if (!this.greater(k, j)) break;
            this.exchange(k, j);
            k = j;
        }
    }

    private class HeapIterator
    extends CollectionIterator<T> {
        private IndexedPriorityQueue<T> copy;

        public HeapIterator() {
            this.copy = new IndexedPriorityQueue(IndexedPriorityQueue.this.pq.length - 1, IndexedPriorityQueue.this.comparator, IndexedPriorityQueue.this.indexer);
            int i = 1;
            while (i <= IndexedPriorityQueue.this.size) {
                this.copy.add(IndexedPriorityQueue.this.keys[IndexedPriorityQueue.this.pq[i]]);
                ++i;
            }
        }

        @Override
        public boolean hasNext() {
            return this.copy.size() > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.copy.get();
        }
    }
}

