/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection;

import ikor.collection.InOutCollection;
import ikor.collection.ReadOnlyCollection;
import java.util.ArrayDeque;
import java.util.Iterator;

public class Queue<T>
implements ReadOnlyCollection<T>,
InOutCollection<T> {
    ArrayDeque<T> items = new ArrayDeque();

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean contains(T object) {
        return this.items.contains(object);
    }

    public void enqueue(T object) {
        this.items.addLast(object);
    }

    @Override
    public int add(T object) {
        this.items.addLast(object);
        return this.size() - 1;
    }

    public T dequeue() {
        return this.items.removeFirst();
    }

    @Override
    public T get() {
        return this.items.removeFirst();
    }

    @Override
    public T peek() {
        return this.items.peekFirst();
    }

    public T get(int i) {
        throw new UnsupportedOperationException("Queues do not support random access methods");
    }

    public String toString() {
        Object[] array = this.items.toArray();
        String str = "";
        int i = 0;
        while (i < array.length) {
            str = String.valueOf(str) + "  " + array[i] + "\n";
            ++i;
        }
        return str;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    public boolean remove(T object) {
        if (object.equals(this.peek())) {
            this.dequeue();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.items.clear();
    }
}

