/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection;

import ikor.collection.CollectionIterator;
import ikor.collection.ReadOnlyList;
import java.util.Iterator;

public class StaticList<T>
implements ReadOnlyList<T> {
    private Object[] items;

    public StaticList(T singleton) {
        this.items = new Object[1];
        this.items[0] = singleton;
    }

    public StaticList(T[] array) {
        this.items = new Object[array.length];
        int i = 0;
        while (i < array.length) {
            this.items[i] = array[i];
            ++i;
        }
    }

    public StaticList(ReadOnlyList<T> list) {
        this.items = new Object[list.size()];
        int i = 0;
        while (i < this.items.length) {
            this.items[i] = list.get(i);
            ++i;
        }
    }

    @Override
    public T get(int index) {
        return (T)this.items[index];
    }

    @Override
    public int size() {
        return this.items.length;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator();
    }

    @Override
    public boolean contains(T object) {
        return this.index(object) != -1;
    }

    @Override
    public int index(T object) {
        if (object != null) {
            int i = 0;
            while (i < this.items.length) {
                if (object.equals(this.items[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public class ArrayIterator<X>
    extends CollectionIterator<X> {
        private int current = 0;

        @Override
        public boolean hasNext() {
            return this.current < StaticList.this.items.length;
        }

        @Override
        public X next() {
            return (X)StaticList.this.items[this.current++];
        }
    }
}

