/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.graph;

import ikor.collection.Dictionary;
import ikor.collection.DynamicDictionary;
import ikor.collection.DynamicList;
import ikor.collection.List;
import ikor.collection.ReadOnlyList;
import ikor.collection.graph.GraphInterface;
import ikor.collection.graph.GraphLink;
import ikor.collection.graph.GraphNode;
import ikor.collection.graph.GraphNodeImplementation;
import ikor.collection.graph.GraphNodeIterator;
import ikor.collection.graph.ReadOnlyGraphImplementation;
import java.util.Iterator;

public class GraphImplementation<V, E>
extends ReadOnlyGraphImplementation<V, E>
implements GraphInterface<V, E> {
    private Dictionary<V, Integer> index = new DynamicDictionary<V, Integer>();
    private List<GraphNodeImplementation<V>> nodes = new DynamicList<GraphNodeImplementation<V>>();
    private boolean directed;

    public GraphImplementation(boolean directed) {
        this.directed = directed;
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public GraphNode<V> getNode(int nodeIndex) {
        if (nodeIndex >= 0 && nodeIndex < this.nodes.size()) {
            return (GraphNode)this.nodes.get(nodeIndex);
        }
        return null;
    }

    @Override
    public V get(int nodeIndex) {
        return ((GraphNodeImplementation)this.nodes.get(nodeIndex)).getContent();
    }

    @Override
    public void set(int nodeIndex, V nodeValue) {
        this.index.remove(this.get(nodeIndex));
        this.index.set((Integer)nodeValue, nodeIndex);
        ((GraphNodeImplementation)this.nodes.get(nodeIndex)).setContent(nodeValue);
    }

    @Override
    public int index(V node) {
        Integer entry = (Integer)this.index.get(node);
        if (entry != null) {
            return entry;
        }
        return -1;
    }

    @Override
    public int index(GraphNode<V> node) {
        Integer result = (Integer)this.index.get(node.getContent());
        if (result != null) {
            return result;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public int links() {
        int total = 0;
        int i = 0;
        while (i < this.size()) {
            total += ((GraphNodeImplementation)this.nodes.get(i)).degree();
            ++i;
        }
        if (!this.isDirected()) {
            total /= 2;
        }
        return total;
    }

    @Override
    public int degree(int i) {
        if (i >= 0 && i < this.size()) {
            return ((GraphNodeImplementation)this.nodes.get(i)).degree();
        }
        return 0;
    }

    @Override
    public int degree(V node) {
        return this.degree(this.index(node));
    }

    @Override
    public int inDegree(int i) {
        if (i >= 0 && i < this.size()) {
            return ((GraphNodeImplementation)this.nodes.get(i)).inDegree();
        }
        return 0;
    }

    @Override
    public int inDegree(V node) {
        return this.inDegree(this.index(node));
    }

    @Override
    public int outDegree(int i) {
        if (i >= 0 && i < this.size()) {
            return ((GraphNodeImplementation)this.nodes.get(i)).outDegree();
        }
        return 0;
    }

    @Override
    public int outDegree(V node) {
        return this.outDegree(this.index(node));
    }

    @Override
    public E get(int source, int destination) {
        GraphLink<E> link = this.getLink(this.getNode(source), this.getNode(destination));
        if (link != null) {
            return link.getContent();
        }
        return null;
    }

    @Override
    public E get(V source, V destination) {
        GraphLink<E> link = this.getLink(this.getNode(source), this.getNode(destination));
        if (link != null) {
            return link.getContent();
        }
        return null;
    }

    @Override
    public GraphLink<E> getLink(GraphNode<V> source, GraphNode<V> destination) {
        if (source != null && destination != null) {
            int degree = source.outDegree();
            int i = 0;
            while (i < degree) {
                GraphLink link = source.outLink(i);
                if (link.getDestination().equals(destination) || !this.isDirected() && link.getSource().equals(destination)) {
                    return link;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public ReadOnlyList<GraphLink<E>> outLinkList(int node) {
        DynamicList<GraphLink> list = null;
        if (node >= 0 && node < this.size()) {
            list = new DynamicList<GraphLink>();
            for (GraphLink link : ((GraphNodeImplementation)this.nodes.get(node)).outLinks()) {
                list.add(link);
            }
        }
        return list;
    }

    @Override
    public ReadOnlyList<GraphLink<E>> inLinkList(int node) {
        DynamicList<GraphLink> list = null;
        if (node >= 0 && node < this.size()) {
            list = new DynamicList<GraphLink>();
            for (GraphLink link : ((GraphNodeImplementation)this.nodes.get(node)).inLinks()) {
                list.add(link);
            }
        }
        return list;
    }

    @Override
    public int add(V node) {
        int pos = this.size();
        this.index.set((Integer)node, pos);
        this.nodes.add(new GraphNodeImplementation<V>(node));
        return pos;
    }

    @Override
    public boolean add(V source, V destination, E content) {
        return this.add(this.index(source), this.index(destination), content);
    }

    @Override
    public boolean add(int sourceIndex, int destinationIndex, E content) {
        if (sourceIndex >= 0 && sourceIndex < this.size() && destinationIndex >= 0 && destinationIndex < this.size()) {
            GraphLink<E> link = this.getLink(this.getNode(sourceIndex), this.getNode(destinationIndex));
            if (link == null) {
                GraphNodeImplementation source = (GraphNodeImplementation)this.nodes.get(sourceIndex);
                GraphNodeImplementation destination = (GraphNodeImplementation)this.nodes.get(destinationIndex);
                link = new GraphLink<E>(source, destination, content);
                source.addOutLink(link);
                destination.addInLink(link);
                if (!this.isDirected()) {
                    source.addInLink(link);
                    destination.addOutLink(link);
                }
            } else {
                link.setContent(content);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(V node) {
        return this.remove(this.index(node));
    }

    @Override
    public boolean remove(GraphNode<V> node) {
        return this.remove(this.index(node));
    }

    @Override
    public boolean remove(int nodeIndex) {
        if (nodeIndex >= 0 && nodeIndex < this.size()) {
            GraphNodeImplementation node = (GraphNodeImplementation)this.nodes.get(nodeIndex);
            while (node.outDegree() > 0) {
                this.remove(node.outLink(0));
            }
            while (node.inDegree() > 0) {
                this.remove(node.inLink(0));
            }
            this.nodes.remove(node);
            this.index.remove(node.getContent());
            int i = nodeIndex;
            while (i < this.size()) {
                this.index.set((Integer)((GraphNodeImplementation)this.nodes.get(i)).getContent(), i);
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(V source, V destination, E content) {
        return this.remove(this.index(source), this.index(destination), content);
    }

    @Override
    public boolean remove(int sourceIndex, int destinationIndex, E content) {
        if (sourceIndex >= 0 && sourceIndex < this.size() && destinationIndex >= 0 && destinationIndex < this.size()) {
            GraphNodeImplementation source = (GraphNodeImplementation)this.nodes.get(sourceIndex);
            GraphNodeImplementation destination = (GraphNodeImplementation)this.nodes.get(destinationIndex);
            int i = 0;
            while (i < source.outDegree()) {
                Object linkContent;
                GraphLink link = source.outLink(i);
                if (link.getDestination() == destination && ((linkContent = link.getContent()) == content || linkContent != null && linkContent.equals(content) || content != null && content.equals(linkContent))) {
                    this.remove(source.outLink(i));
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean remove(GraphLink<E> link) {
        GraphNodeImplementation source = (GraphNodeImplementation)link.getSource();
        GraphNodeImplementation destination = (GraphNodeImplementation)link.getDestination();
        source.removeOutLink(link);
        destination.removeInLink(link);
        if (!this.isDirected()) {
            source.removeInLink(link);
            destination.removeOutLink(link);
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.size()) + " NODES");
        buffer.append(" + " + this.links() + (this.isDirected() ? " ARCS\n" : " LINKS\n"));
        int i = 0;
        while (i < this.size()) {
            buffer.append("- " + this.get(i).toString() + "\n");
            if (this.isDirected()) {
                this.toStringBuffer(buffer, "OUT", ((GraphNodeImplementation)this.nodes.get(i)).outLinks());
                this.toStringBuffer(buffer, "IN", ((GraphNodeImplementation)this.nodes.get(i)).inLinks());
            } else {
                this.toStringBuffer(buffer, "Links", ((GraphNodeImplementation)this.nodes.get(i)).outLinks());
            }
            ++i;
        }
        return buffer.toString();
    }

    private void toStringBuffer(StringBuffer buffer, String label, ReadOnlyList<GraphLink> arcs) {
        if (arcs != null && arcs.size() > 0) {
            buffer.append("  " + arcs.size() + " " + label + "\n");
            int j = 0;
            while (j < arcs.size()) {
                GraphLink arc = arcs.get(j);
                buffer.append("    " + arc.toString() + ")\n");
                ++j;
            }
        }
    }

    @Override
    public boolean contains(V object) {
        return this.index.get(object) != null;
    }

    @Override
    public Iterator<V> iterator() {
        return new GraphNodeIterator(this);
    }

    @Override
    public void clear() {
        this.index.clear();
        this.nodes.clear();
    }
}

