/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.graph;

import ikor.collection.CollectionIterator;
import ikor.collection.graph.ReadOnlyGraph;

public class GraphLinkIterator<E>
extends CollectionIterator<E> {
    ReadOnlyGraph<?, E> graph;
    int nodeIndex;
    int linkIndex;
    int lastNode;
    int lastLink;
    int[] links;

    public GraphLinkIterator(ReadOnlyGraph<?, E> graph) {
        this(graph, 0, graph.size() - 1);
    }

    public GraphLinkIterator(ReadOnlyGraph<?, E> graph, int start, int end) {
        this.graph = graph;
        this.nodeIndex = start;
        this.lastNode = end;
        this.links = graph.outLinks(start);
        this.linkIndex = 0;
        this.lastLink = graph.outDegree(start) - 1;
    }

    @Override
    public boolean hasNext() {
        return this.nodeIndex <= this.lastNode && this.linkIndex <= this.lastLink;
    }

    @Override
    public E next() {
        E result = null;
        if (this.nodeIndex <= this.lastNode && this.linkIndex <= this.lastLink) {
            result = this.graph.get(this.nodeIndex, this.links[this.linkIndex]);
            ++this.linkIndex;
            if (this.linkIndex > this.lastLink) {
                this.linkIndex = 0;
                do {
                    ++this.nodeIndex;
                    if (this.nodeIndex >= this.graph.size()) continue;
                    this.links = this.graph.outLinks(this.nodeIndex);
                    this.lastLink = this.graph.outDegree(this.nodeIndex) - 1;
                } while (this.nodeIndex <= this.lastNode && this.linkIndex > this.lastLink);
            }
        }
        return result;
    }
}

