/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.graph;

import ikor.collection.DynamicList;
import ikor.collection.ReadOnlyList;
import ikor.collection.graph.GraphLink;
import ikor.collection.graph.GraphNode;

class GraphNodeImplementation<V>
implements GraphNode<V> {
    private V content;
    private DynamicList<GraphLink> in;
    private DynamicList<GraphLink> out;

    public GraphNodeImplementation(V content) {
        this.setContent(content);
    }

    @Override
    public V getContent() {
        return this.content;
    }

    public void setContent(V content) {
        this.content = content;
    }

    public ReadOnlyList<GraphLink> outLinks() {
        if (this.out == null) {
            this.out = new DynamicList();
        }
        return this.out;
    }

    public ReadOnlyList<GraphLink> inLinks() {
        if (this.in == null) {
            this.in = new DynamicList();
        }
        return this.in;
    }

    @Override
    public GraphLink outLink(int arc) {
        return this.out.get(arc);
    }

    @Override
    public GraphLink inLink(int arc) {
        return this.in.get(arc);
    }

    public void addOutLink(GraphLink link) {
        if (this.out == null) {
            this.out = new DynamicList();
        }
        this.out.add(link);
    }

    public void addInLink(GraphLink link) {
        if (this.in == null) {
            this.in = new DynamicList();
        }
        this.in.add(link);
    }

    public void removeOutLink(GraphLink link) {
        this.out.remove(link);
    }

    public void removeInLink(GraphLink link) {
        this.in.remove(link);
    }

    @Override
    public int degree() {
        return this.outDegree();
    }

    @Override
    public int inDegree() {
        if (this.in != null) {
            return this.in.size();
        }
        return 0;
    }

    @Override
    public int outDegree() {
        if (this.out != null) {
            return this.out.size();
        }
        return 0;
    }

    public String toString() {
        return this.content.toString();
    }
}

