/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.graph;

import ikor.collection.ReadOnlyList;
import ikor.collection.graph.GraphLink;
import ikor.collection.graph.GraphNode;
import ikor.collection.graph.ReadOnlyGraphInterface;

public abstract class ReadOnlyGraphImplementation<V, E>
implements ReadOnlyGraphInterface<V, E> {
    @Override
    public abstract int index(GraphNode<V> var1);

    @Override
    public abstract GraphNode<V> getNode(int var1);

    @Override
    public final GraphNode<V> getNode(V node) {
        return this.getNode((V)this.index(node));
    }

    @Override
    public abstract GraphLink<E> getLink(GraphNode<V> var1, GraphNode<V> var2);

    @Override
    public final GraphLink<E> getLink(int source, int destination) {
        return this.getLink((V)this.getNode((V)source), (V)this.getNode((V)destination));
    }

    @Override
    public final GraphLink<E> getLink(V source, V destination) {
        return this.getLink((V)this.getNode(source), (V)this.getNode(destination));
    }

    @Override
    public abstract ReadOnlyList<GraphLink<E>> outLinkList(int var1);

    @Override
    public final ReadOnlyList<GraphLink<E>> outLinkList(V node) {
        return this.outLinkList((V)this.index(node));
    }

    @Override
    public abstract ReadOnlyList<GraphLink<E>> inLinkList(int var1);

    @Override
    public final ReadOnlyList<GraphLink<E>> inLinkList(V node) {
        return this.inLinkList((V)this.index(node));
    }

    @Override
    public final int outLink(int node, int index) {
        ReadOnlyList<GraphLink<E>> list = this.outLinkList((V)node);
        if (this.isDirected()) {
            return this.index(list.get(index).getDestination());
        }
        GraphLink<E> link = list.get(index);
        if (node == this.index(link.getSource())) {
            return this.index(link.getDestination());
        }
        return this.index(link.getSource());
    }

    @Override
    public final int[] outLinks(int node) {
        ReadOnlyList<GraphLink<E>> list = this.outLinkList((V)node);
        int[] array = new int[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = this.outLink(node, i);
            ++i;
        }
        return array;
    }

    @Override
    public final int[] outLinks(V node) {
        return this.outLinks(this.index(node));
    }

    @Override
    public final int inLink(int node, int index) {
        ReadOnlyList<GraphLink<E>> list = this.inLinkList((V)node);
        if (this.isDirected()) {
            return this.index(list.get(index).getSource());
        }
        GraphLink<E> link = list.get(index);
        if (node == this.index(link.getDestination())) {
            return this.index(link.getSource());
        }
        return this.index(link.getDestination());
    }

    @Override
    public final int[] inLinks(int node) {
        ReadOnlyList<GraphLink<E>> list = this.inLinkList((V)node);
        int[] array = new int[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = this.inLink(node, i);
            ++i;
        }
        return array;
    }

    @Override
    public final int[] inLinks(V node) {
        return this.inLinks(this.index(node));
    }
}

