/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.graph.search;

import ikor.collection.Queue;
import ikor.collection.ReadOnlyList;
import ikor.collection.Visitor;
import ikor.collection.graph.GraphLink;
import ikor.collection.graph.GraphNode;
import ikor.collection.graph.ReadOnlyGraphInterface;
import ikor.collection.graph.search.GraphSearch;

public class BFS<V, E>
extends GraphSearch<V, E> {
    public BFS(ReadOnlyGraphInterface<V, E> graph) {
        super(graph);
    }

    public BFS(ReadOnlyGraphInterface<V, E> graph, Visitor<GraphNode<V>> nodeVisitor, Visitor<GraphLink<E>> linkVisitor) {
        super(graph, nodeVisitor, linkVisitor);
    }

    @Override
    public void explore(GraphNode<V> start) {
        Queue<GraphNode> queue = new Queue<GraphNode>();
        queue.enqueue(start);
        while (queue.size() > 0) {
            GraphNode current = (GraphNode)queue.dequeue();
            int currentIndex = this.graph.index(current);
            this.state[currentIndex] = GraphSearch.State.DISCOVERED;
            this.visitNode(current);
            ReadOnlyList links = this.graph.outLinkList(currentIndex);
            if (links != null) {
                int i = 0;
                while (i < links.size()) {
                    GraphLink link = links.get(i);
                    this.visitLink(link);
                    GraphNode target = this.graph.isDirected() ? link.getDestination() : (link.getDestination() == current ? link.getSource() : link.getDestination());
                    int targetIndex = this.graph.index(target);
                    if (this.state[targetIndex] == GraphSearch.State.UNDISCOVERED) {
                        queue.enqueue(target);
                        this.state[targetIndex] = GraphSearch.State.DISCOVERED;
                    }
                    ++i;
                }
            }
            this.state[currentIndex] = GraphSearch.State.EXPLORED;
        }
    }
}

