/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.graph.search;

import ikor.collection.Visitor;
import ikor.collection.graph.GraphLink;
import ikor.collection.graph.GraphNode;
import ikor.collection.graph.ReadOnlyGraphInterface;
import java.util.Arrays;

public abstract class GraphSearch<V, E> {
    protected ReadOnlyGraphInterface<V, E> graph;
    protected State[] state;
    private Visitor<GraphNode<V>> nodeVisitor;
    private Visitor<GraphLink<E>> linkVisitor;

    public GraphSearch(ReadOnlyGraphInterface<V, E> graph) {
        this(graph, null, null);
    }

    public GraphSearch(ReadOnlyGraphInterface<V, E> graph, Visitor<GraphNode<V>> nodeVisitor, Visitor<GraphLink<E>> linkVisitor) {
        this.graph = graph;
        this.state = new State[graph.size()];
        Arrays.fill((Object[])this.state, (Object)State.UNDISCOVERED);
        this.nodeVisitor = nodeVisitor;
        this.linkVisitor = linkVisitor;
    }

    public void setNodeVisitor(Visitor<GraphNode<V>> visitor) {
        this.nodeVisitor = visitor;
    }

    protected void visitNode(GraphNode<V> node) {
        if (this.nodeVisitor != null) {
            this.nodeVisitor.visit(node);
        }
    }

    public void setLinkVisitor(Visitor<GraphLink<E>> visitor) {
        this.linkVisitor = visitor;
    }

    protected void visitLink(GraphLink<E> link) {
        if (this.linkVisitor != null) {
            this.linkVisitor.visit(link);
        }
    }

    public final void explore() {
        this.explore(0);
    }

    public final void explore(int index) {
        this.explore(this.graph.getNode(index));
    }

    public abstract void explore(GraphNode<V> var1);

    public State status(int index) {
        return this.state[index];
    }

    public State status(GraphNode<V> node) {
        return this.status(this.graph.index(node));
    }

    public static enum State {
        UNDISCOVERED,
        DISCOVERED,
        EXPLORED;

    }
}

