/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.index;

import ikor.collection.index.Index;

public class ArrayIndex
implements Index {
    private int currentSize = 0;
    private int[] values;
    private static final int INITIAL_CAPACITY = 4;

    public ArrayIndex() {
        this.resizeArray(4);
    }

    private final void resizeArray(int capacity) {
        int[] oldValues = this.values;
        this.values = new int[capacity];
        if (oldValues != null) {
            System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
        }
    }

    @Override
    public int get(int position) {
        return this.values[position];
    }

    @Override
    public int size() {
        return this.currentSize;
    }

    @Override
    public int index(int value) {
        int i = 0;
        while (i < this.size()) {
            if (this.get(i) == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean contains(int value) {
        return this.index(value) != -1;
    }

    @Override
    public void set(int index, int value) {
        if (index >= 0 && index < this.values.length) {
            this.values[index] = value;
        }
    }

    @Override
    public boolean add(int value) {
        if (this.values.length <= this.currentSize) {
            this.resizeArray(2 * this.values.length);
        }
        this.values[this.currentSize] = value;
        ++this.currentSize;
        return true;
    }

    @Override
    public int remove(int index) {
        int value = 0;
        if (index >= 0 && index < this.currentSize) {
            value = this.get(index);
            System.arraycopy(this.values, index + 1, this.values, index, this.currentSize - 1 - index);
            --this.currentSize;
        }
        return value;
    }

    @Override
    public boolean removeValue(int value) {
        int position = this.index(value);
        if (position != -1) {
            this.remove(position);
            return true;
        }
        return false;
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.currentSize) {
            str = String.valueOf(str) + " " + this.values[i];
            ++i;
        }
        return str;
    }

    @Override
    public int[] values() {
        int[] v = new int[this.currentSize];
        int i = 0;
        while (i < v.length) {
            v[i] = this.values[i];
            ++i;
        }
        return v;
    }
}

