/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.index;

import ikor.collection.index.Index;

public class HeapIndex
implements Index {
    private int currentSize = 0;
    private int[] values;
    private static final int INITIAL_CAPACITY = 4;

    public HeapIndex() {
        this.resizeArray(4);
    }

    private final void resizeArray(int capacity) {
        int[] oldValues = this.values;
        this.values = new int[capacity];
        if (oldValues != null) {
            System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
        }
    }

    @Override
    public int get(int position) {
        return this.values[position];
    }

    @Override
    public int size() {
        return this.currentSize;
    }

    @Override
    public int index(int value) {
        int i = 0;
        while (i < this.size()) {
            if (this.get(i) == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean contains(int value) {
        return this.index(value) != -1;
    }

    @Override
    public void set(int index, int value) {
        if (index >= 0 && index < this.values.length) {
            this.remove(index);
            this.add(value);
        }
    }

    protected int parent(int k) {
        return (k - 1) / 2;
    }

    protected int leftChild(int k) {
        return 2 * k + 1;
    }

    protected int rightChild(int k) {
        return 2 * k + 2;
    }

    private void swim(int k) {
        int parent = this.parent(k);
        while (k > 1 && this.values[parent] > this.values[k]) {
            int tmp = this.values[k];
            this.values[k] = this.values[parent];
            this.values[parent] = tmp;
            k = parent;
            parent = this.parent(k);
        }
    }

    private void sink(int k) {
        boolean finished = false;
        while (this.leftChild(k) < this.currentSize && !finished) {
            int j = this.leftChild(k);
            if (j < this.currentSize - 1 && this.values[j] > this.values[j + 1]) {
                ++j;
            }
            if (this.values[k] > this.values[j]) {
                int tmp = this.values[k];
                this.values[k] = this.values[j];
                this.values[j] = tmp;
            } else {
                finished = true;
            }
            k = j;
        }
    }

    @Override
    public boolean add(int value) {
        int last = this.currentSize;
        if (this.values.length <= this.currentSize) {
            this.resizeArray(2 * this.values.length);
        }
        this.values[last] = value;
        ++this.currentSize;
        this.swim(last);
        return true;
    }

    @Override
    public int remove(int index) {
        int value = 0;
        if (index >= 0 && index < this.currentSize) {
            value = this.values[index];
            this.values[index] = this.values[this.currentSize - 1];
            --this.currentSize;
            this.sink(index);
        }
        return value;
    }

    @Override
    public boolean removeValue(int value) {
        int position = this.index(value);
        if (position != -1) {
            this.remove(position);
            return true;
        }
        return false;
    }

    @Override
    public int[] values() {
        int[] v = new int[this.currentSize];
        int i = 0;
        while (i < v.length) {
            v[i] = this.values[i];
            ++i;
        }
        return v;
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.currentSize) {
            str = String.valueOf(str) + " " + this.values[i];
            ++i;
        }
        return str;
    }
}

