/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.relation;

import ikor.collection.DynamicList;
import ikor.collection.ReadOnlyCollection;
import ikor.collection.ReadOnlyList;
import ikor.collection.StaticList;
import ikor.collection.relation.Relation;
import java.util.Iterator;

public abstract class Matching<X, Y>
implements Relation<X, Y> {
    private ReadOnlyList<X> x;
    private ReadOnlyList<Y> y;
    private int[] matchX;
    private int[] matchY;

    @Override
    public ReadOnlyList<X> getX() {
        return this.x;
    }

    public void setX(ReadOnlyList<X> collection) {
        this.x = collection;
        this.matchX = new int[this.x.size()];
        int i = 0;
        while (i < this.matchX.length) {
            this.matchX[i] = -1;
            ++i;
        }
    }

    @Override
    public ReadOnlyList<Y> getY() {
        return this.y;
    }

    public void setY(ReadOnlyList<Y> collection) {
        this.y = collection;
        this.matchY = new int[this.y.size()];
        int i = 0;
        while (i < this.matchY.length) {
            this.matchY[i] = -1;
            ++i;
        }
    }

    public abstract float match();

    public final void reset() {
        int i = 0;
        while (i < this.matchX.length) {
            this.matchX[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.matchY.length) {
            this.matchY[i] = -1;
            ++i;
        }
    }

    @Override
    public final int size() {
        int n = 0;
        int i = 0;
        while (i < this.sizeX()) {
            if (this.matchX[i] != -1) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public final int sizeX() {
        return this.matchX != null ? this.matchX.length : 0;
    }

    public final int sizeY() {
        return this.matchY != null ? this.matchY.length : 0;
    }

    public final Y getXMatch(int i) {
        if (this.matchX[i] != -1) {
            return this.y.get(this.matchX[i]);
        }
        return null;
    }

    public final int getXMatchIndex(int i) {
        return this.matchX[i];
    }

    public final X getYMatch(int j) {
        if (this.matchY[j] != -1) {
            return this.x.get(this.matchY[j]);
        }
        return null;
    }

    public final int getYMatchIndex(int j) {
        return this.matchY[j];
    }

    protected final void match(int i, int j) {
        if (this.matchX[i] != -1) {
            this.matchY[this.matchX[i]] = -1;
        }
        if (this.matchY[j] != -1) {
            this.matchX[this.matchY[j]] = -1;
        }
        this.matchX[i] = j;
        this.matchY[j] = i;
    }

    @Override
    public ReadOnlyCollection<Y> getY(X key) {
        int xIndex = this.x.index(key);
        if (xIndex != -1) {
            return new StaticList<Y>(this.y.get(this.matchX[xIndex]));
        }
        return null;
    }

    @Override
    public ReadOnlyCollection<X> getX(Y key) {
        int yIndex = this.y.index(key);
        if (yIndex != -1) {
            return new StaticList<X>(this.x.get(this.matchY[yIndex]));
        }
        return null;
    }

    @Override
    public boolean contains(Relation.Pair<X, Y> pair) {
        int xIndex = this.x.index(pair.getX());
        int yIndex = this.y.index(pair.getY());
        if (xIndex != -1 && yIndex != -1) {
            return this.matchX[xIndex] == yIndex;
        }
        return false;
    }

    @Override
    public ReadOnlyCollection<Relation.Pair<X, Y>> pairs() {
        DynamicList<Relation.Pair<X, Y>> list = new DynamicList<Relation.Pair<X, Y>>();
        int i = 0;
        while (i < this.sizeX()) {
            if (this.matchX[i] != -1) {
                list.add(new Relation.Pair<X, Y>(this.x.get(i), this.y.get(this.matchX[i])));
            }
            ++i;
        }
        return list;
    }

    @Override
    public Iterator<Relation.Pair<X, Y>> iterator() {
        return this.pairs().iterator();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.sizeX()) {
            result.append(this.x.get(i) + " -> " + this.getXMatch(i) + "\n");
            ++i;
        }
        return result.toString();
    }
}

