/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.sequence;

import ikor.collection.ListIterator;
import ikor.collection.sequence.Sequence;
import java.util.Iterator;

public class Subsequence<T>
implements Sequence<T> {
    private Sequence<T> original;
    private int start;
    private int end;

    public Subsequence(Sequence<T> original, int start, int end) {
        this.original = original;
        this.start = start;
        this.end = end;
    }

    @Override
    public int size() {
        return this.end - this.start + 1;
    }

    @Override
    public T get(int index) {
        if (index >= 0 && index < this.size()) {
            return this.original.get(this.start + index);
        }
        return null;
    }

    @Override
    public boolean contains(T object) {
        return this.index(object) != -1;
    }

    @Override
    public int index(T object) {
        if (object != null) {
            int i = 0;
            while (i < this.size()) {
                if (object.equals(this.get(this.start + i))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new ListIterator(this, this.start, this.end);
    }
}

