/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.sequence.alignment;

import ikor.collection.sequence.Sequence;
import ikor.collection.sequence.StringSequence;
import ikor.collection.sequence.alignment.Alignment;
import ikor.util.similarity.Equality;
import ikor.util.similarity.SimilarityMetric;

public class BackwardAlignment<T>
extends Alignment<T> {
    private SimilarityMetric<T> sm;
    private float penalty;
    protected float[] cost;

    public BackwardAlignment(SimilarityMetric<T> sm, float penalty) {
        this.sm = sm;
        this.penalty = penalty;
    }

    @Override
    public float match() {
        Sequence x = (Sequence)this.getX();
        Sequence y = (Sequence)this.getY();
        return this.align(x, y);
    }

    @Override
    public float align(Sequence<T> x, Sequence<T> y) {
        float[] prev = new float[x.size() + 1];
        float[] current = new float[x.size() + 1];
        int i = 0;
        while (i <= x.size()) {
            prev[i] = (float)(x.size() - i) * this.penalty;
            ++i;
        }
        int j = y.size();
        while (j >= 0) {
            current[x.size()] = (float)(y.size() - j) * this.penalty;
            i = x.size() - 1;
            while (i >= 0) {
                current[i] = this.sm.mismatch(x.get(i), y.get(j)) + prev[i + 1];
                if (current[i + 1] + this.penalty < current[i]) {
                    current[i] = current[i + 1] + this.penalty;
                }
                if (prev[i] + this.penalty < current[i]) {
                    current[i] = prev[i] + this.penalty;
                }
                --i;
            }
            float[] tmp = prev;
            prev = current;
            current = tmp;
            --j;
        }
        this.cost = prev;
        return this.cost[0];
    }

    @Override
    public float cost() {
        return this.cost[0];
    }

    @Override
    public String toString() {
        return "Backward alignment algorithm";
    }

    public static void main(String[] args) {
        StringSequence x = new StringSequence("occurrence");
        StringSequence y = new StringSequence("ocurrance");
        BackwardAlignment<Character> alignment = new BackwardAlignment<Character>(new Equality(), 1.0f);
        ((Alignment)alignment).align(x, y);
        System.out.println("Alignment cost: " + ((Alignment)alignment).cost());
        System.out.println(alignment);
    }
}

