/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.sequence.alignment;

import ikor.collection.sequence.Sequence;
import ikor.collection.sequence.StringSequence;
import ikor.collection.sequence.Subsequence;
import ikor.collection.sequence.alignment.Alignment;
import ikor.collection.sequence.alignment.BackwardAlignment;
import ikor.collection.sequence.alignment.DPAlignment;
import ikor.collection.sequence.alignment.ForwardAlignment;
import ikor.util.similarity.Equality;
import ikor.util.similarity.SimilarityMetric;

public class DCAlignment<T>
extends Alignment<T> {
    private SimilarityMetric<T> sm;
    private float penalty;
    private DPAlignment<T> standard;
    private ForwardAlignment<T> forward;
    private BackwardAlignment<T> backward;
    private final int SIZE_THRESHOLD = 2;

    public DCAlignment(SimilarityMetric<T> sm, float penalty) {
        this.sm = sm;
        this.penalty = penalty;
    }

    @Override
    public float match() {
        Sequence x = (Sequence)this.getX();
        Sequence y = (Sequence)this.getY();
        this.forward = new ForwardAlignment<T>(this.sm, this.penalty);
        this.backward = new BackwardAlignment<T>(this.sm, this.penalty);
        this.standard = new DPAlignment<T>(this.sm, this.penalty);
        this.alignment(x, 0, y, 0);
        return this.cost();
    }

    private void alignment(Sequence x, int startX, Sequence y, int startY) {
        if (x.size() <= 2 || y.size() <= 2) {
            this.standard.align(x, y);
            int i = 0;
            while (i < x.size()) {
                if (this.standard.getXMatchIndex(i) != -1) {
                    this.match(startX + i, startY + this.standard.getXMatchIndex(i));
                }
                ++i;
            }
        } else {
            Subsequence y1 = new Subsequence(y, 0, y.size() / 2);
            Subsequence y2 = new Subsequence(y, y.size() / 2 + 1, y.size() - 1);
            this.forward.align(x, y1);
            this.backward.align(x, y2);
            int q = 0;
            int i = 1;
            while (i <= x.size()) {
                if (this.forward.cost[i] + this.backward.cost[i] < this.forward.cost[q] + this.backward.cost[q]) {
                    q = i;
                }
                ++i;
            }
            Subsequence x1 = new Subsequence(x, 0, q - 1);
            Subsequence x2 = new Subsequence(x, q, x.size() - 1);
            this.alignment(x1, startX, y1, startY);
            this.alignment(x2, startX + q, y2, startY + y.size() / 2 + 1);
        }
    }

    @Override
    public float cost() {
        Sequence x = (Sequence)this.getX();
        Sequence y = (Sequence)this.getY();
        float result = 0.0f;
        int matches = 0;
        int i = 0;
        while (i < x.size()) {
            int j = this.getXMatchIndex(i);
            if (j != -1) {
                result += this.sm.mismatch(x.get(i), y.get(j));
                ++matches;
            } else {
                result += this.penalty;
            }
            ++i;
        }
        return result += this.penalty * (float)(y.size() - matches);
    }

    public static void main(String[] args) {
        StringSequence x = new StringSequence("abbbaabbbbaab");
        StringSequence y = new StringSequence("ababaaabbbbbab");
        DCAlignment<Character> alignment = new DCAlignment<Character>(new Equality(), 1.0f);
        alignment.align(x, y);
        System.out.println("Alignment cost: " + ((Alignment)alignment).cost());
        System.out.println(alignment);
    }
}

