/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.sequence.alignment;

import ikor.collection.sequence.Sequence;
import ikor.collection.sequence.StringSequence;
import ikor.collection.sequence.alignment.Alignment;
import ikor.util.similarity.Equality;
import ikor.util.similarity.SimilarityMetric;

public class DPAlignment<T>
extends Alignment<T> {
    private SimilarityMetric<T> sm;
    private float penalty;
    private float[][] cost;

    public DPAlignment(SimilarityMetric<T> sm, float penalty) {
        this.sm = sm;
        this.penalty = penalty;
    }

    @Override
    public float match() {
        Sequence x = (Sequence)this.getX();
        Sequence y = (Sequence)this.getY();
        this.cost = this.getCosts(x, y);
        this.findSolution(x, y, this.cost);
        return this.cost[x.size()][y.size()];
    }

    private float[][] getCosts(Sequence<T> x, Sequence<T> y) {
        float[][] cost = new float[x.size() + 1][y.size() + 1];
        int i = 0;
        while (i <= x.size()) {
            cost[i][0] = (float)i * this.penalty;
            ++i;
        }
        int j = 0;
        while (j <= y.size()) {
            cost[0][j] = (float)j * this.penalty;
            ++j;
        }
        i = 1;
        while (i <= x.size()) {
            j = 1;
            while (j <= y.size()) {
                cost[i][j] = this.sm.mismatch(x.get(i - 1), y.get(j - 1)) + cost[i - 1][j - 1];
                if (cost[i - 1][j] + this.penalty < cost[i][j]) {
                    cost[i][j] = cost[i - 1][j] + this.penalty;
                }
                if (cost[i][j - 1] + this.penalty < cost[i][j]) {
                    cost[i][j] = cost[i][j - 1] + this.penalty;
                }
                ++j;
            }
            ++i;
        }
        return cost;
    }

    private void findSolution(Sequence<T> x, Sequence<T> y, float[][] cost) {
        int i = x.size();
        int j = y.size();
        while (i > 0 && j > 0) {
            if (cost[i][j] == this.sm.mismatch(x.get(i - 1), y.get(j - 1)) + cost[i - 1][j - 1]) {
                this.match(i - 1, j - 1);
                --j;
                --i;
                continue;
            }
            if (cost[i][j] == cost[i - 1][j] + this.penalty) {
                --i;
                continue;
            }
            if (cost[i][j] != cost[i][j - 1] + this.penalty) continue;
            --j;
        }
    }

    @Override
    public float cost() {
        return this.cost[this.sizeX()][this.sizeY()];
    }

    @Override
    public String toString() {
        String result = String.valueOf(super.toString()) + "\n";
        result = String.valueOf(result) + "Alignment cost: " + this.cost() + "\n";
        int i = 0;
        while (i <= this.sizeX()) {
            int j = 0;
            while (j <= this.sizeY()) {
                result = String.valueOf(result) + " " + this.cost[i][j];
                ++j;
            }
            result = String.valueOf(result) + "\n";
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        StringSequence x = new StringSequence("abbbaabbbbaab");
        StringSequence y = new StringSequence("ababaaabbbbbab");
        DPAlignment<Character> alignment = new DPAlignment<Character>(new Equality(), 1.0f);
        alignment.align(x, y);
        System.out.println(alignment);
    }
}

