/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.sequence.alignment;

import ikor.collection.sequence.Sequence;
import ikor.collection.sequence.StringSequence;
import ikor.collection.sequence.alignment.Alignment;
import ikor.util.similarity.Equality;
import ikor.util.similarity.SimilarityMetric;

public class ForwardAlignment<T>
extends Alignment<T> {
    private SimilarityMetric<T> sm;
    private float penalty;
    protected float[] cost;

    public ForwardAlignment(SimilarityMetric<T> sm, float penalty) {
        this.sm = sm;
        this.penalty = penalty;
    }

    @Override
    public float match() {
        Sequence x = (Sequence)this.getX();
        Sequence y = (Sequence)this.getY();
        return this.align(x, y);
    }

    @Override
    public float align(Sequence<T> x, Sequence<T> y) {
        float[] prev = new float[x.size() + 1];
        float[] current = new float[x.size() + 1];
        int i = 0;
        while (i <= x.size()) {
            prev[i] = (float)i * this.penalty;
            ++i;
        }
        int j = 1;
        while (j <= y.size()) {
            current[0] = (float)j * this.penalty;
            i = 1;
            while (i <= x.size()) {
                current[i] = this.sm.mismatch(x.get(i - 1), y.get(j - 1)) + prev[i - 1];
                if (current[i - 1] + this.penalty < current[i]) {
                    current[i] = current[i - 1] + this.penalty;
                }
                if (prev[i] + this.penalty < current[i]) {
                    current[i] = prev[i] + this.penalty;
                }
                ++i;
            }
            float[] tmp = prev;
            prev = current;
            current = tmp;
            ++j;
        }
        this.cost = prev;
        return this.cost[x.size()];
    }

    @Override
    public float cost() {
        return this.cost[this.cost.length - 1];
    }

    @Override
    public String toString() {
        return "Forward alignment algorithm";
    }

    public static void main(String[] args) {
        StringSequence x = new StringSequence("occurrence");
        StringSequence y = new StringSequence("ocurrance");
        ForwardAlignment<Character> alignment = new ForwardAlignment<Character>(new Equality(), 1.0f);
        ((Alignment)alignment).align(x, y);
        System.out.println("Alignment cost: " + ((Alignment)alignment).cost());
        System.out.println(alignment);
    }
}

