/*
 * Decompiled with CFR 0.152.
 */
package ikor.collection.util;

public class UnionFind {
    private int[] id;
    private int[] sz;
    private int count;

    public UnionFind(int n) {
        this.count = n;
        this.id = new int[n];
        this.sz = new int[n];
        int i = 0;
        while (i < n) {
            this.id[i] = i;
            this.sz[i] = 1;
            ++i;
        }
    }

    public int find(int p) {
        while (p != this.id[p]) {
            p = this.id[p];
        }
        return p;
    }

    public int size() {
        return this.count;
    }

    public boolean inSameSet(int p, int q) {
        return this.find(p) == this.find(q);
    }

    public void union(int p, int q) {
        int j;
        int i = this.find(p);
        if (i == (j = this.find(q))) {
            return;
        }
        if (this.sz[i] < this.sz[j]) {
            this.id[i] = j;
            int n = j;
            this.sz[n] = this.sz[n] + this.sz[i];
        } else {
            this.id[j] = i;
            int n = i;
            this.sz[n] = this.sz[n] + this.sz[j];
        }
        --this.count;
    }
}

