/*
 * Decompiled with CFR 0.152.
 */
package ikor.math;

import java.math.BigInteger;

public class Decimal
extends Number
implements Comparable {
    private BigInteger intVal = null;
    private int scale = 0;
    private static BigInteger TEN = BigInteger.valueOf(10L);
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;

    public Decimal(String val) {
        String fracString = null;
        String expString = null;
        String intString = null;
        int pointPos = val.indexOf(46);
        int expPos = val.indexOf(101);
        if (expPos == -1) {
            expPos = val.indexOf(69);
        }
        if (expPos == -1) {
            expPos = val.length();
        }
        if (pointPos == -1) {
            pointPos = expPos;
        }
        if ((intString = val.substring(0, pointPos)) == null || intString.length() == 0) {
            intString = "0";
        }
        this.intVal = new BigInteger(intString);
        try {
            fracString = val.substring(pointPos + 1, expPos);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (fracString == null || fracString.length() == 0) {
            this.scale = 0;
        } else {
            BigInteger fracPart = new BigInteger(fracString);
            if (fracPart.signum() < 0) {
                throw new NumberFormatException();
            }
            this.scale = fracString.length();
            if (val.charAt(0) == '-') {
                fracPart = fracPart.negate();
            }
            this.intVal = this.intVal.multiply(TEN.pow(this.scale));
            this.intVal = this.intVal.add(fracPart);
        }
        try {
            expString = val.substring(expPos + 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (expString != null && expString.length() != 0) {
            BigInteger expPart = new BigInteger(expString);
            int exp = expPart.intValue();
            if (exp < 0) {
                this.scale -= exp;
            } else if (exp > 0) {
                this.scale -= exp;
                if (this.scale < 0) {
                    this.intVal = this.intVal.multiply(TEN.pow(-this.scale));
                    this.scale = 0;
                }
            }
        }
        while (this.intVal.remainder(TEN).equals(BigInteger.ZERO) && this.scale > 0) {
            this.intVal = this.intVal.divide(TEN);
            --this.scale;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Decimal(double val) {
        super();
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        valBits = Double.doubleToLongBits(val);
        sign = valBits >> 63 == 0L ? 1 : -1;
        exponent = (int)(valBits >> 52 & 2047L);
        mantissa = exponent == 0 ? (valBits & 0xFFFFFFFFFFFFFL) << 1 : valBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        exponent -= 1075;
        if (mantissa != 0L) ** GOTO lbl16
        this.intVal = BigInteger.ZERO;
        return;
lbl-1000:
        // 1 sources

        {
            mantissa >>= 1;
            ++exponent;
lbl16:
            // 2 sources

            ** while ((mantissa & 1L) == 0L)
        }
lbl17:
        // 1 sources

        this.intVal = BigInteger.valueOf((long)sign * mantissa);
        if (exponent < 0) {
            this.intVal = this.intVal.multiply(BigInteger.valueOf(5L).pow(-exponent));
            this.scale = -exponent;
        } else if (exponent > 0) {
            this.intVal = this.intVal.multiply(BigInteger.valueOf(2L).pow(exponent));
        }
    }

    public Decimal(BigInteger val) {
        this.intVal = val;
        this.scale = 0;
    }

    public Decimal(BigInteger unscaledVal, int scale) {
        this.intVal = unscaledVal;
        this.scale = scale;
    }

    public static Decimal valueOf(long unscaledVal, int scale) {
        return new Decimal(BigInteger.valueOf(unscaledVal), scale);
    }

    public static Decimal valueOf(long val) {
        return Decimal.valueOf(val, 0);
    }

    public Decimal add(Decimal val) {
        Decimal[] arg = new Decimal[]{this, val};
        Decimal.matchScale(arg);
        return new Decimal(arg[0].intVal.add(arg[1].intVal), arg[0].scale);
    }

    public Decimal subtract(Decimal val) {
        Decimal[] arg = new Decimal[]{this, val};
        Decimal.matchScale(arg);
        return new Decimal(arg[0].intVal.subtract(arg[1].intVal), arg[0].scale);
    }

    public Decimal multiply(Decimal val) {
        return new Decimal(this.intVal.multiply(val.intVal), this.scale + val.scale);
    }

    public Decimal divide(Decimal val, int scale, int roundingMode) {
        int cmpFracHalf;
        Decimal divisor;
        Decimal dividend;
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        if (scale + val.scale >= this.scale) {
            dividend = this.setScale(scale + val.scale);
            divisor = val;
        } else {
            dividend = this;
            divisor = val.setScale(this.scale - scale);
        }
        BigInteger[] i = dividend.intVal.divideAndRemainder(divisor.intVal);
        BigInteger q = i[0];
        BigInteger r = i[1];
        if (r.signum() == 0) {
            return new Decimal(q, scale);
        }
        if (roundingMode == 7) {
            throw new ArithmeticException("Rounding necessary");
        }
        int signum = dividend.signum() * divisor.signum();
        boolean increment = roundingMode == 0 ? true : (roundingMode == 1 ? false : (roundingMode == 2 ? signum > 0 : (roundingMode == 3 ? signum < 0 : ((cmpFracHalf = r.abs().multiply(BigInteger.valueOf(2L)).compareTo(divisor.intVal.abs())) < 0 ? false : (cmpFracHalf > 0 ? true : (roundingMode == 4 ? true : (roundingMode == 5 ? false : q.testBit(0))))))));
        return increment ? new Decimal(q.add(BigInteger.valueOf(signum)), scale) : new Decimal(q, scale);
    }

    public Decimal divide(Decimal val, int roundingMode) {
        return this.divide(val, this.scale, roundingMode);
    }

    public Decimal abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public Decimal negate() {
        return new Decimal(this.intVal.negate(), this.scale);
    }

    public int signum() {
        return this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public BigInteger unscaledValue() {
        return this.intVal;
    }

    public Decimal setScale(int scale, int roundingMode) {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        if (scale == this.scale) {
            return this;
        }
        if (scale > this.scale) {
            return new Decimal(this.intVal.multiply(TEN.pow(scale - this.scale)), scale);
        }
        return this.divide(Decimal.valueOf(1L), scale, roundingMode);
    }

    public Decimal setScale(int scale) {
        return this.setScale(scale, 7);
    }

    public Decimal movePointLeft(int n) {
        return n >= 0 ? new Decimal(this.intVal, this.scale + n) : this.movePointRight(-n);
    }

    public Decimal movePointRight(int n) {
        return this.scale >= n ? new Decimal(this.intVal, this.scale - n) : new Decimal(this.intVal.multiply(TEN.pow(n - this.scale)), 0);
    }

    public int compareTo(Decimal val) {
        int sigDiff = this.signum() - val.signum();
        if (sigDiff != 0) {
            return sigDiff > 0 ? 1 : -1;
        }
        Decimal[] arg = new Decimal[]{this, val};
        Decimal.matchScale(arg);
        return arg[0].intVal.compareTo(arg[1].intVal);
    }

    public int compareTo(Object o) {
        return this.compareTo((Decimal)o);
    }

    public boolean equals(Object x) {
        if (!(x instanceof Decimal)) {
            return false;
        }
        Decimal xDec = (Decimal)x;
        return this.scale == xDec.scale && this.intVal.equals(xDec.intVal);
    }

    public Decimal min(Decimal val) {
        return this.compareTo(val) < 0 ? this : val;
    }

    public Decimal max(Decimal val) {
        return this.compareTo(val) > 0 ? this : val;
    }

    public int hashCode() {
        while (this.intVal.remainder(TEN).equals(BigInteger.ZERO) && this.scale > 0) {
            this.intVal = this.intVal.divide(TEN);
            --this.scale;
        }
        return 31 * this.intVal.hashCode() + this.scale;
    }

    public String toString() {
        StringBuffer buf;
        if (this.scale == 0) {
            return this.intVal.toString();
        }
        String intString = this.intVal.abs().toString();
        int signum = this.intVal.signum();
        int insertionPoint = intString.length() - this.scale;
        if (insertionPoint == 0) {
            return String.valueOf(signum < 0 ? "-0." : "0.") + intString;
        }
        if (insertionPoint > 0) {
            buf = new StringBuffer(intString);
            buf.insert(insertionPoint, '.');
            if (signum < 0) {
                buf.insert(0, '-');
            }
        } else {
            buf = new StringBuffer(3 - insertionPoint + intString.length());
            buf.append(signum < 0 ? "-0." : "0.");
            int i = 0;
            while (i < -insertionPoint) {
                buf.append('0');
                ++i;
            }
            buf.append(intString);
        }
        return buf.toString();
    }

    public BigInteger toBigInteger() {
        return this.scale == 0 ? this.intVal : this.intVal.divide(BigInteger.valueOf(10L).pow(this.scale));
    }

    @Override
    public int intValue() {
        return this.toBigInteger().intValue();
    }

    @Override
    public long longValue() {
        return this.toBigInteger().longValue();
    }

    @Override
    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    @Override
    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    private static void matchScale(Decimal[] val) {
        if (val[0].scale < val[1].scale) {
            val[0] = val[0].setScale(val[1].scale);
        } else if (val[1].scale < val[0].scale) {
            val[1] = val[1].setScale(val[0].scale);
        }
    }

    public static void main(String[] args) {
        Decimal d = new Decimal(new BigInteger("50"), 1);
        Decimal d0 = new Decimal("4.9");
        Decimal d1 = new Decimal("5.1");
        System.out.println(d.intVal + ":" + d.scale);
        d = d.setScale(2);
        System.out.println(d.intVal + ":" + d.scale);
        System.out.println(d + " " + d.compareTo(d0) + " " + d0);
        System.out.println(d + " " + d.compareTo(d0) + " " + d.compareTo(d1));
        System.out.println(d0 + " " + d0.compareTo(d) + " " + d0.compareTo(d1));
        System.out.println(d1 + " " + d1.compareTo(d) + " " + d1.compareTo(d0));
    }
}

