/*
 * Decompiled with CFR 0.152.
 */
package ikor.math;

import ikor.math.Configuration;
import ikor.math.Constants;

public class Functions {
    private static double[] lanczos = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};

    public static double Phi(double z) {
        if (z <= -8.0) {
            return 0.0;
        }
        if (z >= 8.0) {
            return 1.0;
        }
        double sum = 0.0;
        double term = z;
        int i = 3;
        while (sum + term != sum) {
            sum += term;
            term = term * z * z / (double)i;
            i += 2;
        }
        return 0.5 + sum * Math.exp(-z * z / 2.0) / Constants.SQRT2PI;
    }

    public static double probit(double p) {
        if (p <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Functions.probit(p, -8.0, 8.0);
    }

    private static double probit(double p, double low, double high) {
        double mid = low + (high - low) / 2.0;
        if (high - low < Configuration.EPSILON) {
            return mid;
        }
        if (Functions.Phi(mid) > p) {
            return Functions.probit(p, low, mid);
        }
        return Functions.probit(p, mid, high);
    }

    public static double gamma(double x) {
        return Math.exp(Functions.logGamma(x));
    }

    public static double logGamma(double x) {
        double g = 4.7421875;
        double tmp = x + g + 0.5;
        double sum = lanczos[0];
        int i = 1;
        while (i < lanczos.length) {
            sum += lanczos[i] / (x + (double)i);
            ++i;
        }
        return (x + 0.5) * Math.log(tmp) - tmp + 0.5 * Constants.LOG2PI + Math.log(sum) - Math.log(x);
    }

    public static double gammaP(double a, double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x < a + 1.0) {
            return Functions.gammaseries(a, x);
        }
        return 1.0 - Functions.gammacf(a, x);
    }

    public static double gammaQ(double a, double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        if (x < a + 1.0) {
            return 1.0 - Functions.gammaseries(a, x);
        }
        return Functions.gammacf(a, x);
    }

    private static double gammaseries(double a, double x) {
        double sum;
        double gln = Functions.logGamma(a);
        double ap = a;
        double del = sum = 1.0 / a;
        if (x > 0.0) {
            while (Math.abs(del) >= Math.abs(sum += (del *= x / (ap += 1.0))) * Configuration.EPSILON) {
            }
        }
        return sum * Math.exp(-x + a * Math.log(x) - gln);
    }

    private static double gammacf(double a, double x) {
        double del;
        double d;
        double gln = Functions.logGamma(a);
        double b = x + 1.0 - a;
        double c = 1.0 / Configuration.FPMIN;
        double h = d = 1.0 / b;
        int i = 1;
        do {
            double an;
            if (Math.abs(d = (an = (double)(-i) * ((double)i - a)) * d + (b += 2.0)) < Configuration.FPMIN) {
                d = Configuration.FPMIN;
            }
            if (Math.abs(c = b + an / c) < Configuration.FPMIN) {
                c = Configuration.FPMIN;
            }
            d = 1.0 / d;
            del = d * c;
            h *= del;
            ++i;
        } while (Math.abs(del - 1.0) >= Configuration.EPSILON);
        return Math.exp(-x + a * Math.log(x) - gln) * h;
    }

    public static double gammaPinv(double p, double a) {
        double x;
        double t;
        double lna1 = 0.0;
        double afac = 0.0;
        double a1 = a - 1.0;
        double gln = Functions.logGamma(a);
        if (p >= 1.0) {
            return Math.max(100.0, a + 100.0 * Math.sqrt(a));
        }
        if (p <= 0.0) {
            return 0.0;
        }
        if (a > 1.0) {
            lna1 = Math.log(a1);
            afac = Math.exp(a1 * (lna1 - 1.0) - gln);
            double pp = p < 0.5 ? p : 1.0 - p;
            t = Math.sqrt(-2.0 * Math.log(pp));
            x = (2.30753 + t * 0.27061) / (1.0 + t * (0.99229 + t * 0.04481)) - t;
            if (p < 0.5) {
                x = -x;
            }
            x = Math.max(0.001, a * Math.pow(1.0 - 1.0 / (9.0 * a) - x / (3.0 * Math.sqrt(a)), 3.0));
        } else {
            t = 1.0 - a * (0.253 + a * 0.12);
            x = p < t ? Math.pow(p / t, 1.0 / a) : 1.0 - Math.log(1.0 - (p - t) / (1.0 - t));
        }
        int j = 0;
        while (j < 12 && Math.abs(t) >= Configuration.EPSILON * x) {
            if (x <= 0.0) {
                return 0.0;
            }
            double err = Functions.gammaP(a, x) - p;
            t = a > 1.0 ? afac * Math.exp(-(x - a1) + a1 * (Math.log(x) - lna1)) : Math.exp(-x + a1 * Math.log(x) - gln);
            double u = err / t;
            if ((x -= (t = u / (1.0 - 0.5 * Math.min(1.0, u * ((a - 1.0) / x - 1.0))))) <= 0.0) {
                x = 0.5 * (x + t);
            }
            ++j;
        }
        return x;
    }

    public static double beta(double z, double w) {
        return Math.exp(Functions.logGamma(z) + Functions.logGamma(w) - Functions.logGamma(z + w));
    }

    public static double logBeta(double a, double b) {
        return Functions.logGamma(a) + Functions.logGamma(b) - Functions.logGamma(a + b);
    }

    public static double betaI(double a, double b, double x) {
        if (x == 0.0 || x == 1.0) {
            return x;
        }
        double bt = Math.exp(Functions.logGamma(a + b) - Functions.logGamma(a) - Functions.logGamma(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return bt * Functions.betacf(a, b, x) / a;
        }
        return 1.0 - bt * Functions.betacf(b, a, 1.0 - x) / b;
    }

    private static double betacf(double a, double b, double x) {
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double del = 0.0;
        double c = 1.0;
        double d = 1.0 - qab * x / qap;
        if (Math.abs(d) < Configuration.FPMIN) {
            d = Configuration.FPMIN;
        }
        double h = d = 1.0 / d;
        int m = 1;
        while (Math.abs(del - 1.0) > Configuration.EPSILON && m < Configuration.MAX_ITERATIONS) {
            int m2 = 2 * m;
            double aa = (double)m * (b - (double)m) * x / ((qam + (double)m2) * (a + (double)m2));
            if (Math.abs(d = 1.0 + aa * d) < Configuration.FPMIN) {
                d = Configuration.FPMIN;
            }
            if (Math.abs(c = 1.0 + aa / c) < Configuration.FPMIN) {
                c = Configuration.FPMIN;
            }
            d = 1.0 / d;
            h *= d * c;
            aa = -(a + (double)m) * (qab + (double)m) * x / ((a + (double)m2) * (qap + (double)m2));
            if (Math.abs(d = 1.0 + aa * d) < Configuration.FPMIN) {
                d = Configuration.FPMIN;
            }
            if (Math.abs(c = 1.0 + aa / c) < Configuration.FPMIN) {
                c = Configuration.FPMIN;
            }
            d = 1.0 / d;
            del = d * c;
            h *= del;
            ++m;
        }
        return h;
    }

    public static double betaIinv(double p, double a, double b) {
        double u;
        double w;
        double x;
        double t;
        double a1 = a - 1.0;
        double b1 = b - 1.0;
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return 1.0;
        }
        if (a >= 1.0 && b >= 1.0) {
            double pp = p < 0.5 ? p : 1.0 - p;
            t = Math.sqrt(-2.0 * Math.log(pp));
            x = (2.30753 + t * 0.27061) / (1.0 + t * (0.99229 + t * 0.04481)) - t;
            if (p < 0.5) {
                x = -x;
            }
            double al = (x * x - 3.0) / 6.0;
            double h = 2.0 / (1.0 / (2.0 * a - 1.0) + 1.0 / (2.0 * b - 1.0));
            w = x * Math.sqrt(al + h) / h - (1.0 / (2.0 * b - 1.0) - 1.0 / (2.0 * a - 1.0)) * (al + 0.8333333333333334 - 2.0 / (3.0 * h));
            x = a / (a + b * Math.exp(2.0 * w));
        } else {
            double lna = Math.log(a / (a + b));
            double lnb = Math.log(b / (a + b));
            t = Math.exp(a * lna) / a;
            x = p < t / (w = t + (u = Math.exp(b * lnb) / b)) ? Math.pow(a * w * p, 1.0 / a) : 1.0 - Math.pow(b * w * (1.0 - p), 1.0 / b);
        }
        double afac = -Functions.logGamma(a) - Functions.logGamma(b) + Functions.logGamma(a + b);
        int j = 0;
        while (j < 10) {
            if (x == 0.0 || x == 1.0) {
                return x;
            }
            double err = Functions.betaI(a, b, x) - p;
            t = Math.exp(a1 * Math.log(x) + b1 * Math.log(1.0 - x) + afac);
            u = err / t;
            if ((x -= (t = u / (1.0 - 0.5 * Math.min(1.0, u * (a1 / x - b1 / (1.0 - x)))))) <= 0.0) {
                x = 0.5 * (x + t);
            }
            if (x >= 1.0) {
                x = 0.5 * (x + t + 1.0);
            }
            if (Math.abs(t) < Configuration.EPSILON * x && j > 0) break;
            ++j;
        }
        return x;
    }

    public static double logFactorial(int n) {
        if (n <= 1) {
            return 0.0;
        }
        return Functions.logGamma((double)n + 1.0);
    }

    public static double binomial(int n, int k) {
        return Math.floor(0.5 + Math.exp(Functions.logFactorial(n) - Functions.logFactorial(k) - Functions.logFactorial(n - k)));
    }

    public static double logBinomial(int n, int k) {
        return Functions.logGamma(n + 1) - Functions.logGamma(k + 1) - Functions.logGamma(n - k + 1);
    }

    public static double erf(double z) {
        return z < 0.0 ? -Functions.gammaP(0.5, z * z) : Functions.gammaP(0.5, z * z);
    }

    public static double erfc(double z) {
        return z < 0.0 ? 1.0 + Functions.gammaP(0.5, z * z) : Functions.gammaQ(0.5, z * z);
    }

    public static double erfinv(double y) {
        if (y == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (y == -1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (y == 0.0) {
            return 0.0;
        }
        if (y > 0.0) {
            return Functions.erfinv(y, 0.0, 100.0);
        }
        return Functions.erfinv(y, -100.0, 0.0);
    }

    private static double erfinv(double y, double low, double high) {
        double x = low + (high - low) / 2.0;
        if (high - low < Configuration.EPSILON) {
            return x;
        }
        if (Functions.erf(x) > y) {
            return Functions.erfinv(y, low, x);
        }
        return Functions.erfinv(y, x, high);
    }

    public static double erfcinv(double y) {
        return Functions.erfinv(1.0 - y);
    }
}

