/*
 * Decompiled with CFR 0.152.
 */
package ikor.math;

import ikor.math.DenseVector;
import ikor.math.Vector;
import ikor.math.util.LinearScale;
import ikor.math.util.Scale;

public class Histogram
extends DenseVector {
    private Scale scale;

    public Histogram(int bins, Vector data) {
        this(bins, data, new LinearScale(data.min(), data.max()));
    }

    public Histogram(int bins, Vector data, Scale scale) {
        super(bins);
        this.scale = scale;
        this.count(data);
    }

    public Scale getScale() {
        return this.scale;
    }

    public double threshold(int n) {
        return this.scale.inverse((double)n / (double)this.size());
    }

    public int bin(double value) {
        int p = (int)(this.scale.scale(value) * (double)this.size());
        if (p == this.size()) {
            --p;
        }
        return p;
    }

    public void count(Vector data) {
        int i = 0;
        while (i < data.size()) {
            int p = this.bin(data.get(i));
            this.set(p, this.get(p) + 1.0);
            ++i;
        }
    }
}

