/*
 * Decompiled with CFR 0.152.
 */
package ikor.math;

import ikor.math.DenseMatrix;
import ikor.math.DenseVector;
import ikor.math.Matrix;
import ikor.math.MatrixDecomposition;
import ikor.math.MatrixFactory;
import ikor.math.Vector;

public class LUDecomposition
extends MatrixDecomposition {
    private double[][] LU;
    private int n;
    private int m;
    private int pivsign;
    private int[] piv;
    private int exchanges;

    public LUDecomposition(Matrix matrix) {
        this.LU = matrix.getArray();
        this.n = matrix.rows();
        this.m = matrix.columns();
        this.piv = new int[this.m];
        int i = 0;
        while (i < this.m) {
            this.piv[i] = i;
            ++i;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[this.m];
        int j = 0;
        while (j < this.n) {
            int i2 = 0;
            while (i2 < this.m) {
                LUcolj[i2] = this.LU[i2][j];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.m) {
                double[] LUrowi = this.LU[i2];
                int kmax = Math.min(i2, j);
                double s = 0.0;
                int k = 0;
                while (k < kmax) {
                    s += LUrowi[k] * LUcolj[k];
                    ++k;
                }
                int n = i2++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                LUrowi[j] = d;
            }
            int p = j;
            int i3 = j + 1;
            while (i3 < this.m) {
                if (Math.abs(LUcolj[i3]) > Math.abs(LUcolj[p])) {
                    p = i3;
                }
                ++i3;
            }
            if (p != j) {
                int k = 0;
                while (k < this.n) {
                    double t = this.LU[p][k];
                    this.LU[p][k] = this.LU[j][k];
                    this.LU[j][k] = t;
                    ++k;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
                ++this.exchanges;
            }
            if (j < this.m & this.LU[j][j] != 0.0) {
                i3 = j + 1;
                while (i3 < this.m) {
                    double[] dArray = this.LU[i3];
                    int n = j;
                    dArray[n] = dArray[n] / this.LU[j][j];
                    ++i3;
                }
            }
            ++j;
        }
    }

    public Matrix getLU() {
        return new DenseMatrix(this.LU);
    }

    public Vector getPermutation() {
        DenseVector permutation = new DenseVector(this.m);
        int i = 0;
        while (i < this.m) {
            ((Vector)permutation).set(i, this.piv[i]);
            ++i;
        }
        return permutation;
    }

    public Matrix getL() {
        DenseMatrix L = new DenseMatrix(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            ((Matrix)L).set(i, i, 1.0);
            int j = 0;
            while (j < i) {
                ((Matrix)L).set(i, j, this.LU[i][j]);
                ++j;
            }
            ++i;
        }
        return L;
    }

    public Matrix getU() {
        DenseMatrix U = new DenseMatrix(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            int j = i;
            while (j < this.n) {
                ((Matrix)U).set(i, j, this.LU[i][j]);
                ++j;
            }
            ++i;
        }
        return U;
    }

    public int getRowExchangeCount() {
        return this.exchanges;
    }

    public boolean isSingular() {
        int j = 0;
        while (j < this.n) {
            if (this.LU[j][j] == 0.0) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public double determinant() {
        if (this.m != this.n) {
            throw new UnsupportedOperationException("Matrix must be square.");
        }
        double d = this.pivsign;
        int j = 0;
        while (j < this.n) {
            d *= this.LU[j][j];
            ++j;
        }
        return d;
    }

    public Matrix solve(Matrix B) {
        int j;
        int i;
        if (B.rows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.columns();
        double[][] X = this.getDataArray(B);
        int k = 0;
        while (k < this.n) {
            i = k + 1;
            while (i < this.n) {
                j = 0;
                while (j < nx) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            int j2 = 0;
            while (j2 < nx) {
                double[] dArray = X[k];
                int n = j2++;
                dArray[n] = dArray[n] / this.LU[k][k];
            }
            i = 0;
            while (i < k) {
                j = 0;
                while (j < nx) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                    ++j;
                }
                ++i;
            }
            --k;
        }
        return new DenseMatrix(X);
    }

    private double[][] getDataArray(Matrix B) {
        double[][] data = new double[B.rows()][B.columns()];
        int i = 0;
        while (i < B.rows()) {
            int j = 0;
            while (j < B.columns()) {
                data[i][j] = B.get(this.piv[i], j);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public Matrix inverse() {
        return this.solve(MatrixFactory.createIdentity(this.n));
    }
}

