/*
 * Decompiled with CFR 0.152.
 */
package ikor.math;

import ikor.math.LUDecomposition;
import ikor.math.MatrixFactory;
import ikor.math.SparseMatrix;
import ikor.math.Vector;
import java.io.Serializable;

public abstract class Matrix
implements Serializable {
    private RowVector[] rowVector;
    private ColumnVector[] columnVector;
    private static final double[] sign = new double[]{1.0, -1.0};

    public int size() {
        return this.rows() * this.columns();
    }

    public abstract int rows();

    public abstract int columns();

    public abstract double get(int var1, int var2);

    public abstract void set(int var1, int var2, double var3);

    public double[][] getArray() {
        int m = this.rows();
        int n = this.columns();
        double[][] array = new double[m][n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                array[i][j] = this.get(i, j);
                ++j;
            }
            ++i;
        }
        return array;
    }

    public void set(double[][] v) {
        if (v.length == this.rows()) {
            int i = 0;
            while (i < v.length) {
                this.setRow(i, v[i]);
                ++i;
            }
        }
    }

    public void zero() {
        int filas = this.rows();
        int columnas = this.columns();
        int i = 0;
        while (i < filas) {
            int j = 0;
            while (j < columnas) {
                this.set(i, j, 0.0);
                ++j;
            }
            ++i;
        }
    }

    public final void set(int i, double[] v) {
        this.setRow(i, v);
    }

    public Vector getRow(int i) {
        if (this.rowVector == null) {
            this.rowVector = new RowVector[this.rows()];
        }
        if (this.rowVector[i] == null) {
            this.rowVector[i] = new RowVector(i);
        }
        return this.rowVector[i];
    }

    public final void setRow(int i, double[] v) {
        if (v.length == this.columns()) {
            int j = 0;
            while (j < v.length) {
                this.set(i, j, v[j]);
                ++j;
            }
        }
    }

    public final void setRow(int i, Vector v) {
        if (v.size() == this.columns()) {
            int j = 0;
            while (j < v.size()) {
                this.set(i, j, v.get(j));
                ++j;
            }
        }
    }

    public final void setRow(int i, double v) {
        int j = 0;
        while (j < this.columns()) {
            this.set(i, j, v);
            ++j;
        }
    }

    public Vector getColumn(int j) {
        if (this.columnVector == null) {
            this.columnVector = new ColumnVector[this.columns()];
        }
        if (this.columnVector[j] == null) {
            this.columnVector[j] = new ColumnVector(j);
        }
        return this.columnVector[j];
    }

    public final void setColumn(int j, double[] v) {
        if (v.length == this.rows()) {
            int i = 0;
            while (i < v.length) {
                this.set(i, j, v[i]);
                ++i;
            }
        }
    }

    public final void setColumn(int j, Vector v) {
        if (v.size() == this.rows()) {
            int i = 0;
            while (i < v.size()) {
                this.set(i, j, v.get(i));
                ++i;
            }
        }
    }

    public final void setColumn(int j, double v) {
        int i = 0;
        while (i < this.rows()) {
            this.set(i, j, v);
            ++i;
        }
    }

    public Matrix transpose() {
        int filas = this.rows();
        int columnas = this.columns();
        Matrix t = MatrixFactory.create(columnas, filas);
        int i = 0;
        while (i < columnas) {
            int j = 0;
            while (j < filas) {
                t.set(i, j, this.get(j, i));
                ++j;
            }
            ++i;
        }
        return t;
    }

    public Matrix submatrix(int i, int j) {
        int filas = this.rows();
        int columnas = this.columns();
        Matrix S = MatrixFactory.create(filas - 1, columnas - 1);
        int xS = 0;
        int x = 0;
        while (x < filas) {
            if (x != i) {
                int yS = 0;
                int y = 0;
                while (y < columnas) {
                    if (y != j) {
                        S.set(xS, yS, this.get(x, y));
                        ++yS;
                    }
                    ++y;
                }
                ++xS;
            }
            ++x;
        }
        return S;
    }

    public Matrix add(Matrix other) {
        int filas = this.rows();
        int columnas = this.columns();
        Matrix suma = null;
        if (this.rows() == other.rows() && this.columns() == other.columns()) {
            suma = MatrixFactory.create(filas, columnas);
            int i = 0;
            while (i < filas) {
                int j = 0;
                while (j < columnas) {
                    suma.set(i, j, this.get(i, j) + other.get(i, j));
                    ++j;
                }
                ++i;
            }
        }
        return suma;
    }

    public Matrix add(double constant) {
        int filas = this.rows();
        int columnas = this.columns();
        Matrix suma = MatrixFactory.create(filas, columnas);
        int i = 0;
        while (i < filas) {
            int j = 0;
            while (j < columnas) {
                suma.set(i, j, this.get(i, j) + constant);
                ++j;
            }
            ++i;
        }
        return suma;
    }

    public Matrix subtract(Matrix other) {
        int filas = this.rows();
        int columnas = this.columns();
        Matrix result = null;
        if (this.rows() == other.rows() && this.columns() == other.columns()) {
            result = MatrixFactory.create(filas, columnas);
            int i = 0;
            while (i < filas) {
                int j = 0;
                while (j < columnas) {
                    result.set(i, j, this.get(i, j) - other.get(i, j));
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    public Matrix multiply(Matrix other) {
        Matrix result = null;
        if (this.columns() == other.rows()) {
            result = MatrixFactory.create(this.rows(), other.columns());
            int i = 0;
            while (i < this.rows()) {
                int j = 0;
                while (j < other.columns()) {
                    result.set(i, j, this.getRow(i).dotProduct(other.getColumn(j)));
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    public Matrix multiply(SparseMatrix other) {
        Matrix result;
        block6: {
            result = null;
            if (this.columns() != other.rows()) break block6;
            result = MatrixFactory.create(this.rows(), other.columns());
            if (this instanceof SparseMatrix) {
                int i = 0;
                while (i < this.rows()) {
                    int j = 0;
                    while (j < other.columns()) {
                        result.set(i, j, this.getRow(i).dotProduct(other.getColumn(j)));
                        ++j;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.rows()) {
                    int j = 0;
                    while (j < other.columns()) {
                        result.set(i, j, other.getColumn(j).dotProduct(this.getRow(i)));
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public Matrix multiply(double constant) {
        int filas = this.rows();
        int columnas = this.columns();
        Matrix result = MatrixFactory.create(filas, columnas);
        int i = 0;
        while (i < filas) {
            int j = 0;
            while (j < columnas) {
                result.set(i, j, constant * this.get(i, j));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public Matrix divide(double constant) {
        int filas = this.rows();
        int columnas = this.columns();
        Matrix result = MatrixFactory.create(filas, columnas);
        int i = 0;
        while (i < filas) {
            int j = 0;
            while (j < columnas) {
                result.set(i, j, this.get(i, j) / constant);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public Matrix power(int n) {
        Matrix result = null;
        if (this.rows() == this.columns()) {
            if (n > 1) {
                Matrix half = this.power(n / 2);
                result = n % 2 == 1 ? half.multiply(half).multiply(this) : half.multiply(half);
            } else if (n == 1) {
                result = this;
            } else if (n == 0) {
                result = MatrixFactory.createIdentity(this.rows());
            } else if (n < 0) {
                result = this.power(-n).inverse();
            }
        }
        return result;
    }

    public Vector getDiagonal() {
        Vector diagonal = null;
        if (this.rows() == this.columns()) {
            int n = this.rows();
            diagonal = MatrixFactory.createVector(n);
            int i = 0;
            while (i < n) {
                diagonal.set(i, this.get(i, i));
                ++i;
            }
        }
        return diagonal;
    }

    public double trace() {
        int filas = this.rows();
        int columnas = this.columns();
        double result = 0.0;
        if (filas == columnas) {
            int i = 0;
            while (i < filas) {
                result += this.get(i, i);
                ++i;
            }
        }
        return result;
    }

    public double diagonalProduct() {
        int filas = this.rows();
        int columnas = this.columns();
        double result = 1.0;
        if (filas == columnas) {
            int i = 0;
            while (i < filas) {
                result *= this.get(i, i);
                ++i;
            }
        }
        return result;
    }

    public double sum() {
        double sum = 0.0;
        int i = 0;
        while (i < this.rows()) {
            int j = 0;
            while (j < this.columns()) {
                sum += this.get(i, j);
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public double max() {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.rows()) {
            int j = 0;
            while (j < this.columns()) {
                if (this.get(i, j) > max) {
                    max = this.get(i, j);
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    public double min() {
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.rows()) {
            int j = 0;
            while (j < this.columns()) {
                if (this.get(i, j) < min) {
                    min = this.get(i, j);
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public Matrix inverse() {
        LUDecomposition lu = new LUDecomposition(this);
        if (!lu.isSingular()) {
            return lu.inverse();
        }
        return null;
    }

    public double determinant() {
        LUDecomposition lu = new LUDecomposition(this);
        return lu.determinant();
    }

    public double minor(int i, int j) {
        Matrix S = this.submatrix(i, j);
        return S.determinant();
    }

    public double cofactor(int i, int j) {
        return sign[(i + j) % 2] * this.minor(i, j);
    }

    public boolean isSquare() {
        return this.rows() == this.columns();
    }

    public boolean isSymmetric() {
        boolean symmetric = this.isSquare();
        int n = this.rows();
        int j = 0;
        while (j < n & symmetric) {
            int i = j + 1;
            while (i < n & symmetric) {
                symmetric = this.get(i, j) == this.get(j, i);
                ++i;
            }
            ++j;
        }
        return symmetric;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Matrix) {
            Matrix other = (Matrix)obj;
            if (this.columns() != other.columns()) {
                return false;
            }
            if (this.rows() != other.rows()) {
                return false;
            }
            int i = 0;
            while (i < this.rows()) {
                int j = 0;
                while (j < this.rows()) {
                    if (this.get(i, j) != other.get(i, j)) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.toString("[", "]\n", " ");
    }

    public String toString(String rowPrefix, String rowSuffix, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.rows()) {
            buffer.append(rowPrefix);
            buffer.append(this.get(i, 0));
            int j = 1;
            while (j < this.columns()) {
                buffer.append(delimiter);
                buffer.append(this.get(i, j));
                ++j;
            }
            buffer.append(rowSuffix);
            ++i;
        }
        return buffer.toString();
    }

    public class ColumnVector
    extends Vector {
        private int column;

        public ColumnVector(int column) {
            this.column = column;
        }

        @Override
        public int size() {
            return Matrix.this.rows();
        }

        @Override
        public double get(int i) {
            return Matrix.this.get(i, this.column);
        }

        @Override
        public void set(int i, double value) {
            Matrix.this.set(i, this.column, value);
        }
    }

    public class RowVector
    extends Vector {
        private int row;

        public RowVector(int row) {
            this.row = row;
        }

        @Override
        public int size() {
            return Matrix.this.columns();
        }

        @Override
        public double get(int i) {
            return Matrix.this.get(this.row, i);
        }

        @Override
        public void set(int i, double value) {
            Matrix.this.set(this.row, i, value);
        }
    }
}

