/*
 * Decompiled with CFR 0.152.
 */
package ikor.math;

import ikor.math.DenseMatrix;
import ikor.math.DenseVector;
import ikor.math.Matrix;
import ikor.math.SparseMatrix;
import ikor.math.Vector;

public class MatrixFactory {
    public static final Matrix create(int rows, int columns) {
        return new DenseMatrix(rows, columns);
    }

    public static final Matrix create(int rows, int columns, double value) {
        DenseMatrix matrix = new DenseMatrix(rows, columns);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                ((Matrix)matrix).set(i, j, value);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static final Matrix create(Matrix original) {
        int filas = original.rows();
        int columnas = original.columns();
        Matrix matrix = original instanceof DenseMatrix ? new DenseMatrix(filas, columnas) : new SparseMatrix(filas, columnas);
        int i = 0;
        while (i < filas) {
            int j = 0;
            while (j < columnas) {
                matrix.set(i, j, original.get(i, j));
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static final Matrix create(double[][] data) {
        int rows = data.length;
        int columns = data[0].length;
        DenseMatrix matrix = new DenseMatrix(rows, columns);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                ((Matrix)matrix).set(i, j, data[i][j]);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static final Vector createVector(int n) {
        return new DenseVector(n);
    }

    public static final Vector createVector(Vector v) {
        return new DenseVector(v);
    }

    public static final Vector createVector(double[] v) {
        DenseVector vector = new DenseVector(v.length);
        int i = 0;
        while (i < v.length) {
            ((Vector)vector).set(i, v[i]);
            ++i;
        }
        return vector;
    }

    public static final Matrix createIdentity(int n) {
        SparseMatrix identity = new SparseMatrix(n, n);
        int i = 0;
        while (i < n) {
            ((Matrix)identity).set(i, i, 1.0);
            ++i;
        }
        return identity;
    }

    public Matrix createToeplitz(Vector v) {
        int n = v.size();
        Matrix T = MatrixFactory.create(n, n);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                T.set(i, j, v.get(Math.abs(i - j)));
                ++j;
            }
            ++i;
        }
        return T;
    }
}

