/*
 * Decompiled with CFR 0.152.
 */
package ikor.math;

import ikor.math.DenseMatrix;
import ikor.math.DenseVector;
import ikor.math.Matrix;
import ikor.math.MatrixDecomposition;
import ikor.math.Vector;

public class SingularValueDecomposition
extends MatrixDecomposition {
    private double[][] U;
    private double[][] V;
    private double[] s;
    private double[] e;
    private int m;
    private int n;

    public SingularValueDecomposition(Matrix matrix) {
        this.m = matrix.rows();
        this.n = matrix.columns();
        int nu = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][nu];
        this.V = new double[this.n][this.n];
        this.e = new double[this.n];
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        double[][] A = matrix.getArray();
        double[] work = new double[this.m];
        int k = 0;
        while (k < Math.max(nct, nrt)) {
            int i;
            int i2;
            if (k < nct) {
                this.s[k] = 0.0;
                i2 = k;
                while (i2 < this.m) {
                    this.s[k] = this.hypot(this.s[k], A[i2][k]);
                    ++i2;
                }
                if (this.s[k] != 0.0) {
                    if (A[k][k] < 0.0) {
                        this.s[k] = -this.s[k];
                    }
                    i2 = k;
                    while (i2 < this.m) {
                        double[] dArray = A[i2];
                        int n = k;
                        dArray[n] = dArray[n] / this.s[k];
                        ++i2;
                    }
                    double[] dArray = A[k];
                    int n = k;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.s[k] = -this.s[k];
            }
            int j = k + 1;
            while (j < this.n) {
                if (k < nct & this.s[k] != 0.0) {
                    double t = 0.0;
                    i = k;
                    while (i < this.m) {
                        t += A[i][k] * A[i][j];
                        ++i;
                    }
                    t = -t / A[k][k];
                    i = k;
                    while (i < this.m) {
                        double[] dArray = A[i];
                        int n = j;
                        dArray[n] = dArray[n] + t * A[i][k];
                        ++i;
                    }
                }
                this.e[j] = A[k][j];
                ++j;
            }
            if (k < nct) {
                i2 = k;
                while (i2 < this.m) {
                    this.U[i2][k] = A[i2][k];
                    ++i2;
                }
            }
            if (k < nrt) {
                this.e[k] = 0.0;
                i2 = k + 1;
                while (i2 < this.n) {
                    this.e[k] = this.hypot(this.e[k], this.e[i2]);
                    ++i2;
                }
                if (this.e[k] != 0.0) {
                    if (this.e[k + 1] < 0.0) {
                        this.e[k] = -this.e[k];
                    }
                    i2 = k + 1;
                    while (i2 < this.n) {
                        int n = i2++;
                        this.e[n] = this.e[n] / this.e[k];
                    }
                    int n = k + 1;
                    this.e[n] = this.e[n] + 1.0;
                }
                this.e[k] = -this.e[k];
                if (k + 1 < this.m & this.e[k] != 0.0) {
                    i2 = k + 1;
                    while (i2 < this.m) {
                        work[i2] = 0.0;
                        ++i2;
                    }
                    j = k + 1;
                    while (j < this.n) {
                        int i3 = k + 1;
                        while (i3 < this.m) {
                            int n = i3;
                            work[n] = work[n] + this.e[j] * A[i3][j];
                            ++i3;
                        }
                        ++j;
                    }
                    j = k + 1;
                    while (j < this.n) {
                        double t = -this.e[j] / this.e[k + 1];
                        i = k + 1;
                        while (i < this.m) {
                            double[] dArray = A[i];
                            int n = j;
                            dArray[n] = dArray[n] + t * work[i];
                            ++i;
                        }
                        ++j;
                    }
                }
                i2 = k + 1;
                while (i2 < this.n) {
                    this.V[i2][k] = this.e[i2];
                    ++i2;
                }
            }
            ++k;
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.s[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            this.e[nrt] = A[nrt][p - 1];
        }
        this.e[p - 1] = 0.0;
        this.generateU(nu, nct);
        this.generateV(nu, nrt);
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        while (p > 0) {
            int kase;
            int k2 = p - 2;
            while (k2 >= -1) {
                if (k2 == -1) break;
                if (Math.abs(this.e[k2]) <= tiny + eps * (Math.abs(this.s[k2]) + Math.abs(this.s[k2 + 1]))) {
                    this.e[k2] = 0.0;
                    break;
                }
                --k2;
            }
            if (k2 == p - 2) {
                kase = 4;
            } else {
                int ks = p - 1;
                while (ks >= k2) {
                    if (ks == k2) break;
                    double t = (ks != p ? Math.abs(this.e[ks]) : 0.0) + (ks != k2 + 1 ? Math.abs(this.e[ks - 1]) : 0.0);
                    if (Math.abs(this.s[ks]) <= tiny + eps * t) {
                        this.s[ks] = 0.0;
                        break;
                    }
                    --ks;
                }
                if (ks == k2) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k2 = ks;
                }
            }
            ++k2;
            switch (kase) {
                case 1: {
                    this.deflateNegligibleSingularValue(p, k2);
                    break;
                }
                case 2: {
                    this.splitNegligibleSingularValue(pp, k2);
                    break;
                }
                case 3: {
                    this.e[p - 2] = this.qr(p, k2);
                    ++iter;
                    break;
                }
                case 4: {
                    this.convergence(pp, k2);
                    iter = 0;
                    --p;
                }
            }
        }
    }

    public Matrix getU() {
        return new DenseMatrix(this.U);
    }

    public Matrix getV() {
        return new DenseMatrix(this.V);
    }

    public Vector getSingularValues() {
        return new DenseVector(this.s);
    }

    public Matrix getS() {
        DenseMatrix S = new DenseMatrix(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            ((Matrix)S).set(i, i, this.s[i]);
            ++i;
        }
        return S;
    }

    public double norm2() {
        return this.s[0];
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        double eps = Math.pow(2.0, -52.0);
        double tol = (double)Math.max(this.m, this.n) * this.s[0] * eps;
        int r = 0;
        int i = 0;
        while (i < this.s.length) {
            if (this.s[i] > tol) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    private void generateV(int nu, int nrt) {
        int k = this.n - 1;
        while (k >= 0) {
            if (k < nrt & this.e[k] != 0.0) {
                int j = k + 1;
                while (j < nu) {
                    double t = 0.0;
                    int i = k + 1;
                    while (i < this.n) {
                        t += this.V[i][k] * this.V[i][j];
                        ++i;
                    }
                    t = -t / this.V[k + 1][k];
                    i = k + 1;
                    while (i < this.n) {
                        double[] dArray = this.V[i];
                        int n = j;
                        dArray[n] = dArray[n] + t * this.V[i][k];
                        ++i;
                    }
                    ++j;
                }
            }
            int i = 0;
            while (i < this.n) {
                this.V[i][k] = 0.0;
                ++i;
            }
            this.V[k][k] = 1.0;
            --k;
        }
    }

    private void generateU(int nu, int nct) {
        int i;
        int j = nct;
        while (j < nu) {
            i = 0;
            while (i < this.m) {
                this.U[i][j] = 0.0;
                ++i;
            }
            this.U[j][j] = 1.0;
            ++j;
        }
        int k = nct - 1;
        while (k >= 0) {
            if (this.s[k] != 0.0) {
                int j2 = k + 1;
                while (j2 < nu) {
                    double t = 0.0;
                    int i2 = k;
                    while (i2 < this.m) {
                        t += this.U[i2][k] * this.U[i2][j2];
                        ++i2;
                    }
                    t = -t / this.U[k][k];
                    i2 = k;
                    while (i2 < this.m) {
                        double[] dArray = this.U[i2];
                        int n = j2;
                        dArray[n] = dArray[n] + t * this.U[i2][k];
                        ++i2;
                    }
                    ++j2;
                }
                i = k;
                while (i < this.m) {
                    this.U[i][k] = -this.U[i][k];
                    ++i;
                }
                this.U[k][k] = 1.0 + this.U[k][k];
                i = 0;
                while (i < k - 1) {
                    this.U[i][k] = 0.0;
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.m) {
                    this.U[i][k] = 0.0;
                    ++i;
                }
                this.U[k][k] = 1.0;
            }
            --k;
        }
    }

    private int convergence(int pp, int k) {
        if (this.s[k] <= 0.0) {
            this.s[k] = this.s[k] < 0.0 ? -this.s[k] : 0.0;
            int i = 0;
            while (i <= pp) {
                this.V[i][k] = -this.V[i][k];
                ++i;
            }
        }
        while (k < pp) {
            int i;
            if (this.s[k] >= this.s[k + 1]) break;
            double t = this.s[k];
            this.s[k] = this.s[k + 1];
            this.s[k + 1] = t;
            if (k < this.n - 1) {
                i = 0;
                while (i < this.n) {
                    t = this.V[i][k + 1];
                    this.V[i][k + 1] = this.V[i][k];
                    this.V[i][k] = t;
                    ++i;
                }
            }
            if (k < this.m - 1) {
                i = 0;
                while (i < this.m) {
                    t = this.U[i][k + 1];
                    this.U[i][k + 1] = this.U[i][k];
                    this.U[i][k] = t;
                    ++i;
                }
            }
            ++k;
        }
        return k;
    }

    private double qr(int p, int k) {
        double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(this.e[p - 2])), Math.abs(this.s[k])), Math.abs(this.e[k]));
        double sp = this.s[p - 1] / scale;
        double spm1 = this.s[p - 2] / scale;
        double epm1 = this.e[p - 2] / scale;
        double sk = this.s[k] / scale;
        double ek = this.e[k] / scale;
        double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
        double c = sp * epm1 * (sp * epm1);
        double shift = 0.0;
        if (b != 0.0 | c != 0.0) {
            shift = Math.sqrt(b * b + c);
            if (b < 0.0) {
                shift = -shift;
            }
            shift = c / (b + shift);
        }
        double f = (sk + sp) * (sk - sp) + shift;
        double g = sk * ek;
        int j = k;
        while (j < p - 1) {
            double t = this.hypot(f, g);
            double cs = f / t;
            double sn = g / t;
            if (j != k) {
                this.e[j - 1] = t;
            }
            f = cs * this.s[j] + sn * this.e[j];
            this.e[j] = cs * this.e[j] - sn * this.s[j];
            g = sn * this.s[j + 1];
            this.s[j + 1] = cs * this.s[j + 1];
            int i = 0;
            while (i < this.n) {
                t = cs * this.V[i][j] + sn * this.V[i][j + 1];
                this.V[i][j + 1] = -sn * this.V[i][j] + cs * this.V[i][j + 1];
                this.V[i][j] = t;
                ++i;
            }
            t = this.hypot(f, g);
            cs = f / t;
            sn = g / t;
            this.s[j] = t;
            f = cs * this.e[j] + sn * this.s[j + 1];
            this.s[j + 1] = -sn * this.e[j] + cs * this.s[j + 1];
            g = sn * this.e[j + 1];
            this.e[j + 1] = cs * this.e[j + 1];
            if (j < this.m - 1) {
                i = 0;
                while (i < this.m) {
                    t = cs * this.U[i][j] + sn * this.U[i][j + 1];
                    this.U[i][j + 1] = -sn * this.U[i][j] + cs * this.U[i][j + 1];
                    this.U[i][j] = t;
                    ++i;
                }
            }
            ++j;
        }
        return f;
    }

    private void splitNegligibleSingularValue(int p, int k) {
        double f = this.e[k - 1];
        this.e[k - 1] = 0.0;
        int j = k;
        while (j < p) {
            double t = this.hypot(this.s[j], f);
            double cs = this.s[j] / t;
            double sn = f / t;
            this.s[j] = t;
            f = -sn * this.e[j];
            this.e[j] = cs * this.e[j];
            int i = 0;
            while (i < this.m) {
                t = cs * this.U[i][j] + sn * this.U[i][k - 1];
                this.U[i][k - 1] = -sn * this.U[i][j] + cs * this.U[i][k - 1];
                this.U[i][j] = t;
                ++i;
            }
            ++j;
        }
    }

    private void deflateNegligibleSingularValue(int p, int k) {
        double f = this.e[p - 2];
        this.e[p - 2] = 0.0;
        int j = p - 2;
        while (j >= k) {
            double t = this.hypot(this.s[j], f);
            double cs = this.s[j] / t;
            double sn = f / t;
            this.s[j] = t;
            if (j != k) {
                f = -sn * this.e[j - 1];
                this.e[j - 1] = cs * this.e[j - 1];
            }
            int i = 0;
            while (i < this.n) {
                t = cs * this.V[i][j] + sn * this.V[i][p - 1];
                this.V[i][p - 1] = -sn * this.V[i][j] + cs * this.V[i][p - 1];
                this.V[i][j] = t;
                ++i;
            }
            --j;
        }
    }
}

