/*
 * Decompiled with CFR 0.152.
 */
package ikor.math;

import ikor.math.Matrix;
import ikor.math.SparseVector;
import ikor.math.Vector;

public class SparseMatrix
extends Matrix {
    private SparseVector[] rows;
    private SparseVector[] columns;
    private SparseVector emptyRow;
    private SparseVector emptyColumn;

    public SparseMatrix(int rows, int columns) {
        this.rows = new SparseVector[rows];
        this.columns = new SparseVector[columns];
    }

    @Override
    public int rows() {
        return this.rows.length;
    }

    @Override
    public int columns() {
        return this.columns.length;
    }

    @Override
    public double get(int i, int j) {
        if (this.rows[i] != null) {
            return this.rows[i].get(j);
        }
        return 0.0;
    }

    @Override
    public void set(int i, int j, double v) {
        if (this.rows[i] == null) {
            this.rows[i] = new SparseVector(this.columns());
        }
        if (this.columns[j] == null) {
            this.columns[j] = new SparseVector(this.rows());
        }
        this.rows[i].set(j, v);
        this.columns[j].set(i, v);
    }

    @Override
    public Vector getRow(int i) {
        if (this.rows[i] != null) {
            return this.rows[i];
        }
        if (this.emptyRow == null) {
            this.emptyRow = new SparseVector(this.columns());
        }
        return this.emptyRow;
    }

    @Override
    public Vector getColumn(int j) {
        if (this.columns[j] != null) {
            return this.columns[j];
        }
        if (this.emptyColumn == null) {
            this.emptyColumn = new SparseVector(this.rows());
        }
        return this.emptyColumn;
    }
}

