/*
 * Decompiled with CFR 0.152.
 */
package ikor.math;

import ikor.math.Vector;

public class SparseVector
extends Vector {
    private static final int INITIAL_ARRAY_SIZE = 4;
    private int size;
    private int used;
    private int[] index;
    private double[] value;

    public SparseVector(int size) {
        this.size = size;
        this.index = new int[4];
        this.value = new double[4];
        this.used = 0;
    }

    public void extend() {
        int[] newIndex = new int[2 * this.index.length];
        double[] newValue = new double[2 * this.value.length];
        System.arraycopy(this.index, 0, newIndex, 0, this.index.length);
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        this.index = newIndex;
        this.value = newValue;
    }

    private void insert(int pos, int ndx, double val) {
        if (this.used == this.index.length) {
            this.extend();
        }
        int i = this.used;
        while (i > pos) {
            this.index[i] = this.index[i - 1];
            this.value[i] = this.value[i - 1];
            --i;
        }
        this.index[pos] = ndx;
        this.value[pos] = val;
        ++this.used;
        if (ndx >= this.size) {
            this.size = ndx + 1;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public int nonzero() {
        return this.used;
    }

    private int position(int x) {
        int left = 0;
        int right = this.used - 1;
        int middle = (left + right) / 2;
        while (left < right && this.index[middle] != x) {
            if (x < this.index[middle]) {
                right = middle - 1;
            } else {
                left = middle + 1;
            }
            middle = (left + right) / 2;
        }
        if (middle < this.used && this.index[middle] < x) {
            ++middle;
        }
        return middle;
    }

    @Override
    public double get(int i) {
        int p = this.position(i);
        if (p >= 0 && p < this.used && this.index[p] == i) {
            return this.value[p];
        }
        return 0.0;
    }

    @Override
    public void set(int i, double value) {
        int p = this.position(i);
        if (p >= 0 && p < this.used && this.index[p] == i) {
            this.value[p] = value;
        } else if (value != 0.0) {
            this.insert(p, i, value);
        }
    }

    @Override
    public double dotProduct(Vector other) {
        double result = 0.0;
        int i = 0;
        while (i < this.used) {
            result += this.value[i] * other.get(this.index[i]);
            ++i;
        }
        return result;
    }

    public double dotProduct(SparseVector other) {
        double result = 0.0;
        int i = 0;
        int j = 0;
        while (i < this.used && j < other.used) {
            if (this.index[i] == other.index[j]) {
                result += this.value[i] * other.value[j];
                ++i;
                ++j;
                continue;
            }
            if (this.index[i] < other.index[j]) {
                ++i;
                continue;
            }
            ++j;
        }
        return result;
    }

    @Override
    public double magnitude2() {
        double result = 0.0;
        int i = 0;
        while (i < this.used) {
            result += this.value[i] * this.value[i];
            ++i;
        }
        return result;
    }

    @Override
    public double distance2(Vector other) {
        double result = 0.0;
        int i = 0;
        while (i < this.used) {
            double diff = this.value[i] - other.get(this.index[i]);
            result += diff * diff;
            ++i;
        }
        return result;
    }

    @Override
    public double min() {
        double min = this.nonzero() < this.size() ? 0.0 : Double.MAX_VALUE;
        int i = 0;
        while (i < this.used) {
            if (this.value[i] < min) {
                min = this.value[i];
            }
            ++i;
        }
        return min;
    }

    @Override
    public double max() {
        double max = this.nonzero() < this.size() ? 0.0 : -1.7976931348623157E308;
        int i = 0;
        while (i < this.used) {
            if (this.value[i] > max) {
                max = this.value[i];
            }
            ++i;
        }
        return max;
    }

    @Override
    public double sum() {
        double sum = 0.0;
        int i = 0;
        while (i < this.used) {
            sum += this.value[i];
            ++i;
        }
        return sum;
    }

    @Override
    public double sum2() {
        double sum2 = 0.0;
        int i = 0;
        while (i < this.used) {
            sum2 += this.value[i] * this.value[i];
            ++i;
        }
        return sum2;
    }
}

