/*
 * Decompiled with CFR 0.152.
 */
package ikor.math;

import ikor.math.Configuration;
import ikor.math.Matrix;
import ikor.math.MatrixFactory;

public abstract class Vector
extends Matrix {
    private boolean transposed;

    public Vector() {
        this.transposed = false;
    }

    public Vector(boolean transposed) {
        this.transposed = transposed;
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    @Override
    public int rows() {
        if (this.transposed) {
            return this.size();
        }
        return 1;
    }

    @Override
    public int columns() {
        if (this.transposed) {
            return 1;
        }
        return this.size();
    }

    @Override
    public abstract int size();

    public abstract double get(int var1);

    public abstract void set(int var1, double var2);

    public final void set(double[] values) {
        int i = 0;
        while (i < values.length) {
            this.set(i, values[i]);
            ++i;
        }
    }

    public final void set(double value) {
        int i = 0;
        while (i < this.size()) {
            this.set(i, value);
            ++i;
        }
    }

    public final void set(Vector vector) {
        int i = 0;
        while (i < this.size()) {
            this.set(i, vector.get(i));
            ++i;
        }
    }

    @Override
    public double get(int i, int j) {
        return this.get(Math.max(i, j));
    }

    @Override
    public void set(int i, int j, double v) {
        this.set(Math.max(i, j), v);
    }

    public void swap(int i, int j) {
        double tmp = this.get(i);
        this.set(i, this.get(j));
        this.set(j, tmp);
    }

    @Override
    public Vector transpose() {
        Vector result = MatrixFactory.createVector(this);
        result.transposed = !this.transposed;
        return result;
    }

    public Vector add(Vector other) {
        Vector suma = null;
        if (this.size() == other.size()) {
            suma = MatrixFactory.createVector(this.size());
            int i = 0;
            while (i < this.size()) {
                suma.set(i, this.get(i) + other.get(i));
                ++i;
            }
        }
        return suma;
    }

    public Vector subtract(Vector other) {
        Vector suma = null;
        if (this.size() == other.size()) {
            suma = MatrixFactory.createVector(this.size());
            int i = 0;
            while (i < this.size()) {
                suma.set(i, this.get(i) - other.get(i));
                ++i;
            }
        }
        return suma;
    }

    @Override
    public Vector add(double constant) {
        Vector result = MatrixFactory.createVector(this.size());
        int i = 0;
        while (i < this.size()) {
            result.set(i, this.get(i) + constant);
            ++i;
        }
        return result;
    }

    public Vector subtract(double constant) {
        Vector result = MatrixFactory.createVector(this.size());
        int i = 0;
        while (i < this.size()) {
            result.set(i, this.get(i) - constant);
            ++i;
        }
        return result;
    }

    @Override
    public Vector multiply(double constant) {
        Vector result = MatrixFactory.createVector(this.size());
        int i = 0;
        while (i < this.size()) {
            result.set(i, this.get(i) * constant);
            ++i;
        }
        return result;
    }

    public Vector arrayMultiply(Vector other) {
        Vector result = null;
        if (this.size() == other.size()) {
            result = MatrixFactory.createVector(this.size());
            int i = 0;
            while (i < this.size()) {
                result.set(i, this.get(i) * other.get(i));
                ++i;
            }
        }
        return result;
    }

    public Vector accumulate(Vector other) {
        int dim = this.size();
        int i = 0;
        while (i < dim) {
            this.set(i, this.get(i) + other.get(i));
            ++i;
        }
        return this;
    }

    public double magnitude() {
        return Math.sqrt(this.magnitude2());
    }

    public double magnitude2() {
        double result = 0.0;
        int i = 0;
        while (i < this.size()) {
            result += this.get(i) * this.get(i);
            ++i;
        }
        return result;
    }

    public double dotProduct(Vector other) {
        double result = 0.0;
        int i = 0;
        while (i < this.size()) {
            result += this.get(i) * other.get(i);
            ++i;
        }
        return result;
    }

    public double projection(Vector other) {
        double length = other.magnitude();
        if (length > 0.0) {
            return this.dotProduct(other) / length;
        }
        return 0.0;
    }

    public double distance(Vector other) {
        return Math.sqrt(this.distance2(other));
    }

    public double distance2(Vector other) {
        double result = 0.0;
        int i = 0;
        while (i < this.size()) {
            double diff = this.get(i) - other.get(i);
            result += diff * diff;
            ++i;
        }
        return result;
    }

    public double angle(Vector other) {
        double a = this.magnitude();
        double b = other.magnitude();
        double p = this.dotProduct(other);
        if (a > 0.0 && b > 0.0) {
            if (Math.abs(p - a * b) < Configuration.EPSILON) {
                return 0.0;
            }
            return Math.acos(p / (a * b));
        }
        return 0.0;
    }

    @Override
    public double min() {
        double min = this.get(0);
        int i = 1;
        while (i < this.size()) {
            if (this.get(i) < min) {
                min = this.get(i);
            }
            ++i;
        }
        return min;
    }

    public int minIndex() {
        int min = 0;
        int i = 1;
        while (i < this.size()) {
            if (this.get(i) < this.get(min)) {
                min = i;
            }
            ++i;
        }
        return min;
    }

    @Override
    public double max() {
        double max = this.get(0);
        int i = 1;
        while (i < this.size()) {
            if (this.get(i) > max) {
                max = this.get(i);
            }
            ++i;
        }
        return max;
    }

    public int maxIndex() {
        int max = 0;
        int i = 1;
        while (i < this.size()) {
            if (this.get(i) > this.get(max)) {
                max = i;
            }
            ++i;
        }
        return max;
    }

    @Override
    public double sum() {
        double sum = 0.0;
        int i = 0;
        while (i < this.size()) {
            sum += this.get(i);
            ++i;
        }
        return sum;
    }

    public double sum2() {
        double sum2 = 0.0;
        int i = 0;
        while (i < this.size()) {
            sum2 += this.get(i) * this.get(i);
            ++i;
        }
        return sum2;
    }

    public double average() {
        return this.sum() / (double)this.size();
    }

    public double variance() {
        double avg = this.average();
        return this.sum2() / (double)this.size() - avg * avg;
    }

    public double sampleVariance() {
        double avg = this.average();
        double sum2 = 0.0;
        int i = 0;
        while (i < this.size()) {
            double diff = this.get(i) - avg;
            sum2 += diff * diff;
            ++i;
        }
        return sum2 / (double)(this.size() - 1);
    }

    public double deviation() {
        return Math.sqrt(this.variance());
    }

    public double sampleDeviation() {
        return Math.sqrt(this.sampleVariance());
    }

    public double absoluteDeviation() {
        double avg = this.average();
        double dev = 0.0;
        int i = 0;
        while (i < this.size()) {
            dev += Math.abs(this.get(i) - avg);
            ++i;
        }
        return dev / (double)this.size();
    }

    public double covariance(Vector other) {
        double mu1 = this.average();
        double mu2 = other.average();
        double cov = 0.0;
        int i = 0;
        while (i < this.size()) {
            cov += (this.get(i) - mu1) * (other.get(i) - mu2);
            ++i;
        }
        return cov / (double)this.size();
    }

    public double correlation(Vector other) {
        double sigma1 = this.deviation();
        double sigma2 = other.deviation();
        double cov = this.covariance(other);
        if (cov == 0.0) {
            return 0.0;
        }
        return this.covariance(other) / (sigma1 * sigma2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Vector) {
            Vector other = (Vector)obj;
            int i = 0;
            while (i < this.size()) {
                if (this.get(i) != other.get(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return this.toString("[", "]", ",");
    }

    public String toStringSummary() {
        if (this.size() > 0) {
            return "[n=" + this.size() + " min=" + this.min() + " max=" + this.max() + " avg=" + this.average() + " dev=" + this.deviation() + "]";
        }
        return "[n=0]";
    }

    @Override
    public String toString(String prefix, String suffix, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        int n = this.size();
        buffer.append(prefix);
        buffer.append(this.get(0));
        int i = 1;
        while (i < n) {
            buffer.append(delimiter);
            buffer.append(this.get(i));
            ++i;
        }
        buffer.append(suffix);
        return buffer.toString();
    }
}

