/*
 * Decompiled with CFR 0.152.
 */
package ikor.math;

import ikor.math.Configuration;
import java.io.Serializable;

public class Vector2D
implements Serializable {
    double x;
    double y;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double squaredLength() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2D normalize() {
        double length = this.length();
        if (length > Configuration.EPSILON) {
            return new Vector2D(this.x / length, this.y / length);
        }
        return null;
    }

    public Vector2D reverse() {
        return new Vector2D(-this.x, -this.y);
    }

    public Vector2D add(Vector2D v) {
        return new Vector2D(this.x + v.x, this.y + v.y);
    }

    public Vector2D substract(Vector2D v) {
        return new Vector2D(this.x - v.x, this.y - v.y);
    }

    public Vector2D multiply(double a) {
        return new Vector2D(a * this.x, a * this.y);
    }

    public Vector2D divide(double a) {
        return new Vector2D(this.x / a, this.y / a);
    }

    public double dotProduct(Vector2D v) {
        return this.x * v.x + this.y * v.y;
    }

    public double projection(Vector2D v) {
        double length = v.length();
        if (length > 0.0) {
            return this.dotProduct(v) / v.length();
        }
        return 0.0;
    }

    public double angle(Vector2D v) {
        double angle = Math.atan2(v.y, v.x) - Math.atan2(this.y, this.x);
        if (this.squaredLength() == 0.0 || v.squaredLength() == 0.0) {
            return 0.0;
        }
        if (angle > Math.PI) {
            return angle - Math.PI * 2;
        }
        if (angle < -Math.PI) {
            return angle + Math.PI * 2;
        }
        return angle;
    }

    public double distance(Vector2D v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double squaredDistance(Vector2D v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        return dx * dx + dy * dy;
    }

    public Vector2D reflect(Vector2D normal) {
        Vector2D displacement = normal.multiply(2.0 * this.dotProduct(normal)).reverse();
        return this.add(displacement);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vector2D)) {
            return false;
        }
        Vector2D v = (Vector2D)obj;
        return Math.abs(this.x - v.x) < Configuration.EPSILON && Math.abs(this.y - v.y) < Configuration.EPSILON;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

