/*
 * Decompiled with CFR 0.152.
 */
package ikor.math;

import ikor.math.Configuration;
import ikor.math.Vector2D;
import java.io.Serializable;

public class Vector3D
implements Serializable {
    double x;
    double y;
    double z;

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D(Vector2D vector2d) {
        this.x = vector2d.x();
        this.y = vector2d.y();
        this.z = 0.0;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double squaredLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3D normalize() {
        double length = this.length();
        if (length > Configuration.EPSILON) {
            return new Vector3D(this.x / length, this.y / length, this.z / length);
        }
        return null;
    }

    public Vector3D reverse() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    public Vector3D add(Vector3D v) {
        return new Vector3D(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vector3D substract(Vector3D v) {
        return new Vector3D(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vector3D multiply(double a) {
        return new Vector3D(a * this.x, a * this.y, a * this.z);
    }

    public Vector3D divide(double a) {
        return new Vector3D(this.x / a, this.y / a, this.z / a);
    }

    public double dotProduct(Vector3D v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public double projection(Vector3D v) {
        double length = v.length();
        if (length > 0.0) {
            return this.dotProduct(v) / length;
        }
        return 0.0;
    }

    public double distance(Vector3D v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        double dz = this.z - v.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double squaredDistance(Vector3D v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        double dz = this.z - v.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double angle(Vector3D v) {
        double a = this.length();
        double b = v.length();
        double p = this.dotProduct(v);
        if (a > 0.0 && b > 0.0) {
            if (Math.abs(p - a * b) < Configuration.EPSILON) {
                return 0.0;
            }
            return Math.acos(p / (a * b));
        }
        return 0.0;
    }

    public Vector3D crossProduct(Vector3D other) {
        return new Vector3D(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public Vector3D reflect(Vector3D normal) {
        Vector3D displacement = normal.multiply(2.0 * this.dotProduct(normal)).reverse();
        return this.add(displacement);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vector3D)) {
            return false;
        }
        Vector3D v = (Vector3D)obj;
        return Math.abs(this.x - v.x) < Configuration.EPSILON && Math.abs(this.y - v.y) < Configuration.EPSILON && Math.abs(this.z - v.z) < Configuration.EPSILON;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

