/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.equation;

import ikor.math.Matrix;
import ikor.math.MatrixFactory;
import ikor.math.Vector;
import ikor.math.equation.SystemSolver;

public class LevinsonDurbinSolver
implements SystemSolver {
    public Vector solve(double[] v) {
        int p = v.length - 1;
        double[] W = new double[p + 2];
        double[] E = new double[p + 2];
        double[] K = new double[p + 2];
        double[][] A = new double[p + 2][p + 2];
        W[0] = v[1];
        E[0] = v[0];
        int i = 1;
        while (i <= p) {
            int j;
            K[i] = W[i - 1] / E[i - 1];
            E[i] = E[i - 1] * (1.0 - K[i] * K[i]);
            A[i][i] = -K[i];
            int i1 = i - 1;
            if (i1 >= 1) {
                j = 1;
                while (j <= i1) {
                    int ji = i - j;
                    A[j][i] = A[j][i1] - K[i] * A[ji][i1];
                    ++j;
                }
            }
            if (i != p) {
                W[i] = v[i + 1];
                j = 1;
                while (j <= i) {
                    int n = i;
                    W[n] = W[n] + A[j][i] * v[i - j + 1];
                    ++j;
                }
            }
            ++i;
        }
        Vector X = MatrixFactory.createVector(p);
        i = 0;
        while (i < p) {
            X.set(i, -A[i + 1][p]);
            ++i;
        }
        W = null;
        E = null;
        K = null;
        A = null;
        return X;
    }

    @Override
    public Vector solve(Matrix A, Vector B) {
        int n = A.rows();
        double[] v = new double[n + 1];
        int i = 0;
        while (i < n) {
            v[i] = A.get(i, 0);
            ++i;
        }
        v[n] = B.get(n - 1, 0);
        Vector X = this.solve(v);
        v = null;
        return X;
    }
}

