/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.optimization;

import ikor.math.Configuration;

public class Simplex {
    private double[][] A;
    private double[] b;
    private double[] c;
    private OP[] op;
    private double[][] a;
    private int M;
    private int N;
    private int Q;
    private int[] basis;
    private static final double LARGE = 1000000.0;
    double[] cost;

    public Simplex(double[][] A, double[] b, double[] c) {
        this.A = A;
        this.b = b;
        this.c = c;
        this.M = b.length;
        this.N = c.length;
        this.Q = this.M + this.N;
        this.a = new double[this.M + 1][this.N + this.M + 1];
        int i = 0;
        while (i < this.M) {
            int j = 0;
            while (j < this.N) {
                this.a[i][j] = A[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.M) {
            this.a[i][this.N + i] = 1.0;
            ++i;
        }
        int j = 0;
        while (j < this.N) {
            this.a[this.M][j] = c[j];
            ++j;
        }
        i = 0;
        while (i < this.M) {
            this.a[i][this.M + this.N] = b[i];
            ++i;
        }
        this.basis = new int[this.M];
        i = 0;
        while (i < this.M) {
            this.basis[i] = this.N + i;
            ++i;
        }
    }

    public Simplex(double[][] A, OP[] op, double[] b, double[] c) {
        this.A = A;
        this.b = b;
        this.c = c;
        this.op = op;
        this.M = b.length;
        this.N = c.length;
        this.Q = this.N + 2 * this.M;
        this.a = new double[this.M + 1][this.N + this.M + this.M + 1];
        int i = 0;
        while (i < this.M) {
            int j = 0;
            while (j < this.N) {
                this.a[i][j] = A[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.M) {
            if (op[i] == OP.GT || op[i] == OP.GE) {
                this.a[i][this.N + i] = -1.0;
            } else if (op[i] == OP.LT || op[i] == OP.LE) {
                this.a[i][this.N + i] = 1.0;
            }
            ++i;
        }
        i = 0;
        while (i < this.M) {
            if (op[i] == OP.EQ || op[i] == OP.GE) {
                this.a[i][this.N + this.M + i] = 1.0;
            }
            ++i;
        }
        int j = 0;
        while (j < this.N) {
            this.a[this.M][j] = c[j];
            ++j;
        }
        i = 0;
        while (i < this.M) {
            this.a[i][2 * this.M + this.N] = b[i];
            ++i;
        }
        this.basis = new int[this.M];
        i = 0;
        while (i < this.M) {
            this.basis[i] = this.N + this.M + i;
            ++i;
        }
    }

    public void maximize() {
        this.maxCost();
        int q = this.bland();
        while (q != -1) {
            int p = this.minRatioRule(q);
            if (p == -1) {
                throw new RuntimeException("Linear program is unbounded");
            }
            this.pivot(p, q);
            this.basis[p] = q;
            q = this.bland();
        }
        if (!this.check()) {
            throw new RuntimeException("Linear program unable to find maximum.");
        }
    }

    public void minimize() {
        this.minCost();
        this.initFinalRow();
        int q = this.blandMin();
        while (q != -1) {
            int p = this.minRatioRule(q);
            if (p == -1) {
                throw new RuntimeException("Linear program is unbounded");
            }
            this.pivot(p, q);
            this.basis[p] = q;
            q = this.blandMin();
        }
        if (!this.isPrimalFeasible()) {
            throw new RuntimeException("Linear program unable to find minimum.");
        }
    }

    private void minCost() {
        this.cost = new double[this.N + 2 * this.M];
        int i = 0;
        while (i < this.N) {
            this.cost[i] = this.c[i];
            ++i;
        }
        int j = this.N;
        while (j < this.N + this.M) {
            this.cost[j] = 0.0;
            ++j;
        }
        j = this.N + this.M;
        while (j < this.N + 2 * this.M) {
            this.cost[j] = 1000000.0;
            ++j;
        }
    }

    private void maxCost() {
        this.cost = new double[this.N + 2 * this.M];
        int i = 0;
        while (i < this.N) {
            this.cost[i] = this.c[i];
            ++i;
        }
        int j = this.N;
        while (j < this.N + this.M) {
            this.cost[j] = 0.0;
            ++j;
        }
        j = this.N + this.M;
        while (j < this.N + 2 * this.M) {
            this.cost[j] = -1000000.0;
            ++j;
        }
    }

    private void initFinalRow() {
        int i = 0;
        while (i <= this.Q) {
            if (i < this.cost.length) {
                this.a[this.M][i] = this.cost[i];
            }
            int j = 0;
            while (j < this.M) {
                double[] dArray = this.a[this.M];
                int n = i;
                dArray[n] = dArray[n] - this.cost[this.N + this.M + j] * this.a[j][i];
                ++j;
            }
            ++i;
        }
    }

    protected int bland() {
        int j = 0;
        while (j < this.Q) {
            if (this.a[this.M][j] > 0.0) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    protected int blandMin() {
        int j = 0;
        while (j < this.Q) {
            if (this.a[this.M][j] < 0.0) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    protected int dantzig() {
        int q = 0;
        int j = 1;
        while (j < this.Q) {
            if (this.a[this.M][j] > this.a[this.M][q]) {
                q = j;
            }
            ++j;
        }
        if (this.a[this.M][q] <= 0.0) {
            return -1;
        }
        return q;
    }

    protected int dantzigMin() {
        int q = 0;
        int j = 1;
        while (j < this.Q) {
            if (this.a[this.M][j] < this.a[this.M][q]) {
                q = j;
            }
            ++j;
        }
        if (this.a[this.M][q] >= 0.0) {
            return -1;
        }
        return q;
    }

    private int minRatioRule(int q) {
        int p = -1;
        int i = 0;
        while (i < this.M) {
            if (this.a[i][q] > 0.0) {
                if (p == -1) {
                    p = i;
                } else if (this.a[i][this.Q] / this.a[i][q] < this.a[p][this.Q] / this.a[p][q]) {
                    p = i;
                }
            }
            ++i;
        }
        return p;
    }

    private void pivot(int p, int q) {
        int i = 0;
        while (i <= this.M) {
            int j = 0;
            while (j <= this.Q) {
                if (i != p && j != q) {
                    double[] dArray = this.a[i];
                    int n = j;
                    dArray[n] = dArray[n] - this.a[p][j] * this.a[i][q] / this.a[p][q];
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i <= this.M) {
            if (i != p) {
                this.a[i][q] = 0.0;
            }
            ++i;
        }
        int j = 0;
        while (j <= this.Q) {
            if (j != q) {
                double[] dArray = this.a[p];
                int n = j;
                dArray[n] = dArray[n] / this.a[p][q];
            }
            ++j;
        }
        this.a[p][q] = 1.0;
    }

    public double value() {
        return -this.a[this.M][this.Q];
    }

    public double[] primal() {
        double[] x = new double[this.N];
        int i = 0;
        while (i < this.M) {
            if (this.basis[i] < this.N) {
                x[this.basis[i]] = this.a[i][this.Q];
            }
            ++i;
        }
        return x;
    }

    private int basicRow(int x) {
        int i = 0;
        while (i < this.M) {
            if (this.basis[i] == x) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public double[] dual() {
        double[] y = new double[this.M];
        int i = 0;
        while (i < this.M) {
            y[i] = Math.abs(this.a[this.M][this.N + i]);
            ++i;
        }
        return y;
    }

    private boolean isPrimalFeasible() {
        double[] x = this.primal();
        int j = 0;
        while (j < x.length) {
            if (x[j] < 0.0) {
                return false;
            }
            ++j;
        }
        int i = 0;
        while (i < this.M) {
            if (!this.isPrimalSatisfied(x, i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isPrimalSatisfied(double[] x, int i) {
        double sum = 0.0;
        OP operator = this.op != null ? this.op[i] : OP.LE;
        int j = 0;
        while (j < this.N) {
            sum += this.A[i][j] * x[j];
            ++j;
        }
        return this.checkOP(sum, operator, this.b[i]);
    }

    private boolean checkOP(double a, OP op, double b) {
        switch (op) {
            case EQ: {
                return Math.abs(a - b) < Configuration.EPSILON;
            }
            case LE: {
                return a <= b + Configuration.EPSILON;
            }
            case LT: {
                return a < b + Configuration.EPSILON;
            }
            case GE: {
                return a >= b - Configuration.EPSILON;
            }
            case GT: {
                return a > b - Configuration.EPSILON;
            }
        }
        return false;
    }

    private boolean isDualFeasible() {
        double[] y = this.dual();
        int i = 0;
        while (i < y.length) {
            if (y[i] < 0.0) {
                return false;
            }
            ++i;
        }
        int j = 0;
        while (j < this.N) {
            if (!this.isDualSatisfied(y, j)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private boolean isDualSatisfied(double[] y, int j) {
        double sum = 0.0;
        OP operator = this.op != null ? this.op[j] : OP.LE;
        int i = 0;
        while (i < this.M) {
            sum += this.A[i][j] * y[i];
            ++i;
        }
        return this.checkDualOP(sum, operator, this.c[j]);
    }

    private boolean checkDualOP(double a, OP op, double b) {
        switch (op) {
            case EQ: {
                return Math.abs(a - b) < Configuration.EPSILON;
            }
            case LE: {
                return a > b - Configuration.EPSILON;
            }
            case LT: {
                return a >= b - Configuration.EPSILON;
            }
            case GE: {
                return a < b + Configuration.EPSILON;
            }
            case GT: {
                return a <= b + Configuration.EPSILON;
            }
        }
        return false;
    }

    private boolean isOptimal() {
        double[] x = this.primal();
        double[] y = this.dual();
        double value = this.value();
        double value1 = 0.0;
        int j = 0;
        while (j < x.length) {
            value1 += this.c[j] * x[j];
            ++j;
        }
        double value2 = 0.0;
        int i = 0;
        while (i < y.length) {
            value2 += y[i] * this.b[i];
            ++i;
        }
        return Math.abs(value - value1) <= Configuration.EPSILON && Math.abs(value - value2) <= Configuration.EPSILON;
    }

    public boolean check() {
        return this.isPrimalFeasible() && this.isDualFeasible() && this.isOptimal();
    }

    public double[] reduced() {
        double[] r = new double[this.N];
        int i = 0;
        while (i < this.N) {
            r[i] = this.a[this.M][i];
            ++i;
        }
        return r;
    }

    public double[] used() {
        double[] u = new double[this.M];
        double[] x = this.primal();
        int i = 0;
        while (i < this.M) {
            int j = 0;
            while (j < this.N) {
                int n = i;
                u[n] = u[n] + this.A[i][j] * x[j];
                ++j;
            }
            ++i;
        }
        return u;
    }

    public double insignificance(int i) {
        return this.c[i] - this.a[this.M][i];
    }

    public double optimality(int v) {
        int row = this.basicRow(v);
        double max = 0.0;
        if (row != -1) {
            int i = 0;
            while (i < this.Q) {
                double delta;
                if (i != v && this.a[row][i] != 0.0 && this.a[this.M][i] < 0.0 && this.c[v] - (delta = -this.a[this.M][i] / this.a[row][i]) > max) {
                    max = this.c[v] - delta;
                }
                ++i;
            }
        }
        return max;
    }

    public double reducedRHS(int constraint) {
        double result = this.b[constraint];
        int i = 0;
        while (i < this.M) {
            double ratio = this.a[i][this.Q] / this.a[i][this.N + constraint];
            if (ratio > 0.0 && ratio < result) {
                result = ratio;
            }
            ++i;
        }
        return this.b[constraint] - result;
    }

    public double increasedRHS(int constraint) {
        double result = 0.0;
        boolean constrained = false;
        int i = 0;
        while (i < this.M) {
            double ratio = this.a[i][this.Q] / this.a[i][this.N + constraint];
            if (ratio < 0.0 && ratio < result) {
                result = ratio;
                constrained = true;
            }
            ++i;
        }
        if (constrained) {
            return this.b[constraint] - result;
        }
        return Double.POSITIVE_INFINITY;
    }

    public String toString() {
        int j;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Optimize\n\t");
        int i = 0;
        while (i < this.c.length) {
            if (this.c[i] > 0.0) {
                buffer.append(" + " + Math.abs(this.c[i]) + "*x[" + i + "]");
            } else {
                buffer.append(" - " + Math.abs(this.c[i]) + "*x[" + i + "]");
            }
            ++i;
        }
        buffer.append("\nSubject to\n");
        i = 0;
        while (i < this.b.length) {
            buffer.append("\t");
            j = 0;
            while (j < this.A[i].length) {
                if (this.A[i][j] > 0.0) {
                    buffer.append(" + " + Math.abs(this.A[i][j]) + "*x[" + j + "]");
                } else {
                    buffer.append(" - " + Math.abs(this.A[i][j]) + "*x[" + j + "]");
                }
                ++j;
            }
            if (this.op != null) {
                buffer.append(" " + this.opString(this.op[i]) + " ");
            } else {
                buffer.append(" <= ");
            }
            buffer.append(String.valueOf(this.b[i]) + "\n");
            ++i;
        }
        buffer.append("N = " + this.N + "\n");
        buffer.append("M = " + this.M + "\n");
        buffer.append("value  = " + this.value() + "\n");
        buffer.append("primal = " + this.toString(this.primal()) + "\n");
        buffer.append("dual   = " + this.toString(this.dual()) + "\n");
        buffer.append("TABLEAU\n");
        i = 0;
        while (i < this.a.length) {
            j = 0;
            while (j < this.a[i].length) {
                buffer.append("\t" + String.format("%7.2f ", this.a[i][j]));
                ++j;
            }
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    private String opString(OP op) {
        switch (op) {
            case EQ: {
                return "=";
            }
            case LE: {
                return "<=";
            }
            case LT: {
                return "<";
            }
            case GE: {
                return ">=";
            }
            case GT: {
                return ">";
            }
        }
        return "<=";
    }

    private String toString(double[] v) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[" + v[0]);
        int i = 1;
        while (i < v.length) {
            buffer.append(", " + v[i]);
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static enum OP {
        LT,
        LE,
        GT,
        GE,
        EQ;

    }
}

