/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.random;

import ikor.math.random.JavaRNG;
import ikor.math.random.RNG;

public class Random {
    private static RNG rng = new JavaRNG();

    public static RNG get() {
        return rng;
    }

    public static void set(RNG newRandomNumberGenerator) {
        rng = newRandomNumberGenerator;
    }

    public static double random() {
        return rng.random();
    }

    public static int random(int k) {
        return (int)((double)k * Random.random());
    }

    public static long integer() {
        return rng.integer();
    }

    public static double gaussian() {
        double v2;
        double v1;
        double s;
        while ((s = (v1 = 2.0 * Random.random() - 1.0) * v1 + (v2 = 2.0 * Random.random() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        return v1 * multiplier;
    }
}

