/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.regression;

import ikor.math.Vector;
import ikor.math.regression.GradientDescentRegression;
import ikor.math.regression.LinearRegressionModel;
import ikor.math.regression.RegressionModel;

public class GradientDescentLinearRegression
extends GradientDescentRegression {
    public GradientDescentLinearRegression(Vector[] x, Vector y) {
        super(x, y);
    }

    public GradientDescentLinearRegression(double[][] x, double[] y) {
        super(x, y);
    }

    @Override
    public RegressionModel createModel() {
        return new LinearRegressionModel(this.variables());
    }

    @Override
    public double cost() {
        RegressionModel model = this.getModel();
        return this.getSSE(model) / (double)(2 * this.instances());
    }

    @Override
    public double[] gradient() {
        int j;
        RegressionModel model = this.getModel();
        int m = this.instances();
        int p = model.parameters();
        double[] s = new double[p];
        int i = 0;
        while (i < m) {
            double r = this.getPrediction(model, i) - this.getY(i);
            j = 0;
            while (j < p) {
                int n = j;
                s[n] = s[n] + r * this.getX(j, i);
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < s.length) {
            int n = j++;
            s[n] = s[n] / (double)m;
        }
        return s;
    }
}

