/*
 * Decompiled with CFR 0.152.
 */
package ikor.math.regression;

import ikor.math.Matrix;
import ikor.math.MatrixFactory;
import ikor.math.Vector;
import ikor.math.regression.GradientDescentRegression;
import ikor.math.regression.LogisticRegressionModel;
import ikor.math.regression.RegressionModel;

public class GradientDescentLogisticRegression
extends GradientDescentRegression {
    public GradientDescentLogisticRegression(Vector[] x, Vector y) {
        super(x, y);
    }

    public GradientDescentLogisticRegression(double[][] x, double[] y) {
        super(x, y);
    }

    @Override
    public RegressionModel createModel() {
        return new LogisticRegressionModel(this.variables());
    }

    @Override
    public double cost() {
        double J = 0.0;
        int i = 0;
        while (i < this.instances()) {
            J += this.cost(i);
            ++i;
        }
        return J / (double)this.instances();
    }

    public double cost(int i) {
        double y = this.getY(i);
        double h = this.getPrediction(this.getModel(), i);
        return -y * Math.log(h) - (1.0 - y) * Math.log(1.0 - h);
    }

    @Override
    public double[] gradient() {
        int j;
        RegressionModel model = this.getModel();
        int m = this.instances();
        int p = model.parameters();
        double[] s = new double[p];
        int i = 0;
        while (i < m) {
            double r = this.getPrediction(model, i) - this.getY(i);
            j = 0;
            while (j < p) {
                int n = j;
                s[n] = s[n] + r * this.getX(j, i);
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < s.length) {
            int n = j++;
            s[n] = s[n] / (double)m;
        }
        return s;
    }

    public double[][] hessian() {
        int k;
        int j;
        RegressionModel model = this.getModel();
        int m = this.instances();
        int p = model.parameters();
        double[][] s = new double[p][p];
        int i = 0;
        while (i < m) {
            double h = this.getPrediction(model, i);
            double f = h * (1.0 - h);
            j = 0;
            while (j < p) {
                k = 0;
                while (k < p) {
                    double[] dArray = s[j];
                    int n = k;
                    dArray[n] = dArray[n] + f * this.getX(j, i) * this.getX(k, i);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < p) {
            k = 0;
            while (k < p) {
                double[] dArray = s[j];
                int n = k++;
                dArray[n] = dArray[n] / (double)m;
            }
            ++j;
        }
        return s;
    }

    public Matrix covariance() {
        Matrix hessian = MatrixFactory.create(this.hessian());
        return hessian.inverse().divide(this.instances());
    }
}

